/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlParsingException
extends SAXException {
    private int columnNumber;
    private int lineNumber;

    public XmlParsingException(Exception exception) {
        super(exception);
    }

    public XmlParsingException(String string, Exception exception) {
        super(string, exception);
    }

    public XmlParsingException(String string) {
        super(string);
    }

    public XmlParsingException rememberLocation(Locator locator) {
        if (locator != null) {
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
        }
        return this;
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        if (this.lineNumber == 0 && this.columnNumber == 0) {
            return string;
        }
        if (string == null) {
            string = this.getClass().getName();
        }
        return string + ' ' + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

