/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.impl.AbstractXtfWriterAlt;
import ch.interlis.iom_j.xtf.impl.Xtf24WriterAlt;
import ch.interlis.iom_j.xtf.impl.XtfWriterAlt;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class XtfWriterBase
implements IoxWriter {
    private AbstractXtfWriterAlt alt = null;
    private OutputStream outputFile = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private XtfModel[] models = null;

    public XtfWriterBase(OutputStreamWriter buffer, ViewableProperties mapping1, String version) throws IoxException {
        this.alt = version.equals("2.4") ? new Xtf24WriterAlt(buffer, mapping1) : new XtfWriterAlt(buffer, mapping1, version);
    }

    public XtfWriterBase(File outfile, ViewableProperties mapping1, String version) throws IoxException {
        try {
            File outdir = outfile.getParentFile();
            if (outdir != null && !outdir.exists() && !outdir.mkdirs()) {
                throw new IOException("failed to create directory " + outdir.getAbsolutePath());
            }
            this.outputFile = new FileOutputStream(outfile);
            this.init(this.outputFile, mapping1, version);
        }
        catch (IOException ex) {
            throw new IoxException(ex);
        }
    }

    public XtfWriterBase(OutputStream buffer, ViewableProperties mapping1, String version) throws IoxException {
        this.init(buffer, mapping1, version);
    }

    private void init(OutputStream buffer, ViewableProperties mapping1, String version) throws IoxException {
        try {
            this.alt = version.equals("2.4") ? new Xtf24WriterAlt(new OutputStreamWriter(buffer, "UTF-8"), mapping1) : new XtfWriterAlt(new OutputStreamWriter(buffer, "UTF-8"), mapping1, version);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void write(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            StartTransferEvent e = (StartTransferEvent)event;
            if (e instanceof XtfStartTransferEvent) {
                this.alt.writeStartTransfer(e.getSender(), e.getComment(), this.getModels(), (XtfStartTransferEvent)e);
            } else {
                this.alt.writeStartTransfer(e.getSender(), e.getComment(), this.getModels());
            }
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent e = (StartBasketEvent)event;
            this.alt.writeStartBasket(e.getType(), e.getBid(), e.getConsistency(), e.getKind(), e.getStartstate(), e.getEndstate(), e.getTopicv());
        } else if (event instanceof ObjectEvent) {
            ObjectEvent e = (ObjectEvent)event;
            this.alt.writeObject(e.getIomObject());
        } else if (event instanceof EndBasketEvent) {
            this.alt.writeEndBasket();
        } else if (event instanceof EndTransferEvent) {
            this.alt.writeEndTransfer();
        } else {
            throw new IoxException("unknown event type " + event.getClass().getName());
        }
    }

    @Override
    public void close() throws IoxException {
        if (this.alt != null) {
            this.alt.close();
            this.alt = null;
        }
        if (this.outputFile != null) {
            try {
                this.outputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException(ex);
            }
            this.outputFile = null;
        }
    }

    @Override
    public void flush() throws IoxException {
        this.alt.flush();
    }

    @Override
    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    @Override
    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    @Override
    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    public XtfModel[] getModels() {
        return this.models;
    }

    public void setModels(XtfModel[] models) {
        this.models = models;
    }
}

