/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.FigureChangeAdapter;
import CH.ifa.draw.util.GraphNode;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class GraphLayout
extends FigureChangeAdapter {
    public double LENGTH_FACTOR = 1.0;
    public double REPULSION_STRENGTH = 0.5;
    public double REPULSION_LIMIT = 200.0;
    int REPULSION_TYPE = 0;
    public double SPRING_STRENGTH = 0.1;
    public double TORQUE_STRENGTH = 0.25;
    public double FRICTION_FACTOR = 0.75;
    private Hashtable nodes = new Hashtable();
    private Hashtable edges = new Hashtable();

    private GraphNode getGraphNode(Figure node) {
        return (GraphNode)this.nodes.get(node);
    }

    private double len(Figure edge) {
        return (Double)this.edges.get(edge) * this.LENGTH_FACTOR;
    }

    public void addNode(Figure node) {
        this.nodes.put(node, new GraphNode(node));
        node.addFigureChangeListener(this);
    }

    public void addEdge(ConnectionFigure edge, int addlen) {
        Dimension d1 = edge.getStartConnector().owner().size();
        Dimension d2 = edge.getEndConnector().owner().size();
        int len = Math.max(d1.width, d1.height) / 2 + Math.max(d2.width, d2.height) / 2 + addlen;
        this.edges.put(edge, new Double(len));
    }

    public synchronized void relax() {
        if (this.nodes == null) {
            return;
        }
        Enumeration edgeEnum = this.edges.keys();
        while (edgeEnum.hasMoreElements()) {
            ConnectionFigure e = (ConnectionFigure)edgeEnum.nextElement();
            double targetlen = this.len(e);
            GraphNode from = this.getGraphNode(e.getStartConnector().owner());
            GraphNode to = this.getGraphNode(e.getEndConnector().owner());
            double vx = to.x - from.x;
            double vy = to.y - from.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            if (!(len > 0.0)) continue;
            double f = this.SPRING_STRENGTH * (targetlen - len) / len;
            double dx = f * vx;
            double dy = f * vy;
            double phi = Math.atan2(vx, vy);
            double dir = -Math.sin(4.0 * phi);
            to.dx += (dx += this.TORQUE_STRENGTH * vy * dir / len);
            to.dy += (dy += -this.TORQUE_STRENGTH * vx * dir / len);
            from.dx += -dx;
            from.dy += -dy;
        }
        Enumeration nodeEnum1 = this.nodes.elements();
        while (nodeEnum1.hasMoreElements()) {
            GraphNode n1 = (GraphNode)nodeEnum1.nextElement();
            double dx = 0.0;
            double dy = 0.0;
            Enumeration nodeEnum2 = this.nodes.elements();
            while (nodeEnum2.hasMoreElements()) {
                GraphNode n2 = (GraphNode)nodeEnum2.nextElement();
                if (n1 == n2) continue;
                double vx = n1.x - n2.x;
                double vy = n1.y - n2.y;
                double lensqr = vx * vx + vy * vy;
                double len = Math.sqrt(lensqr);
                if (len == 0.0) {
                    dx += this.REPULSION_STRENGTH * Math.random();
                    dy += this.REPULSION_STRENGTH * Math.random();
                    continue;
                }
                if (!(len < this.REPULSION_LIMIT)) continue;
                vx /= this.REPULSION_LIMIT;
                vy /= this.REPULSION_LIMIT;
                len /= this.REPULSION_LIMIT;
                double f = 0.0;
                switch (this.REPULSION_TYPE) {
                    case 0: {
                        f = 0.5 * (1.0 - len) / len;
                        break;
                    }
                    case 1: {
                        f = 1.0 - len;
                        break;
                    }
                    case 2: {
                        f = 2.0 * (1.0 - len) * (1.0 - len);
                    }
                }
                dx += (f *= this.REPULSION_STRENGTH) * vx;
                dy += f * vy;
            }
            n1.dx += dx;
            n1.dy += dy;
        }
        Enumeration nodeEnum = this.nodes.keys();
        while (nodeEnum.hasMoreElements()) {
            Figure node = (Figure)nodeEnum.nextElement();
            GraphNode n = this.getGraphNode(node);
            if (!Boolean.TRUE.equals(node.getAttribute("Location"))) {
                n.x += Math.max(-5.0, Math.min(5.0, n.dx));
                n.y += Math.max(-5.0, Math.min(5.0, n.dy));
                Point c = node.center();
                node.moveBy((int)Math.round(n.x) - c.x, (int)Math.round(n.y) - c.y);
                if (n.x < 0.0) {
                    n.x = 0.0;
                }
                if (n.y < 0.0) {
                    n.y = 0.0;
                }
            }
            n.dx *= this.FRICTION_FACTOR;
            n.dy *= this.FRICTION_FACTOR;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent e) {
        Figure node;
        if (this.nodes != null && this.nodes.containsKey(node = e.getFigure())) {
            this.getGraphNode(node).update();
        }
    }

    public void remove() {
        if (this.nodes != null) {
            Enumeration nodeEnum = this.nodes.keys();
            while (nodeEnum.hasMoreElements()) {
                Figure node = (Figure)nodeEnum.nextElement();
                node.removeFigureChangeListener(this);
            }
            this.nodes = null;
            this.edges = null;
        }
    }
}

