/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.ip;

import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericTokenizer;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;

public class IpFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "ip";
    public static final long MAX_IP = 0x100000000L;
    private static final Pattern pattern = Pattern.compile("\\.");
    private static final Pattern MASK_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");

    public static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    public static long ipToLong(String ip) {
        try {
            if (!InetAddresses.isInetAddress((String)ip)) {
                throw new IllegalArgumentException("failed to parse ip [" + ip + "], not a valid ip address");
            }
            String[] octets = pattern.split(ip);
            if (octets.length != 4) {
                throw new IllegalArgumentException("failed to parse ip [" + ip + "], not a valid ipv4 address (4 dots)");
            }
            return (Long.parseLong(octets[0]) << 24) + (long)(Integer.parseInt(octets[1]) << 16) + (long)(Integer.parseInt(octets[2]) << 8) + (long)Integer.parseInt(octets[3]);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new IllegalArgumentException("failed to parse ip [" + ip + "]", e);
        }
    }

    public static long[] cidrMaskToMinMax(String cidr) {
        int to;
        long longTo;
        int from;
        long longFrom;
        Matcher matcher = MASK_PATTERN.matcher(cidr);
        if (!matcher.matches()) {
            return null;
        }
        int addr = Integer.parseInt(matcher.group(1)) << 24 & 0xFF000000 | Integer.parseInt(matcher.group(2)) << 16 & 0xFF0000 | Integer.parseInt(matcher.group(3)) << 8 & 0xFF00 | Integer.parseInt(matcher.group(4)) & 0xFF;
        int mask = -1 << 32 - Integer.parseInt(matcher.group(5));
        if (Integer.parseInt(matcher.group(5)) == 0) {
            mask = 0;
        }
        if ((longFrom = IpFieldMapper.intIpToLongIp(from = addr & mask)) == 0L) {
            longFrom = -1L;
        }
        if ((longTo = IpFieldMapper.intIpToLongIp(to = from + ~mask) + 1L) == 0x100000000L) {
            longTo = -1L;
        }
        return new long[]{longFrom, longTo};
    }

    private static long intIpToLongIp(int i) {
        long p1 = (long)(i >> 24 & 0xFF) << 24;
        int p2 = (i >> 16 & 0xFF) << 16;
        int p3 = (i >> 8 & 0xFF) << 8;
        int p4 = i & 0xFF;
        return p1 + (long)p2 + (long)p3 + (long)p4;
    }

    protected IpFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    private static long parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return IpFieldMapper.ipToLong(((BytesRef)value).utf8ToString());
        }
        return IpFieldMapper.ipToLong(value.toString());
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        String ipAsString;
        if (context.externalValueSet()) {
            ipAsString = (String)context.externalValue();
            if (ipAsString == null) {
                ipAsString = this.fieldType().nullValueAsString();
            }
        } else {
            ipAsString = context.parser().currentToken() == XContentParser.Token.VALUE_NULL ? this.fieldType().nullValueAsString() : context.parser().text();
        }
        if (ipAsString == null) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().names().fullName(), ipAsString, this.fieldType().boost());
        }
        long value = IpFieldMapper.ipToLong(ipAsString);
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            LongFieldMapper.CustomLongNumericField field = new LongFieldMapper.CustomLongNumericField(value, this.fieldType());
            field.setBoost(this.fieldType().boost());
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 16) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValueAsString() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class NumericIpTokenizer
    extends NumericTokenizer {
        public NumericIpTokenizer(int precisionStep, char[] buffer) throws IOException {
            super(new NumericTokenStream(precisionStep), buffer, null);
        }

        @Override
        protected void setValue(NumericTokenStream tokenStream, String value) {
            tokenStream.setLongValue(IpFieldMapper.ipToLong(value));
        }
    }

    public static class NumericIpAnalyzer
    extends NumericAnalyzer<NumericIpTokenizer> {
        private final int precisionStep;

        public NumericIpAnalyzer(int precisionStep) {
            this.precisionStep = precisionStep;
        }

        @Override
        protected NumericIpTokenizer createNumericTokenizer(char[] buffer) throws IOException {
            return new NumericIpTokenizer(this.precisionStep, buffer);
        }
    }

    public static final class IpFieldType
    extends LongFieldMapper.LongFieldType {
        public IpFieldType() {
            this.setFieldDataType(new FieldDataType("long"));
        }

        protected IpFieldType(IpFieldType ref) {
            super(ref);
        }

        @Override
        public NumberFieldMapper.NumberFieldType clone() {
            return new IpFieldType(this);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Long value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                return Numbers.bytesToLong((BytesRef)value);
            }
            return IpFieldMapper.ipToLong(value.toString());
        }

        @Override
        public Object valueForSearch(Object value) {
            Long val = this.value(value);
            if (val == null) {
                return null;
            }
            return IpFieldMapper.longToIp(val);
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.longToPrefixCoded((long)IpFieldMapper.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryParseContext context) {
            long[] fromTo;
            if (value != null && (fromTo = value instanceof BytesRef ? IpFieldMapper.cidrMaskToMinMax(((BytesRef)value).utf8ToString()) : IpFieldMapper.cidrMaskToMinMax(value.toString())) != null) {
                return this.rangeQuery(fromTo[0] < 0L ? null : Long.valueOf(fromTo[0]), fromTo[1] < 0L ? null : Long.valueOf(fromTo[1]), true, false);
            }
            return super.termQuery(value, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Long)(lowerTerm == null ? null : Long.valueOf(IpFieldMapper.parseValue(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(IpFieldMapper.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            long iSim;
            long iValue = IpFieldMapper.parseValue(value);
            try {
                iSim = IpFieldMapper.ipToLong(fuzziness.asString());
            }
            catch (IllegalArgumentException e) {
                iSim = fuzziness.asLong();
            }
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.ipField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(propNode.toString());
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IpFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 16);
            this.builder = this;
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            IpFieldMapper fieldMapper = new IpFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (IpFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            String name = precisionStep == Integer.MAX_VALUE ? "_ip/max" : "_ip/" + precisionStep;
            return new NamedAnalyzer(name, new NumericIpAnalyzer(precisionStep));
        }

        @Override
        protected int maxPrecisionStep() {
            return 64;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NULL_VALUE = null;
        public static final MappedFieldType FIELD_TYPE = new IpFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

