/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.AbstractScriptParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;

public class Template
extends Script {
    private XContentType contentType;

    public Template() {
    }

    public Template(String template) {
        super(template, "mustache");
    }

    public Template(String template, ScriptService.ScriptType type, @Nullable String lang, @Nullable XContentType xContentType, @Nullable Map<String, Object> params) {
        super(template, type, lang, params);
        this.contentType = xContentType;
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.contentType = XContentType.readFrom(in);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        boolean hasContentType = this.contentType != null;
        out.writeBoolean(hasContentType);
        if (hasContentType) {
            XContentType.writeTo(this.contentType, out);
        }
    }

    @Override
    protected XContentBuilder scriptFieldToXContent(String template, ScriptService.ScriptType type, XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (type == ScriptService.ScriptType.INLINE && this.contentType != null && builder.contentType() == this.contentType) {
            builder.rawField(type.getParseField().getPreferredName(), new BytesArray(template));
        } else {
            builder.field(type.getParseField().getPreferredName(), template);
        }
        return builder;
    }

    public static Template readTemplate(StreamInput in) throws IOException {
        Template template = new Template();
        template.readFrom(in);
        return template;
    }

    public static Script parse(Map<String, Object> config, boolean removeMatchedEntries, ParseFieldMatcher parseFieldMatcher) {
        return new TemplateParser(Collections.EMPTY_MAP, "mustache").parse(config, removeMatchedEntries, parseFieldMatcher);
    }

    public static Template parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return (Template)new TemplateParser(Collections.EMPTY_MAP, "mustache").parse(parser, parseFieldMatcher);
    }

    @Deprecated
    public static Template parse(XContentParser parser, Map<String, ScriptService.ScriptType> additionalTemplateFieldNames, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return (Template)new TemplateParser(additionalTemplateFieldNames, "mustache").parse(parser, parseFieldMatcher);
    }

    @Deprecated
    public static Template parse(XContentParser parser, Map<String, ScriptService.ScriptType> additionalTemplateFieldNames, String defaultLang, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return (Template)new TemplateParser(additionalTemplateFieldNames, defaultLang).parse(parser, parseFieldMatcher);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return this.contentType == other.contentType;
    }

    private static class TemplateParser
    extends AbstractScriptParser<Template> {
        private XContentType contentType = null;
        private final Map<String, ScriptService.ScriptType> additionalTemplateFieldNames;
        private String defaultLang;

        public TemplateParser(Map<String, ScriptService.ScriptType> additionalTemplateFieldNames, String defaultLang) {
            this.additionalTemplateFieldNames = additionalTemplateFieldNames;
            this.defaultLang = defaultLang;
        }

        @Override
        protected Template createSimpleScript(XContentParser parser) throws IOException {
            return new Template(String.valueOf(parser.objectText()), ScriptService.ScriptType.INLINE, "mustache", this.contentType, null);
        }

        @Override
        protected Template createScript(String script, ScriptService.ScriptType type, String lang, Map<String, Object> params) {
            return new Template(script, type, lang, this.contentType, params);
        }

        @Override
        protected String parseInlineScript(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                this.contentType = parser.contentType();
                XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
                return builder.copyCurrentStructure(parser).bytes().toUtf8();
            }
            return parser.text();
        }

        @Override
        protected Map<String, ScriptService.ScriptType> getAdditionalScriptParameters() {
            return this.additionalTemplateFieldNames;
        }

        @Override
        protected String getDefaultScriptLang() {
            return this.defaultLang;
        }
    }
}

