/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.cache.MinimalPersistentCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotDataSerializer;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.serialize.HashValueSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarSnapshotCache
implements JarSnapshotCache {
    private final MinimalPersistentCache<HashValue, JarSnapshotData> cache;

    public DefaultJarSnapshotCache(CacheRepository cacheRepository) {
        this.cache = new MinimalPersistentCache(cacheRepository, "jar snapshots", (Serializer)new HashValueSerializer(), (Serializer)new JarSnapshotDataSerializer());
    }

    @Override
    public Map<File, JarSnapshot> getJarSnapshots(final Map<File, HashValue> jarHashes) {
        return (Map)this.cache.getCacheAccess().useCache("loading jar snapshots", (Factory)new Factory<Map<File, JarSnapshot>>(){

            public Map<File, JarSnapshot> create() {
                HashMap<File, JarSnapshot> out = new HashMap<File, JarSnapshot>();
                for (Map.Entry entry : jarHashes.entrySet()) {
                    JarSnapshot snapshot = new JarSnapshot((JarSnapshotData)DefaultJarSnapshotCache.this.cache.getCache().get(entry.getValue()));
                    out.put((File)entry.getKey(), snapshot);
                }
                return out;
            }
        });
    }

    public JarSnapshot get(HashValue key, final Factory<JarSnapshot> factory) {
        return new JarSnapshot((JarSnapshotData)this.cache.get((Object)key, (Factory)new Factory<JarSnapshotData>(){

            public JarSnapshotData create() {
                return ((JarSnapshot)factory.create()).getData();
            }
        }));
    }

    public void stop() {
        this.cache.stop();
    }
}

