/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.DefaultMemoryElementDescriptor;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDoubleLinkedListMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDoubleLinkedListMemoryCache.class);
    protected DoubleLinkedList<MemoryElementDescriptor<K, V>> list;
    private AtomicLong hitCnt;
    private AtomicLong missCnt;
    private AtomicLong putCnt;

    @Override
    public void initialize(CompositeCache<K, V> compositeCache) {
        this.lock.lock();
        try {
            super.initialize(compositeCache);
            this.hitCnt = new AtomicLong(0L);
            this.missCnt = new AtomicLong(0L);
            this.putCnt = new AtomicLong(0L);
            this.list = new DoubleLinkedList();
            log.info("initialized MemoryCache for " + this.getCacheName());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void dispose() throws IOException {
        super.dispose();
        this.removeAll();
        this.hitCnt.set(0L);
        this.missCnt.set(0L);
        this.putCnt.set(0L);
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> iCacheElement) throws IOException {
        this.putCnt.incrementAndGet();
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> memoryElementDescriptor = this.adjustListForUpdate(iCacheElement);
            K k = memoryElementDescriptor.getCacheElement().getKey();
            MemoryElementDescriptor<K, V> memoryElementDescriptor2 = this.map.put(k, memoryElementDescriptor);
            if (memoryElementDescriptor2 != null && k.equals(memoryElementDescriptor2.getCacheElement().getKey())) {
                this.list.remove(memoryElementDescriptor2);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor<K, V> adjustListForUpdate(ICacheElement<K, V> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolIfNeeded() throws Error {
        int n = this.map.size();
        if (n <= this.getCacheAttributes().getMaxObjects()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("In memory limit reached, spooling");
        }
        int n2 = Math.min(n, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug("About to spool to disk cache, map size: " + n + ", max objects: " + this.getCacheAttributes().getMaxObjects() + ", maximum items to spool: " + n2);
        }
        this.lock.lock();
        try {
            ICacheElement<K, V> iCacheElement;
            for (int i = 0; i < n2 && (iCacheElement = this.spoolLastElement()) != null; ++i) {
            }
            if (log.isDebugEnabled() && this.map.size() != this.list.size()) {
                log.debug("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.list.size());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("update: After spool map size: " + this.map.size() + " linked list size = " + this.list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICacheElement<K, V> get(K k) throws IOException {
        MemoryElementDescriptor memoryElementDescriptor;
        ICacheElement iCacheElement = null;
        if (log.isDebugEnabled()) {
            log.debug(this.getCacheName() + ": getting item for key " + k);
        }
        if ((memoryElementDescriptor = (MemoryElementDescriptor)this.map.get(k)) != null) {
            this.hitCnt.incrementAndGet();
            this.lock.lock();
            try {
                iCacheElement = memoryElementDescriptor.getCacheElement();
                this.adjustListForGet(memoryElementDescriptor);
            }
            finally {
                this.lock.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug(this.getCacheName() + ": LRUMemoryCache hit for " + k);
            }
        } else {
            this.missCnt.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(this.getCacheName() + ": LRUMemoryCache miss for " + k);
            }
        }
        if (log.isDebugEnabled()) {
            this.verifyCache();
        }
        return iCacheElement;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor<K, V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeElements(int n) throws IOException {
        int n2;
        this.lock.lock();
        try {
            for (n2 = 0; n2 < n; ++n2) {
                ICacheElement<K, V> iCacheElement = this.spoolLastElement();
                if (iCacheElement != null) continue;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return n2;
    }

    private ICacheElement<K, V> spoolLastElement() throws Error {
        ICacheElement<K, V> iCacheElement = null;
        MemoryElementDescriptor<K, V> memoryElementDescriptor = this.list.getLast();
        if (memoryElementDescriptor != null) {
            iCacheElement = memoryElementDescriptor.getCacheElement();
            if (iCacheElement != null) {
                this.getCompositeCache().spoolToDisk(iCacheElement);
                if (this.map.remove(iCacheElement.getKey()) == null) {
                    log.warn("update: remove failed for key: " + iCacheElement.getKey());
                    if (log.isDebugEnabled()) {
                        this.verifyCache();
                    }
                }
            } else {
                throw new Error("update: last.ce is null!");
            }
            this.list.remove(memoryElementDescriptor);
        }
        return iCacheElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(K k) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("removing item for key: " + k);
        }
        boolean bl = false;
        if (k instanceof String && ((String)k).endsWith(":")) {
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                if (!(k2 instanceof String) || !((String)k2).startsWith(k.toString())) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    iterator.remove();
                    bl = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return bl;
        } else if (k instanceof GroupAttrName && ((GroupAttrName)k).attrName == null) {
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k3 = entry.getKey();
                if (!(k3 instanceof GroupAttrName) || !((GroupAttrName)k3).groupId.equals(((GroupAttrName)k).groupId)) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    iterator.remove();
                    bl = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return bl;
        } else {
            this.lock.lock();
            try {
                MemoryElementDescriptor memoryElementDescriptor = (MemoryElementDescriptor)this.map.remove(k);
                if (memoryElementDescriptor == null) return bl;
                this.list.remove(memoryElementDescriptor);
                bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void removeAll() throws IOException {
        this.lock.lock();
        try {
            this.list.removeAll();
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addFirst(ICacheElement<K, V> iCacheElement) {
        this.lock.lock();
        try {
            DefaultMemoryElementDescriptor<K, V> defaultMemoryElementDescriptor = new DefaultMemoryElementDescriptor<K, V>(iCacheElement);
            this.list.addFirst(defaultMemoryElementDescriptor);
            if (log.isDebugEnabled()) {
                this.verifyCache(iCacheElement.getKey());
            }
            DefaultMemoryElementDescriptor<K, V> defaultMemoryElementDescriptor2 = defaultMemoryElementDescriptor;
            return defaultMemoryElementDescriptor2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addLast(ICacheElement<K, V> iCacheElement) {
        this.lock.lock();
        try {
            DefaultMemoryElementDescriptor<K, V> defaultMemoryElementDescriptor = new DefaultMemoryElementDescriptor<K, V>(iCacheElement);
            this.list.addLast(defaultMemoryElementDescriptor);
            if (log.isDebugEnabled()) {
                this.verifyCache(iCacheElement.getKey());
            }
            DefaultMemoryElementDescriptor<K, V> defaultMemoryElementDescriptor2 = defaultMemoryElementDescriptor;
            return defaultMemoryElementDescriptor2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void dumpCacheEntries() {
        log.debug("dumpingCacheEntries");
        MemoryElementDescriptor memoryElementDescriptor = this.list.getFirst();
        while (memoryElementDescriptor != null) {
            log.debug("dumpCacheEntries> key=" + memoryElementDescriptor.getCacheElement().getKey() + ", val=" + memoryElementDescriptor.getCacheElement().getVal());
            memoryElementDescriptor = (MemoryElementDescriptor)memoryElementDescriptor.next;
        }
    }

    private void verifyCache() {
        Serializable serializable;
        boolean bl = false;
        log.debug("verifycache[" + this.getCacheName() + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.list.size() + " elements");
        log.debug("verifycache: checking linked list by key ");
        Object object = this.list.getFirst();
        while (object != null) {
            Object object2 = ((MemoryElementDescriptor)object).getCacheElement().getKey();
            if (!this.map.containsKey(object2)) {
                log.error("verifycache[" + this.getCacheName() + "]: map does not contain key : " + object2);
                log.error("key class=" + object2.getClass());
                log.error("key hashcode=" + object2.hashCode());
                log.error("key toString=" + object2.toString());
                if (object2 instanceof GroupAttrName) {
                    serializable = (GroupAttrName)object2;
                    log.error("GroupID hashcode=" + ((GroupAttrName)serializable).groupId.hashCode());
                    log.error("GroupID.class=" + ((GroupAttrName)serializable).groupId.getClass());
                    log.error("AttrName hashcode=" + ((GroupAttrName)serializable).attrName.hashCode());
                    log.error("AttrName.class=" + ((GroupAttrName)serializable).attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(object2) == null) {
                log.error("verifycache[" + this.getCacheName() + "]: linked list retrieval returned null for key: " + object2);
            }
            object = (MemoryElementDescriptor)((MemoryElementDescriptor)object).next;
        }
        log.debug("verifycache: checking linked list by value ");
        object = this.list.getFirst();
        while (object != null) {
            if (!this.map.containsValue(object)) {
                log.error("verifycache[" + this.getCacheName() + "]: map does not contain value : " + object);
                this.dumpMap();
            }
            object = (MemoryElementDescriptor)((MemoryElementDescriptor)object).next;
        }
        log.debug("verifycache: checking via keysets!");
        for (Object object2 : this.map.keySet()) {
            bl = false;
            serializable = this.list.getFirst();
            while (serializable != null) {
                if (object2.equals(serializable.getCacheElement().getKey())) {
                    bl = true;
                    break;
                }
                serializable = (MemoryElementDescriptor)serializable.next;
            }
            if (bl) continue;
            log.error("verifycache[" + this.getCacheName() + "]: key not found in list : " + object2);
            this.dumpCacheEntries();
            if (this.map.containsKey(object2)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(K k) {
        boolean bl = false;
        MemoryElementDescriptor memoryElementDescriptor = this.list.getFirst();
        while (memoryElementDescriptor != null) {
            if (memoryElementDescriptor.getCacheElement().getKey() == k) {
                bl = true;
                log.debug("verifycache(key) key match: " + k);
                break;
            }
            memoryElementDescriptor = (MemoryElementDescriptor)memoryElementDescriptor.next;
        }
        if (!bl) {
            log.error("verifycache(key)[" + this.getCacheName() + "], couldn't find key! : " + k);
        }
    }

    @Override
    public Set<K> getKeySet() {
        return new LinkedHashSet(this.map.keySet());
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Memory Cache");
        ArrayList arrayList = new ArrayList();
        this.lock.lock();
        try {
            arrayList.add(new StatElement<Integer>("List Size", this.list.size()));
            arrayList.add(new StatElement<Integer>("Map Size", this.map.size()));
            arrayList.add(new StatElement<AtomicLong>("Put Count", this.putCnt));
            arrayList.add(new StatElement<AtomicLong>("Hit Count", this.hitCnt));
            arrayList.add(new StatElement<AtomicLong>("Miss Count", this.missCnt));
        }
        finally {
            this.lock.unlock();
        }
        stats.setStatElements(arrayList);
        return stats;
    }
}

