/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public abstract class CrossingWays
extends Test {
    protected static final int CROSSING_WAYS = 601;
    private static final String HIGHWAY = "highway";
    private static final String RAILWAY = "railway";
    private static final String WATERWAY = "waterway";
    private final Map<Point2D, List<WaySegment>> cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
    private final Set<WaySegment> errorSegments = new HashSet<WaySegment>();
    private final Map<List<Way>, List<WaySegment>> seenWays = new HashMap<List<Way>, List<WaySegment>>(50);

    public CrossingWays(String string) {
        super(string, I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellSegments.clear();
        this.errorSegments.clear();
        this.seenWays.clear();
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments.clear();
        this.errorSegments.clear();
        this.seenWays.clear();
    }

    static String getLayer(OsmPrimitive osmPrimitive) {
        String string = osmPrimitive.get("layer");
        if ("0".equals(string)) {
            string = null;
        }
        return string;
    }

    static boolean isCoastline(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag("natural", "water", "coastline") || osmPrimitive.hasTag("landuse", "reservoir");
    }

    static boolean isSubwayOrTram(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag(RAILWAY, "subway", "tram");
    }

    static boolean isProposedOrAbandoned(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag(HIGHWAY, "proposed") || osmPrimitive.hasTag(RAILWAY, "proposed", "abandoned");
    }

    abstract boolean ignoreWaySegmentCombination(Way var1, Way var2);

    abstract String createMessage(Way var1, Way var2);

    @Override
    public void visit(Way way) {
        int n = way.getNodesCount();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            EastNorth eastNorth = waySegment.getFirstNode().getEastNorth();
            EastNorth eastNorth2 = waySegment.getSecondNode().getEastNorth();
            if (eastNorth == null || eastNorth2 == null) {
                Main.warn("Crossing ways test skipped " + waySegment);
                continue;
            }
            for (List<WaySegment> list : this.getSegments(eastNorth, eastNorth2)) {
                for (WaySegment waySegment2 : list) {
                    if (this.errorSegments.contains(waySegment) && this.errorSegments.contains(waySegment2) || !waySegment.intersects(waySegment2) || this.ignoreWaySegmentCombination(waySegment.way, waySegment2.way)) continue;
                    List<Way> list2 = Arrays.asList(waySegment.way, waySegment2.way);
                    List<WaySegment> list3 = this.seenWays.get(list2);
                    if (list3 == null) {
                        list3 = new ArrayList<WaySegment>();
                        list3.add(waySegment);
                        list3.add(waySegment2);
                        String string = this.createMessage(waySegment.way, waySegment2.way);
                        this.errors.add(new TestError(this, Severity.WARNING, string, 601, list2, list3));
                        this.seenWays.put(list2, list3);
                        continue;
                    }
                    list3.add(waySegment);
                    list3.add(waySegment2);
                }
                list.add(waySegment);
            }
        }
    }

    public List<List<WaySegment>> getSegments(EastNorth eastNorth, EastNorth eastNorth2) {
        ArrayList<List<WaySegment>> arrayList = new ArrayList<List<WaySegment>>();
        for (Point2D point2D : ValUtil.getSegmentCells(eastNorth, eastNorth2, OsmValidator.griddetail)) {
            List<WaySegment> list = this.cellSegments.get(point2D);
            if (list == null) {
                list = new ArrayList<WaySegment>();
                this.cellSegments.put(point2D, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static class Barrier
    extends CrossingWays {
        public Barrier() {
            super(I18n.tr("Crossing barriers", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("barrier");
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            return !Objects.equals(Barrier.getLayer(way), Barrier.getLayer(way2));
        }

        @Override
        String createMessage(Way way, Way way2) {
            return I18n.tr("Crossing barriers", new Object[0]);
        }
    }

    public static class Boundaries
    extends CrossingWays {
        public Boundaries() {
            super(I18n.tr("Crossing boundaries", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("boundary") && (!(osmPrimitive instanceof Relation) || ((Relation)osmPrimitive).isMultipolygon() && !((Relation)osmPrimitive).hasIncompleteMembers());
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            return !Objects.equals(way.get("boundary"), way2.get("boundary"));
        }

        @Override
        String createMessage(Way way, Way way2) {
            return I18n.tr("Crossing boundaries", new Object[0]);
        }

        @Override
        public void visit(Relation relation) {
            for (Way way : relation.getMemberPrimitives(Way.class)) {
                this.visit(way);
            }
        }
    }

    public static class Ways
    extends CrossingWays {
        public Ways() {
            super(I18n.tr("Crossing ways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && !Ways.isProposedOrAbandoned(osmPrimitive) && (osmPrimitive.hasKey(CrossingWays.HIGHWAY) && !osmPrimitive.hasTag(CrossingWays.HIGHWAY, "rest_area", "services") || osmPrimitive.hasKey(CrossingWays.WATERWAY) || osmPrimitive.hasKey(CrossingWays.RAILWAY) && !Ways.isSubwayOrTram(osmPrimitive) || Ways.isCoastline(osmPrimitive) || Ways.isBuilding(osmPrimitive));
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            if (!Objects.equals(Ways.getLayer(way), Ways.getLayer(way2))) {
                return true;
            }
            if (way.hasKey(CrossingWays.HIGHWAY) && way2.hasKey(CrossingWays.HIGHWAY) && !Objects.equals(way.get("level"), way2.get("level"))) {
                return true;
            }
            if (Ways.isSubwayOrTram(way2)) {
                return true;
            }
            if (Ways.isCoastline(way) != Ways.isCoastline(way2)) {
                return true;
            }
            if (way.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && way2.hasTag(CrossingWays.WATERWAY, "riverbank") || way2.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && way.hasTag(CrossingWays.WATERWAY, "riverbank")) {
                return true;
            }
            return Ways.isProposedOrAbandoned(way2);
        }

        @Override
        String createMessage(Way way, Way way2) {
            if (Ways.isBuilding(way)) {
                return I18n.tr("Crossing buildings", new Object[0]);
            }
            if (way.hasKey(CrossingWays.WATERWAY) && way2.hasKey(CrossingWays.WATERWAY)) {
                return I18n.tr("Crossing waterways", new Object[0]);
            }
            if (way.hasKey(CrossingWays.HIGHWAY) && way2.hasKey(CrossingWays.WATERWAY) || way2.hasKey(CrossingWays.HIGHWAY) && way.hasKey(CrossingWays.WATERWAY)) {
                return I18n.tr("Crossing waterway/highway", new Object[0]);
            }
            return I18n.tr("Crossing ways", new Object[0]);
        }
    }
}

