/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FiberQueue {
    protected BlockingQueue<IRubyObject> queue;
    protected final Ruby runtime;
    final RubyThread.Task<FiberQueue, IRubyObject> takeTask = new RubyThread.Task<FiberQueue, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, FiberQueue queue) throws InterruptedException {
            return queue.getQueueSafe().take();
        }

        @Override
        public void wakeup(RubyThread thread2, FiberQueue data2) {
            thread2.getNativeThread().interrupt();
        }
    };
    final RubyThread.Task<IRubyObject[], IRubyObject> putTask = new RubyThread.Task<IRubyObject[], IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject[] args2) throws InterruptedException {
            BlockingQueue<IRubyObject> queue = FiberQueue.this.getQueueSafe();
            if (args2.length == 2 && args2[1].isTrue() && queue.remainingCapacity() == 0) {
                throw context.runtime.newThreadError("queue full");
            }
            queue.put(args2[0]);
            return context.nil;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject[] data2) {
            thread2.getNativeThread().interrupt();
        }
    };

    public FiberQueue(Ruby runtime) {
        this.runtime = runtime;
        this.queue = new ArrayBlockingQueue<IRubyObject>(1, false);
    }

    public IRubyObject shutdown(ThreadContext context) {
        this.queue = null;
        return context.runtime.getNil();
    }

    public synchronized void shutdown() {
        this.queue = null;
    }

    public boolean isShutdown() {
        return this.queue == null;
    }

    public BlockingQueue<IRubyObject> getQueueSafe() {
        BlockingQueue<IRubyObject> queue = this.queue;
        this.checkShutdown();
        return queue;
    }

    public synchronized void checkShutdown() {
        if (this.queue == null) {
            throw new RaiseException(this.runtime, this.runtime.getThreadError(), "queue shut down", false);
        }
    }

    public IRubyObject pop(ThreadContext context) {
        return this.pop(context, true);
    }

    public IRubyObject pop(ThreadContext context, IRubyObject arg0) {
        return this.pop(context, !arg0.isTrue());
    }

    public void push(ThreadContext context, IRubyObject[] args2) {
        this.checkShutdown();
        try {
            context.getThread().executeTask(context, args2, this.putTask);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in FiberQueue.push");
        }
    }

    private IRubyObject pop(ThreadContext context, boolean should_block) {
        BlockingQueue<IRubyObject> queue = this.getQueueSafe();
        if (!should_block && queue.size() == 0) {
            throw new RaiseException(context.runtime, context.runtime.getThreadError(), "queue empty", false);
        }
        try {
            return context.getThread().executeTask(context, this, this.takeTask);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in FiberQueue.pop");
        }
    }
}

