/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignReadStringCachingHelperNode;
import org.jruby.truffle.interop.ToJavaStringNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
final class ForeignReadStringCachingHelperNodeGen
extends ForeignReadStringCachingHelperNode
implements SpecializedNode {
    @Node.Child
    private RubyNode receiver_;
    @Node.Child
    private RubyNode name_;
    @CompilerDirectives.CompilationFinal
    private Class<?> nameType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ForeignReadStringCachingHelperNodeGen(RubyContext context, RubyNode receiver, RubyNode name) {
        super(context);
        this.receiver_ = receiver;
        this.name_ = name;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeStringCachingHelper(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
        return this.specialization_.execute1(frameValue, receiverValue, nameValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ForeignReadStringCachingHelperNode create(RubyContext context, RubyNode receiver, RubyNode name) {
        return new ForeignReadStringCachingHelperNodeGen(context, receiver, name);
    }

    @GeneratedBy(methodName="indexObject(VirtualFrame, DynamicObject, Object, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexObjectNode_
    extends BaseNode_ {
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        IndexObjectNode_(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 4);
            this.nextHelper = nextHelper;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (!RubyGuards.isRubyString(receiverValue) && !this.root.isStringLike(nameValue)) {
                return this.root.indexObject(frameValue, receiverValue, nameValue, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            DynamicObject receiverValue_;
            if (receiverValue instanceof DynamicObject && !RubyGuards.isRubyString(receiverValue_ = (DynamicObject)receiverValue) && !this.root.isStringLike(nameValue)) {
                return this.root.indexObject(frameValue, receiverValue_, nameValue, this.nextHelper);
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            return new IndexObjectNode_(root, nextHelper);
        }
    }

    @GeneratedBy(methodName="indexStringOutOfRange(DynamicObject, int)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexStringOutOfRangeNode_
    extends BaseNode_ {
        private final Class<?> nameImplicitType;

        IndexStringOutOfRangeNode_(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            super(root, 3);
            this.nameImplicitType = RubyTypesGen.getImplicitIntegerClass(nameValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.nameImplicitType == ((IndexStringOutOfRangeNode_)other).nameImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int nameValue_;
            DynamicObject receiverValue_;
            try {
                receiverValue_ = this.root.receiver_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.executeName_(frameValue);
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
            }
            try {
                if (this.nameImplicitType == Integer.TYPE) {
                    nameValue_ = this.root.name_.executeInteger(frameValue);
                } else {
                    Object nameValue__ = this.executeName_(frameValue);
                    nameValue_ = RubyTypesGen.expectImplicitInteger(nameValue__, this.nameImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyString(receiverValue_) && !this.root.inRange(receiverValue_, nameValue_)) {
                return this.root.indexStringOutOfRange(receiverValue_, nameValue_);
            }
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, nameValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue) && !this.root.inRange(receiverValue, nameValue_)) {
                    return this.root.indexStringOutOfRange(receiverValue, nameValue_);
                }
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue_) && !this.root.inRange(receiverValue_, nameValue_)) {
                    return this.root.indexStringOutOfRange(receiverValue_, nameValue_);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            return new IndexStringOutOfRangeNode_(root, nameValue);
        }
    }

    @GeneratedBy(methodName="indexString(DynamicObject, int)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexStringNode_
    extends BaseNode_ {
        private final Class<?> nameImplicitType;

        IndexStringNode_(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            super(root, 2);
            this.nameImplicitType = RubyTypesGen.getImplicitIntegerClass(nameValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.nameImplicitType == ((IndexStringNode_)other).nameImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int nameValue_;
            DynamicObject receiverValue_;
            try {
                receiverValue_ = this.root.receiver_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.executeName_(frameValue);
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
            }
            try {
                if (this.nameImplicitType == Integer.TYPE) {
                    nameValue_ = this.root.name_.executeInteger(frameValue);
                } else {
                    Object nameValue__ = this.executeName_(frameValue);
                    nameValue_ = RubyTypesGen.expectImplicitInteger(nameValue__, this.nameImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyString(receiverValue_) && this.root.inRange(receiverValue_, nameValue_)) {
                return this.root.indexString(receiverValue_, nameValue_);
            }
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, nameValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue) && this.root.inRange(receiverValue, nameValue_)) {
                    return this.root.indexString(receiverValue, nameValue_);
                }
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue_) && this.root.inRange(receiverValue_, nameValue_)) {
                    return this.root.indexString(receiverValue_, nameValue_);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            return new IndexStringNode_(root, nameValue);
        }
    }

    @GeneratedBy(methodName="cacheStringLikeAndForward(VirtualFrame, DynamicObject, Object, ToJavaStringNode, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class CacheStringLikeAndForwardNode_
    extends BaseNode_ {
        @Node.Child
        private ToJavaStringNode toJavaStringNode;
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        CacheStringLikeAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, ToJavaStringNode toJavaStringNode, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 1);
            this.toJavaStringNode = toJavaStringNode;
            this.nextHelper = nextHelper;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (this.root.isStringLike(nameValue)) {
                return this.root.cacheStringLikeAndForward(frameValue, receiverValue, nameValue, this.toJavaStringNode, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                if (this.root.isStringLike(nameValue)) {
                    return this.root.cacheStringLikeAndForward(frameValue, receiverValue_, nameValue, this.toJavaStringNode, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, ToJavaStringNode toJavaStringNode, ForeignReadStringCachedHelperNode nextHelper) {
            return new CacheStringLikeAndForwardNode_(root, toJavaStringNode, nextHelper);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ForeignReadStringCachingHelperNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object receiverValue, Object nameValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, receiverValue, nameValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ForeignReadStringCachingHelperNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            return this.uninitialized((Frame)frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ForeignReadStringCachingHelperNodeGen root;

        BaseNode_(ForeignReadStringCachingHelperNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ForeignReadStringCachingHelperNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.receiver_, this.root.name_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object receiverValue, Object nameValue) {
            return this.execute_((VirtualFrame)frameValue, receiverValue, nameValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            return this.execute_(frameValue, receiverValue, nameValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object nameValue_ = this.executeName_(frameValue);
            return this.execute_(frameValue, receiverValue_, nameValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.execute0(frameValue));
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                if (this.root.isStringLike(nameValue)) {
                    ToJavaStringNode toJavaStringNode1 = ToJavaStringNode.create();
                    ForeignReadStringCachedHelperNode nextHelper1 = this.root.createNextHelper();
                    return CacheStringLikeAndForwardNode_.create(this.root, toJavaStringNode1, nextHelper1);
                }
                if (RubyTypesGen.isImplicitInteger(nameValue)) {
                    int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue);
                    if (RubyGuards.isRubyString(receiverValue_) && this.root.inRange(receiverValue_, nameValue_)) {
                        return IndexStringNode_.create(this.root, nameValue);
                    }
                    if (RubyGuards.isRubyString(receiverValue_) && !this.root.inRange(receiverValue_, nameValue_)) {
                        return IndexStringOutOfRangeNode_.create(this.root, nameValue);
                    }
                }
                if (!RubyGuards.isRubyString(receiverValue_) && !this.root.isStringLike(nameValue)) {
                    ForeignReadStringCachedHelperNode nextHelper4 = this.root.createNextHelper();
                    return IndexObjectNode_.create(this.root, nextHelper4);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeName_(Frame frameValue) {
            Object object;
            Class nameType_ = this.root.nameType_;
            if (nameType_ == Integer.TYPE) {
                return this.root.name_.executeInteger((VirtualFrame)frameValue);
            }
            if (nameType_ != null) return this.root.name_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.name_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.nameType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.nameType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.nameType_ = _type;
            return object;
        }
    }
}

