/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliSite;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class RepositoryCrawler {
    private String[] repositoryUri;
    private RepositoryAccess rep = new RepositoryAccess();

    public void setup(String[] repositoryUri, RepositoryAccess rep) {
        this.rep = rep;
        this.repositoryUri = repositoryUri;
    }

    private IliFile crawlParents(String modelName, double iliVersion, HashSet<String> visitedSites, ArrayList<String> parents, boolean logLookup) {
        while (!parents.isEmpty()) {
            String uri = parents.remove(0);
            if (visitedSites.contains(uri)) continue;
            visitedSites.add(uri);
            this.logRepositoryScan(uri, modelName, iliVersion, logLookup);
            IliFile iliFile = this.getIliFileMetadataShallow(modelName, iliVersion, uri);
            if (iliFile != null) {
                return iliFile;
            }
            IliSite iliSite = this.rep.getIliSite(uri);
            if (iliSite == null) continue;
            Iterator<String> parenti = iliSite.iteratorParentSite();
            while (parenti.hasNext()) {
                String parent = parenti.next();
                parents.add(parent);
            }
        }
        return null;
    }

    private void logRepositoryScan(String uri, String model, double version, boolean dologging) {
        if (dologging) {
            if (version == 0.0) {
                EhiLogger.logState("lookup model <" + model + "> in repository <" + uri + ">");
            } else {
                EhiLogger.logState("lookup model <" + model + "> " + version + " in repository <" + uri + ">");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public IliFile getIliFileMetadataDeep(String modelName, double iliVersion, boolean logLookup) {
        visitedSites = new HashSet<String>();
        i = 0;
        while (i < this.repositoryUri.length) {
            uri = this.repositoryUri[i];
            if (!visitedSites.contains(uri)) {
                this.logRepositoryScan(uri, modelName, iliVersion, logLookup);
                visitedSites.add(uri);
                iliFile = this.getIliFileMetadataShallow(modelName, iliVersion, uri);
                if (iliFile != null) {
                    return iliFile;
                }
            }
            ++i;
        }
        parents = new ArrayList<String>();
        subsidiaries = new ArrayList<String>();
        i = 0;
        while (i < this.repositoryUri.length) {
            uri = this.repositoryUri[i];
            iliSite = this.rep.getIliSite(uri);
            if (iliSite != null) {
                parenti = iliSite.iteratorParentSite();
                while (parenti.hasNext()) {
                    parent = parenti.next();
                    parents.add(parent);
                }
                subsidiaryi = iliSite.iteratorSubsidiarySite();
                while (subsidiaryi.hasNext()) {
                    subsidiary = subsidiaryi.next();
                    subsidiaries.add(subsidiary);
                }
            }
            ++i;
        }
        ret = this.crawlParents(modelName, iliVersion, visitedSites, parents, logLookup);
        if (ret == null) ** GOTO lbl63
        return ret;
lbl-1000:
        // 1 sources

        {
            uri = (String)subsidiaries.remove(0);
            if (visitedSites.contains(uri)) continue;
            visitedSites.add(uri);
            this.logRepositoryScan(uri, modelName, iliVersion, logLookup);
            iliFile = this.getIliFileMetadataShallow(modelName, iliVersion, uri);
            if (iliFile != null) {
                return iliFile;
            }
            iliSite = this.rep.getIliSite(uri);
            if (iliSite == null) continue;
            subsidiaryi = iliSite.iteratorSubsidiarySite();
            while (subsidiaryi.hasNext()) {
                subsidiary = subsidiaryi.next();
                subsidiaries.add(subsidiary);
            }
            parenti = iliSite.iteratorParentSite();
            while (parenti.hasNext()) {
                parent = parenti.next();
                parents.add(parent);
            }
            ret2 = this.crawlParents(modelName, iliVersion, visitedSites, parents, logLookup);
            if (ret2 == null) continue;
            return ret2;
lbl63:
            // 4 sources

            ** while (!subsidiaries.isEmpty())
        }
lbl64:
        // 1 sources

        return null;
    }

    private IliFile getIliFileMetadataShallow(String modelName, double iliVersion, String uri) {
        IliFiles iliFiles = this.rep.getIliFiles(uri);
        if (iliFiles != null) {
            IliFile iliFile = null;
            if (iliVersion == 0.0) {
                iliFile = iliFiles.getFileWithModel(modelName, 2.3);
                if (iliFile == null) {
                    iliFile = iliFiles.getFileWithModel(modelName, 1.0);
                }
                if (iliFile == null) {
                    iliFile = iliFiles.getFileWithModel(modelName, 2.2);
                }
            } else {
                iliFile = iliFiles.getFileWithModel(modelName, iliVersion);
            }
            if (iliFile != null) {
                return iliFile;
            }
        }
        return null;
    }
}

