/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.db;

import java.io.File;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.db.CouchDBHandler;
import org.owasp.jbrofuzz.db.DBAdaptor;
import org.owasp.jbrofuzz.db.SQLiteHandler;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class DBAdaptorFactory {
    private static DBAdaptor dbAdaptor;

    public static DBAdaptor getInstance() {
        if (JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals("couchdb")) {
            if (dbAdaptor == null) {
                dbAdaptor = new DBAdaptor(new CouchDBHandler());
            }
        } else if (dbAdaptor == null) {
            SQLiteHandler sqlH = new SQLiteHandler();
            try {
                String fileName = String.valueOf(JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[12].getId(), "")) + ".db";
                File test = new File(fileName);
                if (!test.exists()) {
                    sqlH.setUpDB();
                } else {
                    Logger.log("DB exists", 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dbAdaptor = new DBAdaptor(sqlH);
        }
        return dbAdaptor;
    }

    public void resetDBAdaptor() {
        dbAdaptor = null;
    }
}

