/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;

public class Shortcuts
extends JFrame {
    private static final long serialVersionUID = 1726771399839929062L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private static final String FILE_NOT_FOUND = "Help file could not be located.";
    private static boolean shortcutsShowing = false;

    public Shortcuts(JBroFuzzWindow parent) {
        if (shortcutsShowing) {
            return;
        }
        shortcutsShowing = true;
        this.setTitle(" JBroFuzz - Keyboard Shortcuts ");
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        URL shortcutsURL = ClassLoader.getSystemClassLoader().getResource("help/shortcuts.html");
        final JEditorPane helpPane = new JEditorPane();
        try {
            helpPane.setPage(shortcutsURL);
        }
        catch (IOException e1) {
            helpPane.setContentType("text/html");
            helpPane.setText(FILE_NOT_FOUND);
        }
        helpPane.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(helpPane), "Center");
        JButton printBun = new JButton(" Print ");
        JButton okButton = new JButton(" Close ");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(printBun);
        buttonPanel.add(okButton);
        printBun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                try {
                    boolean complete = helpPane.print();
                    if (!complete) {
                        Logger.log("User cancelled Printing", 1);
                    }
                }
                catch (PrinterException prException) {
                    Logger.log("A Printing Exception Occured", 4);
                }
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                shortcutsShowing = false;
                Shortcuts.this.dispose();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 650) / 2, parent.getLocation().y + (parent.getHeight() - 400) / 2);
        this.setSize(650, 400);
        this.setMinimumSize(new Dimension(325, 200));
        this.setResizable(true);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wEvent) {
                shortcutsShowing = false;
                Shortcuts.this.dispose();
            }
        });
    }
}

