/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.extension.ext.OptionsExtensionPanel;

public class ExtensionExtension
extends ExtensionAdaptor
implements CommandLineListener {
    public static final String NAME = "ExtensionExtension";
    private OptionsExtensionPanel optionsExceptionsPanel = null;
    private Logger logger = Logger.getLogger(ExtensionExtension.class);

    public ExtensionExtension() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(new ExtensionParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsExtensionPanel());
        }
    }

    private OptionsExtensionPanel getOptionsExtensionPanel() {
        if (this.optionsExceptionsPanel == null) {
            this.optionsExceptionsPanel = new OptionsExtensionPanel(this);
        }
        return this.optionsExceptionsPanel;
    }

    public void enableExtension(String string, boolean bl) {
        if (this.getOptionsExtensionPanel().enableExtension(string, bl)) {
            try {
                this.getOptionsExtensionPanel().saveParam(Model.getSingleton().getOptionsParam());
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("ext.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void execute(CommandLineArgument[] commandLineArgumentArray) {
    }

    @Override
    public boolean handleFile(File file) {
        Control.getSingleton().openSession(file, null);
        return true;
    }

    @Override
    public List<String> getHandledExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("session");
        return arrayList;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

