/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import java.io.IOException;
import org.libreoffice.report.OutputRepository;

public class DefaultNameGenerator {
    private final OutputRepository outputRepository;

    public DefaultNameGenerator(OutputRepository outputRepository) {
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        this.outputRepository = outputRepository;
    }

    public String generateName(String namePrefix, String mimeType) throws IOException {
        return this.generateName(namePrefix, mimeType, true);
    }

    public String generateStorageName(String namePrefix, String mimeType) throws IOException {
        return this.generateName(namePrefix, mimeType, false);
    }

    private String generateName(String namePrefix, String mimeType, boolean isStream) throws IOException {
        String suffix;
        String name = namePrefix != null ? namePrefix : "file";
        StringBuffer firstFileName = new StringBuffer();
        firstFileName.append(name);
        if (mimeType != null) {
            suffix = this.getSuffixForType(mimeType);
            firstFileName.append('.');
            firstFileName.append(suffix);
        } else {
            suffix = null;
        }
        String newName = firstFileName.toString();
        boolean exists = isStream ? this.outputRepository.exists(newName) : this.outputRepository.existsStorage(newName);
        if (exists) {
            int counter = 0;
            while (exists) {
                if (counter < 0) {
                    throw new IOException();
                }
                firstFileName.delete(0, firstFileName.length());
                firstFileName.append(name);
                firstFileName.append(counter);
                if (suffix != null) {
                    firstFileName.append('.');
                    firstFileName.append(suffix);
                }
                newName = firstFileName.toString();
                exists = isStream ? this.outputRepository.exists(newName) : this.outputRepository.existsStorage(newName);
                ++counter;
            }
        }
        return newName;
    }

    private String getSuffixForType(String mimeType) {
        if ("image/png".equals(mimeType)) {
            return "png";
        }
        if ("image/jpeg".equals(mimeType)) {
            return "jpg";
        }
        if ("image/gif".equals(mimeType)) {
            return "gif";
        }
        return "dat";
    }
}

