/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.encog.ml.bayesian.BayesianChoice;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.table.BayesianTable;

public class BayesianEvent
implements Serializable {
    private final String label;
    private final List<BayesianEvent> parents = new ArrayList<BayesianEvent>();
    private final List<BayesianEvent> children = new ArrayList<BayesianEvent>();
    private final Set<BayesianChoice> choices = new TreeSet<BayesianChoice>();
    private BayesianTable table;
    private int minimumChoiceIndex;
    private double minimumChoice;
    private int maximumChoiceIndex;
    private double maximumChoice;

    public BayesianEvent(String theLabel, List<BayesianChoice> theChoices) {
        this.label = theLabel;
        this.choices.addAll(theChoices);
    }

    public BayesianEvent(String theLabel, String[] theChoices) {
        this.label = theLabel;
        int index = 0;
        for (String str : theChoices) {
            this.choices.add(new BayesianChoice(str, index++));
        }
    }

    public BayesianEvent(String theLabel) {
        this(theLabel, BayesianNetwork.CHOICES_TRUE_FALSE);
    }

    public List<BayesianEvent> getParents() {
        return this.parents;
    }

    public List<BayesianEvent> getChildren() {
        return this.children;
    }

    public String getLabel() {
        return this.label;
    }

    public void addChild(BayesianEvent e) {
        this.children.add(e);
    }

    public void addParent(BayesianEvent e) {
        this.parents.add(e);
    }

    public boolean hasParents() {
        return this.parents.size() > 0;
    }

    public boolean hasChildren() {
        return this.parents.size() > 0;
    }

    public String toFullString() {
        StringBuilder result = new StringBuilder();
        result.append("P(");
        result.append(this.getLabel());
        result.append("[");
        boolean first = true;
        for (BayesianChoice choice : this.choices) {
            if (!first) {
                result.append(",");
            }
            result.append(choice.toFullString());
            first = false;
        }
        result.append("]");
        if (this.hasParents()) {
            result.append("|");
        }
        first = true;
        for (BayesianEvent e : this.parents) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(e.getLabel());
        }
        result.append(")");
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("P(");
        result.append(this.getLabel());
        if (this.hasParents()) {
            result.append("|");
        }
        boolean first = true;
        for (BayesianEvent e : this.parents) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(e.getLabel());
        }
        result.append(")");
        return result.toString();
    }

    public int calculateParameterCount() {
        int result = this.getChoices().size() - 1;
        for (BayesianEvent parent : this.parents) {
            result *= parent.getChoices().size();
        }
        return result;
    }

    public Set<BayesianChoice> getChoices() {
        return this.choices;
    }

    public BayesianTable getTable() {
        return this.table;
    }

    public void finalizeStructure() {
        this.minimumChoiceIndex = -1;
        this.maximumChoiceIndex = -1;
        this.minimumChoice = Double.POSITIVE_INFINITY;
        this.maximumChoice = Double.NEGATIVE_INFINITY;
        int index = 0;
        for (BayesianChoice choice : this.choices) {
            if (choice.getMin() < this.minimumChoice) {
                this.minimumChoice = choice.getMin();
                this.minimumChoiceIndex = index;
            }
            if (choice.getMax() > this.maximumChoice) {
                this.maximumChoice = choice.getMax();
                this.maximumChoiceIndex = index;
            }
            ++index;
        }
        if (this.table == null) {
            this.table = new BayesianTable(this);
            this.table.reset();
        } else {
            this.table.reset();
        }
    }

    public void validate() {
        this.table.validate();
    }

    public boolean isBoolean() {
        return this.choices.size() == 2;
    }

    public boolean rollArgs(double[] args) {
        int currentIndex = 0;
        boolean done = false;
        boolean eof = false;
        if (this.parents.size() == 0) {
            done = true;
            eof = true;
        }
        while (!done) {
            int v = (int)args[currentIndex];
            if (++v < this.parents.get(currentIndex).getChoices().size()) {
                args[currentIndex] = v;
                done = true;
                break;
            }
            args[currentIndex] = 0.0;
            if (++currentIndex < this.parents.size()) continue;
            done = true;
            eof = true;
        }
        return !eof;
    }

    public void removeAllRelations() {
        this.children.clear();
        this.parents.clear();
    }

    public static String formatEventName(BayesianEvent event, int value) {
        StringBuilder str = new StringBuilder();
        if (event.isBoolean()) {
            if (value == 0) {
                str.append("+");
            } else {
                str.append("-");
            }
        }
        str.append(event.getLabel());
        if (!event.isBoolean()) {
            str.append("=");
            str.append(value);
        }
        return str.toString();
    }

    public boolean hasGiven(String l) {
        for (BayesianEvent event : this.parents) {
            if (!event.getLabel().equals(l)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        if (this.table == null) {
            this.table = new BayesianTable(this);
        }
        this.table.reset();
    }

    public int matchChoiceToRange(double d) {
        if (this.getChoices().size() > 0 && this.getChoices().iterator().next().isIndex()) {
            int result = (int)d;
            if (result > this.getChoices().size()) {
                throw new BayesianError("The item id " + result + " is not valid for event " + this.toString());
            }
            return (int)d;
        }
        int index = 0;
        for (BayesianChoice choice : this.choices) {
            if (d < choice.getMax()) {
                return index;
            }
            ++index;
        }
        return Math.min(index, this.choices.size() - 1);
    }

    public BayesianChoice getChoice(int arg) {
        int a = arg;
        for (BayesianChoice choice : this.choices) {
            if (a == 0) {
                return choice;
            }
            --a;
        }
        return null;
    }
}

