/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.training.SVMTrain;
import org.encog.ml.train.MLTrain;
import org.encog.util.ParamsHolder;

public class SVMFactory {
    public MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof SVM)) {
            throw new EncogError("SVM Train training cannot be used on a method of type: " + method.getClass().getName());
        }
        double defaultGamma = 1.0 / (double)((SVM)method).getInputCount();
        double defaultC = 1.0;
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        double gamma = holder.getDouble("GAMMA", false, defaultGamma);
        double c = holder.getDouble("C", false, 1.0);
        SVMTrain result = new SVMTrain((SVM)method, training);
        result.setGamma(gamma);
        result.setC(c);
        return result;
    }
}

