/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.fitting.gaussian;

import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.fitting.gaussian.GaussianFitting;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.EngineArray;

public class TrainGaussian
extends BasicTraining {
    private final GaussianFitting method;
    private final MLDataSet training;

    public TrainGaussian(GaussianFitting theMethod, MLDataSet theTraining) {
        super(TrainingImplementationType.OnePass);
        this.method = theMethod;
        this.training = theTraining;
    }

    @Override
    public MLDataSet getTraining() {
        return this.training;
    }

    @Override
    public void iteration() {
        int i;
        double[] sum = new double[this.method.getInputCount()];
        for (MLDataPair pair : this.training) {
            for (i = 0; i < this.training.getInputSize(); ++i) {
                int n = i;
                sum[n] = sum[n] + pair.getInput().getData(i);
            }
        }
        double m = this.training.getRecordCount();
        for (i = 0; i < this.training.getInputSize(); ++i) {
            this.method.getMu().set(0, i, sum[i] / m);
        }
        double[][] sigma = this.method.getSigma().getData();
        EngineArray.fill(sigma, 0);
        int inputCount = this.method.getInputCount();
        for (MLDataPair pair : this.training) {
            for (int i2 = 0; i2 < inputCount; ++i2) {
                for (int j = 0; j < inputCount; ++j) {
                    double[] dArray = sigma[i2];
                    int n = j;
                    dArray[n] = dArray[n] + (pair.getInput().getData(i2) - this.method.getMu().get(0, i2)) * (pair.getInput().getData(j) - this.method.getMu().get(0, j));
                }
            }
        }
        for (int i3 = 0; i3 < inputCount; ++i3) {
            int j = 0;
            while (j < inputCount) {
                double[] dArray = sigma[i3];
                int n = j++;
                dArray[n] = dArray[n] / m;
            }
        }
        this.method.finalizeTraining();
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
        throw new EncogError("Not supported");
    }

    @Override
    public MLMethod getMethod() {
        return this.method;
    }
}

