/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Method;

public final class JavaInterop {
    private JavaInterop() {
    }

    public static <T> T asJavaObject(Class<T> type, TruffleObject foreignObject) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, new ToJavaNode(), foreignObject, type);
        Object convertedValue = Truffle.getRuntime().createCallTarget(root).call(new Object[0]);
        return type.cast(convertedValue);
    }

    public static TruffleObject asTruffleObject(Object obj) {
        if (obj instanceof TruffleObject) {
            return (TruffleObject)obj;
        }
        if (obj instanceof Class) {
            return new JavaObject(null, (Class)obj);
        }
        if (obj == null) {
            return JavaObject.NULL;
        }
        return new JavaObject(obj, obj.getClass());
    }

    public static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, new ToJavaNode(), function, functionalType);
        return functionalType.cast(Truffle.getRuntime().createCallTarget(root).call(new Object[0]));
    }

    public static <T> TruffleObject asTruffleFunction(Class<T> functionalType, T implementation) {
        Method[] arr = functionalType.getDeclaredMethods();
        if (!functionalType.isInterface() || arr.length != 1) {
            throw new IllegalArgumentException();
        }
        return new JavaFunctionObject(arr[0], implementation);
    }

    private static class TemporaryConvertRoot
    extends RootNode {
        @Node.Child
        private ToJavaNode node;
        private final Object value;
        private final Class<?> type;

        TemporaryConvertRoot(Class<? extends TruffleLanguage> lang, ToJavaNode node, Object value, Class<?> type) {
            super(lang, null, null);
            this.node = node;
            this.value = value;
            this.type = type;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.convert(frame, this.value, this.type);
        }
    }
}

