/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;

public abstract class LazyRope
extends Rope {
    protected LazyRope(Encoding encoding, int byteLength, int characterLength) {
        super(encoding, CodeRange.CR_7BIT, true, byteLength, characterLength, 1, null);
    }

    @Override
    protected byte getByteSlow(int index) {
        return this.getBytes()[index];
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            this.doFulfill();
        }
        return this.bytes;
    }

    @CompilerDirectives.TruffleBoundary
    private void doFulfill() {
        this.bytes = this.fulfill();
    }

    protected abstract byte[] fulfill();

    public String toString() {
        return RopeOperations.decodeUTF8(this);
    }
}

