# AWSTATS SEARCH ENGINES DATABASE
#------------------------------------------------------------------------------
# If you want to add a Search Engine to extend AWStats database detection capabilities,
# you must add an entry in SearchEnginesSearchIDOrder, SearchEnginesHashID and in
# SearchEnginesHashLib.
# An entry if known in SearchEnginesKnownUrl is also welcome.
#
# to eldy: Please check if the following description is correct:
# You need the following information to specify a search engine:
# (a) A regular expression that matches the referrer string of the
#    search engine. Unclear: What about slashes in the name of
#    a search engine, e.g. as in 'ecosia.com/search'. Seems that
#    AWStats will non find search strings containing a slash.
#    Maybe use a search string without a slash, and - if necessary -
#    an entry in %NotSearchEnginesKeys , if this search string
#    matches entries that are not search engines.
#    Example of a web address of a Amazon search engine:
#    http://www.amazon.de/gp/bit/apps/web/SERP/search/ref=bit_bds-p24_serp_cr_de?ie=UTF8tagbase=bds-p24&query=deutsch+8.+klasse+gymnasium+protokoll
# (b) A unique string to identify the search engine within AWStats
# (c) A regular expression that finds the start of the query part in the
#    referrer string
# (d) A HTML-fragment that goes into the reports generated by AWStats which
#    identifies the search engine to human reader of the report. In the
#    simplest case this is a string containing the name of the search
#    engine. You can also provide a hypertext clause that presents the
#    name together with a link to the search engine.
#
# The regular expression (a) goes into SearchEnginesSearchIDOrder_list1
# or ..._list2. List 1 contains common search engines, list 2 those
# that are not so often used.
#
# SearchEnginesHashID contains to consecutive entries for each search
# engine: The regular expression (a) followed bei the search engine
# identifier (b)
#
# SearchEnginesKnownUrl specifies how to find the start of the query.
# For each search engine you enter the search engine identifier (b)
# followed by the regular expression (c). Unclear: It is possible to
# omit this entry. If you do this, how will AWStats find the start of
# the query?
#
# SearchEnginesHashLib contains also two entries for each search engine:
# The search engine identifier (b) followed by the HTML-Fragment (d)
#
# There are search engines that do not use a query part in their URLs.
# They put the search expression in the main part of the URL instead.
# AWStats is able to handle these cases. They are specified as described
# above, except the following two things:
# - The regular expression (c) searches the complete URL and not only
#   the query part.
# - An additional Entry in the list %SearchEnginesWithKeysNotInQuery is
#   necessary.
#
#
# AWStats runs a sanity check of the contents of search_engines.pm. This
# check detects the following things:
# - Inconsistencies (number of entries)
# It does not detect the following errors:
# - If the HTML-Fragment (d) is syntactically incorrect.
#
#------------------------------------------------------------------------------

# 2005-08-19 Sean Carlos http://www.antezeta.com/awstats.html
#            added minor italian search engines
#                  arianna http://arianna.libero.it/
#                  supereva http://search.supereva.com/
#                  kataweb http://kataweb.it/
#            corrected uk looksmart
#                  'askuk','ask=', 'bbc','q=', 'freeserve','q=', 'looksmart','key=',
#            to
#                  'askuk','ask=', 'bbc','q=', 'freeserve','q=', 'looksmartuk','key=',
#            corrected spelling
#                     internationnal -> international
#            added 'google\.'=>'mail\.google\.', to NotSearchEnginesKeys in order to
#            avoid counting gmail referrals as search engine traffic
# 2005-08-21 Sean Carlos http://www.antezeta.com/awstats.html
#            avoid counting babelfish.altavista referrals as search engine traffic
#            avoid counting translate.google referrals as search engine traffic
# 2005-11-20 Sean Carlos
# 	     added missing 'tiscali','key=', entry.  Check order
# 2005-11-22 Sean Carlos
# 	     added Google Base & Froogle.  Froogle not tested.
# 2006-04-18 Sean Carlos http://www.antezeta.com/awstats.html
# 	     added biglotron.com (France)
# 	     added blingo http://www.blingo.com/
# 	     added Clusty & Vivisimo
# 	     added eniro.no (Norway) [https://sourceforge.net/forum/message.php?msg_id=3134783]
# 	     added GPU p2p search http://search.centraldatabase.org/
# 	     added mail.tiscali to "not search engines list" [https://sourceforge.net/forum/message.php?msg_id=3166688]
# 	     added Ask group's "mysearch"
# 	     added sify.com (India)
# 	     added sogou.com (Cina) [https://sourceforge.net/forum/message.php?msg_id=3501603]
# 	     Ask changes:
# 	     - added Ask Japan (ask.jp)
# 	     - break out Ask new country level variants (DE, ES, FR, IT, NL)
# 	     - updated Ask name from Ask Jevees
# 	     - added Ask q= parameter - many recent searches probably not recognized; [https://sourceforge.net/forum/message.php?msg_id=3465444]
# 	     - updated Ask uk (new uk.ask.com added to older ask.co.uk)
# 	     updated voila kw|rdata parameter [https://sourceforge.net/forum/message.php?msg_id=3373912]
#	     for each new engine, added link to Search Engine.  This serves to document engine. Done for major & Italian engines as well. Requires patch
#		to AWStats to allow untranslated html.  Otherwise html will appear instead of link.
#	     reviewed mnoGoSearch (http://www.mnogosearch.org/); the search engined mentioned no longer
#		exists https://sourceforge.net/forum/message.php?msg_id=3025426
# 2006-05-13 Sean Carlos http://www.antezeta.com/awstats.html
#            added 10 Chello European broadband portals (Austria, Belgium, Czech Republic, France, Hungary, The Netherlands, Norway, Poland, Slovakia, Sweden)
#	     added Alice Internal Search (blends data with Google?) search.alice.it.master:10005
#            added detection of google cache views from IPs 66.249.93.104 72.14.203.104 72.14.207.104
#		To do: add more extensive IP list; keywords not yet detected.
#            added icerocket.com blog search http://www.icerocket.com/
#	     added live.com (msn) http://www.live.com/
# 	     added Meta motor kartoo.  Note: Kartoo does not provide search words in referrers, thus the engine will appear in the
#		search engine list but the actual search words are not available.
#	     added netluchs.de http://www.netluchs.de/
#	     added sphere.com blog search http://www.sphere.com/
#	     added wwweasel.de http://wwweasel.de
#	     added Yahoo Mindset! http://mindset.research.yahoo.com/
#            updated Mirago query parameter recognition (qry=); added breakout for each country (France, Germany, Spain, Italy, Norway, Sweden, Denmark, Netherlands, Belgium, Switzerland)
# 2006-05-13 Sean Carlos http://www.antezeta.com/awstats.html
#	     added Google cache IPs 64.233.183.104 & 66.102.7.104
# 2006-05-20 Sean Carlos http://www.antezeta.com/awstats.html
#		anzwers.com.au
#		schoenerbrausen.de http://www.schoenerbrausen.de/
#		added Google cache IP 216.239.59.104
#		answerbus http://www.answerbus.com/ (does not provide keywords)
# 2006-05-23 Sean Carlos http://www.antezeta.com/awstats.html
#		added Google cache IP 66.102.9.104, 64.233.161.104
# 2006-06-23 Sean Carlos http://www.antezeta.com/awstats.html
#	     	added Alice Search search.alice.it
#		added GoodSearch http://www.goodsearch.com/ (does not provide keywords) "a Yahoo-powered search engine that donates money to your favorite charity or school each time you search the web"
#		added googlee.com, variant of Google
#		added gotuneed http://www.gotuneed.com/ Italian search engine, in beta
#		added icq.com
#		added logic to parse Google Cache search keywords. Seems to work for alpha but not numeric cache IDs, i.e. search?q=cache:lWVLmnuGJswJ: is recognized but q=cache:Yv5qxeJNuhgJ: is not recognized. The URL triggering the keywords will also appear.  The URLs are probably too varied to parse out?
#		added Nusearch http://www.nusearch.com/
#		added Polymeta www.polymeta.hu (does not provide keywords)
#		added scroogle http://www.scroogle.org/ (does not always provide keywords)
#		added Tango http://tango.hu/search.php?st=0&q=jeles+napok
#		Changed Google Cache notation 64\.233\.(161|167|179|183|187)\.104 to 64\.233\.1[0-9]{2}\.104
#		 			      72\.14\.(203|205|207|209|221)\.104 to 72\.14\.2[0-9]{2}\.104
#					      216\.239\.(51|59)\.104 to 216\.239\.5[0-9]\.104
#					      66\.102\.(7|9)\.104 to 66\.102\.[1-9]\.104
# 2006-06-27 Sean Carlos http://www.antezeta.com/awstats.html
#		added Onet.pl http://szukaj.onet.pl/
#		corrected name "Wirtualna Polska" from "Szukaj" (search); added link http://szukaj.wp.pl/
# 2006-06-30 Sean Carlos http://www.antezeta.com/awstats.html
#	Additional Polish Search Engines:
#	added Dodaj.pl http://www.dodaj.pl/
#	added Gazeta.pl http://szukaj.gazeta.pl/
#	added Gery.pl http://szukaj.gery.pl/
#	added Hoga.pl http://www.hoga.pl/
#	added Interia.pl http://www.google.interia.pl/
#	added Katalog.Onet.pl http://katalog.onet.pl/
#	added NetSprint.pl http://www.netsprint.pl/
#	added o2.pl http://szukaj2.o2.pl/
#	added Polska http://szukaj.polska.pl/
#	added Szukacz http://www.szukacz.pl/
#	added Wow.pl http://szukaj.wow.pl/
#	added Sagool http://sagool.jp/

# 2006-08-25 Social Bookmarks
#	International
#	added del.icio.us/search - for now, just search referrer. To do: consider /tag/(tagname) referrer?
# 	added stumbleupon.com - No keywords supplied.
#	added swik.net
#       added digg. Keywords sometimes supplied.
#	Italy
# 	added segnalo.alice.it - No keywords supplied.
#	added ineffabile.it - No keywords supplied.

#       added filter for google groups.  Attempt to parse group name as keyword.

# 2006-09-14
#	added Eniro Sverige http://www.eniro.se/
#	added MyWebSearch http://search.mywebsearch.com/
#	added Teecno http://www.teecno.it/ Italian Open Source Search Engine

#package AWSSE;

# 2006-09-25 (Gabor Moizes)
# added 4-counter (Google alternative) http://4-counter.com/
# added Googlecom (Google alternative) http://googlecom.com/
# added Goggle (Google alternative) http://goggle.co.hu/
# added Comet toolbar http://as.starware.com
# added new IP for Yahoo: 216.109.125.130
# added Ledix http://ledix.net/
# added AT&T search (powered by Google) http://www.att.net/
# added Keresolap (Hungarian search engine) http://www.keresolap.hu/
# added Mozbot (French search engine) http://www.mozbot.fr/
# added Zoznam (Slovak search engine) http://www.zoznam.sk/
# added sapo.pt (Portuguese search engine) http://www.sapo.pt/
# added shaw.ca (powered by Google) http://start.shaw.ca/
# added Searchalot http://www.searchalot.com/
# added Copernic http://www.copernic.com/
# added 216.109.125.130 to Yahoo
# added 66.218.69.11 to Yahoo
# added Avantfind http://www.avantfind.com/
# added Steadysearch http://www.steadysearch.com/
# added Steadysearch http://www.steady-search.com/
# modified 216\.239\.5[0-9]\.104/search to 216\.239\.5[0-9]\.104


# SearchEnginesSearchIDOrder
# It contains all matching criteria to search for in log fields. This list is
# used to know in which order to search Search Engines IDs.
# Most frequent one are in list1, used when LevelForSearchEnginesDetection is 1 or more
# Minor robots are in list2, used when LevelForSearchEnginesDetection is 2 or more
# Note: Regex IDs are in lower case and ' ' and '+' are changed into '_'
#------------------------------------------------------------------------------
@SearchEnginesSearchIDOrder_list1=(
# Major international search engines
'google\.[\w.]+/products',
'base\.google\.',
'froogle\.google\.',
'groups\.google\.',
'images\.google\.',
'google\.',
'googlee\.',
'googlecom\.com',
'goggle\.co\.hu',
'216\.239\.32\.20',
'173\.194\.32\.223',
'216\.239\.(35|37|39|51)\.100',
'216\.239\.(35|37|39|51)\.101',
'216\.239\.5[0-9]\.104',
'64\.233\.1[0-9]{2}\.104',
'66\.102\.[1-9]\.104',
'66\.249\.93\.104',
'72\.14\.2[0-9]{2}\.104',
'msn\.',
'live\.com',
'bing\.',
'voila\.',
'mindset\.research\.yahoo',
'yahoo\.','(66\.218\.71\.225|216\.109\.117\.135|216\.109\.125\.130|66\.218\.69\.11)',
'search\.aol\.co',
'tiscali\.',
'lycos\.',
'alexa\.com',
'alltheweb\.com',
'altavista\.',
'a9\.com',
'dmoz\.org',
'netscape\.',
'search\.terra\.',
'www\.search\.com',
'search\.sli\.sympatico\.ca',
'excite\.'
);

@SearchEnginesSearchIDOrder_list2=(
# Minor international search engines
'4\-counter\.com',
'att\.net',
'bungeebonesdotcom',
'northernlight\.',
'hotbot\.',
'kvasir\.',
'webcrawler\.',
'metacrawler\.',
'go2net\.com',
'(^|\.)go\.com',
'euroseek\.',
'looksmart\.',
'spray\.',
'nbci\.com\/search',
'de\.ask.\com', # break out Ask country specific engines.  (.jp is in Japan section)
'es\.ask.\com',
'fr\.ask.\com',
'it\.ask.\com',
'nl\.ask.\com',
'uk\.ask.\com',
'(^|\.)ask\.com',
'atomz\.',
'overture\.com',		# Replace 'goto\.com','Goto.com',
'teoma\.',
'findarticles\.com',
'infospace\.com',
'mamma\.',
'dejanews\.',
'dogpile\.com',
'wisenut\.com',
'ixquick\.com',
'search\.earthlink\.net',
'i-une\.com',
'blingo\.com',
'centraldatabase\.org',
'clusty\.com',
'mysearch\.',
'vivisimo\.com',
'kartoo\.com',
'icerocket\.com',
'sphere\.com',
'ledix\.net',
'start\.shaw\.ca',
'searchalot\.com',
'copernic\.com',
'avantfind\.com',
'steadysearch\.com',
'steady-search\.com',
'claro-search\.com',
'www1\.search-results\.com',
'www\.holasearch\.com',
'search\.conduit\.com',
'static\.flipora\.com',
'(?:www[12]?|mixidj)\.delta-search\.com',
'start\.iminent\.com',
'www\.searchmobileonline\.com',
'int\.search-results\.com',
'www2\.inbox\.com',
'www\.govome\.com',
'find1friend\.com',
'start\.mysearchdial\.com',
'go\.speedbit\.com',
'search\.certified-toolbar\.com',
'search\.sweetim\.com',
'search\.searchcompletion\.com',
'en\.eazel\.com',
'sr\.searchfunmoods\.com',
'173\.194\.35\.177',
'dalesearch\.com',
'sweetpacks-search\.com',
'searchgol\.com',
'duckduckgo\.com',
'sr\.facemoods\.com',
'shoppstop\.com',
'searchya\.com',
'picsearch\.de',
'webssearches\.com',
'airzip\.inspsearch\.com',
'zapmeta\.de',
'localmoxie\.com',
'search-results\.mobi',
'androidsearch\.com',
'isearch\.nation\.com',
'search\.zonealarm\.com',
'www\.buenosearch\.com',
'search\.foxtab\.com',
'searches\.qone8\.com',
'startpage\.com',
'www\.qwant\.com',
'searches\.safehomepage\.com',
'searches\.vi-view\.com',
'wow\.utop\.it',
'windowssearch\.com',
'www\.wow\.com',
'globososo\.',
'kingtale3\.inspsearch\.com',
'swisscows\.ch',
'preciobarato\.xyz',
'www\.dregol\.com',
'search\.socialdownloadr\.com',
'int\.search\.myway\.com',
'de\.dolphin\.com',
'mys\.yoursearch\.me',
# Chello Portals
'chello\.at',
'chello\.be',
'chello\.cz',
'chello\.fr',
'chello\.hu',
'chello\.nl',
'chello\.no',
'chello\.pl',
'chello\.se',
'chello\.sk',
'chello', # required as catchall for new countries not yet known
# Mirago
'mirago\.be',
'mirago\.ch',
'mirago\.de',
'mirago\.dk',
'es\.mirago\.com',
'mirago\.fr',
'mirago\.it',
'mirago\.nl',
'no\.mirago\.com',
'mirago\.se',
'mirago\.co\.uk',
'mirago', # required as catchall for new countries not yet known
'answerbus\.com',
'icq\.com\/search',
'nusearch\.com',
'goodsearch\.com',
'scroogle\.org',
'questionanswering\.com',
'mywebsearch\.com',
'as\.starware\.com',
# Social Bookmarking Services
'del\.icio\.us',
'digg\.com',
'stumbleupon\.com',
'swik\.net',
'segnalo\.alice\.it',
'ineffabile\.it',
# Minor Australian search engines
'anzwers\.com\.au',
# Minor brazilian search engines
'engine\.exe', 'miner\.bol\.com\.br',
# Minor chinese search engines
'\.baidu\.com',     # baidu search portal
'\.vnet\.cn',       # powered by MSN
'\.soso\.com',      # powered by Google
'\.sogou\.com',     # powered by Sohu
'\.3721\.com',      # powered by Yahoo!
'iask\.com',        # powered by Sina
'\.accoona\.com',   # Accoona
'\.163\.com',       # powered by Google
'\.zhongsou\.com',  # zhongsou search portal
# Minor czech search engines
'atlas\.cz','seznam\.cz','quick\.cz','centrum\.cz','jyxo\.(cz|com)','najdi\.to','redbox\.cz',
'isearch\.avg\.com',
# Minor danish search-engines
'opasia\.dk', 'danielsen\.com', 'sol\.dk', 'jubii\.dk', 'find\.dk', 'edderkoppen\.dk', 'netstjernen\.dk', 'orbis\.dk', 'tyfon\.dk', '1klik\.dk', 'ofir\.dk',
# Minor dutch search engines
'ilse\.','vindex\.',
# Minor english search engines
'(^|\.)ask\.co\.uk','bbc\.co\.uk/cgi-bin/search','ifind\.freeserve','looksmart\.co\.uk','splut\.','spotjockey\.','ukdirectory\.','ukindex\.co\.uk','ukplus\.','searchy\.co\.uk',
'search\.fbdownloader\.com',
'search\.fdownloadr\.com',
'search\.babylon\.com',
'my\.allgameshome\.com',
'surfcanyon\.com',
'uk\.foxstart\.com',
'yandex\.com',
# Minor finnish search engines
'haku\.www\.fi',
# Minor french search engines
'recherche\.aol\.fr','ctrouve\.','francite\.','\.lbb\.org','rechercher\.libertysurf\.fr', 'search[\w\-]+\.free\.fr', 'recherche\.club-internet\.fr',
'toile\.com', 'biglotron\.com',
'mozbot\.fr',
# Minor german search engines
'sucheaol\.aol\.de',
'o2suche\.aol\.de',
'fireball\.de','infoseek\.de','suche\d?\.web\.de','[a-z]serv\.rrzn\.uni-hannover\.de',
'suchen\.abacho\.de','(brisbane|suche)\.t-online\.de','allesklar\.de','meinestadt\.de',
'212\.227\.33\.241',
'(161\.58\.227\.204|161\.58\.247\.101|212\.40\.165\.90|213\.133\.108\.202|217\.160\.108\.151|217\.160\.111\.99|217\.160\.131\.108|217\.160\.142\.227|217\.160\.176\.42)',
'wwweasel\.de',
'netluchs\.de',
'schoenerbrausen\.de',
'suche\.gmx\.net',
'suche\.gmx\.at',
'ecosia\.org',
'de\.aolsearch\.com',
'suche\.aol\.de',
'www\.startxxl\.com',
'www\.benefind\.de',
'www\.amazon\.de.*search', #Just as a reminder, probably will not work as AWstats seems to consider the host part of an URL only
'de\.wow\.com',
'www\.vlips\.de',
'metager\.de',
'search\.1und1\.de',
'sm\.de',
'sumaja\.de',
'navigationshilfe\.t-online\.de',
'umfis\.de',
'fastbot\.de',
'tixuma\.de',
'suche\.freenet\.de',
'www\.izito\.de',
'extern\.peoplecheck\.de',
'www\.oneseek\.de',
'de\.wiki\.gov\.cn',
'umuwa\.de',
'suche\.1und1\.de',
'www\.metasuche\.ch',
# Minor Hungarian search engines
'heureka\.hu','vizsla\.origo\.hu','lapkereso\.hu','goliat\.hu','index\.hu','wahoo\.hu','webmania\.hu','search\.internetto\.hu',
'tango\.hu',
'keresolap\.hu',
'kereso\.startlap\.hu',
'polymeta\.hu',
# Minor Indian search engines
'sify\.com',
# Minor Italian search engines
'virgilio\.it','arianna\.libero\.it','supereva\.com','kataweb\.it','search\.alice\.it\.master','search\.alice\.it','gotuneed\.com',
'godado','jumpy\.it','shinyseek\.it','teecno\.it',
# Minor Israeli search engines
'search\.genieo\.com',
# Minor Japanese search engines
'ask\.jp','sagool\.jp',
'websearch\.rakuten\.co\.jp',
# Minor Norwegian search engines
'sok\.start\.no', 'eniro\.no',
# Minor Polish search engines
'szukaj\.wp\.pl','szukaj\.onet\.pl','dodaj\.pl','gazeta\.pl','gery\.pl','hoga\.pl','netsprint\.pl','interia\.pl','katalog\.onet\.pl','o2\.pl','polska\.pl','szukacz\.pl','wow\.pl',
# Minor russian search engines
'ya(ndex)?\.ru', 'aport\.ru', 'rambler\.ru', 'turtle\.ru', 'metabot\.ru',
'go\.mail\.ru',
# Minor Swedish search engines
'evreka\.passagen\.se','eniro\.se',
# Minor Slovak search engines
'zoznam\.sk',
# Minor Portuguese search engines
'sapo\.pt',
# Minor swiss search engines
'search\.ch', 'search\.bluewin\.ch',
'www\.zapmeta\.ch',
'etools\.ch',
# Minor Croatian, Serbian, Macedonian, Bosnian and Herzegovinian search engines
'pogodak\.'
);
@SearchEnginesSearchIDOrder_listgen=(
# Generic search engines
'search\..*\.\w+'
);


# NotSearchEnginesKeys
# If a search engine key is found, we check its exclude list to know if it's
# really a search engine
#------------------------------------------------------------------------------
%NotSearchEnginesKeys=(
'altavista\.'=>'babelfish\.altavista\.',
'google\.'=>'mail\.google\.',
'google\.'=>'translate\.google\.',
'google\.'=>'code\.google\.',
'google\.'=>'groups\.google\.',
'msn\.'=>'hotmail\.msn\.',
'tiscali\.'=>'mail\.tiscali\.',
'yahoo\.'=>'(?:picks|mail)\.yahoo\.|yahoo\.[^/]+/picks',
'yandex\.'=>'direct\.yandex\.'
);


# SearchEnginesHashID
# Each Search Engine Search ID is associated to an AWStats id string
#------------------------------------------------------------------------------
%SearchEnginesHashID = (
# Major international search engines
'google\.[\w.]+/products','google_products',
'base\.google\.','google_base',
'froogle\.google\.','google_froogle',
'groups\.google\.','google_groups',
'images\.google\.','google_image',
'google\.','google',
'googlee\.','google',
'googlecom\.com','google',
'goggle\.co\.hu','google',
'216\.239\.32\.20', 'google',
'173\.194\.32\.223', 'google',
'216\.239\.(35|37|39|51)\.100','google_cache',
'216\.239\.(35|37|39|51)\.101','google_cache',
'216\.239\.5[0-9]\.104','google_cache',
'64\.233\.1[0-9]{2}\.104','google_cache',
'66\.102\.[1-9]\.104','google_cache',
'66\.249\.93\.104','google_cache',
'72\.14\.2[0-9]{2}\.104','google_cache',
'msn\.','msn',
'live\.com','live',
'bing\.','bing',
'voila\.','voila',
'mindset\.research\.yahoo','yahoo_mindset',
'yahoo\.','yahoo','(66\.218\.71\.225|216\.109\.117\.135|216\.109\.125\.130|66\.218\.69\.11)','yahoo',
'lycos\.','lycos',
'alexa\.com','alexa',
'alltheweb\.com','alltheweb',
'altavista\.','altavista',
'a9\.com','a9',
'dmoz\.org','dmoz',
'netscape\.','netscape',
'search\.terra\.','terra',
'www\.search\.com','search.com',
'tiscali\.','tiscali',
'search\.aol\.co','aol',
'search\.sli\.sympatico\.ca','sympatico',
'excite\.','excite',
# Minor international search engines
'4\-counter\.com','google4counter',
'att\.net','att',
'bungeebonesdotcom','bungeebonesdotcom',
'northernlight\.','northernlight',
'hotbot\.','hotbot',
'kvasir\.','kvasir',
'webcrawler\.','webcrawler',
'metacrawler\.','metacrawler',
'go2net\.com','go2net',
'(^|\.)go\.com','go',
'euroseek\.','euroseek',
'looksmart\.','looksmart',
'spray\.','spray',
'nbci\.com\/search','nbci',
'de\.ask.\com','askde', # break out Ask country specific engines.
'es\.ask.\com','askes',
'fr\.ask.\com','askfr',
'it\.ask.\com','askit',
'nl\.ask.\com','asknl',
'uk\.ask.\com','askuk',
'(^|\.)ask\.co\.uk','askuk',
'(^|\.)ask\.com','ask',
'atomz\.','atomz',
'overture\.com','overture',		# Replace 'goto\.com','Goto.com',
'teoma\.','teoma',
'findarticles\.com','findarticles',
'infospace\.com','infospace',
'mamma\.','mamma',
'dejanews\.','dejanews',
'dogpile\.com','dogpile',
'wisenut\.com','wisenut',
'ixquick\.com','ixquick',
'search\.earthlink\.net','earthlink',
'i-une\.com','iune',
'blingo\.com','blingo',
'centraldatabase\.org','centraldatabase',
'clusty\.com','clusty',
'mysearch\.','mysearch',
'vivisimo\.com','vivisimo',
'kartoo\.com','kartoo',
'icerocket\.com','icerocket',
'sphere\.com','sphere',
'ledix\.net','ledix',
'start\.shaw\.ca','shawca',
'searchalot\.com','searchalot',
'copernic\.com','copernic',
'avantfind\.com','avantfind',
'steadysearch\.com','steadysearch',
'steady-search\.com','steadysearch',
'claro-search\.com','clarosearch',
'www1\.search-results\.com', 'searchresults',
'www\.holasearch\.com', 'holasearch',
'search\.conduit\.com', 'conduit',
'static\.flipora\.com', 'flipora',
'(?:www[12]?|mixidj)\.delta-search\.com', 'delta-search',
'start\.iminent\.com', 'iminent',
'www\.searchmobileonline\.com', 'searchmobileonline',
'int\.search-results\.com', 'nortonsavesearch',
'www2\.inbox\.com', 'inbox',
'www\.govome\.com', 'govome',
'find1friend\.com', 'find1friend',
'start\.mysearchdial\.com', 'mysearchdial',
'go\.speedbit\.com', 'speedbit',
'search\.certified-toolbar\.com', 'certifiedtoolbarsearch',
'search\.sweetim\.com', 'sweetim',
'search\.searchcompletion\.com', 'searchcompletion',
'en\.eazel\.com','eazelsearch',
'sr\.searchfunmoods\.com', 'searchfunmoods',
'173\.194\.35\.177', 'googleByIP',
'dalesearch\.com', 'dalesearch',
'sweetpacks-search\.com', 'sweetpacks',
'searchgol\.com', 'searchgol',
'duckduckgo\.com', 'duckduckgo',
'sr\.facemoods\.com', 'facemoods',
'shoppstop\.com', 'shoppstop',
'searchya\.com', 'searchya',
'picsearch\.de', 'picsearch',
'webssearches\.com', 'webssearches',
'airzip\.inspsearch\.com', 'webssearches',
'zapmeta\.de', 'zapmeta',
'localmoxie\.com', 'localmoxie',
'search-results\.mobi', 'search-results_mobi',
'androidsearch\.com', 'androidsearch',
'isearch\.nation\.com', 'isearch_nation_com',
'search\.zonealarm\.com', 'search_zonealarm_com',
'www\.buenosearch\.com', 'www_buenosearch_com',
'search\.foxtab\.com', 'search_foxtab_com',
'searches\.qone8\.com', 'searches_qone8_com',
'startpage\.com', 'startpage_com',
'www\.qwant\.com', 'qwant_com',
'searches\.safehomepage\.com', 'safehomepage_com',
'searches\.vi-view\.com', 'vi-view_com',
'wow\.utop\.it', 'wow_utop_it',
'windowssearch\.com', 'windowssearch_com',
'www\.wow\.com', 'www_wow_com',
'globososo\.', 'globososo',
'kingtale3\.inspsearch\.com', 'globososo',
'swisscows\.ch', 'swisscows_ch',
'preciobarato\.xyz', 'preciobarato_xyz',
'www\.dregol\.com', 'www_dregol_com',
'search\.socialdownloadr\.com', 'search_socialdownloadr_com',
'int\.search\.myway\.com', 'int_search_myway_com',
'de\.dolphin\.com', 'de_dolphin_com',
'mys\.yoursearch\.me', 'mys_yoursearch_me',
# Chello Portals
'chello\.at','chelloat',
'chello\.be','chellobe',
'chello\.cz','chellocz',
'chello\.fr','chellofr',
'chello\.hu','chellohu',
'chello\.nl','chellonl',
'chello\.no','chellono',
'chello\.pl','chellopl',
'chello\.se','chellose',
'chello\.sk','chellosk',
'chello','chellocom',
# Mirago
'mirago\.be','miragobe',
'mirago\.ch','miragoch',
'mirago\.de','miragode',
'mirago\.dk','miragodk',
'es\.mirago\.com','miragoes',
'mirago\.fr','miragofr',
'mirago\.it','miragoit',
'mirago\.nl','miragonl',
'no\.mirago\.com','miragono',
'mirago\.se','miragose',
'mirago\.co\.uk','miragocouk',
'mirago','mirago', # required as catchall for new countries not yet known
'answerbus\.com','answerbus',
'icq\.com\/search','icq',
'nusearch\.com','nusearch',
'goodsearch\.com','goodsearch',
'scroogle\.org','scroogle',
'questionanswering\.com','questionanswering',
'mywebsearch\.com','mywebsearch',
'as\.starware\.com','comettoolbar',
# Social Bookmarking Services
'del\.icio\.us','delicious',
'digg\.com','digg',
'stumbleupon\.com','stumbleupon',
'swik\.net','swik',
'segnalo\.alice\.it','segnalo',
'ineffabile\.it','ineffabile',
# Minor Australian search engines
'anzwers\.com\.au','anzwers',
# Minor brazilian search engines
'engine\.exe','engine',
'miner\.bol\.com\.br','miner',
# Minor chinese search engines
'\.baidu\.com','baidu',
'iask\.com','iask',
'\.accoona\.com','accoona',
'\.3721\.com','3721',
'\.163\.com','netease',
'\.soso\.com','soso',
'\.zhongsou\.com','zhongsou',
'\.vnet\.cn','vnet',
'\.sogou\.com','sogou',
# Minor czech search engines
'atlas\.cz','atlas',
'seznam\.cz','seznam',
'quick\.cz','quick',
'centrum\.cz','centrum',
'jyxo\.(cz|com)','jyxo',
'najdi\.to','najdi',
'redbox\.cz','redbox',
'isearch\.avg\.com', 'avgsearch',
# Minor danish search-engines
'opasia\.dk','opasia',
'danielsen\.com','danielsen',
'sol\.dk','sol',
'jubii\.dk','jubii',
'find\.dk','finddk',
'edderkoppen\.dk','edderkoppen',
'netstjernen\.dk','netstjernen',
'orbis\.dk','orbis',
'tyfon\.dk','tyfon',
'1klik\.dk','1klik',
'ofir\.dk','ofir',
# Minor dutch search engines
'ilse\.','ilse',
'vindex\.','vindex',
# Minor english search engines
'bbc\.co\.uk/cgi-bin/search','bbc',
'ifind\.freeserve','freeserve',
'looksmart\.co\.uk','looksmartuk',
'splut\.','splut',
'spotjockey\.','spotjockey',
'ukdirectory\.','ukdirectory',
'ukindex\.co\.uk','ukindex',
'ukplus\.','ukplus',
'searchy\.co\.uk','searchy',
'search\.fbdownloader\.com','fbdownloader',
'search\.fdownloadr\.com', 'fdownloadr_com',
'search\.babylon\.com', 'babylon',
'my\.allgameshome\.com', 'allgameshome',
'surfcanyon\.com', 'surfcanyon_com',
'uk\.foxstart\.com', 'uk_foxstart_com',
'yandex\.com', 'yandex_com',
# Minor finnish search engines
'haku\.www\.fi','haku',
# Minor french search engines
'recherche\.aol\.fr','aolfr',
'ctrouve\.','ctrouve',
'francite\.','francite',
'\.lbb\.org','lbb',
'rechercher\.libertysurf\.fr','libertysurf',
'search[\w\-]+\.free\.fr','free',
'recherche\.club-internet\.fr','clubinternet',
'toile\.com','toile',
'biglotron\.com', 'biglotron',
'mozbot\.fr', 'mozbot',
# Minor german search engines
'sucheaol\.aol\.de','aolde',
'o2suche\.aol\.de','o2aolde',
'fireball\.de','fireball',
'infoseek\.de','infoseek',
'suche\d?\.web\.de','webde',
'[a-z]serv\.rrzn\.uni-hannover\.de','meta',
'suchen\.abacho\.de','abacho',
'(brisbane|suche)\.t-online\.de','t-online',
'allesklar\.de','allesklar',
'meinestadt\.de','meinestadt',
'212\.227\.33\.241','metaspinner',
'(161\.58\.227\.204|161\.58\.247\.101|212\.40\.165\.90|213\.133\.108\.202|217\.160\.108\.151|217\.160\.111\.99|217\.160\.131\.108|217\.160\.142\.227|217\.160\.176\.42)','metacrawler_de',
'wwweasel\.de','wwweasel',
'netluchs\.de','netluchs',
'schoenerbrausen\.de','schoenerbrausen',
'suche\.gmx\.net', 'gmxsuche',
'suche\.gmx\.at', 'gmxsuche_at',
'ecosia\.org', 'ecosiasearch',
'de\.aolsearch\.com', 'aolsearch',
'suche\.aol\.de', 'aolsuche',
'www\.startxxl\.com', 'startxxl',
'www\.benefind\.de', 'benefind',
'www\.amazon\.de.*search', 'amazonsearch', #Not clear if this matches amazon searches only
'de\.wow\.com', 'wowsearch',
'www\.vlips\.de', 'vlips_de',
'metager\.de', 'metager',
'search\.1und1\.de', 'search_1und1_de',
'sm\.de', 'smde',
'sumaja\.de', 'sumaja',
'navigationshilfe\.t-online\.de', 'navigationshilfe',
'umfis\.de', 'umfis',
'fastbot\.de', 'fastbot_de',
'tixuma\.de', 'tixuma_de',
'suche\.freenet\.de', 'freenet_de',
'www\.izito\.de', 'izito_de',
'extern\.peoplecheck\.de', 'peoplecheck_de',
'www\.oneseek\.de', 'oneseek_de',
'de\.wiki\.gov\.cn', 'de_wiki_gov_cn',
'umuwa\.de', 'umuwa_de',
'suche\.1und1\.de', '1und1_de',
'www\.metasuche\.ch', 'metasuche_ch',
# Minor Hungarian search engines
'heureka\.hu','heureka',
'vizsla\.origo\.hu','origo',
'lapkereso\.hu','lapkereso',
'goliat\.hu','goliat',
'index\.hu','indexhu',
'wahoo\.hu','wahoo',
'webmania\.hu','webmania',
'search\.internetto\.hu','internetto',
'tango\.hu','tango_hu',
'keresolap\.hu','keresolap_hu',
'kereso\.startlap\.hu', 'startlap_hu',
'polymeta\.hu','polymeta_hu',
# Minor Indian search engines
'sify\.com','sify',
# Minor Italian search engines
'virgilio\.it','virgilio',
'arianna\.libero\.it','arianna',
'supereva\.com','supereva',
'kataweb\.it','kataweb',
'search\.alice\.it\.master','aliceitmaster',
'search\.alice\.it','aliceit',
'gotuneed\.com','gotuneed',
'godado','godado',
'jumpy\.it','jumpy\.it',
'shinyseek\.it','shinyseek\.it',
'teecno\.it','teecnoit',
# Minor Israeli search engines
'search\.genieo\.com', 'genieo',
# Minor Japanese search engines
'ask\.jp','askjp',
'sagool\.jp','sagool',
'websearch\.rakuten\.co\.jp', 'rakuten',
# Minor Norwegian search engines
'sok\.start\.no','start', 'eniro\.no','eniro',
# Minor Polish search engines
'szukaj\.wp\.pl','wp',
'szukaj\.onet\.pl','onetpl',
'dodaj\.pl','dodajpl',
'gazeta\.pl','gazetapl',
'gery\.pl','gerypl',
'netsprint\.pl\/hoga\-search','hogapl',
'netsprint\.pl','netsprintpl',
'interia\.pl','interiapl',
'katalog\.onet\.pl','katalogonetpl',
'o2\.pl','o2pl',
'polska\.pl','polskapl',
'szukacz\.pl','szukaczpl',
'wow\.pl','wowpl',
# Minor russian search engines
'ya(ndex)?\.ru','yandex',
'aport\.ru','aport',
'rambler\.ru','rambler',
'turtle\.ru','turtle',
'metabot\.ru','metabot',
'go\.mail\.ru', 'mailru',
# Minor Swedish search engines
'evreka\.passagen\.se','passagen',
'eniro\.se','enirose',
# Minor Slovak search engines
'zoznam\.sk','zoznam',
# Minor Portuguese search engines
'sapo\.pt','sapo',
# Minor swiss search engines
'search\.ch','searchch',
'search\.bluewin\.ch','bluewin',
'www\.zapmeta\.ch', 'zapmeta_ch',
'etools\.ch', 'etools_ch',
# Minor Croatian, Serbian, Macedonian, Bosnian and Herzegovinian search engines
'pogodak\.','pogodak',
# Generic search engines
'search\..*\.\w+','search'
);


# SearchEnginesWithKeysNotInQuery
# List of search engines that store keyword as page instead of query parameter
#------------------------------------------------------------------------------
%SearchEnginesWithKeysNotInQuery=(
'a9',1,    # www.a9.com/searchkey1%20searchkey2
'iminent',1, #http://start.iminent.com/StartWeb/1031/toolbox/#q=searchkey1%20searchkey2&additional_arguments
'de_wiki_gov_cn',1, #http://de.wiki.gov.cn/s_searchkey1%20searchkey2
'umuwa_de', 1, #http://umuwa.de/searchkey or http://umuwa.de/searchkey/Images
'amazonsearch', 1 #http://www.amazon.de/gp/bit/apps/web/SERP/search/ref=bit_bds-p24_serp_cr_de?ie=UTF8tagbase=bds-p24&query=deutsch+8.+klasse+gymnasium+protokoll
);

# SearchEnginesKnownUrl
# Known rules to extract keywords from a referrer search engine URL
#------------------------------------------------------------------------------
%SearchEnginesKnownUrl=(
# Most common search engines
'alexa','q=',
'alltheweb','q(|uery)=',
'altavista','q=',
'a9','a9\.com\/',
'dmoz','search=',
'google_products','(p|q|as_p|as_q)=',
'google_base','(p|q|as_p|as_q)=',
'google_froogle','(p|q|as_p|as_q)=',
'google_groups','group\/', # does not work
'google_image','(p|q|as_p|as_q)=',
'google_cache','(p|q|as_p|as_q)=cache:[0-9A-Za-z]{12}:',
'google','(p|q|as_p|as_q)=',
'lycos','query=',
'msn','q=',
'live','q=',
'bing','q=',
'netscape','search=',
'tiscali','key=',
'aol','query=',
'terra','query=',
'voila','(kw|rdata)=',
'search.com','q=',
'yahoo_mindset','p=',
'yahoo','p=',
'sympatico', 'query=',
'excite','search=',
# Minor international search engines
'google4counter','(p|q|as_p|as_q)=',
'att','qry=',
'bungeebonesdotcom','query=',
'go','qt=',
'askde','(ask|q)=', # break out Ask country specific engines.
'askes','(ask|q)=',
'askfr','(ask|q)=',
'askit','(ask|q)=',
'asknl','(ask|q)=',
'ask','(ask|q)=',
'atomz','sp-q=',
'euroseek','query=',
'findarticles','key=',
'go2net','general=',
'hotbot','mt=',
'infospace','qkw=',
'kvasir', 'q=',
'looksmart','key=',
'mamma','query=',
'metacrawler','general=',
'nbci','keyword=',
'northernlight','qr=',
'overture','keywords=',
'dogpile', 'q(|kw)=',
'spray','string=',
'teoma','q=',
'webcrawler','searchText=',
'wisenut','query=',
'ixquick', 'query=',
'earthlink', 'q=',
'iune','(keywords|q)=',
'blingo','q=',
'centraldatabase','query=',
'clusty','query=',
'mysearch','searchfor=',
'vivisimo','query=',
# kartoo: No keywords passed in referring URL.
'kartoo','',
'icerocket','q=',
'sphere','q=',
'ledix','q=',
'shawca','q=',
'searchalot','q=',
'copernic','web\/',
'avantfind','keywords=',
'steadysearch','w=',
'clarosearch','q=',
'searchresults','q=',
'holasearch', 'q=',
'conduit', 'q=',
'flipora', 'q=',
'delta-search', 'q=',
'iminent', 'q=',
'searchmobileonline', 'q=',
'nortonsavesearch', 'q=',
'inbox', 'q(?:kw)?=',
'govome', 'q=',
'find1friend', 'q=',
'mysearchdial', 'q=',
'speedbit', 'q=',
'certifiedtoolbarsearch', 'q=',
'sweetim', 'q=',
'searchcompletion', 'q=',
'eazelsearch', 'q=',
'searchfunmoods', 'q=',
'googleByIP', 'q=',
'dalesearch',  'q=',
'sweetpacks', 'q=',
'searchgol', 'q=',
'duckduckgo', 'uddg=',
'facemoods', 'q=',
'shoppstop', 'keywords=',
'searchya', 'q=',
'picsearch', 'q=',
'webssearches', 'q=',
'zapmeta', 'query=',
'localmoxie', 'keyword=',
'search-results_mobi', 'q=',
'androidsearch', 'q=',
'isearch_nation_com', 'q=',
'search_zonealarm_com', 'q=',
'www_buenosearch_com', 'q=',
'search_foxtab_com', 'q=',
'searches_qone8_com', 'q=',
'startpage_com', 'query=',
'qwant_com', 'q=',
'safehomepage_com', 'q=',
'vi-view_com', 'q=',
'wow_utop_it', 'q=',
'windowssearch_com', 'q=',
'www_wow_com', 'q=',
'globososo', 'q=',
'swisscows_ch', 'query=',
'preciobarato_xyz', 's=',
'www_dregol_com', 'q=',
'search_socialdownloadr_com', 'q=',
'int_search_myway_com', 'searchfor=',
'de_dolphin_com', 'q=',
'mys_yoursearch_me', 'q=',
# Chello Portals
'chelloat','q1=',
'chellobe','q1=',
'chellocz','q1=',
'chellofr','q1=',
'chellohu','q1=',
'chellonl','q1=',
'chellono','q1=',
'chellopl','q1=',
'chellose','q1=',
'chellosk','q1=',
'chellocom','q1=',
# Mirago
'miragobe','(txtsearch|qry)=',
'miragoch','(txtsearch|qry)=',
'miragode','(txtsearch|qry)=',
'miragodk','(txtsearch|qry)=',
'miragoes','(txtsearch|qry)=',
'miragofr','(txtsearch|qry)=',
'miragoit','(txtsearch|qry)=',
'miragonl','(txtsearch|qry)=',
'miragono','(txtsearch|qry)=',
'miragose','(txtsearch|qry)=',
'miragocouk','(txtsearch|qry)=',
'mirago','(txtsearch|qry)=',
'answerbus','', # Does not provide query parameters
'icq','q=',
'nusearch','nusearch_terms=',
'goodsearch','Keywords=',
'scroogle','Gw=', # Does not always provide query parameters
'questionanswering','',
'mywebsearch','searchfor=',
'comettoolbar','qry=',
# Social Bookmarking Services
'delicious','all=',
'digg','s=',
'stumbleupon','',
'swik','swik\.net/', # does not work. Keywords follow domain, e.g. http://swik.net/awstats+analytics
'segnalo','',
'ineffabile','',
# Minor Australian search engines
'anzwers','search=',
# Minor brazilian search engines
'engine','p1=', 'miner','q=',
# Minor chinese search engines
'baidu','(wd|word)=',
'iask','(w|k)=',
'accoona','qt=',
'3721','(p|name)=',
'netease','q=',
'soso','q=',
'zhongsou','(word|w)=',
'sogou', 'query=',
'vnet','kw=',
# Minor czech search engines
'atlas','(searchtext|q)=', 'seznam','(w|q)=', 'quick','query=', 'centrum','q=', 'jyxo','(s|q)=', 'najdi','dotaz=', 'redbox','srch=',
'avgsearch', 'q=',
# Minor danish search engines
'opasia','q=', 'danielsen','q=', 'sol','q=', 'jubii','soegeord=', 'finddk','words=', 'edderkoppen','query=', 'orbis','search_field=', '1klik','query=', 'ofir','querytext=',
# Minor dutch search engines
'ilse','search_for=', 'vindex','in=',
# Minor english search engines
'askuk','(ask|q)=', 'bbc','q=', 'freeserve','q=', 'looksmartuk','key=',
'splut','pattern=', 'spotjockey','Search_Keyword=', 'ukindex', 'stext=', 'ukdirectory','k=', 'ukplus','search=', 'searchy', 'search_term=',
'fbdownloader','q=',
'fdownloadr_com', 'q=',
'babylon','q=',
'allgameshome', 's=',
'surfcanyon_com', 'q=',
'uk_foxstart_com', 'q=',
'yandex_com', 'text=',
# Minor finnish search engines
'haku','w=',
# Minor french search engines
'francite','name=', 'clubinternet', 'q=',
'toile', 'q=',
'biglotron','question=',
'mozbot','q=',
# Minor german search engines
'aolde','q=',
'o2aolde', 'q=',
'fireball','q=', 'infoseek','qt=', 'webde','su=',
'abacho','q=', 't-online','q=',
'metaspinner','qry=',
'metacrawler_de','qry=',
'wwweasel','q=',
'netluchs','query=',
'schoenerbrausen','q=',
'gmxsuche', 'q=',
'gmxsuche_at', 'q=',
'ecosiasearch', 'q=',
'aolsearch', 'q=',
'aolsuche', 'q=',
'startxxl', 'q=',
'benefind', 'q=',
'amazonsearch', 'query=',
'wowsearch', 'q=',
'vlips_de', 'q=',
'metager', 'eingabe=',
'search_1und1_de', 'q=',
'smde', 'q=',
#'sumaja', 'no query string available', #There is no query string in the referrer url
'navigationshilfe', 'q=',
'umfis', 'suchbegriff=',
'fastbot_de', 'red=[0-9]*\+',
'tixuma_de', 'sc=',
'freenet_de', 'query=',
'izito_de', 'q=',
'peoplecheck_de', 'q=',
'oneseek_de', 'q=',
'de_wiki_gov_cn', 'de\.wiki\.gov\.cn\/s_',
'umuwa_de', 'umuwa\.de\/',
'1und1_de', 'q=',
'metasuche_ch', 'q=',
# Minor Hungarian search engines
'heureka','heureka=', 'origo','(q|search)=', 'goliat','KERESES=', 'wahoo','q=', 'internetto','searchstr=',
'keresolap_hu','q=',
'startlap_hu', 'q=',
'tango_hu','q=',
'polymeta_hu','',
# Minor Indian search engines
'sify','keyword=',
# Minor Italian search engines
'virgilio','qs=',
'arianna','query=',
'supereva','q=',
'kataweb','q=',
'aliceitmaster','qs=',
'aliceit','qs=',
'gotuneed','', # Not yet known
'godado','Keywords=',
'jumpy\.it','searchWord=',
'shinyseek\.it','KEY=',
'teecnoit','q=',
# Minor Israeli search engines
'genieo','q=',
# Minor Japanese search engines
'askjp','(ask|q)=',
'sagool','q=',
'rakuten', 'qt=',
# Minor Norwegian search engines
'start','q=', 'eniro','q=',
# Minor Polish search engines
'wp','szukaj=',
'onetpl','qt=',
'dodajpl','keyword=',
'gazetapl','slowo=',
'gerypl','q=',
'hogapl','qt=',
'netsprintpl','q=',
'interiapl','q=',
'katalogonetpl','qt=',
'o2pl','qt=',
'polskapl','qt=',
'szukaczpl','q=',
'wowpl','q=',
# Minor russian search engines
'yandex', 'text=', 'rambler','words=', 'aport', 'r=', 'metabot', 'st=',
'mailru', 'q=',
# Minor swedish search engines
'passagen','q=',
'enirose', 'hitta:', #Not sure if this works, as the keywords are part of the URL, and therefore the URL does not contain a question mark.
# Minor swiss search engines
'searchch', 'q=', 'bluewin', 'qry=',
'zapmeta_ch', 'query=',
'etools_ch', 'query=',
# Minor Croatian, Serbian, Macedonian, Bosnian and Herzegovinian search engines
'pogodak', 'q='
);

# SearchEnginesKnownUrlNotFound
# Known rules to extract not found keywords from a referrer search engine URL
#------------------------------------------------------------------------------
%SearchEnginesKnownUrlNotFound=(
# Most common search engines
'msn','origq='
);

# If no rules are known, we take first paramater not into WordsToCleanSearchUrl
#------------------------------------------------------------------------------
@WordsToCleanSearchUrl= ('act=','annuaire=','btng=','cat=','categoria=','cfg=','cof=','cou=','count=','cp=','dd=','domain=','dt=','dw=','enc=','exec=','geo=','hc=','height=','hits=','hl=','hq=','hs=','id=','kl=','lang=','loc=','lr=','matchmode=','medor=','message=','meta=','mode=','order=','page=','par=','pays=','pg=','pos=','prg=','qc=','refer=','sa=','safe=','sc=','sort=','src=','start=','style=','stype=','sum=','tag=','temp=','theme=','type=','url=','user=','width=','what=','\\.x=','\\.y=','y=','look=');

# SearchEnginesKnownUTFCoding
# Known parameter that proves a search engine has coded its parameters in UTF-8
#------------------------------------------------------------------------------
%SearchEnginesKnownUTFCoding=(
# Most common search engines
'google','ie=utf-8',
'alltheweb','cs=utf-8'
);


# SearchEnginesHashLib
# List of search engines names
# 'search_engine_id', 'search_engine_name',
#------------------------------------------------------------------------------
%SearchEnginesHashLib=(
# Major international search engines
'alexa','<a href="http://www.alexa.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Alexa</a>',
'alltheweb','<a href="http://www.alltheweb.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">AllTheWeb</a>',
'altavista','<a href="http://www.altavista.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">AltaVista</a>',
'a9', '<a href="http://www.a9.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">A9</a>',
'dmoz','<a href="http://dmoz.org/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">DMOZ</a>',
'google_products','<a href="http://www.google.com/products" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google (Products)</a>',
'google_base','<a href="http://base.google.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google (Base)</a>',
'google_froogle','<a href="http://froogle.google.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Froogle (Google)</a>',
'google_groups','<a href="http://groups.google.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google (Groups)</a>',
'google_image','<a href="http://images.google.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google (Images)</a>',
'google_cache','<a href="http://www.google.com/help/features.html#cached" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google (cache)</a>',
'google','<a href="http://www.google.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Google</a>',
'lycos','<a href="http://www.lycos.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Lycos</a>',
'msn','<a href="http://search.msn.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Microsoft MSN Search</a>',
'live','<a href="http://www.live.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Microsoft Windows Live</a>',
'bing','<a href="http://www.bing.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Microsoft Bing</a>',
'netscape','<a href="http://www.netscape.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Netscape</a>',
'aol','<a href="http://www.aol.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">AOL</a>',
'terra','<a href="http://www.terra.es/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Terra</a>',
'tiscali','<a href="http://search.tiscali.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Tiscali</a>',
'voila','<a href="http://www.voila.fr/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Voila</a>',
'search.com','<a href="http://www.search.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Search.com</a>',
'yahoo_mindset','<a href="http://mindset.research.yahoo.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Yahoo! Mindset</a>',
'yahoo','<a href="http://www.yahoo.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Yahoo!</a>',
'sympatico','<a href="http://sympatico.msn.ca/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Sympatico</a>',
'excite','<a href="http://www.excite.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Excite</a>',
# Minor international search engines
'google4counter','<a href="http://www.4-counter.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">4-counter (Google)</a>',
'att','<a href="http://www.att.net/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">AT&T search (powered by Google)</a>',
'bungeebonesdotcom','<a href="http://BungeeBones.com/search.php/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">BungeeBones</a>',
'go','Go.com',
'askde','<a href="http://de.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask Deutschland</a>',
'askes','<a href="http://es.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask Espa&ntilde;a</a>', # break out Ask country specific engines.
'askfr','<a href="http://fr.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask France</a>',
'askit','<a href="http://it.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask Italia</a>',
'asknl','<a href="http://nl.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask Nederland</a>',
'ask','<a href="http://www.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask</a>',
'atomz','Atomz',
'dejanews','DejaNews',
'euroseek','Euroseek',
'findarticles','Find Articles',
'go2net','Go2Net (Metamoteur)',
'hotbot','Hotbot',
'infospace','InfoSpace',
'kvasir','Kvasir',
'looksmart','Looksmart',
'mamma','Mamma',
'metacrawler','MetaCrawler (Metamoteur)',
'nbci','NBCI',
'northernlight','NorthernLight',
'overture','Overture',                 # Replace 'goto\.com','Goto.com',
'dogpile','<a href="http://www.dogpile.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Dogpile</a>',
'spray','Spray',
'teoma','<a href="http://search.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Teoma</a>',							# Replace 'directhit\.com','DirectHit',
'webcrawler','<a href="http://www.webcrawler.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">WebCrawler</a>',
'wisenut','WISENut',
'ixquick','<a href="http://www.ixquick.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">ix quick</a>',
'earthlink', 'Earth Link',
'iune','<a href="http://www.i-une.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">i-une</a>',
'blingo','<a href="http://www.blingo.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Blingo</a>',
'centraldatabase','<a href="http://search.centraldatabase.org/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">GPU p2p search</a>',
'clusty','<a href="http://www.clusty.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Clusty</a>',
'mysearch','<a href="http://www.mysearch.com" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">My Search</a>',
'vivisimo','<a href="http://www.vivisimo.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Vivisimo</a>',
'kartoo','<a href="http://www.kartoo.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Kartoo</a>',
'icerocket','<a href="http://www.icerocket.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Icerocket (Blog)</a>',
'sphere','<a href="http://www.sphere.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Sphere (Blog)</a>',
'ledix','<a href="http://www.ledix.net/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ledix</a>',
'shawca','<a href="http://start.shaw.ca/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Shaw.ca</a>',
'searchalot','<a href="http://www.searchalot.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Searchalot</a>',
'copernic','<a href="http://www.copernic.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Copernic</a>',
'avantfind','<a href="http://www.avantfind.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Avantfind</a>',
'steadysearch','<a href="http://www.avantfind.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Avantfind</a>',
'clarosearch','<a href="http://www.claro-search.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Claro Search</a>',
'searchresults','<a href="http://www1.search-results.com/" rel="nofollow" title="Search-results Home Page [new window]" target="_blank">Search-results</a>',
'holasearch', '<a href="http://www.holasearch.com" rel="nofollow" title="Hola Search Home Page [new window]" target="_blank">Hola Search</a>',
'conduit', '<a href="http://search.conduit.com" rel="nofollow" title="Conduit Search Home Page [new window]" target="_blank">Conduit Search</a>',
'flipora', '<a href="http://static.flipora.com/" rel="nofollow" title="Flipora Home Page [new window]" target="_blank">Flipora</a>',
'delta-search', '<a href="http://www.delta-search.com/" rel="nofollow" title="Delta Search Home Page [new window]" target="_blank">Delta Search</a>',
'iminent', '<a href="http://start.iminent.com/" rel="nofollow" title="Iminent Home Page [new window]" target="_blank">Iminent</a>',
'searchmobileonline', '<a href="http://www.searchmobileonline.com/" rel="nofollow" title="Search Mobile Online (StartApp) Home Page [new window]" target="_blank">Search Mobile Online (StartApp)</a>',
'nortonsavesearch', '<a href="http://int.search-results.com/" rel="nofollow" title="Norton Safe Search Home Page [new window]" target="_blank">Norton Safe Search</a>',
'inbox', '<a href="http://www2.inbox.com/search/results1.aspx" rel="nofollow" title="Inbox Search [new window]" target="_blank">Inbox Search</a>',
'govome', '<a href="http://www.govome.com/" rel="nofollow" title="Govome [new window]" target="_blank">Govome</a>',
'find1friend', '<a href="http://find1friend.com/" rel="nofollow" title="Find1Friend [new window]" target="_blank">Find1Friend</a>',
'mysearchdial', '<a href="http://start.mysearchdial.com/" rel="nofollow" title="My Search Dial [new window]" target="_blank">My Search Dial</a>',
'speedbit', '<a href="http://go.speedbit.com/" rel="nofollow" title="Speedbit [new window]" target="_blank">Speedbit</a>',
'certifiedtoolbarsearch', '<a href="http://search.certified-toolbar.com/" rel="nofollow" title="Certified-Toolbar Search [new window]" target="_blank">Certified-Toolbar Search</a>',
'sweetim', '<a href="http://search.sweetim.com/" rel="nofollow" title="SweetIM Search [new window]" target="_blank">SweetIM Search</a>',
'searchcompletion', '<a href="http://search.searchcompletion.com/" rel="nofollow" title="SearchCompletion Search [new window]" target="_blank">SearchCompletion Search</a>',
'eazelsearch', '<a href="http://en.eazel.com/" rel="nofollow" title="Eazel Search [new window]" target="_blank">Eazel Search</a>',
'searchfunmoods', '<a href="http://sr.searchfunmoods.com/" rel="nofollow" title="Funmoods [new window]" target="_blank">Funmoods</a>',
'googleByIP', '<a href="http://173.194.35.177/" rel="nofollow" title="Google (Access by IP-Address) [new window]" target="_blank">Google (Access by IP-Address)</a>',
'dalesearch',  '<a href="http://www.dalesearch.com/" rel="nofollow" title="Dale Search [new window]" target="_blank">Dale Search</a>',
'sweetpacks', '<a href="http://www.sweetpacks-search.com/" rel="nofollow" title="Sweetpacks [new window]" target="_blank">Sweetpacks</a>',
'searchgol', '<a href="http://www.searchgol.com/" rel="nofollow" title="Search-Gol [new window]" target="_blank">Search-Gol</a>',
'duckduckgo',  '<a href="http://r.duckduckgo.com/" rel="nofollow" title="DuckDuckGo Home Page [new window]" target="_blank">DuckDuckGo (Does not provide search keyphrases, using found page instead)</a>',
'facemoods', '<a href="http://sr.facemoods.com/" rel="nofollow" title="Facemoods Search [new window]" target="_blank">Facemoods Search</a>',
'shoppstop', '<a href="http://www.shoppstop.com/" rel="nofollow" title="ShoppStop [new window]" target="_blank">ShoppStop</a>',
'searchya', '<a href="http://www.searchya.com/" rel="nofollow" title="Searchya [new window]" target="_blank">Searchya</a>',
'picsearch', '<a href="http://www.picsearch.de/" rel="nofollow" title="picsearch [new window]" target="_blank">picsearch</a>',
'webssearches', 'Various variants of Webssearches <a href="http://www.webssearches.com/" rel="nofollow" title="Webssearches [new window]" target="_blank">EMG Technologies</a> and <a href="http://airzip.inspsearch.com/" rel="nofollow" title="airzip.inspsearch.com [new window]" target="_blank">airzip.inspsearch.com</a>',
#Jan 8, 2016: No genuine inspsearch.com search engine seems so exist, but there is a couple of search engines using subdomains of inspsearch.com. Unclear how these are related to each other.
'zapmeta', '<a href="http://www.zapmeta.de/" rel="nofollow" title="ZapMeta [new window]" target="_blank">ZapMeta</a>',
'localmoxie', '<a href="http://www.localmoxie.com/" rel="nofollow" title="Local Moxie [new window]" target="_blank">Local Moxie</a>',
'search-results_mobi', '<a href="http://search-results.mobi/" rel="nofollow" title="search-results.mobi [new window]" target="_blank">search-results.mobi</a>',
'androidsearch', '<a href="http://www.androidsearch.com/" rel="nofollow" title="androidsearch.com [new window]" target="_blank">androidsearch.com</a>',
'isearch_nation_com', '<a href="http://isearch.nation.com/" rel="nofollow" title="Nation Search [new window]" target="_blank">Nation Search</a>',
'search_zonealarm_com', '<a href="http://search.zonealarm.com/" rel="nofollow" title="Zone Alarm Search [new window]" target="_blank">Zone Alarm Search</a>',
'www_buenosearch_com', '<a href="http://www.buenosearch.com/" rel="nofollow" title="BuenoSearch [new window]" target="_blank">BuenoSearch</a>',
'search_foxtab_com',  '<a href="http://search.foxtab.com/" rel="nofollow" title="Foxtab Search [new window]" target="_blank">Foxtab Search</a>',
'searches_qone8_com', '<a href="http://searches.qone8.com/" rel="nofollow" title="Omiga-Plus [new window]" target="_blank">Omiga-Plus</a>',
'startpage_com', '<a href="http://startpage.com/" rel="nofollow" title="Startpage [new window]" target="_blank">Startpage</a>',
'qwant_com', '<a href="https://www.qwant.com/" rel="nofollow" title="qwant.com [new window]" target="_blank">qwant.com</a>',
'safehomepage_com', '<a href="http://searches.safehomepage.com/" rel="nofollow" title="safehomepage.com [new window]" target="_blank">safehomepage.com</a>',
'vi-view_com', '<a href="http://searches.vi-view.com/" rel="nofollow" title="vi-view.com [new window]" target="_blank">vi-view.com</a>',
'wow_utop_it', '<a href="http://wow.utop.it/" rel="nofollow" title="wow.utop.it [new window]" target="_blank">wow.utop.it</a>',
'windowssearch_com', '<a href="http://www.windowssearch.com/search?q=AWStats" rel="nofollow" title="Example page [new window]" target="_blank">windowssearch.com</a>',
'www_wow_com', '<a href="http://www.wow.com/" rel="nofollow" title="www.wow.com [new window]" target="_blank">WOW.com</a>',
'globososo', 'Various variants of Globososo (Kingtale Technology): <a href="http://www.globososo.com/" rel="nofollow" title="Globososo search page [new window]" target="_blank">www</a>, <a href="http://searches.globososo.com/" rel="nofollow" title="searches subdomain of globososo.com [new window]" target="_blank">searches</a>, <a href="http://searches3.globososo.com/" rel="nofollow" title="searches3 subdomain of globososo.com [new window]" target="_blank">searches3</a>, and at inspsearch.com (<a href="http://globososo.inspsearch.com/" rel="nofollow" title="Globososo search page at globososo.inspsearch.com [new window]" target="_blank">globososo</a>, <a href="http://kingtale3.inspsearch.com/" rel="nofollow" title="Globososo search page at kingtale3.inspsearch.com [new window]" target="_blank">kingtale3</a>)',
'swisscows_ch', '<a href="https://swisscows.ch/" rel="nofollow" title="Swisscows search page [new window]" target="_blank">Swisscows</a>',
'preciobarato_xyz', '<a href="http://preciobarato.xyz/" rel="nofollow" title="preciobarato.xyz offline on Oct 2, 2015 [new window]" target="_blank">Yandex</a>',
'www_dregol_com', '<a href="http://www.dregol.com/" rel="nofollow" title="Dregol Search [new window]" target="_blank">Dregol Search</a>',
'search_socialdownloadr_com', '<a href="http://search.socialdownloadr.com/" rel="nofollow" title="Socialdownloadr search page [new window]" target="_blank">Socialdownloadr</a>',
'int_search_myway_com', '<a href="http://int.search.myway.com/" rel="nofollow" title="MyWay search page [new window]" target="_blank">MyWay</a>',
'de_dolphin_com', '<a href="http://de.dolphin.com/" rel="nofollow" title="Dolphin Search search page [new window]" target="_blank">Dolphin Search</a>',
'mys_yoursearch_me', '<a href="http://mys.yoursearch.me/" rel="nofollow" title="Yoursearch.me search page [new window]" target="_blank">Yoursearch.me</a>',
# Chello Portals
'chelloat','<a href="http://www.chello.at/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Austria</a>',
'chellobe','<a href="http://www.chello.be/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Belgium</a>',
'chellocz','<a href="http://www.chello.cz/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Czech Republic</a>',
'chellofr','<a href="http://www.chello.fr/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello France</a>',
'chellohu','<a href="http://www.chello.hu/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Hungary</a>',
'chellonl','<a href="http://www.chello.nl/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Netherlands</a>',
'chellono','<a href="http://www.chello.no/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Norway</a>',
'chellopl','<a href="http://www.chello.pl/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Poland</a>',
'chellose','<a href="http://www.chello.se/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Sweden</a>',
'chellosk','<a href="http://www.chello.sk/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello Slovakia</a>',
'chellocom','<a href="http://www.chello.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Chello (Country not recognized)</a>',
# Mirago
'miragobe','<a href="http://www.mirago.be/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Belgium</a>',
'miragoch','<a href="http://www.mirago.ch/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Switzerland</a>',
'miragode','<a href="http://www.mirago.de/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Germany</a>',
'miragodk','<a href="http://www.mirago.dk/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Denmark</a>',
'miragoes','<a href="http://es.mirago.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Spain</a>',
'miragofr','<a href="http://www.mirago.fr/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago France</a>',
'miragoit','<a href="http://www.mirago.it/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Italy</a>',
'miragonl','<a href="http://www.mirago.nl/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Netherlands</a>',
'miragono','<a href="http://no.mirago.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Norway</a>',
'miragose','<a href="http://www.mirago.se/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago Sweden</a>',
'miragocouk','<a href="http://zone.mirago.co.uk/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago UK</a>',
'mirago','<a href="http://www.mirago.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mirago (country unknown)</a>',
'answerbus','<a href="http://www.answerbus.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Answerbus</a>',
'icq','<a href="http://www.icq.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">icq</a>',
'nusearch','<a href="http://www.nusearch.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Nusearch</a>',
'goodsearch','<a href="http://www.goodsearch.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">GoodSearch</a>',
'scroogle','<a href="http://www.scroogle.org/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Scroogle</a>',
'questionanswering','<a href="http://www.questionanswering.com/" rel="nofollow" title="Questionanswering home page [new window]" target="_blank">Questionanswering</a>',
'mywebsearch','<a href="http://search.mywebsearch.com/" rel="nofollow" title="MyWebSearch home page [new window]" target="_blank">MyWebSearch</a>',
'comettoolbar','<a href="http://as.starware.com/dp/search" rel="nofollow" title="Comet toolbar search home page [new window]" target="_blank">Comet toolbar search</a>',
# Social Bookmarking Services
'delicious','<a href="http://del.icio.us/" rel="nofollow" title="del.icio.us home page [new window]" target="_blank">del.icio.us</a> (Social Bookmark)',
'digg','<a href="http://www.digg.com/" rel="nofollow" title="Digg home page [new window]" target="_blank">Digg</a> (Social Bookmark)',
'stumbleupon','<a href="http://www.stumbleupon.com/" rel="nofollow" title="Stumbleupon home page [new window]" target="_blank">Stumbleupon</a> (Social Bookmark)',
'swik','<a href="http://swik.net/" rel="nofollow" title="Swik home page [new window]" target="_blank">Swik</a> (Social Bookmark)',
'segnalo','<a href="http://segnalo.alice.it/" rel="nofollow" title="Segnalo home page [new window]" target="_blank">Segnalo</a> (Social Bookmark)',
'ineffabile','<a href="http://www.ineffabile.it/" rel="nofollow" title="Ineffabile.it home page [new window]" target="_blank">Ineffabile.it</a> (Social Bookmark)',
# Minor Australian search engines
'anzwers','<a href="http://anzwers.com.au/" rel="nofollow" title="anzwers.com.au home page [new window]" target="_blank">anzwers.com.au</a>',
# Minor brazilian search engines
'engine','Cade', 'miner','Meta Miner',
# Minor chinese search engines
'baidu','<a href="http://www.baidu.com/" rel="nofollow" target="_blank">Baidu</a>',
'iask','<a href="http://www.iask.com/" rel="nofollow" target="_blank">Iask</a>',
'accoona','<a href="http://cn.accoona.com" rel="nofollow" target="_blank">Accoona</a>',
'3721','<a href="http://www.3721.com/" rel="nofollow" target="_blank">3721</a>',
'netease', '<a href="http://www.163.com/" rel="nofollow" target="_blank">NetEase</a>',
'soso','<a href="http://www.soso.com/" rel="nofollow" target="_blank">SoSo</a>',
'zhongsou','<a href="http://www.zhongsou.com/" rel="nofollow" target="_blank">ZhongSou</a>',
'sogou', '<a href="http://www.sogou.com/" rel="nofollow" target="_blank">SoGou</a>',
'vnet','<a href="http://114.vnet.cn/" rel="nofollow" target="_blank">VNet</a>',
# Minor czech search engines
'atlas','Atlas.cz',	'seznam','Seznam', 'quick','Quick.cz', 'centrum','Centrum.cz', 'jyxo','Jyxo.cz', 'najdi','Najdi.to', 'redbox','RedBox.cz',
'avgsearch', '<a href="http://isearch.avg.com" rel="nofollow" target="_blank">AVG Secure Search</a>',
# Minor danish search-engines
'opasia','Opasia', 'danielsen','Thor (danielsen.com)', 'sol','SOL', 'jubii','Jubii', 'finddk','Find', 'edderkoppen','Edderkoppen', 'netstjernen','Netstjernen', 'orbis','Orbis', 'tyfon','Tyfon', '1klik','1Klik', 'ofir','Ofir',
# Minor dutch search engines
'ilse','Ilse','vindex','Vindex\.nl',
# Minor english search engines
'askuk','<a href="http://uk.ask.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask UK</a>',
'bbc','BBC', 'freeserve','Freeserve', 'looksmartuk','Looksmart UK',
'splut','Splut', 'spotjockey','Spotjockey', 'ukdirectory','UK Directory', 'ukindex','UKIndex', 'ukplus','UK Plus', 'searchy','searchy.co.uk',
'fbdownloader','<a href="http://search.fbdownloader.com/" rel="nofollow" title="FBDownloader Home Page [new window]" target="_blank">FBDownloader (fbdownloader)</a>',
'fdownloadr_com', '<a href="http://search.fdownloadr.com/" rel="nofollow" title="FBDownloader Home Page [new window]" target="_blank">FBDownloader (fdownloadr)</a>',
'babylon','<a href="http://search.babylon.com/" rel="nofollow" title="Babylon Home Page [new window]" target="_blank">Babylon</a>',
'allgameshome', '<a href="http://my.allgameshome.com/" rel="nofollow" title="AllGamesHome [new window]" target="_blank">AllGamesHome</a>',
'surfcanyon_com', '<a href="http://search.surfcanyon.com/" rel="nofollow" title="SurfCanyon [new window]" target="_blank">SurfCanyon</a>',
'uk_foxstart_com', '<a href="http://uk.foxstart.com/" rel="nofollow" title="Foxstart search page [new window]" target="_blank">Foxstart.com</a>',
'yandex_com', '<a href="http://yandex.com/" rel="nofollow" title="Yandex search page [new window]" target="_blank">Yandex</a>',
# Minor finnish search engines
'haku','Ihmemaa',
# Minor french search engines
'aolfr','AOL (fr)', 'ctrouve','C\'est trouve', 'francite','Francite', 'lbb', 'LBB', 'libertysurf', 'Libertysurf', 'free', 'Free.fr', 'clubinternet', 'Club-internet',
'toile', 'Toile du Quebec',
'biglotron','<a href="http://www.biglotron.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Biglotron</a>',
'mozbot','<a href="http://www.mozbot.fr/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Mozbot</a>',
# Minor German search engines
'aolde','AOL (de)',
'o2aolde', '<a href="http://o2suche.aol.de/aol/search" rel="nofollow" title="o2 Suche Home Page [new window]" target="_blank">o2 Suche</a>',
'fireball','Fireball', 'infoseek','Infoseek',
'webde','<a href="http://suche.web.de" rel="nofollow" title="Web.de Home Page [new window]" target="_blank">Web.de</a>',
'abacho','Abacho',
't-online','T-Online',
'allesklar','allesklar.de', 'meinestadt','meinestadt.de',
'metaspinner','metaspinner',
'metacrawler_de','metacrawler.de',
'wwweasel','<a href="http://wwweasel.de/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">WWWeasel</a>',
'netluchs','<a href="http://www.netluchs.de/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Netluchs</a>',
'schoenerbrausen','<a href="http://www.schoenerbrausen.de/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Schoenerbrausen/</a>',
'gmxsuche', '<a href="http://suche.gmx.net/" rel="nofollow" title="GMX Suche Home Page [new window]" target="_blank">GMX Suche</a>',
'gmxsuche_at', '<a href="http://suche.gmx.at/" rel="nofollow" title="GMX Suche Oesterreich Home Page [new window]" target="_blank">GMX Suche Oesterreich</a>',
'ecosiasearch', '<a href="http://ecosia.org" rel="nofollow" title="Ecosia Search Home Page [new window]" target="_blank">Ecosia Search</a>',
'aolsearch', '<a href="http://de.aolsearch.com/" rel="nofollow" title="AOL Search Home Page [new window]" target="_blank">AOL Search</a>',
'aolsuche', '<a href="http://suche.aol.de/" rel="nofollow" title="AOL Suche Home Page [new window]" target="_blank">AOL Suche</a>',
'startxxl', '<a href="http://www.startxxl.com/" rel="nofollow" title="StartXXL Home Page [new window]" target="_blank">StartXXL</a>',
'benefind', '<a href="http://www.benefind.de/" rel="nofollow" title="benefind Home Page [new window]" target="_blank">benefind</a>',
'amazonsearch', '<a href="http://www.amazon.de/gp/bit/apps/web/SERP/search/" rel="nofollow" title="Amazon Web Search Home Page [new window]" target="_blank">Amazon Web Search</a>',
'wowsearch', '<a href="http://de.wow.com/" rel="nofollow" title="Wow Search Home Page [new window]" target="_blank">Wow Search</a>',
'vlips_de', '<a href="http://www.vlips.de/semags_proxy.php" rel="nofollow" title="vlips Proxy Page (Homepage not yet ready?) [new window]" target="_blank">vlips.de</a>',
'metager', '<a href="http://www.metager.de" rel="nofollow" title="MetaGer Home Page [new window]" target="_blank">MetaGer</a>',
'search_1und1_de', '<a href="http://search.1und1.de/" rel="nofollow" title="1&amp;1 Suche [new window]" target="_blank">1&amp;1 Suche (subdomain "search")</a>',
'smde', '<a href="http://www.sm.de/" rel="nofollow" title="SM.de - Die SuchMaschine [new window]" target="_blank">SM.de - Die SuchMaschine</a>',
'sumaja',  '<a href="http://www.sumaja.de/" rel="nofollow" title="Sumaja [new window]" target="_blank">Sumaja</a>',
'navigationshilfe', '<a href="http://navigationshilfe.t-online.de/" rel="nofollow" title="T-Online Navigationshilfe [new window]" target="_blank">T-Online Navigationshilfe</a>',
'umfis', '<a href="http://www.umfis.de/" rel="nofollow" title="UMFIS-Online Das Umweltfirmen-Informationssystem der IHKs in Deutschland [new window]" target="_blank">UMFIS-Online Das Umweltfirmen-Informationssystem der IHKs in Deutschland</a>',
'fastbot_de', '<a href="http://fastbot.de/" rel="nofollow" title="Fastbot.de [new window]" target="_blank">Fastbot.de (Does not provide search keyphrases, using found page instead)</a>',
'tixuma_de', '<a href="http://www.tixuma.de/" rel="nofollow" title="Tixuma Deutschland [new window]" target="_blank">Tixuma Deutschland</a>',
'freenet_de', '<a href="http://suche.freenet.de/" rel="nofollow" title="suche.freenet.de [new window]" target="_blank">suche.freenet.de</a>',
'izito_de',  '<a href="http://www.izito.de/" rel="nofollow" title="iZito Deutschland [new window]" target="_blank">iZito Deutschland</a>',
'peoplecheck_de', '<a href="http://peoplecheck.de/" rel="nofollow" title="PeopleCheck.de [new window]" target="_blank">PeopleCheck.de</a>',
'oneseek_de', '<a href="http://www.oneseek.de" rel="nofollow" title="Metasuchmaschine OneSeek.de [new window]" target="_blank">Metasuchmaschine OneSeek.de</a>',
'de_wiki_gov_cn', '<a href="http://de.wiki.gov.cn/" rel="nofollow" title="Wiki Sucher [new window]" target="_blank">Wiki Sucher</a>',
'umuwa_de', '<a href="http://umuwa.de/" rel="nofollow" title="Umuwa Deutschland [new window]" target="_blank">Umuwa Deutschland</a>',
'1und1_de', '<a href="http://suche.1und1.de/" rel="nofollow" title="1&amp;1 Suche [new window]" target="_blank">1&amp;1 Suche (subdomain "suche")</a>',
'metasuche_ch', '<a href="http://www.metasuche.ch/" rel="nofollow" title="Metasuche search page [new window]" target="_blank">Metasuche.ch</a>',
# Minor hungarian search engines
'heureka','Heureka', 'origo','Origo-Vizsla', 'lapkereso','Startlapkereso', 'goliat','Goliat', 'indexhu','Index', 'wahoo','Wahoo', 'webmania','webmania.hu', 'internetto','Internetto Kereso',
'tango_hu','<a href="http://tango.hu/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Tango</a>',
'keresolap_hu','<a href="http://keresolap.hu/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Tango keresolap</a>',
'startlap_hu','<a href="http://kereso.startlap.hu/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Startlab Kereso</a>',
'polymeta_hu','<a href="http://www.polymeta.hu/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Polymeta</a>',
# Minor Indian search engines
'sify','<a href="http://search.sify.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Sify</a>',
# Minor Italian search engines
'virgilio','<a href="http://www.virgilio.it/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Virgilio</a>',
'arianna','<a href="http://arianna.libero.it/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Arianna</a>',
'supereva','<a href="http://search.supereva.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Supereva</a>',
'kataweb','<a href="http://www.kataweb.it/ricerca/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Kataweb</a>',
'aliceitmaster','<a href="http://www.alice.it/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">search.alice.it.master</a>',
'aliceit','<a href="http://www.alice.it/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">alice.it</a>',
'gotuneed','<a href="http://www.gotuneed.com/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">got u need</a>',
'godado','Godado.it',
'jumpy\.it','Jumpy.it',
'shinyseek\.it','Shinyseek.it',
'teecnoit','<a href="http://www.teecno.it/" rel="nofollow" title="Teecno home page [new window]" target="_blank">Teecno</a>',
# Minor Israeli search engines
'genieo','<a href="http://search.genieo.com/" rel="nofollow" title="Genieo home page [new window]" target="_blank">Genieo</a>',
# Minor Japanese search engines
'askjp','<a href="http://www.ask.jp/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Ask Japan</a>',
'sagool','<a href="http://sagool.jp/" rel="nofollow" title="Sagool home page [new window]" target="_blank">Sagool</a>',
'rakuten', '<a href="http://websearch.rakuten.co.jp" rel="nofollow" title="websearch.rakuten.co.jp [new window]" target="_blank">websearch.rakuten.co.jp</a>',
# Minor Norwegian search engines
'start','start.no', 'eniro','<a href="http://www.eniro.no/" rel="nofollow" title="Search Engine Home Page [new window]" target="_blank">Eniro</a>',
# Minor polish search engines
'wp','<a href="http://szukaj.wp.pl/" rel="nofollow" title="Wirtualna Polska home page [new window]" target="_blank">Wirtualna Polska</a>',
'onetpl','<a href="http://szukaj.onet.pl/" rel="nofollow" title="Onet.pl home page [new window]" target="_blank">Onet.pl</a>',
'dodajpl','<a href="http://www.dodaj.pl/" rel="nofollow" title="Dodaj.pl home page [new window]" target="_blank">Dodaj.pl</a>',
'gazetapl','<a href="http://szukaj.gazeta.pl/" rel="nofollow" title="Gazeta.pl home page [new window]" target="_blank">Gazeta.pl</a>',
'gerypl','<a href="http://szukaj.gery.pl/" rel="nofollow" title="Gery.pl home page [new window]" target="_blank">Gery.pl</a>',
'hogapl','<a href="http://www.hoga.pl/" rel="nofollow" title="Hoga.pl home page [new window]" target="_blank">Hoga.pl</a>',
'netsprintpl','<a href="http://www.netsprint.pl/" rel="nofollow" title="NetSprint.pl home page [new window]" target="_blank">NetSprint.pl</a>',
'interiapl','<a href="http://www.google.interia.pl/" rel="nofollow" title="Interia.pl home page [new window]" target="_blank">Interia.pl</a>',
'katalogonetpl','<a href="http://katalog.onet.pl/" rel="nofollow" title="Katalog.Onet.pl home page [new window]" target="_blank">Katalog.Onet.pl</a>',
'o2pl','<a href="http://szukaj2.o2.pl/" rel="nofollow" title="o2.pl home page [new window]" target="_blank">o2.pl</a>',
'polskapl','<a href="http://szukaj.polska.pl/" rel="nofollow" title="Polska home page [new window]" target="_blank">Polska</a>',
'szukaczpl','<a href="http://www.szukacz.pl/" rel="nofollow" title="Szukacz home page [new window]" target="_blank">Szukacz</a>',
'wowpl','<a href="http://szukaj.wow.pl/" rel="nofollow" title="Wow.pl home page [new window]" target="_blank">Wow.pl</a>',
# Minor russian search engines
'yandex', 'Yandex', 'aport', 'Aport', 'rambler', 'Rambler', 'turtle', 'Turtle', 'metabot', 'MetaBot',
'mailru','<a href="http://go.mail.ru/" rel="nofollow" title="Mail.Ru home page [new window]" target="_blank">Mail.Ru</a>',
# Minor Swedish search engines
'passagen','Evreka',
'enirose','<a href="http://www.eniro.se/" rel="nofollow" title="Eniro Sverige home page [new window]" target="_blank">Eniro Sverige</a>',
# Minor Slovak search engines
'zoznam','<a href="http://www.zoznam.sk/" rel="nofollow" title="Zoznam search engine home page [new window]" target="_blank">Zoznam</a>',
# Minor Portuguese search engines
'sapo','<a href="http://www.sapo.pt/" rel="nofollow" title="Sapo search engine home page [new window]" target="_blank">Sapo</a>',
# Minor Swiss search engines
'searchch', 'search.ch', 'bluewin', 'search.bluewin.ch',
'zapmeta_ch', '<a href="http://www.zapmeta.ch/" rel="nofollow" title="ZapMeta.ch [new window]" target="_blank">ZapMeta.ch</a>',
'etools_ch', '<a href="http://www.etools.ch/" rel="nofollow" title="eTools.ch [new window]" target="_blank">eTools.ch</a>',
# Minor Croatian, Serbian, Macedonian, Bosnian and Herzegovinian search engines
'pogodak','<a href="http://www.pogodak.com" rel="nofollow" title="Pogodak search engine home page [new window]" target="_blank">Pogodak.com</a>',
# Generic search engines
'search','Unknown search engines'
);


# Sanity check.
# Enable this code and run perl search_engines.pm to check file entries are ok
#-----------------------------------------------------------------------------
#foreach my $key (@SearchEnginesSearchIDOrder_list1) {
#	if (! $SearchEnginesHashID{$key}) { error("Entry '$key' has been found in SearchEnginesSearchIDOrder_list1 with no value in SearchEnginesHashID");
#	foreach my $key2 (@SearchEnginesSearchIDOrder_list2) { if ($key2 eq $key) { error("$key is in 1 and 2\n"); } }
#	foreach my $key2 (@SearchEnginesSearchIDOrder_listgen) { if ($key2 eq $key) { error("$key is in 1 and gen\n"); } }
#} }
#foreach my $key (@SearchEnginesSearchIDOrder_list2) {
#	if (! $SearchEnginesHashID{$key}) { error("Entry '$key' has been found in SearchEnginesSearchIDOrder_list1 with no value in SearchEnginesHashID");
#	foreach my $key2 (@SearchEnginesSearchIDOrder_list1) { if ($key2 eq $key) { error("$key is in 2 and 1\n"); } }
#	foreach my $key2 (@SearchEnginesSearchIDOrder_listgen) { if ($key2 eq $key) { error("$key is in 2 and gen\n"); } }
#} }
#foreach my $key (@SearchEnginesSearchIDOrder_listgen) { if (! $SearchEnginesHashID{$key}) { error("Entry '$key' has been found in SearchEnginesSearchIDOrder_listgen with no value in SearchEnginesHashID"); } }
#foreach my $key (keys %NotSearchEnginesKeys) { if (! $SearchEnginesHashID{$key}) { error("Entry '$key' has been found in NotSearchEnginesKeys with no value in SearchEnginesHashID"); } }
#foreach my $key (keys %SearchEnginesKnownUrl) {
#	my $found=0;
#	foreach my $key2 (values %SearchEnginesHashID) {
#		if ($key eq $key2) { $found=1; last; }
#	}
#	if (! $found) { die "Entry '$key' has been found in SearchEnginesKnownUrl with no value in SearchEnginesHashID"; }
#}
#foreach my $key (keys %SearchEnginesHashLib) {
#	my $found=0;
#	foreach my $key2 (values %SearchEnginesHashID) {
#		if ($key eq $key2) { $found=1; last; }
#	}
#	if (! $found) { die "Entry '$key' has been found in SearchEnginesHashLib with no value in SearchEnginesHashID"; }
#}
#print @SearchEnginesSearchIDOrder_list1." ".@SearchEnginesSearchIDOrder_list2." ".@SearchEnginesSearchIDOrder_listgen;

1;
