/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CodeGenerator;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.debug.DebugFrame;

public final class Interpreter
extends Icode
implements Evaluator {
    InterpreterData itsData;
    static final int EXCEPTION_TRY_START_SLOT = 0;
    static final int EXCEPTION_TRY_END_SLOT = 1;
    static final int EXCEPTION_HANDLER_SLOT = 2;
    static final int EXCEPTION_TYPE_SLOT = 3;
    static final int EXCEPTION_LOCAL_SLOT = 4;
    static final int EXCEPTION_SCOPE_SLOT = 5;
    static final int EXCEPTION_SLOT_SIZE = 6;

    private static CallFrame captureFrameForGenerator(CallFrame callFrame) {
        callFrame.frozen = true;
        CallFrame callFrame2 = callFrame.cloneFrozen();
        callFrame.frozen = false;
        callFrame2.parentFrame = null;
        callFrame2.frameIndex = 0;
        return callFrame2;
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptNode scriptNode, String string, boolean bl) {
        CodeGenerator codeGenerator = new CodeGenerator();
        this.itsData = codeGenerator.compile(compilerEnvirons, scriptNode, string, bl);
        return this.itsData;
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || bl && nArray[i + 3] != 1) continue;
            if (n2 >= 0) {
                if (n4 < n6) continue;
                if (n3 > n5) {
                    Kit.codeBug();
                }
                if (n4 == n6) {
                    Kit.codeBug();
                }
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case -63: 
            case -62: 
            case 50: 
            case 72: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 57: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -61: 
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            byte by = byArray[i];
            n = Interpreter.bytecodeSpan(by);
            if (by != -26) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n3 = Interpreter.getIndex(byArray, i + 1);
            uintMap.put(n3, 0);
        }
        return uintMap.getKeys();
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        int n;
        Object[] objectArray;
        Context context = Context.getCurrentContext();
        if (context == null || context.lastInterpreterFrame == null) {
            rhinoException.interpreterStackInfo = null;
            rhinoException.interpreterLineData = null;
            return;
        }
        if (context.previousInterpreterInvocations == null || context.previousInterpreterInvocations.size() == 0) {
            objectArray = new CallFrame[1];
        } else {
            n = context.previousInterpreterInvocations.size();
            if (context.previousInterpreterInvocations.peek() == context.lastInterpreterFrame) {
                --n;
            }
            objectArray = new CallFrame[n + 1];
            context.previousInterpreterInvocations.toArray(objectArray);
        }
        objectArray[objectArray.length - 1] = (CallFrame)context.lastInterpreterFrame;
        n = 0;
        for (int i = 0; i != objectArray.length; ++i) {
            n += 1 + ((CallFrame)objectArray[i]).frameIndex;
        }
        int[] nArray = new int[n];
        int n2 = n;
        int n3 = objectArray.length;
        while (n3 != 0) {
            Object object = objectArray[--n3];
            while (object != null) {
                nArray[--n2] = ((CallFrame)object).pcSourceLineStart;
                object = ((CallFrame)object).parentFrame;
            }
        }
        if (n2 != 0) {
            Kit.codeBug();
        }
        rhinoException.interpreterStackInfo = objectArray;
        rhinoException.interpreterLineData = nArray;
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.lastInterpreterFrame;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        String string2 = "org.mozilla.javascript.Interpreter.interpretLoop";
        StringBuilder stringBuilder = new StringBuilder(string.length() + 1000);
        String string3 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            char c;
            --n;
            int n4 = string.indexOf(string2, n3);
            if (n4 < 0) break;
            n4 += string2.length();
            while (n4 != string.length() && (c = string.charAt(n4)) != '\n' && c != '\r') {
                ++n4;
            }
            stringBuilder.append(string.substring(n3, n4));
            n3 = n4;
            CallFrame callFrame = callFrameArray[n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuilder.append(string3);
                stringBuilder.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuilder.append('.');
                    stringBuilder.append(interpreterData.itsName);
                }
                stringBuilder.append('(');
                stringBuilder.append(interpreterData.itsSourceFile);
                int n5 = nArray[n2];
                if (n5 >= 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(Interpreter.getIndex(interpreterData.itsICode, n5));
                }
                stringBuilder.append(')');
                callFrame = callFrame.parentFrame;
            }
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        ScriptStackElement[][] scriptStackElementArray = this.getScriptStackElements(rhinoException);
        ArrayList<String> arrayList = new ArrayList<String>(scriptStackElementArray.length);
        String string = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement[] scriptStackElementArray2 : scriptStackElementArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ScriptStackElement scriptStackElement : scriptStackElementArray2) {
                scriptStackElement.renderJavaStyle(stringBuilder);
                stringBuilder.append(string);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public ScriptStackElement[][] getScriptStackElements(RhinoException rhinoException) {
        if (rhinoException.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<ScriptStackElement[]> arrayList = new ArrayList<ScriptStackElement[]>();
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        while (n != 0) {
            CallFrame callFrame = callFrameArray[--n];
            ArrayList<ScriptStackElement> arrayList2 = new ArrayList<ScriptStackElement>();
            while (callFrame != null) {
                int n3;
                if (n2 == 0) {
                    Kit.codeBug();
                }
                InterpreterData interpreterData = callFrame.idata;
                String string = interpreterData.itsSourceFile;
                String string2 = null;
                int n4 = -1;
                if ((n3 = nArray[--n2]) >= 0) {
                    n4 = Interpreter.getIndex(interpreterData.itsICode, n3);
                }
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    string2 = interpreterData.itsName;
                }
                callFrame = callFrame.parentFrame;
                arrayList2.add(new ScriptStackElement(string, string2, n4));
            }
            arrayList.add(arrayList2.toArray(new ScriptStackElement[arrayList2.size()]));
        }
        return (ScriptStackElement[][])arrayList.toArray((T[])new ScriptStackElement[arrayList.size()][]);
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object2 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object2;
            }
            finally {
                context.interpreterSecurityDomain = object;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        callFrame.isContinuationsTopFrame = context.isContinuationsTopCall;
        context.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(context, callFrame, null);
    }

    public static Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        CallFrame callFrame = (CallFrame)object;
        GeneratorState generatorState = new GeneratorState(n, object2);
        if (n == 2) {
            try {
                return Interpreter.interpretLoop(context, callFrame, generatorState);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException != object2) {
                    throw runtimeException;
                }
                return Undefined.instance;
            }
        }
        Object object3 = Interpreter.interpretLoop(context, callFrame, generatorState);
        if (generatorState.returnedException != null) {
            throw generatorState.returnedException;
        }
        return object3;
    }

    public static Object restartContinuation(NativeContinuation nativeContinuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(nativeContinuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)nativeContinuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(nativeContinuation, null);
        continuationJump.result = object;
        return Interpreter.interpretLoop(context, null, continuationJump);
    }

    private static Object interpretLoop(Context context, CallFrame object, Object object2) {
        double d;
        Object object3;
        UniqueTag uniqueTag;
        block229: {
            Object object4;
            uniqueTag = UniqueTag.DOUBLE_MARK;
            Object object5 = Undefined.instance;
            boolean bl = context.instructionThreshold != 0;
            int n = 100;
            int n2 = 100;
            String string = null;
            int n3 = -1;
            if (context.lastInterpreterFrame != null) {
                if (context.previousInterpreterInvocations == null) {
                    context.previousInterpreterInvocations = new ObjArray();
                }
                context.previousInterpreterInvocations.push(context.lastInterpreterFrame);
            }
            GeneratorState generatorState = null;
            if (object2 != null) {
                if (object2 instanceof GeneratorState) {
                    generatorState = (GeneratorState)object2;
                    Interpreter.enterFrame(context, (CallFrame)object, ScriptRuntime.emptyArgs, true);
                    object2 = null;
                } else if (!(object2 instanceof ContinuationJump)) {
                    Kit.codeBug();
                }
            }
            object3 = null;
            d = 0.0;
            block130: while (true) {
                block230: {
                    int n4;
                    Object object6;
                    block228: {
                        try {
                            block131: while (true) {
                                if (object2 != null) {
                                    object = Interpreter.processThrowable(context, object2, (CallFrame)object, n3, bl);
                                    object2 = ((CallFrame)object).throwable;
                                    ((CallFrame)object).throwable = null;
                                } else if (generatorState == null && ((CallFrame)object).frozen) {
                                    Kit.codeBug();
                                }
                                Object[] objectArray = ((CallFrame)object).stack;
                                double[] dArray = ((CallFrame)object).sDbl;
                                Object[] objectArray2 = ((CallFrame)object).varSource.stack;
                                double[] dArray2 = ((CallFrame)object).varSource.sDbl;
                                object4 = ((CallFrame)object).varSource.stackAttributes;
                                object6 = ((CallFrame)object).idata.itsICode;
                                String[] stringArray = ((CallFrame)object).idata.itsStringTable;
                                int n5 = ((CallFrame)object).savedStackTop;
                                context.lastInterpreterFrame = object;
                                block132: while (true) {
                                    int n6;
                                    int n7 = object6[((CallFrame)object).pc++];
                                    switch (n7) {
                                        case -62: {
                                            if (!((CallFrame)object).frozen) {
                                                --((CallFrame)object).pc;
                                                CallFrame callFrame = Interpreter.captureFrameForGenerator((CallFrame)object);
                                                callFrame.frozen = true;
                                                NativeGenerator nativeGenerator = new NativeGenerator(((CallFrame)object).scope, callFrame.fnOrScript, callFrame);
                                                ((CallFrame)object).result = nativeGenerator;
                                                break block132;
                                            }
                                        }
                                        case 72: {
                                            if (!((CallFrame)object).frozen) {
                                                return Interpreter.freezeGenerator(context, (CallFrame)object, n5, generatorState);
                                            }
                                            Object object7 = Interpreter.thawGenerator((CallFrame)object, n5, generatorState, n7);
                                            if (object7 == Scriptable.NOT_FOUND) continue block132;
                                            object2 = object7;
                                            break block228;
                                        }
                                        case -63: {
                                            ((CallFrame)object).frozen = true;
                                            int n8 = Interpreter.getIndex(object6, ((CallFrame)object).pc);
                                            generatorState.returnedException = new JavaScriptException(NativeIterator.getStopIterationObject(((CallFrame)object).scope), ((CallFrame)object).idata.itsSourceFile, n8);
                                            break block132;
                                        }
                                        case 50: {
                                            Object object8 = objectArray[n5];
                                            if (object8 == uniqueTag) {
                                                object8 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            --n5;
                                            int n9 = Interpreter.getIndex(object6, ((CallFrame)object).pc);
                                            object2 = new JavaScriptException(object8, ((CallFrame)object).idata.itsSourceFile, n9);
                                            break block228;
                                        }
                                        case 51: {
                                            object2 = objectArray[n3 += ((CallFrame)object).localShift];
                                            break block228;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            n5 = Interpreter.doCompare((CallFrame)object, n7, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 52: 
                                        case 53: {
                                            n5 = Interpreter.doInOrInstanceof(context, n7, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 12: 
                                        case 13: {
                                            boolean bl2 = Interpreter.doEquals(objectArray, dArray, --n5);
                                            objectArray[n5] = ScriptRuntime.wrapBoolean(bl2 ^= n7 == 13);
                                            continue block132;
                                        }
                                        case 46: 
                                        case 47: {
                                            boolean bl3 = Interpreter.doShallowEquals(objectArray, dArray, --n5);
                                            objectArray[n5] = ScriptRuntime.wrapBoolean(bl3 ^= n7 == 47);
                                            continue block132;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean((CallFrame)object, n5--)) break;
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean((CallFrame)object, n5--)) break;
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean((CallFrame)object, n5--)) {
                                                ((CallFrame)object).pc += 2;
                                                continue block132;
                                            }
                                            objectArray[n5--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = ((CallFrame)object).pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (n5 == ((CallFrame)object).emptyStackTop + 1) {
                                                objectArray[n3 += ((CallFrame)object).localShift] = objectArray[n5];
                                                dArray[n3] = dArray[n5];
                                                --n5;
                                                continue block132;
                                            }
                                            if (n5 == ((CallFrame)object).emptyStackTop) continue block132;
                                            Kit.codeBug();
                                            continue block132;
                                        }
                                        case -25: {
                                            Object object9;
                                            if (bl) {
                                                Interpreter.addInstructionCount(context, (CallFrame)object, 0);
                                            }
                                            if ((object9 = objectArray[n3 += ((CallFrame)object).localShift]) != uniqueTag) {
                                                object2 = object9;
                                                break block228;
                                            }
                                            ((CallFrame)object).pc = (int)dArray[n3];
                                            if (!bl) continue block132;
                                            ((CallFrame)object).pcPrevBranch = ((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case -4: {
                                            objectArray[n5] = null;
                                            --n5;
                                            continue block132;
                                        }
                                        case -5: {
                                            ((CallFrame)object).result = objectArray[n5];
                                            ((CallFrame)object).resultDbl = dArray[n5];
                                            objectArray[n5] = null;
                                            --n5;
                                            continue block132;
                                        }
                                        case -1: {
                                            objectArray[n5 + 1] = objectArray[n5];
                                            dArray[n5 + 1] = dArray[n5];
                                            ++n5;
                                            continue block132;
                                        }
                                        case -2: {
                                            objectArray[n5 + 1] = objectArray[n5 - 1];
                                            dArray[n5 + 1] = dArray[n5 - 1];
                                            objectArray[n5 + 2] = objectArray[n5];
                                            dArray[n5 + 2] = dArray[n5];
                                            n5 += 2;
                                            continue block132;
                                        }
                                        case -3: {
                                            Object object10 = objectArray[n5];
                                            objectArray[n5] = objectArray[n5 - 1];
                                            objectArray[n5 - 1] = object10;
                                            double d2 = dArray[n5];
                                            dArray[n5] = dArray[n5 - 1];
                                            dArray[n5 - 1] = d2;
                                            continue block132;
                                        }
                                        case 4: {
                                            ((CallFrame)object).result = objectArray[n5];
                                            ((CallFrame)object).resultDbl = dArray[n5];
                                            --n5;
                                            break block132;
                                        }
                                        case 64: {
                                            break block132;
                                        }
                                        case -22: {
                                            ((CallFrame)object).result = object5;
                                            break block132;
                                        }
                                        case 27: {
                                            int n10 = Interpreter.stack_int32((CallFrame)object, n5);
                                            objectArray[n5] = uniqueTag;
                                            dArray[n5] = ~n10;
                                            continue block132;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            n5 = Interpreter.doBitOp((CallFrame)object, n7, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 20: {
                                            double d3 = Interpreter.stack_double((CallFrame)object, n5 - 1);
                                            int n11 = Interpreter.stack_int32((CallFrame)object, n5) & 0x1F;
                                            objectArray[--n5] = uniqueTag;
                                            dArray[n5] = ScriptRuntime.toUint32(d3) >>> n11;
                                            continue block132;
                                        }
                                        case 28: 
                                        case 29: {
                                            double d4 = Interpreter.stack_double((CallFrame)object, n5);
                                            objectArray[n5] = uniqueTag;
                                            if (n7 == 29) {
                                                d4 = -d4;
                                            }
                                            dArray[n5] = d4;
                                            continue block132;
                                        }
                                        case 21: {
                                            Interpreter.doAdd(objectArray, dArray, --n5, context);
                                            continue block132;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            n5 = Interpreter.doArithmetic((CallFrame)object, n7, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 26: {
                                            objectArray[n5] = ScriptRuntime.wrapBoolean(!Interpreter.stack_boolean((CallFrame)object, n5));
                                            continue block132;
                                        }
                                        case 49: {
                                            objectArray[++n5] = ScriptRuntime.bind(context, ((CallFrame)object).scope, string);
                                            continue block132;
                                        }
                                        case 8: 
                                        case 73: {
                                            Object object11 = objectArray[n5];
                                            if (object11 == uniqueTag) {
                                                object11 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            Scriptable scriptable = (Scriptable)objectArray[--n5];
                                            objectArray[n5] = n7 == 8 ? ScriptRuntime.setName(scriptable, object11, context, ((CallFrame)object).scope, string) : ScriptRuntime.strictSetName(scriptable, object11, context, ((CallFrame)object).scope, string);
                                            continue block132;
                                        }
                                        case -59: {
                                            Object object12 = objectArray[n5];
                                            if (object12 == uniqueTag) {
                                                object12 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            Scriptable scriptable = (Scriptable)objectArray[--n5];
                                            objectArray[n5] = ScriptRuntime.setConst(scriptable, object12, context, string);
                                            continue block132;
                                        }
                                        case 0: 
                                        case 31: {
                                            n5 = Interpreter.doDelName(context, (CallFrame)object, n7, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 34: {
                                            Object object13 = objectArray[n5];
                                            if (object13 == uniqueTag) {
                                                object13 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.getObjectPropNoWarn(object13, string, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 33: {
                                            Object object14 = objectArray[n5];
                                            if (object14 == uniqueTag) {
                                                object14 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.getObjectProp(object14, string, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 35: {
                                            Object object15;
                                            Object object16 = objectArray[n5];
                                            if (object16 == uniqueTag) {
                                                object16 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            if ((object15 = objectArray[--n5]) == uniqueTag) {
                                                object15 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.setObjectProp(object15, string, object16, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case -9: {
                                            Object object17 = objectArray[n5];
                                            if (object17 == uniqueTag) {
                                                object17 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.propIncrDecr(object17, string, context, ((CallFrame)object).scope, object6[((CallFrame)object).pc]);
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case 36: {
                                            n5 = Interpreter.doGetElem(context, (CallFrame)object, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 37: {
                                            n5 = Interpreter.doSetElem(context, (CallFrame)object, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case -10: {
                                            n5 = Interpreter.doElemIncDec(context, (CallFrame)object, object6, objectArray, dArray, n5);
                                            continue block132;
                                        }
                                        case 67: {
                                            Ref ref = (Ref)objectArray[n5];
                                            objectArray[n5] = ScriptRuntime.refGet(ref, context);
                                            continue block132;
                                        }
                                        case 68: {
                                            Object object18 = objectArray[n5];
                                            if (object18 == uniqueTag) {
                                                object18 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            Ref ref = (Ref)objectArray[--n5];
                                            objectArray[n5] = ScriptRuntime.refSet(ref, object18, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 69: {
                                            Ref ref = (Ref)objectArray[n5];
                                            objectArray[n5] = ScriptRuntime.refDel(ref, context);
                                            continue block132;
                                        }
                                        case -11: {
                                            Ref ref = (Ref)objectArray[n5];
                                            objectArray[n5] = ScriptRuntime.refIncrDecr(ref, context, ((CallFrame)object).scope, object6[((CallFrame)object).pc]);
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case 54: {
                                            objectArray[++n5] = objectArray[n3 += ((CallFrame)object).localShift];
                                            dArray[n5] = dArray[n3];
                                            continue block132;
                                        }
                                        case -56: {
                                            objectArray[n3 += ((CallFrame)object).localShift] = null;
                                            continue block132;
                                        }
                                        case -15: {
                                            objectArray[++n5] = ScriptRuntime.getNameFunctionAndThis(string, context, ((CallFrame)object).scope);
                                            objectArray[++n5] = ScriptRuntime.lastStoredScriptable(context);
                                            continue block132;
                                        }
                                        case -16: {
                                            Object object19 = objectArray[n5];
                                            if (object19 == uniqueTag) {
                                                object19 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.getPropFunctionAndThis(object19, string, context, ((CallFrame)object).scope);
                                            objectArray[++n5] = ScriptRuntime.lastStoredScriptable(context);
                                            continue block132;
                                        }
                                        case -17: {
                                            Object object20;
                                            Object object21 = objectArray[n5 - 1];
                                            if (object21 == uniqueTag) {
                                                object21 = ScriptRuntime.wrapNumber(dArray[n5 - 1]);
                                            }
                                            if ((object20 = objectArray[n5]) == uniqueTag) {
                                                object20 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5 - 1] = ScriptRuntime.getElemFunctionAndThis(object21, object20, context, ((CallFrame)object).scope);
                                            objectArray[n5] = ScriptRuntime.lastStoredScriptable(context);
                                            continue block132;
                                        }
                                        case -18: {
                                            Object object22 = objectArray[n5];
                                            if (object22 == uniqueTag) {
                                                object22 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.getValueFunctionAndThis(object22, context);
                                            objectArray[++n5] = ScriptRuntime.lastStoredScriptable(context);
                                            continue block132;
                                        }
                                        case -21: {
                                            if (bl) {
                                                context.instructionCount += 100;
                                            }
                                            n5 = Interpreter.doCallSpecial(context, (CallFrame)object, objectArray, dArray, n5, object6, n3);
                                            continue block132;
                                        }
                                        case -55: 
                                        case 38: 
                                        case 70: {
                                            Serializable serializable;
                                            Object object23;
                                            Object object24;
                                            if (bl) {
                                                context.instructionCount += 100;
                                            }
                                            Callable callable = (Callable)objectArray[n5 -= 1 + n3];
                                            Scriptable scriptable = (Scriptable)objectArray[n5 + 1];
                                            if (n7 == 70) {
                                                Object[] objectArray3 = Interpreter.getArgsArray(objectArray, dArray, n5 + 2, n3);
                                                objectArray[n5] = ScriptRuntime.callRef(callable, scriptable, objectArray3, context);
                                                continue block132;
                                            }
                                            Scriptable scriptable2 = ((CallFrame)object).scope;
                                            if (((CallFrame)object).useActivation) {
                                                scriptable2 = ScriptableObject.getTopLevelScope(((CallFrame)object).scope);
                                            }
                                            if (callable instanceof InterpretedFunction) {
                                                object24 = (InterpretedFunction)callable;
                                                if (((CallFrame)object).fnOrScript.securityDomain == ((InterpretedFunction)object24).securityDomain) {
                                                    object23 = object;
                                                    serializable = new CallFrame();
                                                    if (n7 == -55) {
                                                        object23 = ((CallFrame)object).parentFrame;
                                                        Interpreter.exitFrame(context, (CallFrame)object, null);
                                                    }
                                                    Interpreter.initFrame(context, scriptable2, scriptable, objectArray, dArray, n5 + 2, n3, (InterpretedFunction)object24, (CallFrame)object23, serializable);
                                                    if (n7 != -55) {
                                                        ((CallFrame)object).savedStackTop = n5;
                                                        ((CallFrame)object).savedCallOp = n7;
                                                    }
                                                    object = serializable;
                                                    continue block131;
                                                }
                                            }
                                            if (callable instanceof NativeContinuation) {
                                                object24 = new ContinuationJump((NativeContinuation)callable, (CallFrame)object);
                                                if (n3 == 0) {
                                                    ((ContinuationJump)object24).result = object5;
                                                } else {
                                                    ((ContinuationJump)object24).result = objectArray[n5 + 2];
                                                    ((ContinuationJump)object24).resultDbl = dArray[n5 + 2];
                                                }
                                                object2 = object24;
                                                break block228;
                                            }
                                            if (callable instanceof IdFunctionObject) {
                                                object24 = (IdFunctionObject)callable;
                                                if (NativeContinuation.isContinuationConstructor((IdFunctionObject)object24)) {
                                                    ((CallFrame)object).stack[n5] = Interpreter.captureContinuation(context, ((CallFrame)object).parentFrame, false);
                                                    continue block132;
                                                }
                                                if (BaseFunction.isApplyOrCall((IdFunctionObject)object24) && (object23 = ScriptRuntime.getCallable(scriptable)) instanceof InterpretedFunction) {
                                                    serializable = (InterpretedFunction)object23;
                                                    if (((CallFrame)object).fnOrScript.securityDomain == ((InterpretedFunction)serializable).securityDomain) {
                                                        object = Interpreter.initFrameForApplyOrCall(context, (CallFrame)object, n3, objectArray, dArray, n5, n7, scriptable2, (IdFunctionObject)object24, (InterpretedFunction)serializable);
                                                        continue block131;
                                                    }
                                                }
                                            }
                                            if (callable instanceof ScriptRuntime.NoSuchMethodShim) {
                                                object24 = (ScriptRuntime.NoSuchMethodShim)callable;
                                                object23 = ((ScriptRuntime.NoSuchMethodShim)object24).noSuchMethodMethod;
                                                if (object23 instanceof InterpretedFunction) {
                                                    serializable = (InterpretedFunction)object23;
                                                    if (((CallFrame)object).fnOrScript.securityDomain == ((InterpretedFunction)serializable).securityDomain) {
                                                        object = Interpreter.initFrameForNoSuchMethod(context, (CallFrame)object, n3, objectArray, dArray, n5, n7, scriptable, scriptable2, (ScriptRuntime.NoSuchMethodShim)object24, (InterpretedFunction)serializable);
                                                        continue block131;
                                                    }
                                                }
                                            }
                                            context.lastInterpreterFrame = object;
                                            ((CallFrame)object).savedCallOp = n7;
                                            ((CallFrame)object).savedStackTop = n5;
                                            objectArray[n5] = callable.call(context, scriptable2, scriptable, Interpreter.getArgsArray(objectArray, dArray, n5 + 2, n3));
                                            continue block132;
                                        }
                                        case 30: {
                                            IdFunctionObject idFunctionObject;
                                            Object object25;
                                            Object object24;
                                            if (bl) {
                                                context.instructionCount += 100;
                                            }
                                            if ((object25 = objectArray[n5 -= n3]) instanceof InterpretedFunction) {
                                                InterpretedFunction interpretedFunction = (InterpretedFunction)object25;
                                                if (((CallFrame)object).fnOrScript.securityDomain == interpretedFunction.securityDomain) {
                                                    Scriptable scriptable = interpretedFunction.createObject(context, ((CallFrame)object).scope);
                                                    object24 = new CallFrame();
                                                    Interpreter.initFrame(context, ((CallFrame)object).scope, scriptable, objectArray, dArray, n5 + 1, n3, interpretedFunction, (CallFrame)object, (CallFrame)object24);
                                                    objectArray[n5] = scriptable;
                                                    ((CallFrame)object).savedStackTop = n5;
                                                    ((CallFrame)object).savedCallOp = n7;
                                                    object = object24;
                                                    continue block131;
                                                }
                                            }
                                            if (!(object25 instanceof Function)) {
                                                if (object25 == uniqueTag) {
                                                    object25 = ScriptRuntime.wrapNumber(dArray[n5]);
                                                }
                                                throw ScriptRuntime.notFunctionError(object25);
                                            }
                                            Function function = (Function)object25;
                                            if (function instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor(idFunctionObject = (IdFunctionObject)function)) {
                                                ((CallFrame)object).stack[n5] = Interpreter.captureContinuation(context, ((CallFrame)object).parentFrame, false);
                                                continue block132;
                                            }
                                            Object[] objectArray4 = Interpreter.getArgsArray(objectArray, dArray, n5 + 1, n3);
                                            objectArray[n5] = function.construct(context, ((CallFrame)object).scope, objectArray4);
                                            continue block132;
                                        }
                                        case 32: {
                                            Object object26 = objectArray[n5];
                                            if (object26 == uniqueTag) {
                                                object26 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.typeof(object26);
                                            continue block132;
                                        }
                                        case -14: {
                                            objectArray[++n5] = ScriptRuntime.typeofName(((CallFrame)object).scope, string);
                                            continue block132;
                                        }
                                        case 41: {
                                            objectArray[++n5] = string;
                                            continue block132;
                                        }
                                        case -27: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = Interpreter.getShort(object6, ((CallFrame)object).pc);
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case -28: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = Interpreter.getInt(object6, ((CallFrame)object).pc);
                                            ((CallFrame)object).pc += 4;
                                            continue block132;
                                        }
                                        case 40: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = ((CallFrame)object).idata.itsDoubleTable[n3];
                                            continue block132;
                                        }
                                        case 39: {
                                            objectArray[++n5] = ScriptRuntime.name(context, ((CallFrame)object).scope, string);
                                            continue block132;
                                        }
                                        case -8: {
                                            objectArray[++n5] = ScriptRuntime.nameIncrDecr(((CallFrame)object).scope, string, context, object6[((CallFrame)object).pc]);
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case -61: {
                                            n3 = object6[((CallFrame)object).pc++];
                                        }
                                        case 156: {
                                            n5 = Interpreter.doSetConstVar((CallFrame)object, objectArray, dArray, n5, objectArray2, dArray2, object4, n3);
                                            continue block132;
                                        }
                                        case -49: {
                                            n3 = object6[((CallFrame)object).pc++];
                                        }
                                        case 56: {
                                            n5 = Interpreter.doSetVar((CallFrame)object, objectArray, dArray, n5, objectArray2, dArray2, object4, n3);
                                            continue block132;
                                        }
                                        case -48: {
                                            n3 = object6[((CallFrame)object).pc++];
                                        }
                                        case 55: {
                                            n5 = Interpreter.doGetVar((CallFrame)object, objectArray, dArray, n5, objectArray2, dArray2, n3);
                                            continue block132;
                                        }
                                        case -7: {
                                            n5 = Interpreter.doVarIncDec(context, (CallFrame)object, objectArray, dArray, n5, objectArray2, dArray2, object4, n3);
                                            continue block132;
                                        }
                                        case -51: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = 0.0;
                                            continue block132;
                                        }
                                        case -52: {
                                            objectArray[++n5] = uniqueTag;
                                            dArray[n5] = 1.0;
                                            continue block132;
                                        }
                                        case 42: {
                                            objectArray[++n5] = null;
                                            continue block132;
                                        }
                                        case 43: {
                                            objectArray[++n5] = ((CallFrame)object).thisObj;
                                            continue block132;
                                        }
                                        case 63: {
                                            objectArray[++n5] = ((CallFrame)object).fnOrScript;
                                            continue block132;
                                        }
                                        case 44: {
                                            objectArray[++n5] = Boolean.FALSE;
                                            continue block132;
                                        }
                                        case 45: {
                                            objectArray[++n5] = Boolean.TRUE;
                                            continue block132;
                                        }
                                        case -50: {
                                            objectArray[++n5] = object5;
                                            continue block132;
                                        }
                                        case 2: {
                                            Object object27 = objectArray[n5];
                                            if (object27 == uniqueTag) {
                                                object27 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            --n5;
                                            ((CallFrame)object).scope = ScriptRuntime.enterWith(object27, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 3: {
                                            ((CallFrame)object).scope = ScriptRuntime.leaveWith(((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 57: {
                                            boolean bl4 = ((CallFrame)object).idata.itsICode[((CallFrame)object).pc] != 0;
                                            Throwable throwable = (Throwable)objectArray[--n5 + 1];
                                            Scriptable scriptable = !bl4 ? null : (Scriptable)objectArray[n3 += ((CallFrame)object).localShift];
                                            objectArray[n3] = ScriptRuntime.newCatchScope(throwable, scriptable, string, context, ((CallFrame)object).scope);
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case 58: 
                                        case 59: 
                                        case 60: {
                                            Object object28 = objectArray[n5];
                                            if (object28 == uniqueTag) {
                                                object28 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            --n5;
                                            int n12 = n7 == 58 ? 0 : (n7 == 59 ? 1 : 2);
                                            objectArray[n3 += ((CallFrame)object).localShift] = ScriptRuntime.enumInit(object28, context, ((CallFrame)object).scope, n12);
                                            continue block132;
                                        }
                                        case 61: 
                                        case 62: {
                                            Object object29 = objectArray[n3 += ((CallFrame)object).localShift];
                                            objectArray[++n5] = n7 == 61 ? ScriptRuntime.enumNext(object29) : ScriptRuntime.enumId(object29, context);
                                            continue block132;
                                        }
                                        case 71: {
                                            Object object30 = objectArray[n5];
                                            if (object30 == uniqueTag) {
                                                object30 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.specialRef(object30, string, context, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case 77: {
                                            n5 = Interpreter.doRefMember(context, objectArray, dArray, n5, n3);
                                            continue block132;
                                        }
                                        case 78: {
                                            n5 = Interpreter.doRefNsMember(context, objectArray, dArray, n5, n3);
                                            continue block132;
                                        }
                                        case 79: {
                                            Object object31 = objectArray[n5];
                                            if (object31 == uniqueTag) {
                                                object31 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.nameRef(object31, context, ((CallFrame)object).scope, n3);
                                            continue block132;
                                        }
                                        case 80: {
                                            n5 = Interpreter.doRefNsName(context, (CallFrame)object, objectArray, dArray, n5, n3);
                                            continue block132;
                                        }
                                        case -12: {
                                            ((CallFrame)object).scope = (Scriptable)objectArray[n3 += ((CallFrame)object).localShift];
                                            continue block132;
                                        }
                                        case -13: {
                                            objectArray[n3 += ((CallFrame)object).localShift] = ((CallFrame)object).scope;
                                            continue block132;
                                        }
                                        case -19: {
                                            objectArray[++n5] = InterpretedFunction.createFunction(context, ((CallFrame)object).scope, ((CallFrame)object).fnOrScript, n3);
                                            continue block132;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(context, ((CallFrame)object).scope, ((CallFrame)object).fnOrScript, n3);
                                            continue block132;
                                        }
                                        case 48: {
                                            Object object32 = ((CallFrame)object).idata.itsRegExpLiterals[n3];
                                            objectArray[++n5] = ScriptRuntime.wrapRegExp(context, ((CallFrame)object).scope, object32);
                                            continue block132;
                                        }
                                        case -29: {
                                            objectArray[++n5] = new int[n3];
                                            objectArray[++n5] = new Object[n3];
                                            dArray[n5] = 0.0;
                                            continue block132;
                                        }
                                        case -30: {
                                            Object object33 = objectArray[n5];
                                            if (object33 == uniqueTag) {
                                                object33 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            int n13 = (int)dArray[--n5];
                                            ((Object[])objectArray[n5])[n13] = object33;
                                            dArray[n5] = n13 + 1;
                                            continue block132;
                                        }
                                        case -57: {
                                            Object object34 = objectArray[n5];
                                            int n14 = (int)dArray[--n5];
                                            ((Object[])objectArray[n5])[n14] = object34;
                                            ((int[])objectArray[n5 - 1])[n14] = -1;
                                            dArray[n5] = n14 + 1;
                                            continue block132;
                                        }
                                        case -58: {
                                            Object object35 = objectArray[n5];
                                            int n15 = (int)dArray[--n5];
                                            ((Object[])objectArray[n5])[n15] = object35;
                                            ((int[])objectArray[n5 - 1])[n15] = 1;
                                            dArray[n5] = n15 + 1;
                                            continue block132;
                                        }
                                        case -31: 
                                        case 65: 
                                        case 66: {
                                            Object object23;
                                            Object object24;
                                            Object[] objectArray5 = (Object[])objectArray[n5];
                                            int[] nArray = (int[])objectArray[--n5];
                                            if (n7 == 66) {
                                                object23 = (Object[])((CallFrame)object).idata.literalIds[n3];
                                                object24 = ScriptRuntime.newObjectLiteral(object23, objectArray5, nArray, context, ((CallFrame)object).scope);
                                            } else {
                                                object23 = null;
                                                if (n7 == -31) {
                                                    object23 = (int[])((CallFrame)object).idata.literalIds[n3];
                                                }
                                                object24 = ScriptRuntime.newArrayLiteral(objectArray5, (int[])object23, context, ((CallFrame)object).scope);
                                            }
                                            objectArray[n5] = object24;
                                            continue block132;
                                        }
                                        case -53: {
                                            Object object36 = objectArray[n5];
                                            if (object36 == uniqueTag) {
                                                object36 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            --n5;
                                            ((CallFrame)object).scope = ScriptRuntime.enterDotQuery(object36, ((CallFrame)object).scope);
                                            continue block132;
                                        }
                                        case -54: {
                                            boolean bl5 = Interpreter.stack_boolean((CallFrame)object, n5);
                                            Object object37 = ScriptRuntime.updateDotQuery(bl5, ((CallFrame)object).scope);
                                            if (object37 != null) {
                                                objectArray[n5] = object37;
                                                ((CallFrame)object).scope = ScriptRuntime.leaveDotQuery(((CallFrame)object).scope);
                                                ((CallFrame)object).pc += 2;
                                                continue block132;
                                            }
                                            --n5;
                                            break;
                                        }
                                        case 74: {
                                            Object object38 = objectArray[n5];
                                            if (object38 == uniqueTag) {
                                                object38 = ScriptRuntime.wrapNumber(dArray[n5]);
                                            }
                                            objectArray[n5] = ScriptRuntime.setDefaultNamespace(object38, context);
                                            continue block132;
                                        }
                                        case 75: {
                                            Object object39 = objectArray[n5];
                                            if (object39 == uniqueTag) continue block132;
                                            objectArray[n5] = ScriptRuntime.escapeAttributeValue(object39, context);
                                            continue block132;
                                        }
                                        case 76: {
                                            Object object40 = objectArray[n5];
                                            if (object40 == uniqueTag) continue block132;
                                            objectArray[n5] = ScriptRuntime.escapeTextValue(object40, context);
                                            continue block132;
                                        }
                                        case -64: {
                                            if (((CallFrame)object).debuggerFrame == null) continue block132;
                                            ((CallFrame)object).debuggerFrame.onDebuggerStatement(context);
                                            continue block132;
                                        }
                                        case -26: {
                                            ((CallFrame)object).pcSourceLineStart = ((CallFrame)object).pc;
                                            if (((CallFrame)object).debuggerFrame != null) {
                                                int n16 = Interpreter.getIndex(object6, ((CallFrame)object).pc);
                                                ((CallFrame)object).debuggerFrame.onLineChange(context, n16);
                                            }
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case -32: {
                                            n3 = 0;
                                            continue block132;
                                        }
                                        case -33: {
                                            n3 = 1;
                                            continue block132;
                                        }
                                        case -34: {
                                            n3 = 2;
                                            continue block132;
                                        }
                                        case -35: {
                                            n3 = 3;
                                            continue block132;
                                        }
                                        case -36: {
                                            n3 = 4;
                                            continue block132;
                                        }
                                        case -37: {
                                            n3 = 5;
                                            continue block132;
                                        }
                                        case -38: {
                                            n3 = 0xFF & object6[((CallFrame)object).pc];
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case -39: {
                                            n3 = Interpreter.getIndex(object6, ((CallFrame)object).pc);
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case -40: {
                                            n3 = Interpreter.getInt(object6, ((CallFrame)object).pc);
                                            ((CallFrame)object).pc += 4;
                                            continue block132;
                                        }
                                        case -41: {
                                            string = stringArray[0];
                                            continue block132;
                                        }
                                        case -42: {
                                            string = stringArray[1];
                                            continue block132;
                                        }
                                        case -43: {
                                            string = stringArray[2];
                                            continue block132;
                                        }
                                        case -44: {
                                            string = stringArray[3];
                                            continue block132;
                                        }
                                        case -45: {
                                            string = stringArray[0xFF & object6[((CallFrame)object).pc]];
                                            ++((CallFrame)object).pc;
                                            continue block132;
                                        }
                                        case -46: {
                                            string = stringArray[Interpreter.getIndex(object6, ((CallFrame)object).pc)];
                                            ((CallFrame)object).pc += 2;
                                            continue block132;
                                        }
                                        case -47: {
                                            string = stringArray[Interpreter.getInt(object6, ((CallFrame)object).pc)];
                                            ((CallFrame)object).pc += 4;
                                            continue block132;
                                        }
                                        default: {
                                            Interpreter.dumpICode(((CallFrame)object).idata);
                                            throw new RuntimeException("Unknown icode : " + n7 + " @ pc : " + (((CallFrame)object).pc - 1));
                                        }
                                    }
                                    if (bl) {
                                        Interpreter.addInstructionCount(context, (CallFrame)object, 2);
                                    }
                                    ((CallFrame)object).pc = (n6 = Interpreter.getShort(object6, ((CallFrame)object).pc)) != 0 ? (((CallFrame)object).pc += n6 - 1) : ((CallFrame)object).idata.longJumps.getExistingInt(((CallFrame)object).pc);
                                    if (!bl) continue;
                                    ((CallFrame)object).pcPrevBranch = ((CallFrame)object).pc;
                                }
                                Interpreter.exitFrame(context, (CallFrame)object, null);
                                object3 = ((CallFrame)object).result;
                                d = ((CallFrame)object).resultDbl;
                                if (((CallFrame)object).parentFrame != null) {
                                    object = ((CallFrame)object).parentFrame;
                                    if (((CallFrame)object).frozen) {
                                        object = ((CallFrame)object).cloneFrozen();
                                    }
                                    Interpreter.setCallResult((CallFrame)object, object3, d);
                                    object3 = null;
                                    continue;
                                }
                                break block229;
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            if (object2 != null) {
                                throwable.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            object2 = throwable;
                        }
                    }
                    if (object2 == null) {
                        Kit.codeBug();
                    }
                    int n17 = 2;
                    boolean bl6 = true;
                    boolean bl7 = false;
                    object4 = null;
                    if (generatorState != null && generatorState.operation == 2 && object2 == generatorState.value) {
                        n4 = 1;
                    } else if (object2 instanceof JavaScriptException) {
                        n4 = 2;
                    } else if (object2 instanceof EcmaError) {
                        n4 = 2;
                    } else if (object2 instanceof EvaluatorException) {
                        n4 = 2;
                    } else if (object2 instanceof ContinuationPending) {
                        n4 = 0;
                    } else if (object2 instanceof RuntimeException) {
                        n4 = context.hasFeature(13) ? 2 : 1;
                    } else if (object2 instanceof Error) {
                        n4 = context.hasFeature(13) ? 2 : 0;
                    } else if (object2 instanceof ContinuationJump) {
                        n4 = 1;
                        object4 = (ContinuationJump)object2;
                    } else {
                        int n18 = n4 = context.hasFeature(13) ? 2 : 1;
                    }
                    if (bl) {
                        try {
                            Interpreter.addInstructionCount(context, (CallFrame)object, 100);
                        }
                        catch (RuntimeException runtimeException) {
                            object2 = runtimeException;
                            n4 = 1;
                        }
                        catch (Error error) {
                            object2 = error;
                            object4 = null;
                            n4 = 0;
                        }
                    }
                    if (((CallFrame)object).debuggerFrame != null && object2 instanceof RuntimeException) {
                        object6 = (RuntimeException)object2;
                        try {
                            ((CallFrame)object).debuggerFrame.onExceptionThrown(context, (Throwable)object6);
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            object4 = null;
                            n4 = 0;
                        }
                    }
                    do {
                        boolean bl8;
                        if (n4 != 0 && (n3 = Interpreter.getExceptionHandler((CallFrame)object, bl8 = n4 != 2)) >= 0) continue block130;
                        Interpreter.exitFrame(context, (CallFrame)object, object2);
                        object = ((CallFrame)object).parentFrame;
                        if (object == null) break block230;
                    } while (object4 == null || object4.branchFrame != object);
                    n3 = -1;
                    continue;
                }
                if (object4 == null) break block229;
                if (object4.branchFrame != null) {
                    Kit.codeBug();
                }
                if (object4.capturedFrame == null) break;
                n3 = -1;
            }
            object3 = object4.result;
            d = object4.resultDbl;
            object2 = null;
        }
        if (context.previousInterpreterInvocations != null && context.previousInterpreterInvocations.size() != 0) {
            context.lastInterpreterFrame = context.previousInterpreterInvocations.pop();
        } else {
            context.lastInterpreterFrame = null;
            context.previousInterpreterInvocations = null;
        }
        if (object2 != null) {
            if (object2 instanceof RuntimeException) {
                throw (RuntimeException)object2;
            }
            throw (Error)object2;
        }
        return object3 != uniqueTag ? object3 : ScriptRuntime.wrapNumber(d);
    }

    private static int doInOrInstanceof(Context context, int n, Object[] objectArray, double[] dArray, int n2) {
        Object object;
        Object object2 = objectArray[n2];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        if ((object = objectArray[--n2]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        boolean bl = n == 52 ? ScriptRuntime.in(object, object2, context) : ScriptRuntime.instanceOf(object, object2, context);
        objectArray[n2] = ScriptRuntime.wrapBoolean(bl);
        return n2;
    }

    private static int doCompare(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        boolean bl;
        block15: {
            Object object;
            Object object2;
            block14: {
                double d;
                double d2;
                block13: {
                    block12: {
                        object2 = objectArray[--n2 + 1];
                        object = objectArray[n2];
                        if (object2 != UniqueTag.DOUBLE_MARK) break block12;
                        d2 = dArray[n2 + 1];
                        d = Interpreter.stack_double(callFrame, n2);
                        break block13;
                    }
                    if (object != UniqueTag.DOUBLE_MARK) break block14;
                    d2 = ScriptRuntime.toNumber(object2);
                    d = dArray[n2];
                }
                switch (n) {
                    case 17: {
                        bl = d >= d2;
                        break block15;
                    }
                    case 15: {
                        bl = d <= d2;
                        break block15;
                    }
                    case 16: {
                        bl = d > d2;
                        break block15;
                    }
                    case 14: {
                        bl = d < d2;
                        break block15;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
            }
            switch (n) {
                case 17: {
                    bl = ScriptRuntime.cmp_LE(object2, object);
                    break;
                }
                case 15: {
                    bl = ScriptRuntime.cmp_LE(object, object2);
                    break;
                }
                case 16: {
                    bl = ScriptRuntime.cmp_LT(object2, object);
                    break;
                }
                case 14: {
                    bl = ScriptRuntime.cmp_LT(object, object2);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
        }
        objectArray[n2] = ScriptRuntime.wrapBoolean(bl);
        return n2;
    }

    private static int doBitOp(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        int n3 = Interpreter.stack_int32(callFrame, n2 - 1);
        int n4 = Interpreter.stack_int32(callFrame, n2);
        objectArray[--n2] = UniqueTag.DOUBLE_MARK;
        switch (n) {
            case 11: {
                n3 &= n4;
                break;
            }
            case 9: {
                n3 |= n4;
                break;
            }
            case 10: {
                n3 ^= n4;
                break;
            }
            case 18: {
                n3 <<= n4;
                break;
            }
            case 19: {
                n3 >>= n4;
            }
        }
        dArray[n2] = n3;
        return n2;
    }

    private static int doDelName(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        Object object;
        Object object2 = objectArray[n2];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        if ((object = objectArray[--n2]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        objectArray[n2] = ScriptRuntime.delete(object, object2, context, callFrame.scope, n == 0);
        return n2;
    }

    private static int doGetElem(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n) {
        Object object;
        Object object2;
        Object object3;
        if ((object3 = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object2 = objectArray[n + 1]) != UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.getObjectElem(object3, object2, context, callFrame.scope);
        } else {
            double d = dArray[n + 1];
            object = ScriptRuntime.getObjectIndex(object3, d, context, callFrame.scope);
        }
        objectArray[n] = object;
        return n;
    }

    private static int doSetElem(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = objectArray[(n -= 2) + 2];
        if (object4 == UniqueTag.DOUBLE_MARK) {
            object4 = ScriptRuntime.wrapNumber(dArray[n + 2]);
        }
        if ((object3 = objectArray[n]) == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object2 = objectArray[n + 1]) != UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.setObjectElem(object3, object2, object4, context, callFrame.scope);
        } else {
            double d = dArray[n + 1];
            object = ScriptRuntime.setObjectIndex(object3, d, object4, context, callFrame.scope);
        }
        objectArray[n] = object;
        return n;
    }

    private static int doElemIncDec(Context context, CallFrame callFrame, byte[] byArray, Object[] objectArray, double[] dArray, int n) {
        Object object;
        Object object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.elemIncrDecr(object, object2, context, callFrame.scope, byArray[callFrame.pc]);
        ++callFrame.pc;
        return n;
    }

    private static int doCallSpecial(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n, byte[] byArray, int n2) {
        int n3 = byArray[callFrame.pc] & 0xFF;
        boolean bl = byArray[callFrame.pc + 1] != 0;
        int n4 = Interpreter.getIndex(byArray, callFrame.pc + 2);
        if (bl) {
            Object object = objectArray[n -= n2];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            Object[] objectArray2 = Interpreter.getArgsArray(objectArray, dArray, n + 1, n2);
            objectArray[n] = ScriptRuntime.newSpecial(context, object, objectArray2, callFrame.scope, n3);
        } else {
            Scriptable scriptable = (Scriptable)objectArray[(n -= 1 + n2) + 1];
            Callable callable = (Callable)objectArray[n];
            Object[] objectArray3 = Interpreter.getArgsArray(objectArray, dArray, n + 2, n2);
            objectArray[n] = ScriptRuntime.callSpecial(context, callable, scriptable, objectArray3, callFrame.scope, callFrame.thisObj, n3, callFrame.idata.itsSourceFile, n4);
        }
        callFrame.pc += 4;
        return n;
    }

    private static int doSetConstVar(CallFrame callFrame, Object[] objectArray, double[] dArray, int n, Object[] objectArray2, double[] dArray2, int[] nArray, int n2) {
        if (!callFrame.useActivation) {
            if ((nArray[n2] & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", callFrame.idata.argNames[n2]);
            }
            if ((nArray[n2] & 8) != 0) {
                objectArray2[n2] = objectArray[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] & 0xFFFFFFF7;
                dArray2[n2] = dArray[n];
            }
        } else {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            String string = callFrame.idata.argNames[n2];
            if (callFrame.scope instanceof ConstProperties) {
                ConstProperties constProperties = (ConstProperties)((Object)callFrame.scope);
                constProperties.putConst(string, callFrame.scope, object);
            } else {
                throw Kit.codeBug();
            }
        }
        return n;
    }

    private static int doSetVar(CallFrame callFrame, Object[] objectArray, double[] dArray, int n, Object[] objectArray2, double[] dArray2, int[] nArray, int n2) {
        if (!callFrame.useActivation) {
            if ((nArray[n2] & 1) == 0) {
                objectArray2[n2] = objectArray[n];
                dArray2[n2] = dArray[n];
            }
        } else {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            String string = callFrame.idata.argNames[n2];
            callFrame.scope.put(string, callFrame.scope, object);
        }
        return n;
    }

    private static int doGetVar(CallFrame callFrame, Object[] objectArray, double[] dArray, int n, Object[] objectArray2, double[] dArray2, int n2) {
        ++n;
        if (!callFrame.useActivation) {
            objectArray[n] = objectArray2[n2];
            dArray[n] = dArray2[n2];
        } else {
            String string = callFrame.idata.argNames[n2];
            objectArray[n] = callFrame.scope.get(string, callFrame.scope);
        }
        return n;
    }

    private static int doVarIncDec(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n, Object[] objectArray2, double[] dArray2, int[] nArray, int n2) {
        ++n;
        byte by = callFrame.idata.itsICode[callFrame.pc];
        if (!callFrame.useActivation) {
            boolean bl;
            Object object = objectArray2[n2];
            double d = object == UniqueTag.DOUBLE_MARK ? dArray2[n2] : ScriptRuntime.toNumber(object);
            double d2 = (by & 1) == 0 ? d + 1.0 : d - 1.0;
            boolean bl2 = bl = (by & 2) != 0;
            if ((nArray[n2] & 1) == 0) {
                if (object != UniqueTag.DOUBLE_MARK) {
                    objectArray2[n2] = UniqueTag.DOUBLE_MARK;
                }
                dArray2[n2] = d2;
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = bl ? d : d2;
            } else if (bl && object != UniqueTag.DOUBLE_MARK) {
                objectArray[n] = object;
            } else {
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = bl ? d : d2;
            }
        } else {
            String string = callFrame.idata.argNames[n2];
            objectArray[n] = ScriptRuntime.nameIncrDecr(callFrame.scope, string, context, by);
        }
        ++callFrame.pc;
        return n;
    }

    private static int doRefMember(Context context, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.memberRef(object, object2, context, n2);
        return n;
    }

    private static int doRefNsMember(Context context, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2;
        Object object3 = objectArray[n];
        if (object3 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object2 = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.memberRef(object, object2, object3, context, n2);
        return n;
    }

    private static int doRefNsName(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        if ((object = objectArray[--n]) == UniqueTag.DOUBLE_MARK) {
            object = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.nameRef(object, object2, context, callFrame.scope, n2);
        return n;
    }

    private static CallFrame initFrameForNoSuchMethod(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, Scriptable scriptable2, ScriptRuntime.NoSuchMethodShim noSuchMethodShim, InterpretedFunction interpretedFunction) {
        Object object;
        Object[] objectArray2 = null;
        int n4 = n2 + 2;
        Object[] objectArray3 = new Object[n];
        int n5 = 0;
        while (n5 < n) {
            object = objectArray[n4];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n4]);
            }
            objectArray3[n5] = object;
            ++n5;
            ++n4;
        }
        objectArray2 = new Object[]{noSuchMethodShim.methodName, context.newArray(scriptable2, objectArray3)};
        CallFrame callFrame2 = callFrame;
        object = new CallFrame();
        if (n3 == -55) {
            callFrame2 = callFrame.parentFrame;
            Interpreter.exitFrame(context, callFrame, null);
        }
        Interpreter.initFrame(context, scriptable2, scriptable, objectArray2, null, 0, 2, interpretedFunction, callFrame2, (CallFrame)object);
        if (n3 != -55) {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        return object;
    }

    private static boolean doEquals(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            if (object2 == UniqueTag.DOUBLE_MARK) {
                return dArray[n] == dArray[n + 1];
            }
            return ScriptRuntime.eqNumber(dArray[n + 1], object2);
        }
        if (object2 == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.eqNumber(dArray[n], object);
        }
        return ScriptRuntime.eq(object2, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean doShallowEquals(Object[] objectArray, double[] dArray, int n) {
        double d;
        double d2;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        UniqueTag uniqueTag = UniqueTag.DOUBLE_MARK;
        if (object == uniqueTag) {
            d2 = dArray[n + 1];
            if (object2 == uniqueTag) {
                d = dArray[n];
            } else {
                if (!(object2 instanceof Number)) return false;
                d = ((Number)object2).doubleValue();
            }
        } else {
            if (object2 != uniqueTag) return ScriptRuntime.shallowEq(object2, object);
            d = dArray[n];
            if (!(object instanceof Number)) return false;
            d2 = ((Number)object).doubleValue();
        }
        if (d != d2) return false;
        return true;
    }

    private static CallFrame processThrowable(Context context, Object object, CallFrame callFrame, int n, boolean bl) {
        if (n >= 0) {
            if (callFrame.frozen) {
                callFrame = callFrame.cloneFrozen();
            }
            int[] nArray = callFrame.idata.itsExceptionTable;
            callFrame.pc = nArray[n + 2];
            if (bl) {
                callFrame.pcPrevBranch = callFrame.pc;
            }
            callFrame.savedStackTop = callFrame.emptyStackTop;
            int n2 = callFrame.localShift + nArray[n + 5];
            int n3 = callFrame.localShift + nArray[n + 4];
            callFrame.scope = (Scriptable)callFrame.stack[n2];
            callFrame.stack[n3] = object;
            object = null;
        } else {
            ContinuationJump continuationJump = (ContinuationJump)object;
            object = null;
            if (continuationJump.branchFrame != callFrame) {
                Kit.codeBug();
            }
            if (continuationJump.capturedFrame == null) {
                Kit.codeBug();
            }
            int n4 = continuationJump.capturedFrame.frameIndex + 1;
            if (continuationJump.branchFrame != null) {
                n4 -= continuationJump.branchFrame.frameIndex;
            }
            int n5 = 0;
            CallFrame[] callFrameArray = null;
            CallFrame callFrame2 = continuationJump.capturedFrame;
            for (int i = 0; i != n4; ++i) {
                if (!callFrame2.frozen) {
                    Kit.codeBug();
                }
                if (Interpreter.isFrameEnterExitRequired(callFrame2)) {
                    if (callFrameArray == null) {
                        callFrameArray = new CallFrame[n4 - i];
                    }
                    callFrameArray[n5] = callFrame2;
                    ++n5;
                }
                callFrame2 = callFrame2.parentFrame;
            }
            while (n5 != 0) {
                callFrame2 = callFrameArray[--n5];
                Interpreter.enterFrame(context, callFrame2, ScriptRuntime.emptyArgs, true);
            }
            callFrame = continuationJump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult(callFrame, continuationJump.result, continuationJump.resultDbl);
        }
        callFrame.throwable = object;
        return callFrame;
    }

    private static Object freezeGenerator(Context context, CallFrame callFrame, int n, GeneratorState generatorState) {
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeError0("msg.yield.closing");
        }
        callFrame.frozen = true;
        callFrame.result = callFrame.stack[n];
        callFrame.resultDbl = callFrame.sDbl[n];
        callFrame.savedStackTop = n;
        --callFrame.pc;
        ScriptRuntime.exitActivationFunction(context);
        return callFrame.result != UniqueTag.DOUBLE_MARK ? callFrame.result : ScriptRuntime.wrapNumber(callFrame.resultDbl);
    }

    private static Object thawGenerator(CallFrame callFrame, int n, GeneratorState generatorState, int n2) {
        callFrame.frozen = false;
        int n3 = Interpreter.getIndex(callFrame.idata.itsICode, callFrame.pc);
        callFrame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, callFrame.idata.itsSourceFile, n3);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (n2 == 72) {
            callFrame.stack[n] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static CallFrame initFrameForApplyOrCall(Context context, CallFrame object, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, IdFunctionObject idFunctionObject, InterpretedFunction interpretedFunction) {
        Scriptable scriptable2;
        Object object2;
        if (n != 0) {
            object2 = objectArray[n2 + 2];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                object2 = ScriptRuntime.wrapNumber(dArray[n2 + 2]);
            }
            scriptable2 = ScriptRuntime.toObjectOrNull(context, object2, ((CallFrame)object).scope);
        } else {
            scriptable2 = null;
        }
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        if (n3 == -55) {
            Interpreter.exitFrame(context, (CallFrame)object, null);
            object = ((CallFrame)object).parentFrame;
        } else {
            ((CallFrame)object).savedStackTop = n2;
            ((CallFrame)object).savedCallOp = n3;
        }
        object2 = new CallFrame();
        if (BaseFunction.isApply(idFunctionObject)) {
            Object[] objectArray2 = n < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[n2 + 3]);
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray2, null, 0, objectArray2.length, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        } else {
            int n4;
            for (n4 = 1; n4 < n; ++n4) {
                objectArray[n2 + 1 + n4] = objectArray[n2 + 2 + n4];
                dArray[n2 + 1 + n4] = dArray[n2 + 2 + n4];
            }
            n4 = n < 2 ? 0 : n - 1;
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray, dArray, n2 + 2, n4, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        }
        object = object2;
        return object;
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        int n3;
        int n4;
        double[] dArray2;
        int[] nArray;
        Object[] objectArray2;
        boolean bl;
        int n5;
        int n6;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = interpretedFunction.getParentScope();
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (n6 = 0; n6 < interpreterData.itsNestedFunctions.length; ++n6) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[n6];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.initFunction(context, scriptable3, interpretedFunction, n6);
            }
        }
        if ((n5 = interpreterData.itsMaxFrameArray) != (n6 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n5 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            nArray = callFrame2.stackAttributes;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n5];
            nArray = new int[n5];
            dArray2 = new double[n5];
        }
        int n7 = interpreterData.getParamAndVarCount();
        for (n4 = 0; n4 < n7; ++n4) {
            if (!interpreterData.getParamOrVarConst(n4)) continue;
            nArray[n4] = 13;
        }
        n4 = interpreterData.argCount;
        if (n4 > n2) {
            n4 = n2;
        }
        callFrame2.parentFrame = callFrame;
        int n8 = callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        if (callFrame2.frameIndex > context.getMaximumInterpreterStackDepth()) {
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.stackAttributes = nArray;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n6;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n6;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n4);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n4);
        }
        for (n3 = n4; n3 != interpreterData.itsMaxVars; ++n3) {
            objectArray2[n3] = Undefined.instance;
        }
        if (bl) {
            for (n3 = n6 + 1; n3 != objectArray2.length; ++n3) {
                objectArray2[n3] = null;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray, false);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2;
        boolean bl3 = callFrame.idata.itsNeedsActivation;
        boolean bl4 = bl2 = callFrame.debuggerFrame != null;
        if (bl3 || bl2) {
            Scriptable scriptable = callFrame.scope;
            if (scriptable == null) {
                Kit.codeBug();
            } else if (bl) {
                while (scriptable instanceof NativeWith) {
                    if ((scriptable = scriptable.getParentScope()) != null && (callFrame.parentFrame == null || callFrame.parentFrame.scope != scriptable)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (bl2) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl3) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 38) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    public static NativeContinuation captureContinuation(Context context) {
        if (context.lastInterpreterFrame == null || !(context.lastInterpreterFrame instanceof CallFrame)) {
            throw new IllegalStateException("Interpreter frames not found");
        }
        return Interpreter.captureContinuation(context, (CallFrame)context.lastInterpreterFrame, true);
    }

    private static NativeContinuation captureContinuation(Context context, CallFrame callFrame, boolean bl) {
        NativeContinuation nativeContinuation = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(nativeContinuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame;
        CallFrame callFrame3 = callFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            for (int i = callFrame2.savedStackTop + 1; i != callFrame2.stack.length; ++i) {
                callFrame2.stack[i] = null;
                callFrame2.stackAttributes[i] = 0;
            }
            if (callFrame2.savedCallOp == 38) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame3 = callFrame2;
            callFrame2 = callFrame2.parentFrame;
        }
        if (bl) {
            while (callFrame3.parentFrame != null) {
                callFrame3 = callFrame3.parentFrame;
            }
            if (!callFrame3.isContinuationsTopFrame) {
                throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
            }
        }
        nativeContinuation.initImplementation(callFrame);
        return nativeContinuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toInt32(callFrame.sDbl[n]);
        }
        return ScriptRuntime.toInt32(object);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void doAdd(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof CharSequence || object instanceof CharSequence) {
                CharSequence charSequence = ScriptRuntime.toCharSequence(object2);
                CharSequence charSequence2 = ScriptRuntime.toCharSequence(object);
                objectArray[n] = new ConsString(charSequence, charSequence2);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object2;
            CharSequence charSequence3 = ScriptRuntime.toCharSequence(d);
            objectArray[n] = bl ? new ConsString(charSequence, charSequence3) : new ConsString(charSequence3, charSequence);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static int doArithmetic(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        double d = Interpreter.stack_double(callFrame, n2);
        double d2 = Interpreter.stack_double(callFrame, --n2);
        objectArray[n2] = UniqueTag.DOUBLE_MARK;
        switch (n) {
            case 22: {
                d2 -= d;
                break;
            }
            case 23: {
                d2 *= d;
                break;
            }
            case 24: {
                d2 /= d;
                break;
            }
            case 25: {
                d2 %= d;
            }
        }
        dArray[n2] = d2;
        return n2;
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        int[] stackAttributes;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        boolean isContinuationsTopFrame;
        Scriptable thisObj;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.stackAttributes = (int[])this.stackAttributes.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation nativeContinuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)nativeContinuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    static class GeneratorState {
        int operation;
        Object value;
        RuntimeException returnedException;

        GeneratorState(int n, Object object) {
            this.operation = n;
            this.value = object;
        }
    }
}

