/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.ScriptNode;

public class FunctionNode
extends ScriptNode {
    public static final int FUNCTION_STATEMENT = 1;
    public static final int FUNCTION_EXPRESSION = 2;
    public static final int FUNCTION_EXPRESSION_STATEMENT = 3;
    private static final List<AstNode> NO_PARAMS = Collections.unmodifiableList(new ArrayList());
    private Name functionName;
    private List<AstNode> params;
    private AstNode body;
    private boolean isExpressionClosure;
    private Form functionForm = Form.FUNCTION;
    private int lp = -1;
    private int rp = -1;
    private int functionType;
    private boolean needsActivation;
    private boolean isGenerator;
    private List<Node> generatorResumePoints;
    private Map<Node, int[]> liveLocals;
    private AstNode memberExprNode;

    public FunctionNode() {
        this.type = 109;
    }

    public FunctionNode(int n) {
        super(n);
        this.type = 109;
    }

    public FunctionNode(int n, Name name) {
        super(n);
        this.type = 109;
        this.setFunctionName(name);
    }

    public Name getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(Name name) {
        this.functionName = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public String getName() {
        return this.functionName != null ? this.functionName.getIdentifier() : "";
    }

    public List<AstNode> getParams() {
        return this.params != null ? this.params : NO_PARAMS;
    }

    public void setParams(List<AstNode> list) {
        if (list == null) {
            this.params = null;
        } else {
            if (this.params != null) {
                this.params.clear();
            }
            for (AstNode astNode : list) {
                this.addParam(astNode);
            }
        }
    }

    public void addParam(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.params == null) {
            this.params = new ArrayList<AstNode>();
        }
        this.params.add(astNode);
        astNode.setParent(this);
    }

    public boolean isParam(AstNode astNode) {
        return this.params == null ? false : this.params.contains(astNode);
    }

    public AstNode getBody() {
        return this.body;
    }

    public void setBody(AstNode astNode) {
        this.assertNotNull(astNode);
        this.body = astNode;
        if (Boolean.TRUE.equals(astNode.getProp(25))) {
            this.setIsExpressionClosure(true);
        }
        int n = astNode.getPosition() + astNode.getLength();
        astNode.setParent(this);
        this.setLength(n - this.position);
        this.setEncodedSourceBounds(this.position, n);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    public boolean isExpressionClosure() {
        return this.isExpressionClosure;
    }

    public void setIsExpressionClosure(boolean bl) {
        this.isExpressionClosure = bl;
    }

    public boolean requiresActivation() {
        return this.needsActivation;
    }

    public void setRequiresActivation() {
        this.needsActivation = true;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public void setIsGenerator() {
        this.isGenerator = true;
    }

    public void addResumptionPoint(Node node) {
        if (this.generatorResumePoints == null) {
            this.generatorResumePoints = new ArrayList<Node>();
        }
        this.generatorResumePoints.add(node);
    }

    public List<Node> getResumptionPoints() {
        return this.generatorResumePoints;
    }

    public Map<Node, int[]> getLiveLocals() {
        return this.liveLocals;
    }

    public void addLiveLocals(Node node, int[] nArray) {
        if (this.liveLocals == null) {
            this.liveLocals = new HashMap<Node, int[]>();
        }
        this.liveLocals.put(node, nArray);
    }

    @Override
    public int addFunction(FunctionNode functionNode) {
        int n = super.addFunction(functionNode);
        if (this.getFunctionCount() > 0) {
            this.needsActivation = true;
        }
        return n;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(int n) {
        this.functionType = n;
    }

    public boolean isMethod() {
        return this.functionForm == Form.GETTER || this.functionForm == Form.SETTER || this.functionForm == Form.METHOD;
    }

    public boolean isGetterMethod() {
        return this.functionForm == Form.GETTER;
    }

    public boolean isSetterMethod() {
        return this.functionForm == Form.SETTER;
    }

    public boolean isNormalMethod() {
        return this.functionForm == Form.METHOD;
    }

    public void setFunctionIsGetterMethod() {
        this.functionForm = Form.GETTER;
    }

    public void setFunctionIsSetterMethod() {
        this.functionForm = Form.SETTER;
    }

    public void setFunctionIsNormalMethod() {
        this.functionForm = Form.METHOD;
    }

    public void setMemberExprNode(AstNode astNode) {
        this.memberExprNode = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public AstNode getMemberExprNode() {
        return this.memberExprNode;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isMethod()) {
            stringBuilder.append(this.makeIndent(n));
            stringBuilder.append("function");
        }
        if (this.functionName != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.functionName.toSource(0));
        }
        if (this.params == null) {
            stringBuilder.append("() ");
        } else {
            stringBuilder.append("(");
            this.printList(this.params, stringBuilder);
            stringBuilder.append(") ");
        }
        if (this.isExpressionClosure) {
            AstNode astNode = this.getBody();
            if (astNode.getLastChild() instanceof ReturnStatement) {
                astNode = ((ReturnStatement)astNode.getLastChild()).getReturnValue();
                stringBuilder.append(astNode.toSource(0));
                if (this.functionType == 1) {
                    stringBuilder.append(";");
                }
            } else {
                stringBuilder.append(" ");
                stringBuilder.append(astNode.toSource(0));
            }
        } else {
            stringBuilder.append(this.getBody().toSource(n).trim());
        }
        if (this.functionType == 1 || this.isMethod()) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            if (this.functionName != null) {
                this.functionName.visit(nodeVisitor);
            }
            for (AstNode astNode : this.getParams()) {
                astNode.visit(nodeVisitor);
            }
            this.getBody().visit(nodeVisitor);
            if (!this.isExpressionClosure && this.memberExprNode != null) {
                this.memberExprNode.visit(nodeVisitor);
            }
        }
    }

    public static enum Form {
        FUNCTION,
        GETTER,
        SETTER,
        METHOD;

    }
}

