/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.HyperSearchFileNode;
import org.gjt.sp.jedit.search.HyperSearchFolderNode;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.search.HyperSearchOperationNode;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchTreeNodeCallback;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.HtmlUtilities;
import org.gjt.sp.util.SyntaxUtilities;
import org.gjt.sp.util.TaskManager;

public class HyperSearchResults
extends JPanel
implements DefaultFocusComponent {
    public static final String NAME = "hypersearch-results";
    public static final String HIGHLIGHT_PROP = "hypersearch.results.highlight";
    private final View view;
    private final JLabel caption;
    private final JTree resultTree;
    private final DefaultMutableTreeNode resultTreeRoot;
    private final DefaultTreeModel resultTreeModel;
    private final RolloverButton highlight;
    private final RolloverButton clear;
    private final RolloverButton multi;
    private final RolloverButton stop;
    private boolean multiStatus;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;

    public HyperSearchResults(View view) {
        super(new BorderLayout());
        this.view = view;
        this.caption = new JLabel();
        Box box = new Box(0);
        box.add(this.caption);
        box.add(Box.createGlue());
        ActionHandler actionHandler = new ActionHandler();
        this.highlight = new RolloverButton();
        this.highlight.setToolTipText(jEdit.getProperty("hypersearch-results.highlight.label"));
        this.highlight.addActionListener(actionHandler);
        box.add(this.highlight);
        this.clear = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.clear.icon")));
        this.clear.setToolTipText(jEdit.getProperty("hypersearch-results.clear.label"));
        this.clear.addActionListener(actionHandler);
        box.add(this.clear);
        this.multi = new RolloverButton();
        this.multi.setToolTipText(jEdit.getProperty("hypersearch-results.multi.label"));
        this.multi.addActionListener(actionHandler);
        box.add(this.multi);
        this.stop = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.stop.icon")));
        this.stop.setToolTipText(jEdit.getProperty("hypersearch-results.stop.label"));
        this.stop.addActionListener(actionHandler);
        box.add(this.stop);
        this.stop.setEnabled(false);
        this.add("North", box);
        this.resultTreeRoot = new DefaultMutableTreeNode();
        this.resultTreeModel = new DefaultTreeModel(this.resultTreeRoot);
        this.resultTree = new HighlightingTree(this.resultTreeModel);
        this.resultTree.setRowHeight(0);
        this.resultTree.setToolTipText(null);
        this.resultTree.setCellRenderer(new ResultCellRenderer());
        this.resultTree.setVisibleRowCount(16);
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.resultTree.getInputMap().remove(keyStroke);
        if (!OperatingSystem.isMacOSLF()) {
            this.resultTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.resultTree.setEditable(false);
        this.resultTree.addKeyListener(new KeyHandler());
        this.resultTree.addMouseListener(new MouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.resultTree);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = 400;
        jScrollPane.setPreferredSize(dimension);
        this.add("Center", jScrollPane);
        this.resultTree.setTransferHandler(new ResultTreeTransferHandler());
    }

    @Override
    public void focusOnDefaultComponent() {
        this.resultTree.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
        this.multiStatus = jEdit.getBooleanProperty("hypersearch-results.multi");
        this.updateHighlightStatus();
        this.updateMultiStatus();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
        jEdit.setBooleanProperty("hypersearch-results.multi", this.multiStatus);
    }

    private void visitBuffers(final ResultVisitor resultVisitor, final Buffer buffer) {
        HyperSearchResults.traverseNodes(this.resultTreeRoot, new TreeNodeCallbackAdapter(){

            @Override
            public boolean processNode(DefaultMutableTreeNode defaultMutableTreeNode) {
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof HyperSearchResult)) {
                    return true;
                }
                HyperSearchResult hyperSearchResult = (HyperSearchResult)object;
                if (hyperSearchResult.pathEquals(buffer.getSymlinkPath())) {
                    resultVisitor.visit(buffer, hyperSearchResult);
                }
                return true;
            }
        });
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        Object object = bufferUpdate.getWhat();
        if (object == BufferUpdate.LOADED) {
            this.visitBuffers(new BufferLoadedVisitor(), buffer);
        } else if (object == BufferUpdate.CLOSED) {
            this.visitBuffers(new BufferClosedVisitor(), buffer);
        }
    }

    public static boolean traverseNodes(DefaultMutableTreeNode defaultMutableTreeNode, HyperSearchTreeNodeCallback hyperSearchTreeNodeCallback) {
        if (!hyperSearchTreeNodeCallback.processNode(defaultMutableTreeNode)) {
            return false;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (HyperSearchResults.traverseNodes(defaultMutableTreeNode2, hyperSearchTreeNodeCallback)) continue;
            return false;
        }
        return true;
    }

    public DefaultTreeModel getTreeModel() {
        return this.resultTreeModel;
    }

    public JTree getTree() {
        return this.resultTree;
    }

    public void searchStarted() {
        this.stop.setEnabled(true);
        this.caption.setText(jEdit.getProperty("hypersearch-results.searching", new String[]{HyperSearchResults.trimSearchString()}));
    }

    public void setSearchStatus(String string) {
        this.caption.setText(string);
    }

    public void searchFailed() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.no-results", new String[]{HyperSearchResults.trimSearchString()}));
        for (int i = 0; i < this.resultTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            this.resultTree.collapsePath(new TreePath(new Object[]{this.resultTreeRoot, defaultMutableTreeNode}));
        }
    }

    public void searchDone(final DefaultMutableTreeNode defaultMutableTreeNode, final DefaultMutableTreeNode defaultMutableTreeNode2) {
        this.stop.setEnabled(false);
        final int n = defaultMutableTreeNode.getChildCount();
        if (n < 1) {
            this.searchFailed();
            return;
        }
        this.caption.setText(jEdit.getProperty("hypersearch-results.done", new String[]{HyperSearchResults.trimSearchString()}));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n2;
                if (!HyperSearchResults.this.multiStatus) {
                    for (n2 = 0; n2 < HyperSearchResults.this.resultTreeRoot.getChildCount(); ++n2) {
                        HyperSearchResults.this.resultTreeRoot.remove(0);
                    }
                }
                HyperSearchResults.this.resultTreeRoot.add(defaultMutableTreeNode);
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
                for (n2 = 0; n2 < n; ++n2) {
                    TreePath treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2)).getPath());
                    HyperSearchResults.this.resultTree.expandPath(treePath);
                }
                TreePath treePath = defaultMutableTreeNode2 == null ? new TreePath(new Object[]{HyperSearchResults.this.resultTreeRoot, defaultMutableTreeNode}) : new TreePath(defaultMutableTreeNode2.getPath());
                HyperSearchResults.this.resultTree.setSelectionPath(treePath);
                HyperSearchResults.this.resultTree.scrollPathToVisible(treePath);
            }
        });
    }

    public void searchDone(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.searchDone(defaultMutableTreeNode, null);
    }

    private void updateHighlightStatus() {
        String string = jEdit.getProperty(HIGHLIGHT_PROP);
        if (string != null && !string.isEmpty()) {
            this.highlight.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.match.highlight.icon")));
        } else {
            this.highlight.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.match.normal.icon")));
        }
        this.resultTree.repaint();
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.multiple.icon")));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.single.icon")));
        }
    }

    private void goToSelectedNode(int n) {
        TreePath treePath = this.resultTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.getParent() != this.resultTreeRoot && object instanceof HyperSearchNode) {
            EditPane editPane;
            HyperSearchNode hyperSearchNode = (HyperSearchNode)object;
            Buffer buffer = hyperSearchNode.getBuffer(this.view);
            if (buffer == null) {
                return;
            }
            switch (n) {
                case 0: {
                    editPane = this.view.goToBuffer(buffer);
                    break;
                }
                case 1: {
                    editPane = jEdit.newView(this.view, buffer, false).getEditPane();
                    break;
                }
                case 2: {
                    editPane = jEdit.newView(this.view, buffer, true).getEditPane();
                    break;
                }
                case 3: {
                    editPane = this.view.splitHorizontally();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad mode: " + n);
                }
            }
            hyperSearchNode.goTo(editPane);
        }
    }

    private void removeSelectedNode() {
        TreePath treePath = this.resultTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        if (treePath.getPathCount() > 1) {
            TreePath treePath2 = treePath.getParentPath();
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)treePath2.getLastPathComponent();
            int n = mutableTreeNode2.getIndex(mutableTreeNode);
            int n2 = n + 1;
            if (n2 < mutableTreeNode2.getChildCount()) {
                TreeNode treeNode = mutableTreeNode2.getChildAt(n2);
                this.resultTree.setSelectionPath(treePath2.pathByAddingChild(treeNode));
            } else {
                this.resultTree.setSelectionPath(treePath2);
            }
            this.resultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
        HyperSearchOperationNode.removeNodeFromCache(mutableTreeNode);
        if (this.resultTreeRoot.getChildCount() == 0) {
            this.hideDockable();
        }
    }

    private void removeAllNodes() {
        this.resultTreeRoot.removeAllChildren();
        this.resultTreeModel.reload(this.resultTreeRoot);
        this.setSearchStatus(null);
        this.hideDockable();
    }

    private void hideDockable() {
        this.view.getDockableWindowManager().hideDockableWindow(NAME);
    }

    private static String trimSearchString() {
        String string = SearchAndReplace.getSearchString();
        int n = jEdit.getIntegerProperty("hypersearch.displayQueryLength", 100);
        if (string.length() > n) {
            return string.substring(0, n) + "...";
        }
        return string;
    }

    SyntaxStyle parseHighlightStyle(String string) {
        SyntaxStyle syntaxStyle;
        Font font = this.resultTree != null ? this.resultTree.getFont() : UIManager.getFont("Tree.font");
        try {
            syntaxStyle = SyntaxUtilities.parseStyle(string, font.getFamily(), font.getSize(), true, null);
        }
        catch (Exception exception) {
            string = "color:#000000";
            syntaxStyle = SyntaxUtilities.parseStyle(string, font.getFamily(), font.getSize(), true);
        }
        return syntaxStyle;
    }

    public void expandAllNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        HyperSearchResults.traverseNodes(defaultMutableTreeNode, new TreeNodeCallbackAdapter(){

            @Override
            public boolean processNode(DefaultMutableTreeNode defaultMutableTreeNode) {
                HyperSearchResults.this.resultTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                return true;
            }
        });
    }

    static class TreeNodeCallbackAdapter
    implements HyperSearchTreeNodeCallback {
        TreeNodeCallbackAdapter() {
        }

        @Override
        public boolean processNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            return false;
        }
    }

    static class BufferClosedVisitor
    implements ResultVisitor {
        BufferClosedVisitor() {
        }

        @Override
        public void visit(Buffer buffer, HyperSearchResult hyperSearchResult) {
            hyperSearchResult.bufferClosed();
        }
    }

    static class BufferLoadedVisitor
    implements ResultVisitor {
        BufferLoadedVisitor() {
        }

        @Override
        public void visit(Buffer buffer, HyperSearchResult hyperSearchResult) {
            hyperSearchResult.bufferOpened(buffer);
        }
    }

    static interface ResultVisitor {
        public void visit(Buffer var1, HyperSearchResult var2);
    }

    class ResultTreeTransferHandler
    extends TransferHandler {
        ResultTreeTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
            TreePath[] treePathArray = HyperSearchResults.this.resultTree.getSelectionPaths();
            ToStringNodes toStringNodes = new ToStringNodes();
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                toStringNodes.processNode(defaultMutableTreeNode);
            }
            StringSelection stringSelection = new StringSelection(toStringNodes.nodesString.toString());
            Clipboard clipboard2 = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard2.setContents(stringSelection, null);
        }
    }

    static class ResultCellRenderer
    extends EnhancedTreeCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ResultCellRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new ResultCellRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setIcon(null);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof HyperSearchOperationNode) {
                this.setFont(this.boldFont);
                CountNodes countNodes = new CountNodes();
                HyperSearchResults.traverseNodes(defaultMutableTreeNode, countNodes);
                this.setText(jEdit.getProperty("hypersearch-results.result-caption", new Object[]{defaultMutableTreeNode.toString(), countNodes.resultCount, countNodes.bufferCount}));
            } else if (defaultMutableTreeNode.getUserObject() instanceof HyperSearchFolderNode) {
                this.setFont(this.plainFont);
                this.setText(defaultMutableTreeNode.toString() + " (" + defaultMutableTreeNode.getChildCount() + " files/folders)");
            } else if (defaultMutableTreeNode.getUserObject() instanceof HyperSearchFileNode) {
                this.setFont(this.boldFont);
                HyperSearchFileNode hyperSearchFileNode = (HyperSearchFileNode)defaultMutableTreeNode.getUserObject();
                this.setText(jEdit.getProperty("hypersearch-results.file-caption", new Object[]{hyperSearchFileNode, hyperSearchFileNode.getCount(), defaultMutableTreeNode.getChildCount()}));
            } else {
                this.setFont(this.plainFont);
            }
        }

        static class CountNodes
        implements HyperSearchTreeNodeCallback {
            int bufferCount;
            int resultCount;

            CountNodes() {
            }

            @Override
            public boolean processNode(DefaultMutableTreeNode defaultMutableTreeNode) {
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof HyperSearchFileNode) {
                    this.resultCount += ((HyperSearchFileNode)object).getCount();
                    ++this.bufferCount;
                }
                return true;
            }
        }
    }

    class GoToNodeAction
    extends AbstractAction {
        private final int mode;

        GoToNodeAction(String string, int n) {
            super(jEdit.getProperty(string));
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperSearchResults.this.goToSelectedNode(this.mode);
        }
    }

    class TreeDisplayAction
    extends AbstractAction {
        TreeDisplayAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.isSelected();
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            HyperSearchOperationNode hyperSearchOperationNode = (HyperSearchOperationNode)defaultMutableTreeNode.getUserObject();
            if (bl) {
                hyperSearchOperationNode.cacheResultNodes(defaultMutableTreeNode);
            }
            defaultMutableTreeNode.removeAllChildren();
            if (bl) {
                Exception exception = null;
                try {
                    hyperSearchOperationNode.insertTreeNodes(HyperSearchResults.this.resultTree, defaultMutableTreeNode);
                }
                catch (Exception exception2) {
                    hyperSearchOperationNode.restoreFlatNodes(HyperSearchResults.this.resultTree, defaultMutableTreeNode);
                    jCheckBoxMenuItem.setSelected(false);
                    exception = exception2;
                }
                finally {
                    ((DefaultTreeModel)HyperSearchResults.this.resultTree.getModel()).nodeStructureChanged(defaultMutableTreeNode);
                    HyperSearchResults.this.expandAllNodes(defaultMutableTreeNode);
                    HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
                }
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            } else {
                hyperSearchOperationNode.restoreFlatNodes(HyperSearchResults.this.resultTree, defaultMutableTreeNode);
            }
            hyperSearchOperationNode.setTreeViewDisplayed(jCheckBoxMenuItem.isSelected());
        }
    }

    class RedoSearchAction
    extends AbstractAction {
        private final HyperSearchOperationNode hyperSearchOperationNode;

        RedoSearchAction(HyperSearchOperationNode hyperSearchOperationNode) {
            super(jEdit.getProperty("hypersearch-results.redo"));
            this.hyperSearchOperationNode = hyperSearchOperationNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchAndReplace.setSearchString(this.hyperSearchOperationNode.getSearchString());
            SearchAndReplace.setSearchMatcher(this.hyperSearchOperationNode.getSearchMatcher());
            HyperSearchResults.this.removeSelectedNode();
            SearchAndReplace.hyperSearch(HyperSearchResults.this.view, false);
        }
    }

    class CollapseChildTreeNodesAction
    extends AbstractAction {
        CollapseChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.collapse-child-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                HyperSearchResults.this.resultTree.collapsePath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    static class ToStringNodes
    implements HyperSearchTreeNodeCallback {
        StringBuilder nodesString = new StringBuilder();

        ToStringNodes() {
        }

        @Override
        public boolean processNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof HyperSearchFileNode) {
                this.nodesString.append(((HyperSearchFileNode)object).path);
            } else if (object instanceof HyperSearchResult) {
                HyperSearchResult hyperSearchResult = (HyperSearchResult)object;
                this.nodesString.append(hyperSearchResult.buffer == null ? hyperSearchResult.toString() : hyperSearchResult.buffer.getLineText(hyperSearchResult.line));
            } else {
                this.nodesString.append(object.toString());
            }
            this.nodesString.append('\n');
            return true;
        }
    }

    class CopyToClipboardAction
    extends AbstractAction {
        CopyToClipboardAction() {
            super(jEdit.getProperty("hypersearch-results.copy-to-clipboard"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ToStringNodes toStringNodes = new ToStringNodes();
            HyperSearchResults.traverseNodes(defaultMutableTreeNode, toStringNodes);
            StringSelection stringSelection = new StringSelection(toStringNodes.nodesString.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    class ExpandChildTreeNodesAction
    extends AbstractAction {
        ExpandChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.expand-child-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            HyperSearchResults.this.expandAllNodes(defaultMutableTreeNode);
        }
    }

    class NewSearchAction
    extends AbstractAction {
        NewSearchAction() {
            super(jEdit.getProperty("hypersearch-results.new-search"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            HyperSearchFolderNode hyperSearchFolderNode = (HyperSearchFolderNode)defaultMutableTreeNode.getUserObject();
            String string = "*";
            SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
            if (searchFileSet instanceof DirectoryListSet) {
                string = ((DirectoryListSet)searchFileSet).getFileFilter();
            }
            SearchAndReplace.setSearchFileSet(new DirectoryListSet(hyperSearchFolderNode.getNodeFile().getAbsolutePath(), string, true));
            SearchDialog.showSearchDialog(HyperSearchResults.this.view, null, 2);
        }
    }

    class RemoveAllTreeNodesAction
    extends AbstractAction {
        RemoveAllTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.remove-all-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperSearchResults.this.removeAllNodes();
        }
    }

    class RemoveTreeNodeAction
    extends AbstractAction {
        RemoveTreeNodeAction() {
            super(jEdit.getProperty("hypersearch-results.remove-node"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperSearchResults.this.removeSelectedNode();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = HyperSearchResults.this.resultTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            HyperSearchResults.this.resultTree.setSelectionPath(treePath);
            if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                this.showPopupMenu(mouseEvent);
            } else {
                HyperSearchResults.this.goToSelectedNode(0);
            }
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.popupMenu = new JPopupMenu();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof HyperSearchFileNode || object instanceof HyperSearchResult) {
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open", 0));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-view", 1));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-plain-view", 2));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-split", 3));
            }
            if (!(object instanceof HyperSearchFolderNode)) {
                this.popupMenu.add(new RemoveTreeNodeAction());
            }
            this.popupMenu.add(new ExpandChildTreeNodesAction());
            if (object instanceof HyperSearchFolderNode || object instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new CollapseChildTreeNodesAction());
                if (object instanceof HyperSearchFolderNode) {
                    this.popupMenu.add(new NewSearchAction());
                }
            }
            if (object instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new JPopupMenu.Separator());
                HyperSearchOperationNode hyperSearchOperationNode = (HyperSearchOperationNode)object;
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(jEdit.getProperty("hypersearch-results.tree-view"), hyperSearchOperationNode.isTreeViewDisplayed());
                jCheckBoxMenuItem.addActionListener(new TreeDisplayAction());
                this.popupMenu.add(jCheckBoxMenuItem);
                this.popupMenu.add(new RedoSearchAction((HyperSearchOperationNode)object));
            }
            this.popupMenu.add(new CopyToClipboardAction());
            GUIUtilities.showPopupMenu(this.popupMenu, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 32: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HyperSearchResults.this.resultTree.requestFocus();
                        }
                    });
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    keyEvent.consume();
                    break;
                }
                case 127: {
                    HyperSearchResults.this.removeSelectedNode();
                    keyEvent.consume();
                    break;
                }
            }
        }
    }

    class HighlightingTree
    extends JTree {
        private String prop;
        private String styleTag;

        HighlightingTree(DefaultTreeModel defaultTreeModel) {
            super(defaultTreeModel);
            this.prop = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
            if (this.prop != null && !this.prop.isEmpty()) {
                Font font = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                this.styleTag = HtmlUtilities.style2html(this.prop, font);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode;
            String string = super.convertValueToText(object, bl, bl2, bl3, n, bl4);
            String string2 = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
            if (string2 == null || string2.isEmpty()) {
                return string;
            }
            for (defaultMutableTreeNode = (DefaultMutableTreeNode)object; defaultMutableTreeNode != null && !(defaultMutableTreeNode.getUserObject() instanceof HyperSearchOperationNode); defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) {
            }
            if (defaultMutableTreeNode == null) {
                return string;
            }
            if (!string2.equals(this.prop)) {
                this.prop = string2;
                object2 = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                this.styleTag = HtmlUtilities.style2html(this.prop, (Font)object2);
            }
            object2 = ((HyperSearchOperationNode)defaultMutableTreeNode.getUserObject()).getSearchMatcher();
            int n2 = string.indexOf(": ");
            n2 = n2 > 0 ? (n2 += 2) : 0;
            SearchMatcher.Match match = null;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            try {
                match = ((SearchMatcher)object2).nextMatch(string.substring(n2), true, true, true, false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            while (match != null) {
                arrayList.add(n2 + match.start);
                arrayList.add(n2 + match.end);
                n2 += match.end;
                try {
                    match = ((SearchMatcher)object2).nextMatch(string.substring(n2), true, true, true, false);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    match = null;
                }
            }
            return HtmlUtilities.highlightString(string, this.styleTag, arrayList);
        }
    }

    public class ActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == HyperSearchResults.this.highlight) {
                String string = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
                Font font = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                SyntaxStyle syntaxStyle = new StyleEditor(jEdit.getActiveView(), HtmlUtilities.parseHighlightStyle(string, font), "hypersearch").getStyle();
                if (syntaxStyle != null) {
                    jEdit.setProperty(HyperSearchResults.HIGHLIGHT_PROP, GUIUtilities.getStyleString(syntaxStyle));
                }
                HyperSearchResults.this.updateHighlightStatus();
            } else if (object == HyperSearchResults.this.clear) {
                HyperSearchResults.this.removeAllNodes();
            } else if (object == HyperSearchResults.this.multi) {
                HyperSearchResults.this.multiStatus = !HyperSearchResults.this.multiStatus;
                HyperSearchResults.this.updateMultiStatus();
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = HyperSearchResults.this.resultTreeRoot.getChildCount() - 2; i >= 0; --i) {
                        HyperSearchResults.this.resultTreeModel.removeNodeFromParent((MutableTreeNode)HyperSearchResults.this.resultTreeRoot.getChildAt(i));
                    }
                }
            } else if (object == HyperSearchResults.this.stop) {
                TaskManager.instance.cancelTasksByClass(HyperSearchRequest.class);
            }
        }
    }
}

