/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private String file = null;
    private int line = -1;

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2) {
        super(runtime, rubyClass);
        this.type = type2;
    }

    @Deprecated
    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2, ISourcePosition sourcePosition) {
        this(runtime, rubyClass, type2, sourcePosition.getFile(), sourcePosition.getLine());
    }

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2, String file2, int line) {
        this(runtime, rubyClass, type2);
        this.file = file2;
        this.line = line;
    }

    public RubyProc(Ruby runtime, RubyClass rubyClass, Block block, String file2, int line) {
        this(runtime, rubyClass, block.type);
        this.block = block;
        this.file = file2;
        this.line = line;
    }

    public static RubyClass createProcClass(Ruby runtime) {
        RubyClass procClass = runtime.defineClass("Proc", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setProc(procClass);
        procClass.setClassIndex(ClassIndex.PROC);
        procClass.setReifiedClass(RubyProc.class);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime, Block.Type type2) {
        throw runtime.newRuntimeError("deprecated RubyProc.newProc with no block; do not use");
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type2);
        proc.setup(block);
        return proc;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2, ISourcePosition sourcePosition) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type2, sourcePosition);
        proc.setup(block);
        return proc;
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2, String file2, int line) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type2, file2, line);
        proc.setup(block);
        return proc;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null && block.getProcObject().getMetaClass() == recv2) {
            return block.getProcObject();
        }
        RubyProc obj = new RubyProc(context.runtime, (RubyClass)recv2, Block.Type.PROC);
        obj.setup(block);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    private void setup(Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.isLambda()) {
            // empty if block
        }
        if (this.isThread()) {
            Binding oldBinding = procBlock.getBinding();
            Binding newBinding = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
            this.block = new Block(procBlock.getBody(), newBinding);
            StaticScope oldScope = this.block.getBody().getStaticScope();
            StaticScope newScope = oldScope.duplicate();
            this.block.getBody().setStaticScope(newScope);
        } else {
            this.block = procBlock;
        }
        this.block.getBinding().setFile(this.block.getBody().getFile());
        this.block.getBinding().setLine(this.block.getBody().getLine());
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.block.getBinding().getDummyScope(this.block.getBody().getStaticScope());
    }

    @Override
    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = RubyProc.newProc(this.getRuntime(), this.block, this.type, this.file, this.line);
        return newProc;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        return RubyProc.newProc(this.getRuntime(), this.block, this.type, this.file, this.line);
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s19();
    }

    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s19() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("#<Proc:0x").append(Integer.toString(System.identityHashCode(this.block), 16));
        String file2 = this.block.getBody().getFile();
        if (file2 != null) {
            sb.append('@').append(file2).append(':').append(this.block.getBody().getLine() + 1);
        }
        if (this.isLambda()) {
            sb.append(" (lambda)");
        }
        sb.append('>');
        RubyString string2 = RubyString.newString(this.getRuntime(), sb.toString());
        if (this.isTaint()) {
            string2.setTaint(true);
        }
        return string2;
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call19(context, args2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.call(context, args2, null, Block.NULL_BLOCK);
    }

    public static IRubyObject[] prepareArgs(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject[] args2) {
        int needsKwargs;
        boolean restKwargs;
        Signature signature = blockBody.getSignature();
        if (args2 == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (type2 == Block.Type.LAMBDA) {
            signature.checkArity(context.runtime, args2);
            return args2;
        }
        boolean isFixed = signature.isFixed();
        int required = signature.required();
        int actual = args2.length;
        boolean bl = restKwargs = blockBody instanceof IRBlockBody && ((IRBlockBody)blockBody).getSignature().hasKwargs();
        if ((signature != Signature.ONE_ARGUMENT && required != 0 && (isFixed || signature != Signature.OPTIONAL) || restKwargs) && actual == 1 && args2[0].respondsTo("to_ary")) {
            IRubyObject newAry = Helpers.aryToAry(args2[0]);
            if (newAry.isNil()) {
                args2 = new IRubyObject[]{args2[0]};
            } else if (newAry instanceof RubyArray) {
                args2 = ((RubyArray)newAry).toJavaArray();
            } else {
                throw context.runtime.newTypeError(args2[0].getType().getName() + "#to_ary should return Array");
            }
            actual = args2.length;
        }
        int n = needsKwargs = blockBody instanceof IRBlockBody && ((IRBlockBody)blockBody).getSignature().hasKwargs() ? 1 - ((IRBlockBody)blockBody).getSignature().getRequiredKeywordForArityCount() : 0;
        if (isFixed && required > 0 && required + needsKwargs != actual) {
            IRubyObject[] newArgs = Arrays.copyOf(args2, required + needsKwargs);
            if (required > actual) {
                Helpers.fillNil(newArgs, actual, required, context.runtime);
            } else if (needsKwargs != 0) {
                newArgs[newArgs.length - 1] = args2.length < required + needsKwargs ? RubyHash.newHash(context.runtime) : args2[args2.length - 1];
            }
            args2 = newArgs;
        }
        return args2;
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, rest=true, omit=true)
    public IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block blockCallArg) {
        IRubyObject[] preppedArgs = RubyProc.prepareArgs(context, this.type, this.block.getBody(), args2);
        return this.call(context, preppedArgs, null, blockCallArg);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Block passedBlock) {
        Block newBlock;
        assert (args2 != null);
        if (self2 == null) {
            newBlock = this.block;
        } else {
            newBlock = this.block.cloneBlockAndFrame();
            newBlock.getBinding().setSelf(self2);
        }
        return newBlock.call(context, args2, passedBlock);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        Signature signature = this.block.getSignature();
        if (this.block.type == Block.Type.LAMBDA) {
            return this.getRuntime().newFixnum(signature.arityValue());
        }
        return this.getRuntime().newFixnum(signature.hasRest() ? signature.arityValue() : signature.required() + signature.getRequiredKeywordForArityCount());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.file != null) {
            return runtime.newArray((IRubyObject)runtime.newString(this.file), (IRubyObject)runtime.newFixnum(this.line + 1));
        }
        if (this.block != null) {
            Binding binding2 = this.block.getBinding();
            return runtime.newArray((IRubyObject)runtime.newString(binding2.getFile()), (IRubyObject)runtime.newFixnum(binding2.getLine() + 1));
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        BlockBody body = this.getBlock().getBody();
        return Helpers.argumentDescriptorsToParameters(context.runtime, body.getArgumentDescriptors(), this.isLambda());
    }

    @JRubyMethod(name={"lambda?"})
    public IRubyObject lambda_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isLambda());
    }

    private boolean isLambda() {
        return this.type.equals((Object)Block.Type.LAMBDA);
    }

    private boolean isThread() {
        return this.type.equals((Object)Block.Type.THREAD);
    }
}

