/****************************************************************************
**
*W  profile.h                     GAP source              Chris Jefferson
**
**
*Y  Copyright (C) 2014 The GAP Group
**
**  This file contains profile related functionality.
**
*/

#ifndef libGAP_GAP_PROFILE_H
#define libGAP_GAP_PROFILE_H

#include "exprs.h"

/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**
*F  InitInfoStats() . . . . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoProfile ( void );

void libGAP_RegisterStatWithProfiling(libGAP_Stat);


void libGAP_InstallEvalBoolFunc( libGAP_Int, libGAP_Obj(*)(libGAP_Expr));
void libGAP_InstallEvalExprFunc( libGAP_Int, libGAP_Obj(*)(libGAP_Expr));
void libGAP_InstallExecStatFunc( libGAP_Int, libGAP_UInt(*)(libGAP_Stat));
void libGAP_InstallPrintStatFunc(libGAP_Int, void(*)(libGAP_Stat));
void libGAP_InstallPrintExprFunc(libGAP_Int, void(*)(libGAP_Expr));

/****************************************************************************
**
** We need this to be in the header, so it can be inlined away. The only
** functionality here which should be publicly used is 'VisitStatIfProfiling',
** 'ProfileLineByLineIntoFunction' and 'ProfileLineByLineOutFunction'.
*/

extern libGAP_UInt libGAP_profileState_Active;

void libGAP_visitStat(libGAP_Stat stat);

static inline void libGAP_VisitStatIfProfiling(libGAP_Stat stat)
{
  if(libGAP_profileState_Active)
    libGAP_visitStat(stat);
}

void libGAP_ProfileLineByLineOutput(libGAP_Obj func, char type);

static inline void libGAP_ProfileLineByLineIntoFunction(libGAP_Obj func)
{
  if(libGAP_profileState_Active)
    libGAP_ProfileLineByLineOutput(func, 'I');
}


static inline void libGAP_ProfileLineByLineOutFunction(libGAP_Obj func)
{
  if(libGAP_profileState_Active)
    libGAP_ProfileLineByLineOutput(func, 'O');
}


#endif // GAP_STATS_H

/****************************************************************************
**

*E  stats.c . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
