/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.util.ArrayList;
import org.perl.inline.java.InlineJavaCallback;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaCallbackQueue {
    private ArrayList queue = new ArrayList();
    private boolean wait_interrupted = false;
    private boolean stream_opened = false;

    InlineJavaCallbackQueue() {
    }

    synchronized void EnqueueCallback(InlineJavaCallback ijc) {
        this.queue.add(ijc);
        this.notify();
    }

    private synchronized InlineJavaCallback DequeueCallback() {
        if (this.GetSize() > 0) {
            return (InlineJavaCallback)this.queue.remove(0);
        }
        return null;
    }

    synchronized int WaitForCallback(double timeout) {
        long secs = (long)Math.floor(timeout);
        double rest = timeout - (double)secs;
        long millis = (long)Math.floor(rest * 1000.0);
        rest = rest * 1000.0 - (double)millis;
        int nanos = (int)Math.floor(rest * 1000000.0);
        return this.WaitForCallback(secs * 1000L + millis, nanos);
    }

    synchronized int WaitForCallback(long millis, int nanos) {
        this.wait_interrupted = false;
        Thread t = Thread.currentThread();
        InlineJavaUtils.debug(3, "waiting for callback request (" + millis + " millis, " + nanos + " nanos) in " + t.getName() + "...");
        if (!this.stream_opened) {
            return -1;
        }
        while (this.stream_opened && !this.wait_interrupted && this.IsEmpty()) {
            try {
                this.wait(millis, nanos);
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        InlineJavaUtils.debug(3, "waiting for callback request finished " + t.getName() + "...");
        if (this.wait_interrupted) {
            return -1;
        }
        return this.GetSize();
    }

    synchronized boolean ProcessNextCallback() throws InlineJavaException, InlineJavaPerlException {
        int rc = this.WaitForCallback(0L, 0);
        if (rc == -1) {
            return false;
        }
        Thread t = Thread.currentThread();
        InlineJavaUtils.debug(3, "processing callback request in " + t.getName() + "...");
        InlineJavaCallback ijc = this.DequeueCallback();
        ijc.Process();
        ijc.NotifyOfResponse(t);
        return true;
    }

    private boolean IsEmpty() {
        return this.GetSize() == 0;
    }

    void OpenCallbackStream() {
        this.stream_opened = true;
    }

    synchronized void CloseCallbackStream() {
        this.stream_opened = false;
        this.InterruptWaitForCallback();
    }

    boolean IsStreamOpen() {
        return this.stream_opened;
    }

    int GetSize() {
        return this.queue.size();
    }

    private synchronized void InterruptWaitForCallback() {
        Thread t = Thread.currentThread();
        InlineJavaUtils.debug(3, "interrupting wait for callback request in " + t.getName() + "...");
        this.wait_interrupted = true;
        this.notify();
    }
}

