/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.enums.LineType;
import com.baselet.element.facet.specific.sequence_aio.CombinedFragment;
import com.baselet.element.facet.specific.sequence_aio.Continuation;
import com.baselet.element.facet.specific.sequence_aio.Coregion;
import com.baselet.element.facet.specific.sequence_aio.ExecutionSpecification;
import com.baselet.element.facet.specific.sequence_aio.GateMessage;
import com.baselet.element.facet.specific.sequence_aio.GeneralOrdering;
import com.baselet.element.facet.specific.sequence_aio.InteractionUse;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;
import com.baselet.element.facet.specific.sequence_aio.LostOrFoundMessage;
import com.baselet.element.facet.specific.sequence_aio.Message;
import com.baselet.element.facet.specific.sequence_aio.OccurrenceSpecification;
import com.baselet.element.facet.specific.sequence_aio.SequenceDiagram;
import com.baselet.element.facet.specific.sequence_aio.SequenceDiagramCheckedException;
import com.baselet.element.facet.specific.sequence_aio.SequenceDiagramException;
import com.baselet.element.facet.specific.sequence_aio.StateInvariant;
import com.baselet.element.facet.specific.sequence_aio.TextOnLifeline;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceDiagramBuilder {
    private static final Logger log = LoggerFactory.getLogger(SequenceDiagramBuilder.class);
    private final String DEFAULT_ID_PREFIX = "id";
    private final SequenceDiagram dia;
    private final Map<Lifeline, LifelineState> currentLifelineState;
    private boolean overrideDefaultIds = false;
    private final Map<String, Lifeline> ids = new HashMap<String, Lifeline>();
    private final LinkedList<ActiveCombinedFragment> activeCombinedFragmentStack = new LinkedList();
    private final Map<Lifeline, Map<String, OccurrenceSpecification>> lifelineLocalIds = new HashMap<Lifeline, Map<String, OccurrenceSpecification>>();
    private final List<String> warnings;
    private int currentTick = 0;
    private int lastMessageReceiveTick = 0;
    private boolean diagramRetrieved = false;

    public SequenceDiagramBuilder() {
        this.dia = new SequenceDiagram();
        this.currentLifelineState = new HashMap<Lifeline, LifelineState>();
        this.warnings = new LinkedList<String>();
    }

    public void setTitle(String title) {
        this.checkState();
        this.dia.setTitle(title);
    }

    public void setText(String text) {
        this.checkState();
        this.dia.setText(text);
    }

    public Lifeline getLifeline(String id) {
        return this.ids.get(id);
    }

    Lifeline getLifelineException(String id) {
        if (!this.ids.containsKey(id)) {
            throw new SequenceDiagramException("No lifeline is associated with the id: '" + id + "'");
        }
        return this.ids.get(id);
    }

    public Lifeline[] getLifelineInterval(String id1, String id2) {
        try {
            return this.getLifelineIntervalException(id1, id2);
        }
        catch (SequenceDiagramException e) {
            return new Lifeline[0];
        }
    }

    public Lifeline[] getLifelineIntervalException(String id1, String id2) {
        Lifeline ll1 = this.getLifelineException(id1);
        Lifeline ll2 = this.getLifelineException(id2);
        if (ll1.getIndex() > ll2.getIndex()) {
            Lifeline tmp = ll1;
            ll1 = ll2;
            ll2 = tmp;
        }
        return Arrays.copyOfRange(this.dia.getLifelinesArray(), ll1.getIndex(), ll2.getIndex() + 1);
    }

    public void addLiveline(String headText, String id, Lifeline.LifelineHeadType headType, boolean createdOnStart, boolean execSpecFromStart) {
        this.checkState();
        if (this.isOverrideDefaultIds() && id == null) {
            throw new SequenceDiagramException("If the override option is set to true then every lifeline needs an id!");
        }
        Lifeline newLifeline = this.dia.addLiveline(headText, headType, createdOnStart, execSpecFromStart);
        if (id != null) {
            if (this.ids.containsKey(id)) {
                throw new SequenceDiagramException("There is already a lifeline which is associated with the id '" + id + "', please choose another identifier.");
            }
            this.ids.put(id, newLifeline);
        }
        if (!this.overrideDefaultIds) {
            if (this.ids.containsKey("id" + this.dia.getLifelineCount())) {
                throw new SequenceDiagramException("There is already a lifeline which is associated with the default id 'id" + this.dia.getLifelineCount() + "',\nplease choose another identifier or add the option 'overrideIds=true'.");
            }
            this.ids.put("id" + this.dia.getLifelineCount(), newLifeline);
        }
        this.lifelineLocalIds.put(newLifeline, new HashMap());
        LifelineState newLifelineState = new LifelineState();
        if (execSpecFromStart && createdOnStart) {
            newLifelineState.execSpecStartTickStack.addFirst(-1);
        }
        this.currentLifelineState.put(newLifeline, newLifelineState);
    }

    private void addLifelineOccurrence(String id, LifelineOccurrence occurrence) {
        this.checkState();
        try {
            this.getLifelineException(id).addLifelineOccurrenceAtTick(occurrence, this.currentTick);
        }
        catch (SequenceDiagramCheckedException ex) {
            throw new SequenceDiagramException("Error on lifeline '" + id + "': " + ex.getMessage(), ex);
        }
    }

    public void addTextOnLifeline(String lifelineId, String text) {
        this.addLifelineOccurrence(lifelineId, new TextOnLifeline(text));
    }

    public void addStateInvariant(String lifelineId, String text, boolean drawAsState) {
        this.addLifelineOccurrence(lifelineId, new StateInvariant(text, drawAsState ? StateInvariant.StateInvariantStyle.STATE : StateInvariant.StateInvariantStyle.CURLY_BRACKETS));
    }

    public void addCoregion(String id, boolean start) {
        this.checkState();
        Lifeline lifeline = this.getLifelineException(id);
        LifelineState lifelineState = this.currentLifelineState.get(lifeline);
        if (lifelineState.coregionActive && start) {
            this.addWarning(id, "A new coregion was started while an old one was still active.");
        } else if (!lifelineState.coregionActive && !start) {
            this.addWarning(id, "A coregion was closed, but no coregion was active.");
        }
        try {
            lifeline.addLifelineOccurrenceAtTick(new Coregion(lifeline, this.currentTick, start), this.currentTick);
            lifelineState.coregionActive = start;
        }
        catch (SequenceDiagramCheckedException ex) {
            throw new SequenceDiagramException("Error on lifeline '" + id + "': " + ex.getMessage(), ex);
        }
    }

    public void destroyLifeline(String id) {
        this.checkState();
        Lifeline lifeline = this.getLifelineException(id);
        if (lifeline.getDestroyed() != null) {
            this.addWarning(id, "The lifeline was already destroyed.");
        } else {
            lifeline.setDestroyed(this.currentTick);
        }
    }

    public void changeExecutionSpecification(String lifelineId, boolean on) {
        this.checkState();
        Lifeline lifeline = this.getLifelineException(lifelineId);
        LifelineState lifelineState = this.currentLifelineState.get(lifeline);
        if (on) {
            if (lifelineState.execSpecStartTickStack.size() > 0 && lifelineState.execSpecStartTickStack.peek() == this.currentTick) {
                throw new SequenceDiagramException("On lifeline " + lifelineId + " two executionspecifications start at the same tick, this is not possible.");
            }
            if (lifelineState.lastEndOfExecSpec == this.currentTick) {
                throw new SequenceDiagramException("On lifeline " + lifelineId + " two executionspecifications overlap, this is not possible.");
            }
            if (!(lifeline.isCreatedOnStart() || lifeline.getCreated() != null && lifeline.getCreated() < this.currentTick)) {
                throw new SequenceDiagramException("Error on lifeline '" + lifelineId + "': the lifeline can not contain executionspecifications before it is created.");
            }
            lifelineState.execSpecStartTickStack.addFirst(this.currentTick);
        } else {
            if (lifelineState.execSpecStartTickStack.size() == 0) {
                throw new SequenceDiagramException("On lifeline " + lifelineId + " a executionspecification was closed but no active executionspecification exists.");
            }
            int startTick = lifelineState.execSpecStartTickStack.poll();
            if (startTick == this.currentTick) {
                throw new SequenceDiagramException("On lifeline " + lifelineId + " a executionspecification was closed too soon, every executionspecification needs to be at least 1 tick long.");
            }
            if (lifelineState.lastEndOfExecSpec == this.currentTick) {
                throw new SequenceDiagramException("On lifeline " + lifelineId + " two executionspecifications end at the same tick, this is not possible.");
            }
            lifelineState.lastEndOfExecSpec = this.currentTick;
            lifeline.addExecutionSpecification(new ExecutionSpecification(startTick, this.currentTick));
        }
    }

    public void addMessage(String fromId, String toId, int duration, String text, LineType lineType, Message.ArrowType arrowType, String fromLocalId, String toLocalId) {
        this.checkState();
        if (fromId.equals(toId) && duration < 1) {
            throw new SequenceDiagramException("The duration of a self message must be greater than 0, but was " + duration + ".");
        }
        this.lastMessageReceiveTick = Math.max(this.lastMessageReceiveTick, this.currentTick + duration);
        Lifeline from = this.getLifelineException(fromId);
        this.checkLifelineSendMessage(from, fromId);
        Lifeline to = this.getLifelineException(toId);
        if (!to.isCreatedOnStart() && to.getCreated() != null && this.currentTick + duration <= to.getCreated()) {
            throw new SequenceDiagramException("A message can't end on a lifeline before this lifeline was created.\nPlease increase the messages duration by at least " + (to.getCreated() + 1 - (this.currentTick + duration)) + ".");
        }
        if (this.currentTick + duration < 0) {
            throw new SequenceDiagramException("A message can't end on a lifeline before this lifeline was created.\nPlease increase the messages duration by at least " + -(this.currentTick + duration) + ".");
        }
        if (!to.isCreatedOnStart() && to.getCreated() == null) {
            to.setCreated(this.currentTick + duration);
            if (to.isExecSpecFromStart()) {
                this.currentLifelineState.get((Object)to).execSpecStartTickStack.push(this.currentTick + duration);
            }
        }
        Message msg = new Message(from, to, duration, this.currentTick, text, arrowType, lineType);
        if (fromLocalId != null) {
            this.addOccurrenceSpecification(from, fromId, fromLocalId, msg.sendOccurrenceSpecification());
        }
        if (toLocalId != null) {
            this.addOccurrenceSpecification(to, toId, toLocalId, msg.receiveOccurrenceSpecification());
        }
        this.dia.addLifelineSpanningTickSpanningOccurrence(msg);
    }

    public void addLostMessage(String fromId, String text, LineType lineType, Message.ArrowType arrowType, String fromLocalId) {
        this.checkState();
        Lifeline from = this.getLifelineException(fromId);
        this.checkLifelineSendMessage(from, fromId);
        LostOrFoundMessage msg = new LostOrFoundMessage(from, false, this.currentTick, text, arrowType, lineType);
        if (fromLocalId != null) {
            this.addOccurrenceSpecification(from, fromId, fromLocalId, msg.sendOccurrenceSpecification());
        }
        this.addLifelineOccurrence(fromId, msg);
    }

    public void addFoundMessage(String toId, String text, LineType lineType, Message.ArrowType arrowType, String toLocalId) {
        this.checkState();
        Lifeline to = this.getLifelineException(toId);
        if (!(to.isCreatedOnStart() || to.getCreated() != null && to.getCreated() < this.currentTick)) {
            throw new SequenceDiagramException("The lifeline " + toId + " was not yet created, therefore it is not possible to send a found message to it.");
        }
        LostOrFoundMessage msg = new LostOrFoundMessage(to, true, this.currentTick, text, arrowType, lineType);
        if (toLocalId != null) {
            this.addOccurrenceSpecification(to, toId, toLocalId, msg.receiveOccurrenceSpecification());
        }
        this.addLifelineOccurrence(toId, msg);
    }

    public void addReceiveGateMessage(String fromId, String text, LineType lineType, Message.ArrowType arrowType, String fromLocalId) {
        this.checkState();
        Lifeline from = this.getLifelineException(fromId);
        this.checkLifelineSendMessage(from, fromId);
        GateMessage msg = GateMessage.createReceiveGateMessage(from, this.currentTick, text, arrowType, lineType, this.dia.getLifelinesArray()[0], this.dia.getLifelinesArray()[this.dia.getLifelinesArray().length - 1]);
        if (fromLocalId != null) {
            this.addOccurrenceSpecification(from, fromId, fromLocalId, msg.sendOccurrenceSpecification());
        }
        this.dia.addLifelineSpanningTickSpanningOccurrence(msg);
    }

    public void addSendGateMessage(String toId, String text, LineType lineType, Message.ArrowType arrowType, String toLocalId) {
        this.checkState();
        Lifeline to = this.getLifelineException(toId);
        GateMessage msg = GateMessage.createSendGateMessage(to, this.currentTick, text, arrowType, lineType, this.dia.getLifelinesArray()[0], this.dia.getLifelinesArray()[this.dia.getLifelinesArray().length - 1]);
        if (toLocalId != null) {
            this.addOccurrenceSpecification(to, toId, toLocalId, msg.receiveOccurrenceSpecification());
        }
        if (!to.isCreatedOnStart() && to.getCreated() == null) {
            to.setCreated(this.currentTick);
        }
        this.dia.addLifelineSpanningTickSpanningOccurrence(msg);
    }

    private void checkLifelineSendMessage(Lifeline from, String id) {
        if (!(from.isCreatedOnStart() || from.getCreated() != null && from.getCreated() < this.currentTick)) {
            throw new SequenceDiagramException("The lifeline " + id + " was not yet created, therefore it is not possible to send a message from it.");
        }
    }

    public void addGeneralOrdering(String earlierLifelineId, String earlierLifelineLocalId, String laterLifelineId, String laterLifelineLocalId) {
        this.checkState();
        this.dia.addLifelineSpanningTickSpanningOccurrence(new GeneralOrdering(this.getLifelineOccurrenceSpecException(earlierLifelineId, earlierLifelineLocalId), this.getLifelineOccurrenceSpecException(laterLifelineId, laterLifelineLocalId), this.getLifelineIntervalException(earlierLifelineId, laterLifelineId)));
    }

    private void addOccurrenceSpecification(Lifeline lifeline, String lifelineId, String localId, OccurrenceSpecification occurrence) {
        if (this.lifelineLocalIds.get(lifeline).containsKey(localId)) {
            throw new SequenceDiagramException("The lifeline '" + lifelineId + "' has already a local id '" + localId + "', please choose another id.");
        }
        this.lifelineLocalIds.get(lifeline).put(localId, occurrence);
    }

    private OccurrenceSpecification getLifelineOccurrenceSpecException(String lifelineId, String localId) {
        Lifeline llifeline = this.getLifelineException(lifelineId);
        OccurrenceSpecification occurrenceSpec = this.lifelineLocalIds.get(llifeline).get(localId);
        if (occurrenceSpec == null) {
            throw new SequenceDiagramException("No lifeline occurrence with the id '" + localId + "' could be found on lifeline '" + lifelineId + "'.");
        }
        return occurrenceSpec;
    }

    public void addInteractionUse(String startId, String endId, String text) {
        this.checkState();
        Lifeline[] lifelines = this.getLifelineIntervalException(startId, endId);
        this.dia.addLifelineSpanningTickSpanningOccurrence(new InteractionUse(this.currentTick, text, lifelines));
    }

    public void addContinuation(String startId, String endId, String text) {
        this.checkState();
        Lifeline[] lifelines = this.getLifelineIntervalException(startId, endId);
        this.dia.addLifelineSpanningTickSpanningOccurrence(new Continuation(this.currentTick, text, lifelines));
    }

    public void beginCombinedFragment(String startId, String endId, String cfId, String operator) {
        this.checkState();
        Lifeline[] lifelines = startId == null && endId == null ? Arrays.copyOf(this.dia.getLifelinesArray(), this.dia.getLifelinesArray().length) : this.getLifelineIntervalException(startId, endId);
        this.activeCombinedFragmentStack.push(new ActiveCombinedFragment(new CombinedFragment(lifelines, this.currentTick, operator), cfId));
        this.activeCombinedFragmentStack.peek().activeOperand = new ActiveOperand(this.currentTick);
    }

    public void endCombinedFragment(String cfId) {
        this.checkState();
        if (this.activeCombinedFragmentStack.size() == 0) {
            throw new SequenceDiagramException("Error a combined fragment was closed, but no open one exists.");
        }
        ActiveCombinedFragment currentCombFrag = null;
        if (cfId == null) {
            currentCombFrag = this.activeCombinedFragmentStack.pop();
        } else {
            ListIterator activeCFIter = this.activeCombinedFragmentStack.listIterator();
            while (activeCFIter.hasNext()) {
                currentCombFrag = (ActiveCombinedFragment)activeCFIter.next();
                if (cfId.equals(currentCombFrag.id)) {
                    activeCFIter.remove();
                    break;
                }
                currentCombFrag = null;
            }
        }
        if (currentCombFrag == null) {
            throw new SequenceDiagramException("Error no combined fragment with id '" + cfId + "' was found.");
        }
        currentCombFrag.combFrag.addOperand(currentCombFrag.activeOperand.startTick, this.currentTick);
        this.dia.addLifelineSpanningTickSpanningOccurrence(currentCombFrag.combFrag);
    }

    public void endAndBeginOperand(String cfId) {
        this.checkState();
        if (this.activeCombinedFragmentStack.size() == 0) {
            throw new SequenceDiagramException("Error a combined fragment was closed, but no open one exists.");
        }
        ActiveCombinedFragment currentCombFrag = null;
        if (cfId == null) {
            currentCombFrag = this.activeCombinedFragmentStack.peek();
        } else {
            ListIterator activeCFIter = this.activeCombinedFragmentStack.listIterator();
            while (activeCFIter.hasNext()) {
                currentCombFrag = (ActiveCombinedFragment)activeCFIter.next();
                if (cfId.equals(currentCombFrag.id)) break;
                currentCombFrag = null;
            }
        }
        if (currentCombFrag == null) {
            throw new SequenceDiagramException("Error no combined fragment with id '" + cfId + "' was found.");
        }
        currentCombFrag.combFrag.addOperand(currentCombFrag.activeOperand.startTick, this.currentTick);
        currentCombFrag.activeOperand = new ActiveOperand(this.currentTick);
    }

    public void tick() {
        this.tick(1);
    }

    public void tick(int tickCount) {
        this.checkState();
        if (tickCount < 1) {
            throw new IllegalArgumentException("The tickCount must be greater than 0.");
        }
        this.currentTick += tickCount;
    }

    public void setOverrideDefaultIds(boolean overrideDefaultIds) {
        this.checkState();
        if (this.dia.getLifelineCount() > 0) {
            throw new SequenceDiagramException("The override ids option must be specified before any lifeline is specified.");
        }
        this.overrideDefaultIds = overrideDefaultIds;
    }

    public boolean isOverrideDefaultIds() {
        return this.overrideDefaultIds;
    }

    public String getWarnings() {
        if (this.warnings.size() == 0) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("Warnings:");
        for (String w : this.warnings) {
            strBuffer.append('\n');
            strBuffer.append(w);
        }
        return strBuffer.toString();
    }

    public SequenceDiagram generateDiagram() {
        boolean openExecSpecs;
        if (this.diagramRetrieved) {
            return this.dia;
        }
        boolean createdLaterWarning = false;
        for (Lifeline ll : this.dia.getLifelines()) {
            if (ll.isCreatedOnStart() || ll.getCreated() != null) continue;
            createdLaterWarning = true;
            ll.setCreatedOnStart(true);
        }
        if (createdLaterWarning) {
            this.warnings.add("At least one lifeline was specified as created later, but didn't receive a message");
        }
        boolean foundOpenExecSpecs = false;
        do {
            openExecSpecs = false;
            for (Map.Entry<Lifeline, LifelineState> e : this.currentLifelineState.entrySet()) {
                if (e.getValue().execSpecStartTickStack.size() <= 0 || e.getValue().lastEndOfExecSpec >= this.currentTick) continue;
                e.getValue().lastEndOfExecSpec = this.currentTick;
                e.getKey().addExecutionSpecification(new ExecutionSpecification(e.getValue().execSpecStartTickStack.pop(), this.currentTick));
                openExecSpecs = openExecSpecs || e.getValue().execSpecStartTickStack.size() > 0;
                foundOpenExecSpecs = true;
            }
            if (!openExecSpecs) continue;
            ++this.currentTick;
        } while (openExecSpecs);
        if (foundOpenExecSpecs) {
            this.warnings.add("At least one executionspecification was not closed, any open executionspecification was closed at the end of the diagram.");
        }
        this.dia.setLastTick(Math.max(this.currentTick, this.lastMessageReceiveTick));
        this.diagramRetrieved = true;
        return this.dia;
    }

    private void checkState() {
        if (this.diagramRetrieved) {
            throw new IllegalStateException("The final diagram was returned and therefore no more changes are allowed.");
        }
    }

    private void addWarning(String id, String text) {
        this.warnings.add("On lifeline '" + id + "': " + text);
    }

    private static class ActiveCombinedFragment {
        String id;
        CombinedFragment combFrag;
        ActiveOperand activeOperand = null;

        public ActiveCombinedFragment(CombinedFragment combFrag, String cfId) {
            this.combFrag = combFrag;
            this.id = cfId;
        }
    }

    private static class ActiveOperand {
        int startTick;

        public ActiveOperand(int startTick) {
            this.startTick = startTick;
        }
    }

    private static class LifelineState {
        int lastEndOfExecSpec = -1;
        LinkedList<Integer> execSpecStartTickStack = new LinkedList();
        boolean coregionActive = false;

        private LifelineState() {
        }
    }
}

