/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.StickLineChange;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.StickingPolygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stickables {
    private static Logger log = LoggerFactory.getLogger(Stickables.class);

    public static StickableMap getStickingPointsWhichAreConnectedToStickingPolygon(StickingPolygon oldStickingPolygon, Collection<? extends Stickable> stickables) {
        int maxDistance = 9;
        log.debug("Polygon to check: " + oldStickingPolygon);
        StickableMap returnMap = new StickableMap();
        for (Stickable stickable : stickables) {
            for (PointDoubleIndexed p : stickable.getStickablePoints()) {
                PointDouble absolutePointPosition = Stickables.getAbsolutePosition(stickable, p);
                for (StickingPolygon.StickLine sl : oldStickingPolygon.getStickLines()) {
                    log.trace("CHECK " + sl + "/" + absolutePointPosition + "/" + maxDistance);
                    if (!sl.isConnected(absolutePointPosition, maxDistance)) continue;
                    returnMap.add(stickable, p);
                }
            }
        }
        return returnMap;
    }

    public static Map<Stickable, List<PointChange>> moveStickPointsBasedOnPolygonChanges(StickingPolygon oldStickingPolygon, StickingPolygon newStickingPolygon, StickableMap stickablePointsToCheck, int maxDistance) {
        if (oldStickingPolygon == null || stickablePointsToCheck == null || stickablePointsToCheck.isEmpty()) {
            return Collections.emptyMap();
        }
        List<StickLineChange> changedStickLines = Stickables.getChangedStickLines(oldStickingPolygon, newStickingPolygon);
        HashMap<Stickable, List<PointChange>> changeList = new HashMap<Stickable, List<PointChange>>();
        for (Stickable stickable : stickablePointsToCheck.getStickables()) {
            List<PointChange> calculatedStickingPointChanges = Stickables.calculateStickingPointChanges(stickable, stickablePointsToCheck.getStickablePoints(stickable), changedStickLines, maxDistance);
            if (calculatedStickingPointChanges.isEmpty()) continue;
            changeList.put(stickable, calculatedStickingPointChanges);
        }
        Stickables.applyChanges(changeList, stickablePointsToCheck);
        return changeList;
    }

    public static void applyChanges(Map<Stickable, List<PointChange>> changeList, StickableMap stickablePointsToCheck) {
        for (Map.Entry<Stickable, List<PointChange>> entry : changeList.entrySet()) {
            Stickable stickable = entry.getKey();
            List<PointDoubleIndexed> updatedChangedPoints = stickable.movePoints(entry.getValue());
            if (stickablePointsToCheck == null) continue;
            stickablePointsToCheck.setStickablePoints(stickable, updatedChangedPoints);
        }
    }

    private static List<StickLineChange> getChangedStickLines(StickingPolygon oldStickingPolygon, StickingPolygon newStickingPolygon) {
        ArrayList<StickLineChange> changedStickLines = new ArrayList<StickLineChange>();
        Iterator<StickingPolygon.StickLine> oldLineIter = oldStickingPolygon.getStickLines().iterator();
        Iterator<StickingPolygon.StickLine> newLineIter = newStickingPolygon.getStickLines().iterator();
        while (oldLineIter.hasNext()) {
            StickingPolygon.StickLine newLine;
            StickingPolygon.StickLine oldLine = oldLineIter.next();
            if (oldLine.equals(newLine = newLineIter.next())) continue;
            changedStickLines.add(new StickLineChange(oldLine, newLine));
        }
        return changedStickLines;
    }

    private static List<PointChange> calculateStickingPointChanges(Stickable stickable, List<PointDoubleIndexed> stickablePoints, List<StickLineChange> changedStickLines, int maxDistance) {
        ArrayList<PointChange> changedPoints = new ArrayList<PointChange>();
        for (PointDoubleIndexed stickablePoint : stickablePoints) {
            PointChange changedPoint;
            PointDouble absolutePosOfStickablePoint = Stickables.getAbsolutePosition(stickable, stickablePoint);
            StickLineChange relevantStickline = Stickables.getNearestStickLineChangeWhichWillChangeTheStickPoint(changedStickLines, absolutePosOfStickablePoint, maxDistance);
            if (relevantStickline == null || (changedPoint = Stickables.calcPointDiffBasedOnStickLineChange(stickablePoint.getIndex(), absolutePosOfStickablePoint, relevantStickline)).getDiffX() == 0 && changedPoint.getDiffY() == 0) continue;
            changedPoints.add(changedPoint);
        }
        return changedPoints;
    }

    static PointChange calcPointDiffBasedOnStickLineChange(Integer index, PointDouble stickablePoint, StickLineChange stickline) {
        StickingPolygon.StickLine oldLine = stickline.getOld();
        StickingPolygon.StickLine newLine = stickline.getNew();
        int diffX = 0;
        int diffY = 0;
        if (newLine.getDirectionOfLine(true).isHorizontal()) {
            diffY = newLine.getStart().getY().intValue() - oldLine.getStart().getY().intValue();
            diffX = Stickables.calcOtherCoordinate(stickablePoint, oldLine, newLine, 0, diffY).getX().intValue();
        } else {
            diffX = newLine.getStart().getX().intValue() - oldLine.getStart().getX().intValue();
            diffY = Stickables.calcOtherCoordinate(stickablePoint, oldLine, newLine, diffX, 0).getY().intValue();
        }
        return new PointChange(index, diffX, diffY);
    }

    private static PointDouble calcOtherCoordinate(PointDouble stickablePoint, StickingPolygon.StickLine oldLine, StickingPolygon.StickLine newLine, int diffX, int diffY) {
        PointDouble stickablePointWithDiff = new PointDouble(stickablePoint.getX() + (double)diffX, stickablePoint.getY() + (double)diffY);
        if (oldLine.getLength() == newLine.getLength()) {
            return new PointDouble(newLine.getStart().getX().intValue() - oldLine.getStart().getX().intValue(), newLine.getStart().getY().intValue() - oldLine.getStart().getY().intValue());
        }
        if (newLine.getDistanceToPoint(stickablePointWithDiff) > 1.0) {
            PointDouble point = newLine.getStart().distance(stickablePointWithDiff) < newLine.getEnd().distance(stickablePointWithDiff) ? newLine.getStart() : newLine.getEnd();
            return new PointDouble(point.getX() - stickablePoint.getX(), point.getY() - stickablePoint.getY());
        }
        return new PointDouble(0.0, 0.0);
    }

    private static StickLineChange getNearestStickLineChangeWhichWillChangeTheStickPoint(List<StickLineChange> changedStickLines, PointDouble absolutePositionOfStickablePoint, int maxDistance) {
        Double lowestDistance = null;
        StickLineChange changeMatchingLowestDistance = null;
        for (StickLineChange change : changedStickLines) {
            double distance = change.getOld().getDistanceToPoint(absolutePositionOfStickablePoint);
            if (!(distance < (double)maxDistance) || lowestDistance != null && !(distance < lowestDistance)) continue;
            lowestDistance = distance;
            changeMatchingLowestDistance = change;
        }
        return changeMatchingLowestDistance;
    }

    private static PointDouble getAbsolutePosition(Stickable stickable, PointDouble pd) {
        int x = stickable.getRealRectangle().getX() + pd.getX().intValue();
        int y = stickable.getRealRectangle().getY() + pd.getY().intValue();
        return new PointDouble(x, y);
    }
}

