/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.AbstractControl;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.control.ExtensionFactory;

public class Control
extends AbstractControl
implements SessionListener {
    private static Logger log = Logger.getLogger(Control.class);
    private static Control control = null;
    private Proxy proxy = null;
    private MenuFileControl menuFileControl = null;
    private MenuToolsControl menuToolsControl = null;
    private SessionListener lastCallback = null;
    private Mode mode = null;

    private Control(Model model, View view) {
        super(model, view);
    }

    private Control() {
        super(null, null);
    }

    private boolean init(ControlOverrides controlOverrides) {
        this.loadExtension();
        Proxy proxy = this.getProxy(controlOverrides);
        this.getExtensionLoader().hookProxyListener(proxy);
        this.getExtensionLoader().hookPersistentConnectionListener(proxy);
        this.getExtensionLoader().hookConnectRequestProxyListeners(proxy);
        if (this.view != null) {
            this.getExtensionLoader().hookSiteMapListener(this.view.getSiteTreePanel());
        }
        this.model.postInit();
        return proxy.startServer();
    }

    public Proxy getProxy() {
        return this.getProxy(null);
    }

    public Proxy getProxy(ControlOverrides controlOverrides) {
        if (this.proxy == null) {
            this.proxy = new Proxy(this.model, controlOverrides);
        }
        return this.proxy;
    }

    @Override
    protected void addExtension() {
        ExtensionFactory.loadAllExtension(this.getExtensionLoader(), this.model.getOptionsParam());
    }

    public MenuFileControl getMenuFileControl() {
        if (this.menuFileControl == null) {
            this.menuFileControl = new MenuFileControl(this.model, this.view, this);
        }
        return this.menuFileControl;
    }

    public MenuToolsControl getMenuToolsControl() {
        if (this.menuToolsControl == null) {
            this.menuToolsControl = new MenuToolsControl(this.model, this.view, this);
        }
        return this.menuToolsControl;
    }

    @Override
    public void shutdown(boolean bl) {
        if (this.view != null) {
            this.view.getRequestPanel().saveConfig(this.model.getOptionsParam().getConfig());
            this.view.getResponsePanel().saveConfig(this.model.getOptionsParam().getConfig());
        }
        try {
            this.model.getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)"Error saving config", (Throwable)configurationException);
        }
        this.getProxy(null).stopServer();
        super.shutdown(bl);
    }

    public void exit(boolean bl, final File file) {
        Object object;
        Object object2;
        boolean bl2;
        boolean bl3 = this.model.getSession().isNewState();
        int n = 0;
        if (!Constant.isLowMemoryOptionSet()) {
            n = this.model.getSession().getSiteTree().getChildCount(this.model.getSession().getSiteTree().getRoot());
        }
        boolean bl4 = this.view != null && Model.getSingleton().getOptionsParam().getViewParam().getAskOnExitOption() > 0;
        boolean bl5 = bl2 = bl3 && n > 0;
        if (!bl) {
            object2 = this.getExtensionLoader().getUnsavedResources();
            if (bl2 && bl4) {
                object2.add(0, (String)Constant.messages.getString("menu.file.exit.message.sessionResNotSaved"));
            }
            object = null;
            String string = Control.wrapEntriesInLiTags(this.getExtensionLoader().getActiveActions());
            if (object2.size() > 0) {
                String string2 = Control.wrapEntriesInLiTags((List<String>)object2);
                object = string.isEmpty() ? MessageFormat.format(Constant.messages.getString("menu.file.exit.message.resourcesNotSaved"), string2) : MessageFormat.format(Constant.messages.getString("menu.file.exit.message.resourcesNotSavedAndActiveActions"), string2, string);
            } else if (!string.isEmpty()) {
                object = MessageFormat.format(Constant.messages.getString("menu.file.exit.message.activeActions"), string);
            }
            if (object != null && this.view.showConfirmDialog((String)object) != 0) {
                return;
            }
        }
        if (bl2) {
            control.discardSession();
        }
        object2 = new Thread(new Runnable(){

            @Override
            public void run() {
                control.shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                log.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
                if (file != null && Desktop.isDesktopSupported()) {
                    try {
                        log.info((Object)("Openning file " + file.getAbsolutePath()));
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        log.error((Object)("Failed to open file " + file.getAbsolutePath()), (Throwable)iOException);
                    }
                }
                System.exit(0);
            }
        });
        if (this.view != null) {
            object = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.shuttingDown"));
            ((Thread)object2).start();
            ((AbstractDialog)object).setVisible(true);
        } else {
            ((Thread)object2).start();
        }
    }

    private static String wrapEntriesInLiTags(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 15);
        for (String string : list) {
            stringBuilder.append("<li>");
            stringBuilder.append(string);
            stringBuilder.append("</li>");
        }
        return stringBuilder.toString();
    }

    public void exitAndDeleteSession(String string) {
        this.shutdown(false);
        Model.getSingleton().getDb().deleteSession(string);
        log.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
        System.exit(0);
    }

    public static Control getSingleton() {
        return control;
    }

    public static boolean initSingletonWithView(ControlOverrides controlOverrides) {
        control = new Control(Model.getSingleton(), View.getSingleton());
        return control.init(controlOverrides);
    }

    public static boolean initSingletonWithoutView(ControlOverrides controlOverrides) {
        control = new Control(Model.getSingleton(), null);
        return control.init(controlOverrides);
    }

    public static void initSingletonForTesting() {
        control = new Control();
    }

    public void runCommandLine() throws Exception {
        log.debug((Object)"runCommand");
        this.getExtensionLoader().runCommandLine();
    }

    public void runCommandLineNewSession(String string) throws Exception {
        log.debug((Object)("runCommandLineNewSession " + string));
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.createAndOpenUntitledDb();
        final Session session = this.model.newSession();
        this.model.saveSession(string);
        if (View.isInitialised()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Control.this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
                    Control.this.view.getMainFrame().setTitle(session.getSessionName());
                    Control.this.view.getOutputPanel().clear();
                }
            });
        }
        log.info((Object)"New session file created");
        control.getExtensionLoader().databaseOpen(this.model.getDb());
        control.getExtensionLoader().sessionChangedAllPlugin(session);
    }

    public void runCommandLineOpenSession(String string) throws Exception {
        log.debug((Object)("runCommandLineOpenSession " + string));
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        Session session = Model.getSingleton().getSession();
        Model.getSingleton().openSession(string);
        log.info((Object)"Session file opened");
        control.getExtensionLoader().databaseOpen(this.model.getDb());
        control.getExtensionLoader().sessionChangedAllPlugin(session);
    }

    public void setExcludeFromProxyUrls(List<String> list) {
        this.getProxy(null).setIgnoreList(list);
    }

    public void openSession(File file, SessionListener sessionListener) {
        log.info((Object)"Open Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = sessionListener;
        this.model.openSession(file, (SessionListener)this);
    }

    public void openSession(String string, SessionListener sessionListener) {
        log.info((Object)"Open Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = sessionListener;
        this.model.openSession(string, (SessionListener)this);
    }

    public Session newSession() throws Exception {
        log.info((Object)"New Session");
        this.closeSessionAndCreateAndOpenUntitledDb();
        final Session session = this.model.newSession();
        this.getExtensionLoader().databaseOpen(this.model.getDb());
        this.getExtensionLoader().sessionChangedAllPlugin(session);
        if (View.isInitialised()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Control.this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
                    Control.this.view.getSiteTreePanel().reloadContextTree();
                }
            });
            this.view.getMainFrame().setTitle(session.getSessionName());
            this.view.getOutputPanel().clear();
        }
        try {
            this.model.getDb().getTableSession().insert(session.getSessionId(), session.getSessionName());
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        return session;
    }

    private void closeSessionAndCreateAndOpenUntitledDb() throws Exception {
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.closeSession();
        log.info((Object)"Create and Open Untitled Db");
        this.model.createAndOpenUntitledDb();
    }

    public void newSession(String string, SessionListener sessionListener) {
        block2: {
            log.info((Object)"New Session");
            try {
                this.closeSessionAndCreateAndOpenUntitledDb();
                this.lastCallback = sessionListener;
                this.model.newSession();
                this.model.saveSession(string, this);
            }
            catch (Exception exception) {
                if (this.lastCallback == null) break block2;
                this.lastCallback.sessionSaved(exception);
                this.lastCallback = null;
            }
        }
    }

    public void saveSession(String string) {
        this.saveSession(string, null);
    }

    public void saveSession(String string, SessionListener sessionListener) {
        log.info((Object)"Save Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = sessionListener;
        this.model.saveSession(string, this);
    }

    public void snapshotSession(String string, SessionListener sessionListener) {
        log.info((Object)"Snapshot Session");
        this.lastCallback = sessionListener;
        this.model.snapshotSession(string, this);
    }

    public void discardSession() {
        log.info((Object)"Discard Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.discardSession();
        this.getExtensionLoader().sessionChangedAllPlugin(null);
    }

    @Deprecated
    public void createAndOpenUntitledDb() throws ClassNotFoundException, Exception {
        log.info((Object)"Create and Open Untitled Db");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.closeSession();
        this.model.createAndOpenUntitledDb();
        this.getExtensionLoader().databaseOpen(this.model.getDb());
        this.getExtensionLoader().sessionChangedAllPlugin(this.model.getSession());
    }

    @Override
    public void sessionOpened(File file, Exception exception) {
        this.getExtensionLoader().databaseOpen(this.model.getDb());
        this.getExtensionLoader().sessionChangedAllPlugin(this.model.getSession());
        if (this.lastCallback != null) {
            this.lastCallback.sessionOpened(file, exception);
            this.lastCallback = null;
        }
    }

    @Override
    public void sessionSaved(Exception exception) {
        this.getExtensionLoader().databaseOpen(this.model.getDb());
        this.getExtensionLoader().sessionChangedAllPlugin(this.model.getSession());
        if (this.lastCallback != null) {
            this.lastCallback.sessionSaved(exception);
            this.lastCallback = null;
        }
    }

    @Override
    public void sessionSnapshot(Exception exception) {
        if (this.lastCallback != null) {
            this.lastCallback.sessionSnapshot(exception);
            this.lastCallback = null;
        }
    }

    public void sessionScopeChanged() {
        this.getExtensionLoader().sessionScopeChangedAllPlugin(this.model.getSession());
    }

    public Mode getMode() {
        if (this.mode == null) {
            this.mode = Mode.valueOf(this.model.getOptionsParam().getViewParam().getMode());
        }
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.getExtensionLoader().sessionModeChangedAllPlugin(mode);
        this.model.getOptionsParam().getViewParam().setMode(mode.name());
    }

    public static enum Mode {
        safe,
        protect,
        standard,
        attack;

    }
}

