/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.IntegerField;
import com.sun.javafx.scene.control.skin.IntegerFieldSkin;
import com.sun.javafx.scene.control.skin.WebColorField;
import com.sun.javafx.scene.control.skin.WebColorFieldSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class CustomColorDialog
extends StackPane {
    private static final int CONTENT_PADDING = 10;
    private static final int RECT_SIZE = 200;
    private static final int CONTROLS_WIDTH = 256;
    private static final int COLORBAR_GAP = 9;
    private static final int LABEL_GAP = 2;
    final Stage dialog = new Stage();
    ColorRectPane colorRectPane;
    ControlsPane controlsPane;
    Circle colorRectIndicator;
    Rectangle colorRect;
    Rectangle colorRectOverlayOne;
    Rectangle colorRectOverlayTwo;
    Rectangle colorBar;
    Rectangle colorBarIndicator;
    private Color currentColor = Color.WHITE;
    ObjectProperty<Color> customColorProperty = new SimpleObjectProperty<Color>(Color.TRANSPARENT);
    boolean saveCustomColor = false;
    boolean useCustomColor = false;
    Button saveButton;
    Button useButton;
    private WebColorField webField = null;
    private Scene customScene;
    private final EventHandler<KeyEvent> keyEventListener = new EventHandler<KeyEvent>(){

        @Override
        public void handle(KeyEvent keyEvent) {
            switch (keyEvent.getCode()) {
                case ESCAPE: {
                    CustomColorDialog.this.dialog.setScene(null);
                    CustomColorDialog.this.dialog.close();
                }
            }
        }
    };

    public CustomColorDialog(Window window) {
        this.getStyleClass().add("custom-color-dialog");
        if (window != null) {
            this.dialog.initOwner(window);
        }
        this.dialog.setTitle("Custom Colors..");
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.UTILITY);
        this.colorRectPane = new ColorRectPane();
        this.controlsPane = new ControlsPane();
        this.customScene = new Scene(this);
        this.getChildren().addAll((Node[])new Node[]{this.colorRectPane, this.controlsPane});
        this.dialog.setScene(this.customScene);
        this.dialog.addEventHandler(KeyEvent.ANY, this.keyEventListener);
    }

    public void setCurrentColor(Color color) {
        this.currentColor = color;
        this.controlsPane.currentColorRect.setFill(color);
    }

    public void show(double d, double d2) {
        if (d != 0.0 && d2 != 0.0) {
            this.dialog.setX(d);
            this.dialog.setY(d2);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.colorRectPane.updateValues();
        this.dialog.show();
    }

    @Override
    public void layoutChildren() {
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        this.controlsPane.relocate(d + this.colorRectPane.prefWidth(-1.0), 0.0);
    }

    @Override
    public double computePrefWidth(double d) {
        return this.getInsets().getLeft() + this.colorRectPane.prefWidth(d) + this.controlsPane.prefWidth(d) + this.getInsets().getRight();
    }

    @Override
    public double computePrefHeight(double d) {
        return this.getInsets().getTop() + Math.max(this.colorRectPane.prefHeight(d), this.controlsPane.prefHeight(d) + this.getInsets().getBottom());
    }

    static double computeXOffset(double d, double d2, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case RIGHT: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d, double d2, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case BOTTOM: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double clamp(double d) {
        return d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
    }

    private static LinearGradient createHueGradient() {
        Stop[] stopArray = new Stop[255];
        for (int i = 0; i < 255; ++i) {
            double d = 1.0 - 0.00392156862745098 * (double)i;
            int n = (int)((double)i / 255.0 * 360.0);
            stopArray[i] = new Stop(d, Color.hsb(n, 1.0, 1.0));
        }
        return new LinearGradient(0.0, 1.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
    }

    private static int doubleToInt(double d) {
        return new Double(d * 255.0).intValue();
    }

    class ColorRectPane
    extends StackPane {
        private boolean changeIsLocal = false;
        DoubleProperty hue = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        DoubleProperty sat = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        DoubleProperty bright = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private ObjectProperty<Color> color = new SimpleObjectProperty<Color>();
        IntegerProperty red = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        IntegerProperty green = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        IntegerProperty blue = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        DoubleProperty alpha = new SimpleDoubleProperty(100.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    switch (CustomColorDialog.this.controlsPane.colorSettingsMode) {
                        case HSB: {
                            ColorRectPane.this.updateHSBColor();
                            break;
                        }
                        case RGB: {
                            ColorRectPane.this.updateRGBColor();
                            break;
                        }
                    }
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };

        public ObjectProperty<Color> colorProperty() {
            return this.color;
        }

        public Color getColor() {
            return (Color)this.color.get();
        }

        public void setColor(Color color) {
            this.color.set(color);
        }

        private void updateRGBColor() {
            this.setColor(Color.rgb(this.red.get(), this.green.get(), this.blue.get(), CustomColorDialog.clamp(this.alpha.get() / 100.0)));
            this.hue.set(this.getColor().getHue());
            this.sat.set(this.getColor().getSaturation() * 100.0);
            this.bright.set(this.getColor().getBrightness() * 100.0);
        }

        private void updateHSBColor() {
            this.setColor(Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0)));
            this.red.set(CustomColorDialog.doubleToInt(this.getColor().getRed()));
            this.green.set(CustomColorDialog.doubleToInt(this.getColor().getGreen()));
            this.blue.set(CustomColorDialog.doubleToInt(this.getColor().getBlue()));
        }

        private void colorChanged() {
            if (!this.changeIsLocal) {
                this.changeIsLocal = true;
                this.hue.set(this.getColor().getHue());
                this.sat.set(this.getColor().getSaturation() * 100.0);
                this.bright.set(this.getColor().getBrightness() * 100.0);
                this.red.set(CustomColorDialog.doubleToInt(this.getColor().getRed()));
                this.green.set(CustomColorDialog.doubleToInt(this.getColor().getGreen()));
                this.blue.set(CustomColorDialog.doubleToInt(this.getColor().getBlue()));
                this.changeIsLocal = false;
            }
        }

        public ColorRectPane() {
            this.getStyleClass().add("color-rect-pane");
            this.color.addListener(new ChangeListener<Color>(){

                @Override
                public void changed(ObservableValue<? extends Color> observableValue, Color color, Color color2) {
                    ColorRectPane.this.colorChanged();
                }
            });
            CustomColorDialog.this.colorRectIndicator = new Circle(60.0, 60.0, 5.0, null);
            CustomColorDialog.this.colorRectIndicator.setStroke(Color.WHITE);
            CustomColorDialog.this.colorRectIndicator.setEffect(new DropShadow(2.0, 0.0, 1.0, Color.BLACK));
            CustomColorDialog.this.colorRect = new Rectangle(200.0, 200.0);
            this.colorProperty().addListener(new ChangeListener<Color>(){

                @Override
                public void changed(ObservableValue<? extends Color> observableValue, Color color, Color color2) {
                    CustomColorDialog.this.colorRect.setFill(Color.hsb(ColorRectPane.this.hue.getValue(), 1.0, 1.0, CustomColorDialog.clamp(ColorRectPane.this.alpha.get() / 100.0)));
                }
            });
            CustomColorDialog.this.colorRectOverlayOne = new Rectangle(200.0, 200.0);
            CustomColorDialog.this.colorRectOverlayOne.setFill(new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(255, 255, 255, 1.0)), new Stop(1.0, Color.rgb(255, 255, 255, 0.0))));
            CustomColorDialog.this.colorRectOverlayOne.setStroke(Utils.deriveColor(Color.web("#d0d0d0"), 0.0));
            EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    double d = mouseEvent.getX();
                    double d2 = mouseEvent.getY();
                    ColorRectPane.this.sat.set(CustomColorDialog.clamp(d / 200.0) * 100.0);
                    ColorRectPane.this.bright.set(100.0 - CustomColorDialog.clamp(d2 / 200.0) * 100.0);
                }
            };
            CustomColorDialog.this.colorRectOverlayTwo = new Rectangle(200.0, 200.0);
            CustomColorDialog.this.colorRectOverlayTwo.setFill(new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(0, 0, 0, 0.0)), new Stop(1.0, Color.rgb(0, 0, 0, 1.0))));
            CustomColorDialog.this.colorRectOverlayTwo.setOnMouseDragged((EventHandler<? super MouseEvent>)eventHandler);
            CustomColorDialog.this.colorRectOverlayTwo.setOnMouseClicked((EventHandler<? super MouseEvent>)eventHandler);
            CustomColorDialog.this.colorBar = new Rectangle(20.0, 200.0);
            CustomColorDialog.this.colorBar.setFill(CustomColorDialog.createHueGradient());
            CustomColorDialog.this.colorBar.setStroke(Utils.deriveColor(Color.web("#d0d0d0"), 0.0));
            CustomColorDialog.this.colorBarIndicator = new Rectangle(24.0, 10.0, null);
            CustomColorDialog.this.colorBarIndicator.setLayoutX(10.0 + CustomColorDialog.this.colorRect.getWidth() + 13.0);
            CustomColorDialog.this.colorBarIndicator.setLayoutY(10.0 + CustomColorDialog.this.colorBar.getHeight() * (this.hue.get() / 360.0));
            CustomColorDialog.this.colorBarIndicator.setArcWidth(4.0);
            CustomColorDialog.this.colorBarIndicator.setArcHeight(4.0);
            CustomColorDialog.this.colorBarIndicator.setStroke(Color.WHITE);
            CustomColorDialog.this.colorBarIndicator.setEffect(new DropShadow(2.0, 0.0, 1.0, Color.BLACK));
            this.hue.addListener(new ChangeListener<Number>(){

                @Override
                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    CustomColorDialog.this.colorBarIndicator.setLayoutY(10.0 + 200.0 * (ColorRectPane.this.hue.get() / 360.0));
                }
            });
            this.sat.addListener(new ChangeListener<Number>(){

                @Override
                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    CustomColorDialog.this.colorRectIndicator.setCenterX(10.0 + CustomColorDialog.this.colorRectIndicator.getRadius() + 200.0 * (ColorRectPane.this.sat.get() / 100.0));
                }
            });
            this.bright.addListener(new ChangeListener<Number>(){

                @Override
                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    CustomColorDialog.this.colorRectIndicator.setCenterY(10.0 + CustomColorDialog.this.colorRectIndicator.getRadius() + 200.0 * (1.0 - ColorRectPane.this.bright.get() / 100.0));
                }
            });
            this.alpha.addListener(new ChangeListener<Number>(){

                @Override
                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                }
            });
            EventHandler<MouseEvent> eventHandler2 = new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    double d = mouseEvent.getY();
                    ColorRectPane.this.hue.set(CustomColorDialog.clamp(d / 200.0) * 360.0);
                }
            };
            CustomColorDialog.this.colorBar.setOnMouseDragged((EventHandler<? super MouseEvent>)eventHandler2);
            CustomColorDialog.this.colorBar.setOnMouseClicked((EventHandler<? super MouseEvent>)eventHandler2);
            this.getChildren().addAll((Node[])new Node[]{CustomColorDialog.this.colorRect, CustomColorDialog.this.colorRectOverlayOne, CustomColorDialog.this.colorRectOverlayTwo, CustomColorDialog.this.colorBar, CustomColorDialog.this.colorRectIndicator, CustomColorDialog.this.colorBarIndicator});
        }

        private void updateValues() {
            this.changeIsLocal = true;
            this.hue.set(CustomColorDialog.this.currentColor.getHue());
            this.sat.set(CustomColorDialog.this.currentColor.getSaturation() * 100.0);
            this.bright.set(CustomColorDialog.this.currentColor.getBrightness() * 100.0);
            this.setColor(Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0)));
            this.red.set(CustomColorDialog.doubleToInt(this.getColor().getRed()));
            this.green.set(CustomColorDialog.doubleToInt(this.getColor().getGreen()));
            this.blue.set(CustomColorDialog.doubleToInt(this.getColor().getBlue()));
            this.changeIsLocal = false;
        }

        @Override
        public void layoutChildren() {
            double d = this.getInsets().getLeft();
            double d2 = this.getInsets().getTop();
            CustomColorDialog.this.colorRect.relocate(d, d2);
            CustomColorDialog.this.colorRectOverlayOne.relocate(d, d2);
            CustomColorDialog.this.colorRectOverlayTwo.relocate(d, d2);
            CustomColorDialog.this.colorBar.relocate(d + CustomColorDialog.this.colorRect.prefWidth(-1.0) + 9.0, d2);
        }

        @Override
        public double computePrefWidth(double d) {
            return this.getInsets().getLeft() + CustomColorDialog.this.colorRect.prefWidth(-1.0) + 9.0 + CustomColorDialog.this.colorBar.prefWidth(-1.0) + (CustomColorDialog.this.colorBarIndicator.getBoundsInParent().getWidth() - CustomColorDialog.this.colorBar.prefWidth(-1.0)) + this.getInsets().getRight();
        }
    }

    static enum ColorSettingsMode {
        HSB,
        RGB,
        WEB;

    }

    class ControlsPane
    extends StackPane {
        Label currentColorLabel;
        Label newColorLabel;
        Rectangle currentColorRect;
        Rectangle newColorRect;
        StackPane currentTransparent;
        StackPane newTransparent;
        GridPane currentAndNewColor;
        Rectangle currentNewColorBorder;
        ToggleButton hsbButton;
        ToggleButton rgbButton;
        ToggleButton webButton;
        HBox hBox;
        GridPane hsbSettings;
        GridPane rgbSettings;
        GridPane webSettings;
        GridPane alphaSettings;
        HBox buttonBox;
        StackPane whiteBox;
        ColorSettingsMode colorSettingsMode = ColorSettingsMode.HSB;
        StackPane settingsPane = new StackPane();

        public ControlsPane() {
            this.getStyleClass().add("controls-pane");
            this.currentNewColorBorder = new Rectangle(256.0, 18.0, null);
            this.currentNewColorBorder.setStroke(Utils.deriveColor(Color.web("#d0d0d0"), 0.0));
            this.currentNewColorBorder.setStrokeWidth(2.0);
            this.currentTransparent = new StackPane();
            this.currentTransparent.setPrefSize(128.0, 18.0);
            this.currentTransparent.setId("transparent-current");
            this.newTransparent = new StackPane();
            this.newTransparent.setPrefSize(128.0, 18.0);
            this.newTransparent.setId("transparent-new");
            this.currentColorRect = new Rectangle(128.0, 18.0);
            this.currentColorRect.setFill(CustomColorDialog.this.currentColor);
            this.newColorRect = new Rectangle(128.0, 18.0);
            this.updateNewColorFill();
            CustomColorDialog.this.colorRectPane.color.addListener(new ChangeListener<Color>(){

                @Override
                public void changed(ObservableValue<? extends Color> observableValue, Color color, Color color2) {
                    ControlsPane.this.updateNewColorFill();
                    CustomColorDialog.this.customColorProperty.set(Color.hsb(CustomColorDialog.this.colorRectPane.hue.getValue(), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.sat.getValue() / 100.0), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.bright.getValue() / 100.0), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.alpha.getValue() / 100.0)));
                }
            });
            this.currentColorLabel = new Label("Current Color");
            this.newColorLabel = new Label("New Color");
            Rectangle rectangle = new Rectangle(0.0, 12.0);
            this.whiteBox = new StackPane();
            this.whiteBox.getStyleClass().add("customcolor-controls-background");
            this.hsbButton = new ToggleButton("HSB");
            this.hsbButton.setId("toggle-button-left");
            this.rgbButton = new ToggleButton("RGB");
            this.rgbButton.setId("toggle-button-center");
            this.webButton = new ToggleButton("Web");
            this.webButton.setId("toggle-button-right");
            ToggleGroup toggleGroup = new ToggleGroup();
            this.hsbButton.setToggleGroup(toggleGroup);
            this.rgbButton.setToggleGroup(toggleGroup);
            this.webButton.setToggleGroup(toggleGroup);
            toggleGroup.selectToggle(this.hsbButton);
            this.showHSBSettings();
            this.hsbButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (ControlsPane.this.colorSettingsMode != ColorSettingsMode.HSB) {
                        ControlsPane.this.colorSettingsMode = ColorSettingsMode.HSB;
                        ControlsPane.this.showHSBSettings();
                        ControlsPane.this.requestLayout();
                    }
                }
            });
            this.rgbButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (ControlsPane.this.colorSettingsMode != ColorSettingsMode.RGB) {
                        ControlsPane.this.colorSettingsMode = ColorSettingsMode.RGB;
                        ControlsPane.this.showRGBSettings();
                        ControlsPane.this.requestLayout();
                    }
                }
            });
            this.webButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (ControlsPane.this.colorSettingsMode != ColorSettingsMode.WEB) {
                        ControlsPane.this.colorSettingsMode = ColorSettingsMode.WEB;
                        ControlsPane.this.showWebSettings();
                        ControlsPane.this.requestLayout();
                    }
                }
            });
            this.hBox = new HBox();
            this.hBox.getChildren().addAll((Node[])new Node[]{this.hsbButton, this.rgbButton, this.webButton});
            this.currentAndNewColor = new GridPane();
            this.currentAndNewColor.getStyleClass().add("current-new-color-grid");
            this.currentAndNewColor.add(this.currentColorLabel, 0, 0, 2, 1);
            this.currentAndNewColor.add(this.newColorLabel, 2, 0, 2, 1);
            Region region = new Region();
            region.setPadding(new Insets(1.0, 128.0, 1.0, 128.0));
            this.currentAndNewColor.add(region, 0, 1, 4, 1);
            this.currentAndNewColor.add(this.currentTransparent, 0, 2, 2, 1);
            this.currentAndNewColor.add(this.currentColorRect, 0, 2, 2, 1);
            this.currentAndNewColor.add(this.newTransparent, 2, 2, 2, 1);
            this.currentAndNewColor.add(this.newColorRect, 2, 2, 2, 1);
            this.currentAndNewColor.add(rectangle, 0, 3, 4, 1);
            this.alphaSettings = new GridPane();
            this.alphaSettings.setHgap(5.0);
            this.alphaSettings.setVgap(0.0);
            this.alphaSettings.setManaged(false);
            this.alphaSettings.getStyleClass().add("alpha-settings");
            Rectangle rectangle2 = new Rectangle(0.0, 12.0);
            this.alphaSettings.add(rectangle2, 0, 0, 3, 1);
            Label label = new Label("Opacity:");
            label.setPrefWidth(68.0);
            this.alphaSettings.add(label, 0, 1);
            Slider slider = new Slider(0.0, 100.0, 50.0);
            slider.setPrefWidth(100.0);
            this.alphaSettings.add(slider, 1, 1);
            IntegerField integerField = new IntegerField(100);
            integerField.setSkin(new IntegerFieldSkin(integerField));
            integerField.setPrefColumnCount(3);
            integerField.setMaxWidth(38.0);
            this.alphaSettings.add(integerField, 2, 1);
            integerField.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.alpha);
            slider.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.alpha);
            Rectangle rectangle3 = new Rectangle(0.0, 15.0);
            this.alphaSettings.add(rectangle3, 0, 2, 3, 1);
            this.buttonBox = new HBox(4.0);
            CustomColorDialog.this.saveButton = new Button("Save");
            CustomColorDialog.this.saveButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    CustomColorDialog.this.saveCustomColor = true;
                    if (ControlsPane.this.colorSettingsMode == ColorSettingsMode.WEB) {
                        CustomColorDialog.this.customColorProperty.set((Color)CustomColorDialog.this.webField.valueProperty().get());
                    } else {
                        CustomColorDialog.this.customColorProperty.set(Color.rgb(CustomColorDialog.this.colorRectPane.red.get(), CustomColorDialog.this.colorRectPane.green.get(), CustomColorDialog.this.colorRectPane.blue.get(), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.alpha.get() / 100.0)));
                    }
                    CustomColorDialog.this.dialog.hide();
                    CustomColorDialog.this.saveCustomColor = false;
                }
            });
            CustomColorDialog.this.useButton = new Button("Use");
            CustomColorDialog.this.useButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    CustomColorDialog.this.useCustomColor = true;
                    CustomColorDialog.this.customColorProperty.set(Color.rgb(CustomColorDialog.this.colorRectPane.red.get(), CustomColorDialog.this.colorRectPane.green.get(), CustomColorDialog.this.colorRectPane.blue.get(), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.alpha.get() / 100.0)));
                    CustomColorDialog.this.dialog.hide();
                    CustomColorDialog.this.useCustomColor = false;
                }
            });
            Button button = new Button("Cancel");
            button.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    CustomColorDialog.this.customColorProperty.set(CustomColorDialog.this.currentColor);
                    CustomColorDialog.this.dialog.hide();
                }
            });
            this.buttonBox.getChildren().addAll((Node[])new Node[]{CustomColorDialog.this.saveButton, CustomColorDialog.this.useButton, button});
            this.getChildren().addAll((Node[])new Node[]{this.currentAndNewColor, this.currentNewColorBorder, this.whiteBox, this.hBox, this.settingsPane, this.alphaSettings, this.buttonBox});
        }

        private void updateNewColorFill() {
            this.newColorRect.setFill(Color.hsb(CustomColorDialog.this.colorRectPane.hue.getValue(), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.sat.getValue() / 100.0), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.bright.getValue() / 100.0), CustomColorDialog.clamp(CustomColorDialog.this.colorRectPane.alpha.getValue() / 100.0)));
        }

        private void showHSBSettings() {
            if (this.hsbSettings == null) {
                this.hsbSettings = new GridPane();
                this.hsbSettings.setHgap(5.0);
                this.hsbSettings.setVgap(4.0);
                this.hsbSettings.setManaged(false);
                Region region = new Region();
                region.setPrefHeight(3.0);
                this.hsbSettings.add(region, 0, 0, 3, 1);
                Label label = new Label("Hue:");
                label.setMinWidth(68.0);
                this.hsbSettings.add(label, 0, 1);
                Slider slider = new Slider(0.0, 360.0, 100.0);
                slider.setPrefWidth(100.0);
                this.hsbSettings.add(slider, 1, 1);
                IntegerField integerField = new IntegerField(360);
                integerField.setSkin(new IntegerFieldSkin(integerField));
                integerField.setPrefColumnCount(3);
                integerField.setMaxWidth(38.0);
                this.hsbSettings.add(integerField, 2, 1);
                integerField.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.hue);
                slider.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.hue);
                Label label2 = new Label("Saturation:");
                label2.setMinWidth(68.0);
                this.hsbSettings.add(label2, 0, 2);
                Slider slider2 = new Slider(0.0, 100.0, 50.0);
                slider2.setPrefWidth(100.0);
                this.hsbSettings.add(slider2, 1, 2);
                IntegerField integerField2 = new IntegerField(100);
                integerField2.setSkin(new IntegerFieldSkin(integerField2));
                integerField2.setPrefColumnCount(3);
                integerField2.setMaxWidth(38.0);
                this.hsbSettings.add(integerField2, 2, 2);
                integerField2.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.sat);
                slider2.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.sat);
                Label label3 = new Label("Brightness:");
                label3.setMinWidth(68.0);
                this.hsbSettings.add(label3, 0, 3);
                Slider slider3 = new Slider(0.0, 100.0, 50.0);
                slider3.setPrefWidth(100.0);
                this.hsbSettings.add(slider3, 1, 3);
                IntegerField integerField3 = new IntegerField(100);
                integerField3.setSkin(new IntegerFieldSkin(integerField3));
                integerField3.setPrefColumnCount(3);
                integerField3.setMaxWidth(38.0);
                this.hsbSettings.add(integerField3, 2, 3);
                integerField3.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.bright);
                slider3.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.bright);
                Region region2 = new Region();
                region2.setPrefHeight(4.0);
                this.hsbSettings.add(region2, 0, 4, 3, 1);
            }
            this.settingsPane.getChildren().setAll((Node[])new Node[]{this.hsbSettings});
        }

        private void showRGBSettings() {
            if (this.rgbSettings == null) {
                this.rgbSettings = new GridPane();
                this.rgbSettings.setHgap(5.0);
                this.rgbSettings.setVgap(4.0);
                this.rgbSettings.setManaged(false);
                Region region = new Region();
                region.setPrefHeight(3.0);
                this.rgbSettings.add(region, 0, 0, 3, 1);
                Label label = new Label("Red:");
                label.setMinWidth(68.0);
                this.rgbSettings.add(label, 0, 1);
                Slider slider = new Slider(0.0, 255.0, 100.0);
                slider.setPrefWidth(100.0);
                this.rgbSettings.add(slider, 1, 1);
                IntegerField integerField = new IntegerField(255);
                integerField.setSkin(new IntegerFieldSkin(integerField));
                integerField.setMaxWidth(38.0);
                this.rgbSettings.add(integerField, 2, 1);
                integerField.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.red);
                slider.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.red);
                Label label2 = new Label("Green:     ");
                label2.setMinWidth(68.0);
                this.rgbSettings.add(label2, 0, 2);
                Slider slider2 = new Slider(0.0, 255.0, 100.0);
                slider2.setPrefWidth(100.0);
                this.rgbSettings.add(slider2, 1, 2);
                IntegerField integerField2 = new IntegerField(255);
                integerField2.setSkin(new IntegerFieldSkin(integerField2));
                integerField2.setMaxWidth(38.0);
                this.rgbSettings.add(integerField2, 2, 2);
                integerField2.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.green);
                slider2.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.green);
                Label label3 = new Label("Blue:      ");
                label3.setMinWidth(68.0);
                this.rgbSettings.add(label3, 0, 3);
                Slider slider3 = new Slider(0.0, 255.0, 100.0);
                slider3.setPrefWidth(100.0);
                this.rgbSettings.add(slider3, 1, 3);
                IntegerField integerField3 = new IntegerField(255);
                integerField3.setSkin(new IntegerFieldSkin(integerField3));
                integerField3.setMaxWidth(38.0);
                this.rgbSettings.add(integerField3, 2, 3);
                Region region2 = new Region();
                region2.setPrefHeight(4.0);
                this.rgbSettings.add(region2, 0, 4, 3, 1);
                integerField3.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.blue);
                slider3.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.blue);
            }
            this.settingsPane.getChildren().setAll((Node[])new Node[]{this.rgbSettings});
        }

        private void showWebSettings() {
            if (this.webSettings == null) {
                this.webSettings = new GridPane();
                this.webSettings.setHgap(5.0);
                this.webSettings.setVgap(4.0);
                this.webSettings.setManaged(false);
                Region region = new Region();
                region.setPrefHeight(3.0);
                this.webSettings.add(region, 0, 0, 3, 1);
                Label label = new Label("Web:        ");
                label.setMinWidth(Double.NEGATIVE_INFINITY);
                this.webSettings.add(label, 0, 1);
                CustomColorDialog.this.webField = new WebColorField();
                CustomColorDialog.this.webField.setSkin(new WebColorFieldSkin(CustomColorDialog.this.webField));
                CustomColorDialog.this.webField.valueProperty().bindBidirectional(CustomColorDialog.this.colorRectPane.colorProperty());
                CustomColorDialog.this.webField.setPrefColumnCount(6);
                this.webSettings.add(CustomColorDialog.this.webField, 1, 1);
                Region region2 = new Region();
                region2.setPrefHeight(22.0);
                this.webSettings.add(region2, 0, 2, 3, 1);
                Region region3 = new Region();
                region3.setPrefHeight(22.0);
                this.webSettings.add(region3, 0, 3, 3, 1);
                Region region4 = new Region();
                region4.setPrefHeight(4.0);
                this.webSettings.add(region4, 0, 4, 3, 1);
            }
            this.settingsPane.getChildren().setAll((Node[])new Node[]{this.webSettings});
        }

        public Label getCurrentColorLabel() {
            return this.currentColorLabel;
        }

        @Override
        public void layoutChildren() {
            double d = this.getInsets().getLeft();
            double d2 = this.getInsets().getTop();
            this.currentAndNewColor.resizeRelocate(d, d2, 256.0, 18.0);
            this.currentNewColorBorder.relocate(d, d2 + CustomColorDialog.this.controlsPane.currentColorLabel.prefHeight(-1.0) + 2.0);
            double d3 = CustomColorDialog.computeXOffset(this.currentAndNewColor.prefWidth(-1.0), this.hBox.prefWidth(-1.0), HPos.CENTER);
            GridPane gridPane = (GridPane)this.settingsPane.getChildren().get(0);
            gridPane.resize(228.0, gridPane.prefHeight(-1.0));
            double d4 = ((Node)this.settingsPane.getChildren().get(0)).prefHeight(-1.0);
            this.whiteBox.resizeRelocate(d, d2 + this.currentAndNewColor.prefHeight(-1.0) + this.hBox.prefHeight(-1.0) / 2.0, 256.0, d4 + this.hBox.prefHeight(-1.0) / 2.0);
            this.hBox.resizeRelocate(d + d3, d2 + this.currentAndNewColor.prefHeight(-1.0), this.hBox.prefWidth(-1.0), this.hBox.prefHeight(-1.0));
            this.settingsPane.resizeRelocate(d + 10.0, d2 + this.currentAndNewColor.prefHeight(-1.0) + this.hBox.prefHeight(-1.0), 228.0, d4);
            this.alphaSettings.resizeRelocate(d + 10.0, d2 + this.currentAndNewColor.prefHeight(-1.0) + this.hBox.prefHeight(-1.0) + d4, 228.0, this.alphaSettings.prefHeight(-1.0));
            double d5 = CustomColorDialog.computeXOffset(this.currentAndNewColor.prefWidth(-1.0), this.buttonBox.prefWidth(-1.0), HPos.RIGHT);
            this.buttonBox.resizeRelocate(d + d5, d2 + this.currentAndNewColor.prefHeight(-1.0) + this.hBox.prefHeight(-1.0) + d4 + this.alphaSettings.prefHeight(-1.0), this.buttonBox.prefWidth(-1.0), this.buttonBox.prefHeight(-1.0));
        }

        @Override
        public double computePrefHeight(double d) {
            double d2 = ((Node)this.settingsPane.getChildren().get(0)).prefHeight(-1.0);
            return this.getInsets().getTop() + this.currentAndNewColor.prefHeight(-1.0) + this.hBox.prefHeight(-1.0) + d2 + this.alphaSettings.prefHeight(-1.0) + this.buttonBox.prefHeight(-1.0) + this.getInsets().getBottom();
        }

        @Override
        public double computePrefWidth(double d) {
            return this.getInsets().getLeft() + 256.0 + this.getInsets().getRight();
        }
    }
}

