/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.gstreamer;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTAudioEqualizer;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTAudioSpectrum;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMedia;

final class GSTMediaPlayer
extends NativeMediaPlayer {
    private GSTMedia gstMedia = null;
    private float mutedVolume = 1.0f;
    private boolean muteEnabled = false;
    private boolean isStopTimeSet = false;
    private AudioEqualizer audioEqualizer;
    private AudioSpectrum audioSpectrum;

    private GSTMediaPlayer(GSTMedia sourceMedia) {
        super(sourceMedia);
        this.gstMedia = sourceMedia;
        int rc = this.gstInitPlayer(this.gstMedia.getNativeMediaRef());
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        this.audioSpectrum = new GSTAudioSpectrum(this.gstMedia.getNativeMediaRef());
        this.audioEqualizer = new GSTAudioEqualizer(this.gstMedia.getNativeMediaRef());
    }

    GSTMediaPlayer(Locator source) {
        this(new GSTMedia(source));
    }

    public AudioEqualizer getEqualizer() {
        return this.audioEqualizer;
    }

    public AudioSpectrum getAudioSpectrum() {
        return this.audioSpectrum;
    }

    private void throwMediaErrorException(int code, String message) throws MediaException {
        MediaError me = MediaError.getFromCode(code);
        throw new MediaException(message, null, me);
    }

    protected long playerGetAudioSyncDelay() throws MediaException {
        long[] audioSyncDelay = new long[1];
        int rc = this.gstGetAudioSyncDelay(this.gstMedia.getNativeMediaRef(), audioSyncDelay);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        return audioSyncDelay[0];
    }

    protected void playerSetAudioSyncDelay(long delay) throws MediaException {
        int rc = this.gstSetAudioSyncDelay(this.gstMedia.getNativeMediaRef(), delay);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected void playerPlay() throws MediaException {
        int rc = this.gstPlay(this.gstMedia.getNativeMediaRef());
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected void playerStop() throws MediaException {
        int rc = this.gstStop(this.gstMedia.getNativeMediaRef());
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected void playerPause() throws MediaException {
        int rc = this.gstPause(this.gstMedia.getNativeMediaRef());
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected float playerGetRate() throws MediaException {
        float[] rate = new float[1];
        int rc = this.gstGetRate(this.gstMedia.getNativeMediaRef(), rate);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        return rate[0];
    }

    protected void playerSetRate(float rate) throws MediaException {
        int rc = this.gstSetRate(this.gstMedia.getNativeMediaRef(), rate);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected double playerGetPresentationTime() throws MediaException {
        double[] presentationTime = new double[1];
        int rc = this.gstGetPresentationTime(this.gstMedia.getNativeMediaRef(), presentationTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        return presentationTime[0];
    }

    protected boolean playerGetMute() throws MediaException {
        return this.muteEnabled;
    }

    protected synchronized void playerSetMute(boolean enable) throws MediaException {
        if (enable != this.muteEnabled) {
            if (enable) {
                float currentVolume = this.getVolume();
                this.playerSetVolume(0.0f);
                this.muteEnabled = true;
                this.mutedVolume = currentVolume;
            } else {
                this.muteEnabled = false;
                this.playerSetVolume(this.mutedVolume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float playerGetVolume() throws MediaException {
        GSTMediaPlayer gSTMediaPlayer = this;
        synchronized (gSTMediaPlayer) {
            if (this.muteEnabled) {
                return this.mutedVolume;
            }
        }
        float[] volume = new float[1];
        int rc = this.gstGetVolume(this.gstMedia.getNativeMediaRef(), volume);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        return volume[0];
    }

    protected synchronized void playerSetVolume(float volume) throws MediaException {
        if (!this.muteEnabled) {
            int rc = this.gstSetVolume(this.gstMedia.getNativeMediaRef(), volume);
            if (0 != rc) {
                this.throwMediaErrorException(rc, null);
            } else {
                this.mutedVolume = volume;
            }
        } else {
            this.mutedVolume = volume;
        }
    }

    protected float playerGetBalance() throws MediaException {
        float[] balance = new float[1];
        int rc = this.gstGetBalance(this.gstMedia.getNativeMediaRef(), balance);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        return balance[0];
    }

    protected void playerSetBalance(float balance) throws MediaException {
        int rc = this.gstSetBalance(this.gstMedia.getNativeMediaRef(), balance);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected double playerGetDuration() throws MediaException {
        double[] duration = new double[1];
        int rc = this.gstGetDuration(this.gstMedia.getNativeMediaRef(), duration);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        if (duration[0] == -1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return duration[0];
    }

    protected synchronized double playerGetStartTime() throws MediaException {
        double[] startTime = new double[1];
        int rc = this.gstGetStartTime(this.gstMedia.getNativeMediaRef(), startTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
            startTime[0] = 0.0;
        }
        return startTime[0];
    }

    protected synchronized void playerSetStartTime(double startTime) throws MediaException {
        int rc = this.gstSetStartTime(this.gstMedia.getNativeMediaRef(), startTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected synchronized double playerGetStopTime() throws MediaException {
        double[] stopTime = new double[1];
        int rc = this.gstGetStopTime(this.gstMedia.getNativeMediaRef(), stopTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
            stopTime[0] = Double.MAX_VALUE;
        }
        return stopTime[0];
    }

    protected synchronized void playerSetStopTime(double stopTime) throws MediaException {
        int rc = this.gstSetStopTime(this.gstMedia.getNativeMediaRef(), stopTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
        this.isStopTimeSet = true;
    }

    protected void playerSeek(double streamTime) throws MediaException {
        int rc = this.gstSeek(this.gstMedia.getNativeMediaRef(), streamTime);
        if (0 != rc) {
            this.throwMediaErrorException(rc, null);
        }
    }

    protected void playerInit() throws MediaException {
        if (!this.isStopTimeSet) {
            this.playerSetStopTime(Double.MAX_VALUE);
            this.isStopTimeSet = true;
        }
    }

    protected void playerDispose() {
        this.audioEqualizer = null;
        this.audioSpectrum = null;
        this.gstMedia = null;
    }

    private native int gstInitPlayer(long var1);

    private native int gstGetAudioSyncDelay(long var1, long[] var3);

    private native int gstSetAudioSyncDelay(long var1, long var3);

    private native int gstPlay(long var1);

    private native int gstPause(long var1);

    private native int gstStop(long var1);

    private native int gstGetRate(long var1, float[] var3);

    private native int gstSetRate(long var1, float var3);

    private native int gstGetPresentationTime(long var1, double[] var3);

    private native int gstGetVolume(long var1, float[] var3);

    private native int gstSetVolume(long var1, float var3);

    private native int gstGetBalance(long var1, float[] var3);

    private native int gstSetBalance(long var1, float var3);

    private native int gstGetStartTime(long var1, double[] var3);

    private native int gstSetStartTime(long var1, double var3);

    private native int gstGetStopTime(long var1, double[] var3);

    private native int gstSetStopTime(long var1, double var3);

    private native int gstGetDuration(long var1, double[] var3);

    private native int gstSeek(long var1, double var3);
}

