/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.platform.Invoker;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class Disposer
implements Runnable {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Disposer disposerInstance = new Disposer();
    private static final Set<WeakDisposerRecord> records = new HashSet<WeakDisposerRecord>();

    public static void addRecord(Object object, DisposerRecord disposerRecord) {
        disposerInstance.add(object, disposerRecord);
    }

    synchronized void add(Object object, DisposerRecord disposerRecord) {
        records.add(new WeakDisposerRecord(object, disposerRecord));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    WeakDisposerRecord weakDisposerRecord = (WeakDisposerRecord)queue.remove();
                    weakDisposerRecord.clear();
                    DisposerRunnable.getInstance().enqueue(weakDisposerRecord);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while removing reference: " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        Thread thread = new Thread((Runnable)disposerInstance, "Disposer");
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.start();
    }

    private static class DisposerRunnable
    implements Runnable {
        private static final DisposerRunnable theInstance = new DisposerRunnable();
        private boolean isRunning = false;
        private final Object disposerLock = new Object();
        private final LinkedBlockingQueue<WeakDisposerRecord> disposerQueue = new LinkedBlockingQueue();

        private DisposerRunnable() {
        }

        private static DisposerRunnable getInstance() {
            return theInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(WeakDisposerRecord weakDisposerRecord) {
            Object object = this.disposerLock;
            synchronized (object) {
                this.disposerQueue.add(weakDisposerRecord);
                if (!this.isRunning) {
                    Invoker.getInvoker().invokeOnEventThread(this);
                    this.isRunning = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WeakDisposerRecord weakDisposerRecord;
                Object object = this.disposerLock;
                synchronized (object) {
                    weakDisposerRecord = this.disposerQueue.poll();
                    if (weakDisposerRecord == null) {
                        this.isRunning = false;
                        break;
                    }
                }
                weakDisposerRecord.run();
            }
        }
    }

    public static class WeakDisposerRecord
    extends WeakReference
    implements DisposerRecord,
    Runnable {
        DisposerRecord record;

        public WeakDisposerRecord(Object object) {
            super(object, queue);
        }

        public WeakDisposerRecord(Object object, DisposerRecord disposerRecord) {
            super(object, queue);
            this.record = disposerRecord;
        }

        @Override
        public void dispose() {
            this.record.dispose();
        }

        @Override
        public void run() {
            records.remove(this);
            this.dispose();
        }
    }
}

