/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class BorderPane
extends Pane {
    private static final String MARGIN = "borderpane-margin";
    private static final String ALIGNMENT = "borderpane-alignment";
    private ObjectProperty<Node> center;
    private ObjectProperty<Node> top;
    private ObjectProperty<Node> bottom;
    private ObjectProperty<Node> left;
    private ObjectProperty<Node> right;

    public static void setAlignment(Node node, Pos pos) {
        BorderPane.setConstraint(node, ALIGNMENT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)BorderPane.getConstraint(node, ALIGNMENT));
    }

    public static void setMargin(Node node, Insets insets) {
        BorderPane.setConstraint(node, MARGIN, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)BorderPane.getConstraint(node, MARGIN);
    }

    private static Insets getNodeMargin(Node node) {
        Insets insets = BorderPane.getMargin(node);
        return insets != null ? insets : Insets.EMPTY;
    }

    public static void clearConstraints(Node node) {
        BorderPane.setAlignment(node, null);
        BorderPane.setMargin(node, null);
    }

    private ObjectProperty<Node> createObjectPropertyModelImpl(final String string) {
        return new ObjectPropertyBase<Node>(){
            Node oldValue = null;

            @Override
            protected void invalidated() {
                Node node = (Node)this.get();
                if (this.oldValue != null) {
                    BorderPane.this.getChildren().remove(this.oldValue);
                }
                this.oldValue = node;
                if (node != null) {
                    BorderPane.this.getChildren().add(node);
                }
            }

            @Override
            public Object getBean() {
                return BorderPane.this;
            }

            @Override
            public String getName() {
                return string;
            }
        };
    }

    public final ObjectProperty<Node> centerProperty() {
        if (this.center == null) {
            this.center = this.createObjectPropertyModelImpl("center");
        }
        return this.center;
    }

    public final void setCenter(Node node) {
        this.centerProperty().set(node);
    }

    public final Node getCenter() {
        return this.center == null ? null : (Node)this.center.get();
    }

    public final ObjectProperty<Node> topProperty() {
        if (this.top == null) {
            this.top = this.createObjectPropertyModelImpl("top");
        }
        return this.top;
    }

    public final void setTop(Node node) {
        this.topProperty().set(node);
    }

    public final Node getTop() {
        return this.top == null ? null : (Node)this.top.get();
    }

    public final ObjectProperty<Node> bottomProperty() {
        if (this.bottom == null) {
            this.bottom = this.createObjectPropertyModelImpl("bottom");
        }
        return this.bottom;
    }

    public final void setBottom(Node node) {
        this.bottomProperty().set(node);
    }

    public final Node getBottom() {
        return this.bottom == null ? null : (Node)this.bottom.get();
    }

    public final ObjectProperty<Node> leftProperty() {
        if (this.left == null) {
            this.left = this.createObjectPropertyModelImpl("left");
        }
        return this.left;
    }

    public final void setLeft(Node node) {
        this.leftProperty().set(node);
    }

    public final Node getLeft() {
        return this.left == null ? null : (Node)this.left.get();
    }

    public final ObjectProperty<Node> rightProperty() {
        if (this.right == null) {
            this.right = this.createObjectPropertyModelImpl("right");
        }
        return this.right;
    }

    public final void setRight(Node node) {
        this.rightProperty().set(node);
    }

    public final Node getRight() {
        return this.right == null ? null : (Node)this.right.get();
    }

    @Override
    public Orientation getContentBias() {
        if (this.getCenter() != null && this.getCenter().isManaged() && this.getCenter().getContentBias() != null) {
            return this.getCenter().getContentBias();
        }
        if (this.getRight() != null && this.getRight().isManaged() && this.getRight().getContentBias() != null) {
            return this.getRight().getContentBias();
        }
        if (this.getBottom() != null && this.getBottom().isManaged() && this.getBottom().getContentBias() != null) {
            return this.getBottom().getContentBias();
        }
        if (this.getLeft() != null && this.getLeft().isManaged() && this.getLeft().getContentBias() != null) {
            return this.getLeft().getContentBias();
        }
        if (this.getTop() != null && this.getTop().isManaged() && this.getTop().getContentBias() != null) {
            return this.getTop().getContentBias();
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.getContentBias() == Orientation.VERTICAL) {
            double[] dArray = this.adjustAreaHeight(d, -1.0);
            d6 = this.getAreaWidth(this.getTop(), dArray[0], true);
            d5 = this.getAreaWidth(this.getLeft(), dArray[1], true);
            d4 = this.getAreaWidth(this.getCenter(), dArray[2], true);
            d3 = this.getAreaWidth(this.getRight(), dArray[3], true);
            d2 = this.getAreaWidth(this.getBottom(), dArray[4], true);
        } else {
            d6 = this.getTop() != null ? this.computeChildMinAreaWidth(this.getTop(), BorderPane.getMargin(this.getTop())) : 0.0;
            d5 = this.getLeft() != null ? this.computeChildMinAreaWidth(this.getLeft(), BorderPane.getMargin(this.getLeft())) : 0.0;
            d4 = this.getCenter() != null ? this.computeChildMinAreaWidth(this.getCenter(), BorderPane.getMargin(this.getCenter())) : 0.0;
            d3 = this.getRight() != null ? this.computeChildMinAreaWidth(this.getRight(), BorderPane.getMargin(this.getRight())) : 0.0;
            d2 = this.getBottom() != null ? this.computeChildMinAreaWidth(this.getBottom(), BorderPane.getMargin(this.getBottom())) : 0.0;
        }
        return this.getInsets().getLeft() + Math.max(d5 + d4 + d3, Math.max(d6, d2)) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double[] dArray = this.adjustAreaWidth(d, -1.0);
            d2 = this.getAreaHeight(this.getTop(), d, true);
            d4 = this.getAreaHeight(this.getLeft(), dArray[0], true);
            d5 = this.getAreaHeight(this.getCenter(), dArray[1], true);
            d6 = this.getAreaHeight(this.getRight(), dArray[2], true);
            d3 = this.getAreaHeight(this.getBottom(), d, true);
        } else {
            d2 = this.getTop() != null ? this.computeChildMinAreaHeight(this.getTop(), BorderPane.getMargin(this.getTop())) : 0.0;
            d4 = this.getLeft() != null ? this.computeChildMinAreaHeight(this.getLeft(), BorderPane.getMargin(this.getLeft())) : 0.0;
            d5 = this.getCenter() != null ? this.computeChildMinAreaHeight(this.getCenter(), BorderPane.getMargin(this.getCenter())) : 0.0;
            d6 = this.getRight() != null ? this.computeChildMinAreaHeight(this.getRight(), BorderPane.getMargin(this.getRight())) : 0.0;
            d3 = this.getBottom() != null ? this.computeChildMinAreaHeight(this.getBottom(), BorderPane.getMargin(this.getBottom())) : 0.0;
        }
        return this.getInsets().getTop() + d2 + Math.max(d5, Math.max(d6, d4)) + d3 + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.getContentBias() == Orientation.VERTICAL) {
            double[] dArray = this.adjustAreaHeight(d, -1.0);
            d2 = this.getAreaWidth(this.getTop(), dArray[0], false);
            d3 = this.getAreaWidth(this.getLeft(), dArray[1], false);
            d4 = this.getAreaWidth(this.getCenter(), dArray[2], false);
            d5 = this.getAreaWidth(this.getRight(), dArray[3], false);
            d6 = this.getAreaWidth(this.getBottom(), dArray[4], false);
        } else {
            double d7 = this.getCenter() != null ? this.computeChildPrefAreaHeight(this.getCenter(), BorderPane.getMargin(this.getCenter())) : 0.0;
            double d8 = this.getLeft() != null ? this.computeChildPrefAreaHeight(this.getLeft(), BorderPane.getMargin(this.getLeft())) : 0.0;
            double d9 = this.getRight() != null ? this.computeChildPrefAreaHeight(this.getRight(), BorderPane.getMargin(this.getRight())) : 0.0;
            double d10 = Math.max(d7, Math.max(d9, d8));
            d3 = this.getLeft() != null ? this.computeChildPrefAreaWidth(this.getLeft(), BorderPane.getMargin(this.getLeft()), d10) : 0.0;
            d5 = this.getRight() != null ? this.computeChildPrefAreaWidth(this.getRight(), BorderPane.getMargin(this.getRight()), d10) : 0.0;
            d4 = this.getCenter() != null ? this.computeChildPrefAreaWidth(this.getCenter(), BorderPane.getMargin(this.getCenter()), d10) : 0.0;
            d2 = this.getTop() != null ? this.computeChildPrefAreaWidth(this.getTop(), BorderPane.getMargin(this.getTop())) : 0.0;
            d6 = this.getBottom() != null ? this.computeChildPrefAreaWidth(this.getBottom(), BorderPane.getMargin(this.getBottom())) : 0.0;
        }
        return this.getInsets().getLeft() + Math.max(d3 + d4 + d5, Math.max(d2, d6)) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double[] dArray = this.adjustAreaWidth(d, -1.0);
            d2 = this.getAreaHeight(this.getTop(), d, false);
            d4 = this.getAreaHeight(this.getLeft(), dArray[0], false);
            d5 = this.getAreaHeight(this.getCenter(), dArray[1], false);
            d6 = this.getAreaHeight(this.getRight(), dArray[2], false);
            d3 = this.getAreaHeight(this.getBottom(), d, false);
            d7 = Math.max(d5, Math.max(d6, d4));
        } else {
            d5 = this.getCenter() != null ? this.computeChildPrefAreaHeight(this.getCenter(), BorderPane.getMargin(this.getCenter())) : 0.0;
            d4 = this.getLeft() != null ? this.computeChildPrefAreaHeight(this.getLeft(), BorderPane.getMargin(this.getLeft())) : 0.0;
            d6 = this.getRight() != null ? this.computeChildPrefAreaHeight(this.getRight(), BorderPane.getMargin(this.getRight())) : 0.0;
            d7 = Math.max(d5, Math.max(d6, d4));
            double d8 = this.getLeft() != null ? this.computeChildPrefAreaWidth(this.getLeft(), BorderPane.getMargin(this.getLeft()), d7) : 0.0;
            double d9 = this.getRight() != null ? this.computeChildPrefAreaWidth(this.getRight(), BorderPane.getMargin(this.getRight()), d7) : 0.0;
            double d10 = this.getCenter() != null ? this.computeChildPrefAreaWidth(this.getCenter(), BorderPane.getMargin(this.getCenter()), d7) : 0.0;
            double d11 = this.getTop() != null ? this.computeChildPrefAreaWidth(this.getTop(), BorderPane.getMargin(this.getTop())) : 0.0;
            double d12 = this.getBottom() != null ? this.computeChildPrefAreaWidth(this.getBottom(), BorderPane.getMargin(this.getBottom())) : 0.0;
            double d13 = this.getInsets().getLeft() + Math.max(d8 + d10 + d9, Math.max(d11, d12)) + this.getInsets().getRight();
            d2 = this.getTop() != null ? this.computeChildPrefAreaHeight(this.getTop(), BorderPane.getMargin(this.getTop()), d13) : 0.0;
            d3 = this.getBottom() != null ? this.computeChildPrefAreaHeight(this.getBottom(), BorderPane.getMargin(this.getBottom()), d13) : 0.0;
        }
        return this.getInsets().getTop() + d2 + d7 + d3 + this.getInsets().getBottom();
    }

    @Override
    protected void layoutChildren() {
        Pos pos;
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getInsets().getLeft();
        double d4 = this.getInsets().getTop();
        double d5 = d - d3 - this.getInsets().getRight();
        double d6 = d2 - d4 - this.getInsets().getBottom();
        double[] dArray = this.adjustAreaWidth(d, d2);
        double[] dArray2 = this.adjustAreaHeight(d2, d);
        double d7 = 0.0;
        Insets insets = null;
        if (this.getTop() != null) {
            insets = BorderPane.getNodeMargin(this.getTop());
            d7 = this.getContentBias() == Orientation.VERTICAL ? (dArray2[0] == -1.0 ? this.getTop().prefHeight(-1.0) : dArray2[0]) : this.snapSize(insets.getTop() + this.getTop().prefHeight(d5 - insets.getLeft() - insets.getRight()) + insets.getBottom());
        }
        double d8 = 0.0;
        Insets insets2 = null;
        if (this.getBottom() != null) {
            insets2 = BorderPane.getNodeMargin(this.getBottom());
            d8 = this.getContentBias() == Orientation.VERTICAL ? (dArray2[4] == -1.0 ? this.getBottom().prefHeight(-1.0) : dArray2[4]) : this.snapSize(insets2.getTop() + this.getBottom().prefHeight(d5 - insets2.getLeft() - insets2.getRight()) + insets2.getBottom());
        }
        double d9 = 0.0;
        Insets insets3 = null;
        if (this.getLeft() != null) {
            insets3 = BorderPane.getNodeMargin(this.getLeft());
            d9 = this.getContentBias() == Orientation.HORIZONTAL ? (dArray[0] == -1.0 ? this.getLeft().prefWidth(-1.0) : dArray[0]) : this.snapSize(insets3.getLeft() + this.getLeft().prefWidth(d6 - d7 - d8 - insets3.getTop() - insets3.getBottom()) + insets3.getRight());
        }
        double d10 = 0.0;
        Insets insets4 = null;
        if (this.getRight() != null) {
            insets4 = BorderPane.getNodeMargin(this.getRight());
            d10 = this.getContentBias() == Orientation.HORIZONTAL ? (dArray[2] == -1.0 ? this.getRight().prefWidth(-1.0) : dArray[2]) : this.snapSize(insets4.getLeft() + this.getRight().prefWidth(d6 - d7 - d8 - insets4.getTop() - insets4.getBottom()) + insets4.getRight());
        }
        if (this.getTop() != null) {
            pos = BorderPane.getAlignment(this.getTop());
            d7 = Math.min(d7, d6);
            this.layoutInArea(this.getTop(), d3, d4, d5, d7, 0.0, insets, pos != null ? pos.getHpos() : HPos.LEFT, pos != null ? pos.getVpos() : VPos.TOP);
        }
        if (this.getBottom() != null) {
            pos = BorderPane.getAlignment(this.getBottom());
            d8 = Math.min(d8, d6 - d7);
            this.layoutInArea(this.getBottom(), d3, d4 + d6 - d8, d5, d8, 0.0, insets2, pos != null ? pos.getHpos() : HPos.LEFT, pos != null ? pos.getVpos() : VPos.BOTTOM);
        }
        if (this.getLeft() != null) {
            pos = BorderPane.getAlignment(this.getLeft());
            d9 = Math.min(d9, d5);
            this.layoutInArea(this.getLeft(), d3, d4 + d7, d9, d6 - d7 - d8, 0.0, insets3, pos != null ? pos.getHpos() : HPos.LEFT, pos != null ? pos.getVpos() : VPos.TOP);
        }
        if (this.getRight() != null) {
            pos = BorderPane.getAlignment(this.getRight());
            d10 = Math.min(d10, d5 - d9);
            this.layoutInArea(this.getRight(), d3 + d5 - d10, d4 + d7, d10, d6 - d7 - d8, 0.0, insets4, pos != null ? pos.getHpos() : HPos.RIGHT, pos != null ? pos.getVpos() : VPos.TOP);
        }
        if (this.getCenter() != null) {
            pos = BorderPane.getAlignment(this.getCenter());
            this.layoutInArea(this.getCenter(), d3 + d9, d4 + d7, d5 - d9 - d10, d6 - d7 - d8, 0.0, BorderPane.getNodeMargin(this.getCenter()), pos != null ? pos.getHpos() : HPos.CENTER, pos != null ? pos.getVpos() : VPos.CENTER);
        }
    }

    private double getAreaWidth(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            return bl ? this.computeChildMinAreaWidth(node, insets, d) : this.computeChildPrefAreaWidth(node, insets, d);
        }
        return 0.0;
    }

    private double getAreaHeight(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            return bl ? this.computeChildMinAreaHeight(node, insets, d) : this.computeChildPrefAreaHeight(node, insets, d);
        }
        return 0.0;
    }

    private boolean childHasContentBias(Node node, Orientation orientation) {
        if (node != null && node.isManaged()) {
            return node.getContentBias() == orientation;
        }
        return false;
    }

    private double getAreaLimitWidth(Node node, boolean bl, double d) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            return bl ? this.computeChildMinAreaWidth(node, insets, d) : this.computeChildMaxAreaWidth(node, insets, d);
        }
        return 0.0;
    }

    private double[] adjustAreaWidth(double d, double d2) {
        double[] dArray = new double[]{this.getAreaWidth(this.getLeft(), -1.0, false), this.getAreaWidth(this.getCenter(), -1.0, false), this.getAreaWidth(this.getRight(), -1.0, false)};
        double d3 = dArray[0] + dArray[1] + dArray[2];
        double d4 = d - d3;
        boolean bl = d4 < 0.0;
        boolean[] blArray = new boolean[]{this.childHasContentBias(this.getLeft(), Orientation.HORIZONTAL), this.childHasContentBias(this.getCenter(), Orientation.HORIZONTAL), this.childHasContentBias(this.getRight(), Orientation.HORIZONTAL)};
        double[] dArray2 = new double[]{this.getAreaLimitWidth(this.getLeft(), bl, d2), this.getAreaLimitWidth(this.getCenter(), bl, d2), this.getAreaLimitWidth(this.getRight(), bl, d2)};
        double d5 = d;
        double[] dArray3 = new double[]{-1.0, -1.0, -1.0};
        int n = dArray3.length;
        if (d != -1.0 && this.getContentBias() == Orientation.HORIZONTAL) {
            int n2;
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                if (blArray[n2]) continue;
                dArray3[n2] = -1.0;
                --n;
                if (!bl) continue;
                d5 -= dArray[n2];
            }
            d4 /= (double)n;
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                if (!bl) {
                    if (!blArray[n2]) continue;
                    double d6 = dArray[n2] + d4;
                    if (d6 < dArray2[n2]) {
                        dArray3[n2] = d6;
                        continue;
                    }
                    dArray3[n2] = dArray2[n2];
                    continue;
                }
                if (!(d5 > 0.0) || !blArray[n2]) continue;
                dArray3[n2] = d5 > dArray2[n2] ? d5 / (double)n : dArray2[n2];
            }
        }
        return dArray3;
    }

    private double getAreaLimitHeight(Node node, boolean bl, double d) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            return bl ? this.computeChildMinAreaHeight(node, insets, d) : this.computeChildMaxAreaHeight(node, insets, d);
        }
        return 0.0;
    }

    private double[] adjustAreaHeight(double d, double d2) {
        double[] dArray = new double[]{this.getAreaHeight(this.getTop(), -1.0, false), this.getAreaHeight(this.getLeft(), -1.0, false), this.getAreaHeight(this.getCenter(), -1.0, false), this.getAreaHeight(this.getRight(), -1.0, false), this.getAreaHeight(this.getBottom(), -1.0, false)};
        double d3 = Math.max(dArray[1], Math.max(dArray[2], dArray[3]));
        double d4 = d - (d3 += dArray[0] + dArray[4]);
        boolean bl = d4 < 0.0;
        boolean[] blArray = new boolean[]{this.childHasContentBias(this.getTop(), Orientation.VERTICAL), this.childHasContentBias(this.getLeft(), Orientation.VERTICAL), this.childHasContentBias(this.getCenter(), Orientation.VERTICAL), this.childHasContentBias(this.getRight(), Orientation.VERTICAL), this.childHasContentBias(this.getBottom(), Orientation.VERTICAL)};
        double[] dArray2 = new double[]{this.getAreaLimitHeight(this.getTop(), bl, d2), this.getAreaLimitHeight(this.getLeft(), bl, d2), this.getAreaLimitHeight(this.getCenter(), bl, d2), this.getAreaLimitHeight(this.getRight(), bl, d2), this.getAreaLimitHeight(this.getBottom(), bl, d2)};
        double d5 = d;
        double[] dArray3 = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0};
        int n = dArray3.length;
        if (d != -1.0 && this.getContentBias() == Orientation.VERTICAL) {
            int n2;
            double d6 = 0.0;
            for (n2 = 1; n2 < 4; ++n2) {
                if (blArray[n2]) continue;
                d6 = Math.max(d6, dArray[n2]);
            }
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                if (blArray[n2]) continue;
                dArray3[n2] = -1.0;
                --n;
                if (!bl) continue;
                if (n2 < 1 || n2 > 3) {
                    d5 -= dArray[n2];
                    continue;
                }
                if (n2 != 1) continue;
                d5 -= d6;
            }
            d4 /= (double)n;
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                if (!bl) {
                    if (!blArray[n2]) continue;
                    double d7 = dArray[n2] + d4;
                    if (d7 < dArray2[n2]) {
                        dArray3[n2] = d7;
                        continue;
                    }
                    dArray3[n2] = dArray2[n2];
                    continue;
                }
                if (!(d5 > 0.0) || !blArray[n2]) continue;
                dArray3[n2] = d5 > dArray2[n2] ? d5 / (double)n : dArray2[n2];
            }
        }
        return dArray3;
    }
}

