/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.lucene.spatial.util.GeoDistanceUtils;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoUtils;

public class GeoPointDistanceQuery
extends GeoPointInBBoxQuery {
    protected final double centerLon;
    protected final double centerLat;
    protected final double radiusMeters;

    public GeoPointDistanceQuery(String field, double centerLon, double centerLat, double radiusMeters) {
        this(field, GeoPointField.TermEncoding.PREFIX, centerLon, centerLat, radiusMeters);
    }

    public GeoPointDistanceQuery(String field, GeoPointField.TermEncoding termEncoding, double centerLon, double centerLat, double radiusMeters) {
        this(field, termEncoding, GeoUtils.circleToBBox(centerLon, centerLat, radiusMeters), centerLon, centerLat, radiusMeters);
    }

    private GeoPointDistanceQuery(String field, GeoPointField.TermEncoding termEncoding, GeoRect bbox, double centerLon, double centerLat, double radiusMeters) {
        super(field, termEncoding, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        double maxRadius = GeoDistanceUtils.maxRadialDistanceMeters(centerLon, centerLat);
        if (radiusMeters > maxRadius) {
            throw new IllegalArgumentException("radiusMeters " + radiusMeters + " exceeds maxRadius [" + maxRadius + "] at location [" + centerLon + " " + centerLat + "]");
        }
        if (!GeoUtils.isValidLon(centerLon)) {
            throw new IllegalArgumentException("invalid centerLon " + centerLon);
        }
        if (!GeoUtils.isValidLat(centerLat)) {
            throw new IllegalArgumentException("invalid centerLat " + centerLat);
        }
        if (radiusMeters <= 0.0) {
            throw new IllegalArgumentException("invalid radiusMeters " + radiusMeters);
        }
        this.centerLon = centerLon;
        this.centerLat = centerLat;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            double unwrappedLon = this.centerLon;
            if (unwrappedLon > this.maxLon) {
                unwrappedLon += -360.0;
            }
            GeoPointDistanceQueryImpl left = new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, unwrappedLon, new GeoRect(-180.0, this.maxLon, this.minLat, this.maxLat));
            bqb.add(new BooleanClause((Query)left, BooleanClause.Occur.SHOULD));
            if (unwrappedLon < this.maxLon) {
                unwrappedLon += 360.0;
            }
            GeoPointDistanceQueryImpl right = new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, unwrappedLon, new GeoRect(this.minLon, 180.0, this.minLat, this.maxLat));
            bqb.add(new BooleanClause((Query)right, BooleanClause.Occur.SHOULD));
            return bqb.build();
        }
        return new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, this.centerLon, new GeoRect(this.minLon, this.maxLon, this.minLat, this.maxLat));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQuery that = (GeoPointDistanceQuery)((Object)o);
        if (Double.compare(that.centerLat, this.centerLat) != 0) {
            return false;
        }
        if (Double.compare(that.centerLon, this.centerLon) != 0) {
            return false;
        }
        return Double.compare(that.radiusMeters, this.radiusMeters) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.centerLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.centerLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Center: [").append(this.centerLon).append(',').append(this.centerLat).append(']').append(" Distance: ").append(this.radiusMeters).append(" meters").append("]").toString();
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }
}

