/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;

class TermsIncludingScoreQuery
extends Query {
    final String field;
    final boolean multipleValuesPerDocument;
    final BytesRefHash terms;
    final float[] scores;
    final int[] ords;
    final Query originalQuery;
    final Query unwrittenOriginalQuery;

    TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, Query originalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.unwrittenOriginalQuery = originalQuery;
    }

    private TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, int[] ords, Query originalQuery, Query unwrittenOriginalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = ords;
        this.unwrittenOriginalQuery = unwrittenOriginalQuery;
    }

    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;originalQuery=%s}", this.field, this.unwrittenOriginalQuery);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query originalQueryRewrite = this.originalQuery.rewrite(reader);
        if (originalQueryRewrite != this.originalQuery) {
            return new TermsIncludingScoreQuery(this.field, this.multipleValuesPerDocument, this.terms, this.scores, this.ords, originalQueryRewrite, this.originalQuery);
        }
        return super.rewrite(reader);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TermsIncludingScoreQuery other = (TermsIncludingScoreQuery)((Object)obj);
        if (!this.field.equals(other.field)) {
            return false;
        }
        return this.unwrittenOriginalQuery.equals((Object)other.unwrittenOriginalQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result += 31 * this.field.hashCode();
        return result += 31 * this.unwrittenOriginalQuery.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight originalWeight = this.originalQuery.createWeight(searcher, needsScores);
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms != null) {
                    TermsEnum segmentTermsEnum = terms.iterator();
                    BytesRef spare = new BytesRef();
                    PostingsEnum postingsEnum = null;
                    for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                        if (!segmentTermsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare)) || (postingsEnum = segmentTermsEnum.postings(postingsEnum, 0)).advance(doc) != doc) continue;
                        float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                        return Explanation.match((float)score, (String)("Score based on join value " + segmentTermsEnum.term().utf8ToString()), (Explanation[])new Explanation[0]);
                    }
                }
                return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
            }

            public float getValueForNormalization() throws IOException {
                return originalWeight.getValueForNormalization();
            }

            public void normalize(float norm, float boost) {
                originalWeight.normalize(norm, boost);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms == null) {
                    return null;
                }
                long cost = (long)context.reader().maxDoc() * terms.size();
                TermsEnum segmentTermsEnum = terms.iterator();
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInOrderScorer(this, segmentTermsEnum, context.reader().maxDoc(), cost);
                }
                return new SVInOrderScorer(this, segmentTermsEnum, context.reader().maxDoc(), cost);
            }
        };
    }

    void dump(PrintStream out) {
        out.println(this.field + ":");
        BytesRef ref = new BytesRef();
        for (int i = 0; i < this.terms.size(); ++i) {
            this.terms.get(this.ords[i], ref);
            out.print(ref + " " + ref.utf8ToString() + " ");
            try {
                out.print(Long.toHexString(NumericUtils.prefixCodedToLong((BytesRef)ref)) + "L");
            }
            catch (Exception e) {
                try {
                    out.print(Integer.toHexString(NumericUtils.prefixCodedToInt((BytesRef)ref)) + "i");
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            out.println(" score=" + this.scores[this.ords[i]]);
            out.println("");
        }
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight, termsEnum, maxDoc, cost);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.get(doc)) {
                        this.scores[doc] = score;
                        matchingDocs.set(doc);
                    }
                    doc = postingsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        final long cost;

        SVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight);
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, termsEnum);
            this.matchingDocsIterator = new BitSetIterator((BitSet)matchingDocs, cost);
            this.cost = cost;
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = postingsEnum.nextDoc();
                }
            }
        }

        public float score() throws IOException {
            return this.scores[this.docID()];
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.matchingDocsIterator.docID();
        }

        public DocIdSetIterator iterator() {
            return this.matchingDocsIterator;
        }
    }
}

