/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;

public class ClusterHealthResponse
extends ActionResponse
implements StatusToXContent {
    private String clusterName;
    private int numberOfPendingTasks = 0;
    private int numberOfInFlightFetch = 0;
    private int delayedUnassignedShards = 0;
    private TimeValue taskMaxWaitingTime = TimeValue.timeValueMillis(0L);
    private boolean timedOut = false;
    private ClusterStateHealth clusterStateHealth;

    ClusterHealthResponse() {
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this(clusterName, concreteIndices, clusterState, -1, -1, -1, TimeValue.timeValueHours(0L));
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.clusterStateHealth = new ClusterStateHealth(clusterState, concreteIndices);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    ClusterStateHealth getClusterStateHealth() {
        return this.clusterStateHealth;
    }

    public List<String> getValidationFailures() {
        return this.clusterStateHealth.getValidationFailures();
    }

    public int getActiveShards() {
        return this.clusterStateHealth.getActiveShards();
    }

    public int getRelocatingShards() {
        return this.clusterStateHealth.getRelocatingShards();
    }

    public int getActivePrimaryShards() {
        return this.clusterStateHealth.getActivePrimaryShards();
    }

    public int getInitializingShards() {
        return this.clusterStateHealth.getInitializingShards();
    }

    public int getUnassignedShards() {
        return this.clusterStateHealth.getUnassignedShards();
    }

    public int getNumberOfNodes() {
        return this.clusterStateHealth.getNumberOfNodes();
    }

    public int getNumberOfDataNodes() {
        return this.clusterStateHealth.getNumberOfDataNodes();
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.clusterStateHealth.getStatus();
    }

    public void setStatus(ClusterHealthStatus status) {
        this.clusterStateHealth.setStatus(status);
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.clusterStateHealth.getIndices();
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.clusterStateHealth.getActiveShardsPercent();
    }

    public static ClusterHealthResponse readResponseFrom(StreamInput in) throws IOException {
        ClusterHealthResponse response = new ClusterHealthResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        List<String> validationFailures;
        super.readFrom(in);
        this.clusterName = in.readString();
        int activePrimaryShards = in.readVInt();
        int activeShards = in.readVInt();
        int relocatingShards = in.readVInt();
        int initializingShards = in.readVInt();
        int unassignedShards = in.readVInt();
        int numberOfNodes = in.readVInt();
        int numberOfDataNodes = in.readVInt();
        this.numberOfPendingTasks = in.readInt();
        ClusterHealthStatus status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        HashMap<String, ClusterIndexHealth> indices = new HashMap<String, ClusterIndexHealth>();
        for (int i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = ClusterIndexHealth.readClusterIndexHealth(in);
            indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.timedOut = in.readBoolean();
        size = in.readVInt();
        if (size == 0) {
            validationFailures = Collections.emptyList();
        } else {
            validationFailures = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                validationFailures.add(in.readString());
            }
        }
        this.numberOfInFlightFetch = in.readInt();
        if (in.getVersion().onOrAfter(Version.V_1_7_0)) {
            this.delayedUnassignedShards = in.readInt();
        }
        double activeShardsPercent = in.readDouble();
        this.taskMaxWaitingTime = TimeValue.readTimeValue(in);
        this.clusterStateHealth = new ClusterStateHealth(numberOfNodes, numberOfDataNodes, activeShards, relocatingShards, activePrimaryShards, initializingShards, unassignedShards, activeShardsPercent, status, validationFailures, indices);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeVInt(this.clusterStateHealth.getActivePrimaryShards());
        out.writeVInt(this.clusterStateHealth.getActiveShards());
        out.writeVInt(this.clusterStateHealth.getRelocatingShards());
        out.writeVInt(this.clusterStateHealth.getInitializingShards());
        out.writeVInt(this.clusterStateHealth.getUnassignedShards());
        out.writeVInt(this.clusterStateHealth.getNumberOfNodes());
        out.writeVInt(this.clusterStateHealth.getNumberOfDataNodes());
        out.writeInt(this.numberOfPendingTasks);
        out.writeByte(this.clusterStateHealth.getStatus().value());
        out.writeVInt(this.clusterStateHealth.getIndices().size());
        for (ClusterIndexHealth indexHealth : this.clusterStateHealth) {
            indexHealth.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.clusterStateHealth.getValidationFailures().size());
        for (String failure : this.clusterStateHealth.getValidationFailures()) {
            out.writeString(failure);
        }
        out.writeInt(this.numberOfInFlightFetch);
        if (out.getVersion().onOrAfter(Version.V_1_7_0)) {
            out.writeInt(this.delayedUnassignedShards);
        }
        out.writeDouble(this.clusterStateHealth.getActiveShardsPercent());
        this.taskMaxWaitingTime.writeTo(out);
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public RestStatus status() {
        return this.isTimedOut() ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.field(Fields.CLUSTER_NAME, this.getClusterName());
        builder.field(Fields.STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(Fields.TIMED_OUT, this.isTimedOut());
        builder.field(Fields.NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(Fields.NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(Fields.ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(Fields.ACTIVE_SHARDS, this.getActiveShards());
        builder.field(Fields.RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(Fields.INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(Fields.UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(Fields.DELAYED_UNASSIGNED_SHARDS, this.getDelayedUnassignedShards());
        builder.field(Fields.NUMBER_OF_PENDING_TASKS, this.getNumberOfPendingTasks());
        builder.field(Fields.NUMBER_OF_IN_FLIGHT_FETCH, this.getNumberOfInFlightFetch());
        builder.timeValueField(Fields.TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, Fields.TASK_MAX_WAIT_TIME_IN_QUEUE, this.getTaskMaxWaitingTime());
        builder.percentageField(Fields.ACTIVE_SHARDS_PERCENT_AS_NUMBER, Fields.ACTIVE_SHARDS_PERCENT, this.getActiveShardsPercent());
        String level = params.param("level", "cluster");
        boolean bl = outputIndices = "indices".equals(level) || "shards".equals(level);
        if (!this.getValidationFailures().isEmpty()) {
            builder.startArray(Fields.VALIDATION_FAILURES);
            for (String validationFailure : this.getValidationFailures()) {
                builder.value(validationFailure);
            }
            if (!outputIndices) {
                for (ClusterIndexHealth indexHealth : this.clusterStateHealth.getIndices().values()) {
                    builder.startObject(indexHealth.getIndex());
                    if (!indexHealth.getValidationFailures().isEmpty()) {
                        builder.startArray(Fields.VALIDATION_FAILURES);
                        for (String validationFailure : indexHealth.getValidationFailures()) {
                            builder.value(validationFailure);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
            }
            builder.endArray();
        }
        if (outputIndices) {
            builder.startObject(Fields.INDICES);
            for (ClusterIndexHealth indexHealth : this.clusterStateHealth.getIndices().values()) {
                builder.startObject(indexHealth.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                indexHealth.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString CLUSTER_NAME = new XContentBuilderString("cluster_name");
        static final XContentBuilderString STATUS = new XContentBuilderString("status");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");
        static final XContentBuilderString NUMBER_OF_NODES = new XContentBuilderString("number_of_nodes");
        static final XContentBuilderString NUMBER_OF_DATA_NODES = new XContentBuilderString("number_of_data_nodes");
        static final XContentBuilderString NUMBER_OF_PENDING_TASKS = new XContentBuilderString("number_of_pending_tasks");
        static final XContentBuilderString NUMBER_OF_IN_FLIGHT_FETCH = new XContentBuilderString("number_of_in_flight_fetch");
        static final XContentBuilderString DELAYED_UNASSIGNED_SHARDS = new XContentBuilderString("delayed_unassigned_shards");
        static final XContentBuilderString TASK_MAX_WAIT_TIME_IN_QUEUE = new XContentBuilderString("task_max_waiting_in_queue");
        static final XContentBuilderString TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = new XContentBuilderString("task_max_waiting_in_queue_millis");
        static final XContentBuilderString ACTIVE_SHARDS_PERCENT_AS_NUMBER = new XContentBuilderString("active_shards_percent_as_number");
        static final XContentBuilderString ACTIVE_SHARDS_PERCENT = new XContentBuilderString("active_shards_percent");
        static final XContentBuilderString ACTIVE_PRIMARY_SHARDS = new XContentBuilderString("active_primary_shards");
        static final XContentBuilderString ACTIVE_SHARDS = new XContentBuilderString("active_shards");
        static final XContentBuilderString RELOCATING_SHARDS = new XContentBuilderString("relocating_shards");
        static final XContentBuilderString INITIALIZING_SHARDS = new XContentBuilderString("initializing_shards");
        static final XContentBuilderString UNASSIGNED_SHARDS = new XContentBuilderString("unassigned_shards");
        static final XContentBuilderString VALIDATION_FAILURES = new XContentBuilderString("validation_failures");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

