/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors.dfs;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.action.termvectors.dfs.DfsOnlyRequest;
import org.elasticsearch.action.termvectors.dfs.DfsOnlyResponse;
import org.elasticsearch.action.termvectors.dfs.ShardDfsOnlyRequest;
import org.elasticsearch.action.termvectors.dfs.ShardDfsOnlyResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDfsOnlyAction
extends TransportBroadcastAction<DfsOnlyRequest, DfsOnlyResponse, ShardDfsOnlyRequest, ShardDfsOnlyResponse> {
    public static final String NAME = "internal:index/termvectors/dfs";
    private final SearchService searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportDfsOnlyAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SearchService searchService, SearchPhaseController searchPhaseController) {
        super(settings, NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, DfsOnlyRequest.class, ShardDfsOnlyRequest.class, "search");
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void doExecute(Task task, DfsOnlyRequest request, ActionListener<DfsOnlyResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(task, request, listener);
    }

    @Override
    protected ShardDfsOnlyRequest newShardRequest(int numShards, ShardRouting shard, DfsOnlyRequest request) {
        String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterService.state(), shard.index(), request.indices());
        return new ShardDfsOnlyRequest(shard, numShards, filteringAliases, request.nowInMillis, request);
    }

    @Override
    protected ShardDfsOnlyResponse newShardResponse() {
        return new ShardDfsOnlyResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, DfsOnlyRequest request, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, request.routing(), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, DfsOnlyRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, DfsOnlyRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected DfsOnlyResponse newResponse(DfsOnlyRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<ShardOperationFailedException> shardFailures = null;
        AtomicArray<DfsSearchResult> dfsResults = new AtomicArray<DfsSearchResult>(shardsResponses.length());
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<ShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            dfsResults.set(i, ((ShardDfsOnlyResponse)shardResponse).getDfsSearchResult());
            ++successfulShards;
        }
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(dfsResults);
        return new DfsOnlyResponse(dfs, shardsResponses.length(), successfulShards, failedShards, shardFailures, this.buildTookInMillis(request));
    }

    @Override
    protected ShardDfsOnlyResponse shardOperation(ShardDfsOnlyRequest request) {
        DfsSearchResult dfsSearchResult = this.searchService.executeDfsPhase(request.getShardSearchRequest());
        this.searchService.freeContext(dfsSearchResult.id());
        return new ShardDfsOnlyResponse(request.shardId(), dfsSearchResult);
    }

    protected final long buildTookInMillis(DfsOnlyRequest request) {
        return Math.max(1L, System.currentTimeMillis() - request.nowInMillis);
    }
}

