/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class IllegalIndexShardStateException
extends ElasticsearchException {
    private final IndexShardState currentState;

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg) {
        this(shardId, currentState, msg, null);
    }

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Throwable ex) {
        super("CurrentState[" + (Object)((Object)currentState) + "] " + msg, ex, new Object[0]);
        this.setShard(shardId);
        this.currentState = currentState;
    }

    public IndexShardState currentState() {
        return this.currentState;
    }

    public IllegalIndexShardStateException(StreamInput in) throws IOException {
        super(in);
        this.currentState = IndexShardState.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.currentState.id());
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }
}

