/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class RangeAggregator
extends BucketsAggregator {
    final ValuesSource.Numeric valuesSource;
    final ValueFormatter formatter;
    final Range[] ranges;
    final boolean keyed;
    final InternalRange.Factory rangeFactory;
    final double[] maxTo;

    public RangeAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, ValueFormat format, InternalRange.Factory rangeFactory, List<Range> ranges, boolean keyed, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        int i;
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.formatter = format.formatter();
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges.toArray(new Range[ranges.size()]);
        ValueParser parser = format != null ? format.parser() : ValueParser.RAW;
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].process(parser, this.context.searchContext());
        }
        RangeAggregator.sortRanges(this.ranges);
        this.maxTo = new double[this.ranges.length];
        this.maxTo[0] = this.ranges[0].to;
        for (i = 1; i < this.ranges.length; ++i) {
            this.maxTo[i] = Math.max(this.ranges[i].to, this.maxTo[i - 1]);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                values.setDocument(doc);
                int valuesCount = values.count();
                int lo = 0;
                for (int i = 0; i < valuesCount; ++i) {
                    double value = values.valueAt(i);
                    lo = this.collect(doc, value, bucket, lo);
                }
            }

            private int collect(int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
                int lo = lowBound;
                int hi = RangeAggregator.this.ranges.length - 1;
                int mid = lo + hi >>> 1;
                while (lo <= hi) {
                    if (value < RangeAggregator.this.ranges[mid].from) {
                        hi = mid - 1;
                    } else {
                        if (!(value >= RangeAggregator.this.maxTo[mid])) break;
                        lo = mid + 1;
                    }
                    mid = lo + hi >>> 1;
                }
                if (lo > hi) {
                    return lo;
                }
                int startLo = lo;
                int startHi = mid;
                while (startLo <= startHi) {
                    int startMid = startLo + startHi >>> 1;
                    if (value >= RangeAggregator.this.maxTo[startMid]) {
                        startLo = startMid + 1;
                        continue;
                    }
                    startHi = startMid - 1;
                }
                int endLo = mid;
                int endHi = hi;
                while (endLo <= endHi) {
                    int endMid = endLo + endHi >>> 1;
                    if (value < RangeAggregator.this.ranges[endMid].from) {
                        endHi = endMid - 1;
                        continue;
                    }
                    endLo = endMid + 1;
                }
                assert (startLo == lowBound || value >= RangeAggregator.this.maxTo[startLo - 1]);
                assert (endHi == RangeAggregator.this.ranges.length - 1 || value < RangeAggregator.this.ranges[endHi + 1].from);
                for (int i = startLo; i <= endHi; ++i) {
                    if (!RangeAggregator.this.ranges[i].matches(value)) continue;
                    RangeAggregator.this.collectBucket(sub, doc, RangeAggregator.this.subBucketOrdinal(owningBucketOrdinal, i));
                }
                return endHi + 1;
            }
        };
    }

    private final long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            long bucketOrd = this.subBucketOrdinal(owningBucketOrdinal, i);
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed, this.formatter);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.keyed, this.formatter);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    private static final void sortRanges(final Range[] ranges) {
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                Range tmp = ranges[i];
                ranges[i] = ranges[j];
                ranges[j] = tmp;
            }

            protected int compare(int i, int j) {
                int cmp = Double.compare(ranges[i].from, ranges[j].from);
                if (cmp == 0) {
                    cmp = Double.compare(ranges[i].to, ranges[j].to);
                }
                return cmp;
            }
        }.sort(0, ranges.length);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory<ValuesSource.Numeric> {
        private final InternalRange.Factory rangeFactory;
        private final List<Range> ranges;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valueSourceConfig, InternalRange.Factory rangeFactory, List<Range> ranges, boolean keyed) {
            super(name, rangeFactory.type(), valueSourceConfig);
            this.rangeFactory = rangeFactory;
            this.ranges = ranges;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new Unmapped(this.name, this.ranges, this.keyed, this.config.format(), aggregationContext, parent, this.rangeFactory, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new RangeAggregator(this.name, this.factories, valuesSource, this.config.format(), this.rangeFactory, this.ranges, this.keyed, aggregationContext, parent, pipelineAggregators, metaData);
        }
    }

    public static class Unmapped
    extends NonCollectingAggregator {
        private final List<Range> ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final ValueFormatter formatter;

        public Unmapped(String name, List<Range> ranges, boolean keyed, ValueFormat format, AggregationContext context, Aggregator parent, InternalRange.Factory factory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, context, parent, pipelineAggregators, metaData);
            this.ranges = ranges;
            ValueParser parser = format != null ? format.parser() : ValueParser.RAW;
            for (Range range : this.ranges) {
                range.process(parser, context.searchContext());
            }
            this.keyed = keyed;
            this.formatter = format.formatter();
            this.factory = factory;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.size());
            for (Range range : this.ranges) {
                buckets.add(this.factory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.keyed, this.formatter));
            }
            return this.factory.create(this.name, buckets, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
        }
    }

    public static class Range {
        public String key;
        public double from = Double.NEGATIVE_INFINITY;
        String fromAsStr;
        public double to = Double.POSITIVE_INFINITY;
        String toAsStr;

        public Range(String key, double from, String fromAsStr, double to, String toAsStr) {
            this.key = key;
            this.from = from;
            this.fromAsStr = fromAsStr;
            this.to = to;
            this.toAsStr = toAsStr;
        }

        boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        public void process(ValueParser parser, SearchContext context) {
            assert (parser != null);
            if (this.fromAsStr != null) {
                this.from = parser.parseDouble(this.fromAsStr, context);
            }
            if (this.toAsStr != null) {
                this.to = parser.parseDouble(this.toAsStr, context);
            }
        }
    }
}

