/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.ActionButton;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.common.model.Preferences;
import net.sourceforge.glsof.common.preferences.PreferencesDialog;
import net.sourceforge.glsof.common.utils.GBC;
import net.sourceforge.glsof.common.utils.MessageDialog;
import net.sourceforge.glsof.filemonitor.MonitorTable;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorPreferencesRepository;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorUIConfRepository;

class PreferencesTable
extends JTable
implements Observer {
    private MonitorTable _monitorTable;
    private FileMonitorPreferencesRepository _preferencesRepository;
    private PreferencesToolBar _toolBar;

    PreferencesTable(MonitorTable monitorTable, FileMonitorPreferencesRepository repository) {
        this._monitorTable = monitorTable;
        this._preferencesRepository = repository;
        String selectedPreference = FileMonitorUIConfRepository.getUiConf().getSelectedPreference();
        this._toolBar = new PreferencesToolBar();
        this.setModel(new PreferencesTableModel(repository.findAllNames(), selectedPreference));
        this.getColumn("#").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (Component)value;
            }
        });
        this.getColumn("#").setMaxWidth(20);
        this.getColumn("#").setMinWidth(20);
        this.getColumn("#").setCellEditor(new RadioButtonEditor());
        this.setBorder(null);
        this.setOpaque(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(4);
        this.setCellSelectionEnabled(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ListSelectionModel lsm = (ListSelectionModel)event.getSource();
                if (lsm.isSelectionEmpty()) {
                    PreferencesTable.this._toolBar.enableToolBarButtons(true, false, false, false);
                } else {
                    PreferencesTable.this.changeSelection(lsm.getMinSelectionIndex(), 1, false, false);
                    PreferencesTable.this.requestFocus();
                    PreferencesTable.this._toolBar.enableToolBarButtons(true, true, true, true);
                }
            }
        });
        this.getColumn(Messages.NLS("Preferences")).setCellEditor(new DefaultCellEditor(new JTextField()){

            @Override
            public boolean stopCellEditing() {
                String newProfileName = ((JTextField)this.getComponent()).getText();
                String oldProfileName = PreferencesTable.this.getTableModel().getNameAt(PreferencesTable.this.getEditingRow());
                return PreferencesTable.this._preferencesRepository.rename(newProfileName, oldProfileName) && super.stopCellEditing();
            }
        });
    }

    private PreferencesTableModel getTableModel() {
        return (PreferencesTableModel)this.getModel();
    }

    JPanel pack() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this._toolBar, new GBC().gridx(0).gridy(0).weightx(0.0).weighty(0.0).fill(2).anchor(21).get());
        panel.add((Component)new JScrollPane(this), new GBC().gridx(0).gridy(1).weightx(1.0).weighty(1.0).fill(1).anchor(11).get());
        return panel;
    }

    @Override
    public void update(Observer.NOTIFY notify, Object ... params) {
        if (notify == Observer.NOTIFY.CLOSE) {
            FileMonitorUIConfRepository.getUiConf().setSelectedPreference(this.getRunningPreferencesName());
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.repaint();
    }

    void addNewPreferences() {
        String newPreferencesName = MessageDialog.input(null, Messages.NLS("Add_preference"), Messages.NLS("Name"));
        if (newPreferencesName != null) {
            if (newPreferencesName.trim().isEmpty()) {
                MessageDialog.warning(null, Messages.NLS("Name_empty"));
                this.addNewPreferences();
            } else if (this._preferencesRepository.fileExists(newPreferencesName)) {
                MessageDialog.warning(null, Messages.NLS("Name_already_used"));
                this.addNewPreferences();
            } else {
                Preferences prefs = this.openDialog(Preferences.from(newPreferencesName));
                if (prefs != null) {
                    if (this.getRowCount() == 0) {
                        this._preferencesRepository.load(newPreferencesName);
                    }
                    this.addNewRow(prefs.getName());
                }
            }
        }
    }

    void editPreference() {
        String name = this.getSelectedProfileName();
        if (this.openDialog(this._preferencesRepository.read(name)) != null) {
            this._preferencesRepository.loadIfCurrentPreferenceName(name);
        }
    }

    void copyPreference() {
        this.addNewRow(this._preferencesRepository.copyPreferenceFrom(this.getSelectedProfileName()));
    }

    void removePreference() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        this._preferencesRepository.delete(this.getSelectedProfileName());
        this.getTableModel().removeRow(selectedRow);
        this.selectRow(selectedRow + 1 > this.getRowCount() ? this.getRowCount() : selectedRow + 1);
    }

    private void addNewRow(String value) {
        this.getTableModel().addNewRow(value);
        this.selectRow(this.getRowCount());
    }

    private void selectRow(int row) {
        if (row > 0) {
            this.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        }
    }

    private Preferences openDialog(Preferences prefs) {
        PreferencesDialog dialog = new PreferencesDialog(prefs, prefs.getName());
        dialog.create();
        dialog.setVisible(true);
        if (dialog.getButtonClickedId() == 1) {
            this._preferencesRepository.save(prefs);
            return prefs;
        }
        return null;
    }

    private String getSelectedProfileName() {
        return this.getTableModel().getNameAt(this.getSelectedRow());
    }

    public boolean noSelectedPreferences() {
        return this.getTableModel().getRunningPreferencesName().equals("");
    }

    public boolean noPreferences() {
        return this.getTableModel().getRowCount() == 0;
    }

    public String getRunningPreferencesName() {
        return this.getTableModel().getRunningPreferencesName();
    }

    private class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton button;

        RadioButtonEditor() {
            super(new JCheckBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button = (JRadioButton)value;
            this.button.addItemListener(this);
            return (Component)value;
        }

        @Override
        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
            List<Boolean> columns = PreferencesTable.this._preferencesRepository.loadColumns(PreferencesTable.this.getTableModel().getRunningPreferencesName());
            PreferencesTable.this._monitorTable.showColumns(columns);
        }
    }

    private class PreferencesTableModel
    extends DefaultTableModel {
        private ButtonGroup _groupRadios = new ButtonGroup();

        private PreferencesTableModel(List<String> preferences, String selectedPreferences) {
            this.addColumn("#");
            this.addColumn(Messages.NLS("Preferences"));
            for (String name : preferences) {
                JRadioButton button = new JRadioButton();
                this._groupRadios.add(button);
                this.addRow(new Object[]{button, name});
                if (!name.equals(selectedPreferences)) continue;
                button.setSelected(true);
            }
        }

        String getRunningPreferencesName() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((JRadioButton)this.getValueAt(i, 0)).isSelected()) continue;
                return (String)this.getValueAt(i, 1);
            }
            return "";
        }

        void addNewRow(String value) {
            JRadioButton radioButton = new JRadioButton();
            this._groupRadios.add(radioButton);
            if (this.getRowCount() == 0) {
                radioButton.setSelected(true);
            }
            PreferencesTable.this.getTableModel().addRow(new Object[]{radioButton, value});
        }

        String getNameAt(int row) {
            return (String)this.getValueAt(row, 1);
        }
    }

    private class PreferencesToolBar
    extends JToolBar {
        private PreferencesToolBar() {
            this.setFloatable(false);
            this.setBorder(new EtchedBorder());
            this.setOpaque(false);
            this.add(new ActionButton("/icons/add.png", "Add_preference"){

                @Override
                protected void execute() {
                    PreferencesTable.this.addNewPreferences();
                }
            }.getButton());
            this.add(new ActionButton("/icons/edit-properties.png", "Edit_preference"){

                @Override
                protected void execute() {
                    PreferencesTable.this.editPreference();
                }
            }.getButton());
            this.add(new ActionButton("/icons/edit-copy.png", "Copy_preference"){

                @Override
                protected void execute() {
                    PreferencesTable.this.copyPreference();
                }
            }.getButton());
            this.add(new ActionButton("/icons/remove.png", "Remove_preference"){

                @Override
                protected void execute() {
                    PreferencesTable.this.removePreference();
                }
            }.getButton());
            this.enableToolBarButtons(true, false, false, false);
        }

        void enableToolBarButtons(boolean ... show) {
            for (int i = 0; i < this.getComponents().length; ++i) {
                this.getComponent(i).setEnabled(show[i]);
            }
        }
    }
}

