/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor.thread;

import com.google.common.base.Equivalence;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.lsof.LsofExecutorObserver;
import net.sourceforge.glsof.common.utils.MessageDialog;
import net.sourceforge.glsof.filemonitor.MonitorTable;
import net.sourceforge.glsof.filemonitor.thread.StatusDetector;

public abstract class AbstractMonitorTableUpdater
extends SwingWorker<Void, Object[]>
implements LsofExecutorObserver {
    private static String OPEN = Messages.NLS("OPEN");
    private static String CLOSED = Messages.NLS("CLOSED");
    private MonitorTable _table;
    private final Map<String, StatusDetector> _detectors = new HashMap<String, StatusDetector>();

    protected abstract void stopLsofExecutor();

    public AbstractMonitorTableUpdater(MonitorTable table) {
        this._table = table;
    }

    @Override
    public void finished() {
        for (StatusDetector detector : this._detectors.values()) {
            for (Equivalence.Wrapper wrapper : detector.getOldCache()) {
                this.publishClosedRow((String[])wrapper.get());
            }
            detector.swapCaches();
        }
    }

    @Override
    public void flush(String[] row) {
        StatusDetector detector = this.getStatusDetector(row[0]);
        detector.add(row);
        if (detector.isOpenRow(row)) {
            this.publishOpenRow(row);
        }
    }

    private StatusDetector getStatusDetector(String processName) {
        StatusDetector statusDetector = this._detectors.get(processName);
        if (statusDetector == null) {
            statusDetector = new StatusDetector();
            this._detectors.put(processName, statusDetector);
        }
        return statusDetector;
    }

    private void publishClosedRow(String[] row) {
        this.publish((V[])new Object[][]{this.appendStatusToRow(row, CLOSED, Color.RED)});
    }

    private void publishOpenRow(String[] row) {
        this.publish((V[])new Object[][]{this.appendStatusToRow(row, OPEN, Color.BLUE)});
    }

    private Object[] appendStatusToRow(String[] row, String status, Color color) {
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        JLabel statusLabel = new JLabel(status);
        statusLabel.setForeground(color);
        newRow[row.length] = statusLabel;
        return newRow;
    }

    @Override
    protected void process(List<Object[]> rows) {
        this._table.addRows(rows);
    }

    @Override
    public void stop() {
        this.stopLsofExecutor();
        this.cancel(true);
    }

    @Override
    public void displayErrorMessage(String text) {
        MessageDialog.error(this._table, text);
    }
}

