/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.DisposerRecord;
import sun.misc.Unsafe;
import sun.util.logging.PlatformLogger;

class UnsafeXDisposerRecord
implements DisposerRecord {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.UnsafeXDisposerRecord");
    private static Unsafe unsafe = XlibWrapper.unsafe;
    final long[] unsafe_ptrs;
    final long[] x_ptrs;
    final String name;
    volatile boolean disposed;
    final Throwable place;

    public UnsafeXDisposerRecord(String name, long[] unsafe_ptrs, long[] x_ptrs) {
        this.unsafe_ptrs = unsafe_ptrs;
        this.x_ptrs = x_ptrs;
        this.name = name;
        this.place = XlibWrapper.isBuildInternal ? new Throwable() : null;
    }

    public UnsafeXDisposerRecord(String name, long ... unsafe_ptrs) {
        this.unsafe_ptrs = unsafe_ptrs;
        this.x_ptrs = null;
        this.name = name;
        this.place = XlibWrapper.isBuildInternal ? new Throwable() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (!this.disposed) {
                if (XlibWrapper.isBuildInternal && "Java2D Disposer".equals(Thread.currentThread().getName()) && log.isLoggable(900)) {
                    if (this.place != null) {
                        log.warning(this.name + " object was not disposed before finalization!", this.place);
                    } else {
                        log.warning(this.name + " object was not disposed before finalization!");
                    }
                }
                if (this.unsafe_ptrs != null) {
                    for (long l : this.unsafe_ptrs) {
                        if (l == 0L) continue;
                        unsafe.freeMemory(l);
                    }
                }
                if (this.x_ptrs != null) {
                    for (long l : this.x_ptrs) {
                        if (l == 0L) continue;
                        if (Native.getLong(l) != 0L) {
                            XlibWrapper.XFree(Native.getLong(l));
                        }
                        unsafe.freeMemory(l);
                    }
                }
                this.disposed = true;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }
}

