/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonBase;

public class CheckBox
extends ButtonBase {
    private BooleanProperty indeterminate;
    private BooleanProperty selected;
    private BooleanProperty allowIndeterminate;
    private static final String DEFAULT_STYLE_CLASS = "check-box";
    private static final String PSEUDO_CLASS_DETERMINATE = "determinate";
    private static final String PSEUDO_CLASS_INDETERMINATE = "indeterminate";
    private static final String PSEUDO_CLASS_SELECTED = "selected";
    private static final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");
    private static final long INDETERMINATE_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("indeterminate");
    private static final long DETERMINATE_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("determinate");

    public CheckBox() {
        this.initialize();
    }

    public CheckBox(String string) {
        this.setText(string);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMnemonicParsing(true);
    }

    public final void setIndeterminate(boolean bl) {
        this.indeterminateProperty().set(bl);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate == null ? false : this.indeterminate.get();
    }

    public final BooleanProperty indeterminateProperty() {
        if (this.indeterminate == null) {
            this.indeterminate = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    CheckBox.this.impl_pseudoClassStateChanged(CheckBox.PSEUDO_CLASS_DETERMINATE);
                    CheckBox.this.impl_pseudoClassStateChanged(CheckBox.PSEUDO_CLASS_INDETERMINATE);
                }

                @Override
                public Object getBean() {
                    return CheckBox.this;
                }

                @Override
                public String getName() {
                    return CheckBox.PSEUDO_CLASS_INDETERMINATE;
                }
            };
        }
        return this.indeterminate;
    }

    public final void setSelected(boolean bl) {
        this.selectedProperty().set(bl);
    }

    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    CheckBox.this.impl_pseudoClassStateChanged(CheckBox.PSEUDO_CLASS_SELECTED);
                }

                @Override
                public Object getBean() {
                    return CheckBox.this;
                }

                @Override
                public String getName() {
                    return CheckBox.PSEUDO_CLASS_SELECTED;
                }
            };
        }
        return this.selected;
    }

    public final void setAllowIndeterminate(boolean bl) {
        this.allowIndeterminateProperty().set(bl);
    }

    public final boolean isAllowIndeterminate() {
        return this.allowIndeterminate == null ? false : this.allowIndeterminate.get();
    }

    public final BooleanProperty allowIndeterminateProperty() {
        if (this.allowIndeterminate == null) {
            this.allowIndeterminate = new SimpleBooleanProperty(this, "allowIndeterminate");
        }
        return this.allowIndeterminate;
    }

    @Override
    public void fire() {
        if (this.isAllowIndeterminate()) {
            if (!this.isSelected() && !this.isIndeterminate()) {
                this.setIndeterminate(true);
            } else if (this.isSelected() && !this.isIndeterminate()) {
                this.setSelected(false);
            } else if (this.isIndeterminate()) {
                this.setSelected(true);
                this.setIndeterminate(false);
            }
        } else {
            this.setSelected(!this.isSelected());
            this.setIndeterminate(false);
        }
        this.fireEvent(new ActionEvent());
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isSelected()) {
            l |= SELECTED_PSEUDOCLASS_STATE;
        }
        return l |= this.isIndeterminate() ? INDETERMINATE_PSEUDOCLASS_STATE : DETERMINATE_PSEUDOCLASS_STATE;
    }
}

