/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.net.HttpCookie;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpResponseBody;
import org.zaproxy.zap.users.User;

public class HttpMessage
implements Message {
    private HttpRequestHeader mReqHeader = new HttpRequestHeader();
    private HttpRequestBody mReqBody = new HttpRequestBody();
    private HttpResponseHeader mResHeader = new HttpResponseHeader();
    private HttpResponseBody mResBody = new HttpResponseBody();
    private Object userObject = null;
    private int timeElapsed = 0;
    private long timeSent = 0L;
    private String note = "";
    private HistoryReference historyRef = null;
    private static Logger log = Logger.getLogger(HttpMessage.class);
    private HttpSession httpSession = null;
    private User requestUser;
    private boolean forceIntercept = false;
    private boolean responseFromTargetHost = false;

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public HttpMessage() {
    }

    public HttpMessage(URI uRI) throws HttpMalformedHeaderException {
        this(uRI, null);
    }

    public HttpMessage(URI uRI, ConnectionParam connectionParam) throws HttpMalformedHeaderException {
        this.setRequestHeader(new HttpRequestHeader("GET", uRI, "HTTP/1.1", connectionParam));
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader) {
        this.setRequestHeader(httpRequestHeader);
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader, HttpRequestBody httpRequestBody) {
        this.setRequestHeader(httpRequestHeader);
        this.setRequestBody(httpRequestBody);
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader, HttpRequestBody httpRequestBody, HttpResponseHeader httpResponseHeader, HttpResponseBody httpResponseBody) {
        this.setRequestHeader(httpRequestHeader);
        this.setRequestBody(httpRequestBody);
        this.setResponseHeader(httpResponseHeader);
        this.setResponseBody(httpResponseBody);
    }

    public HttpMessage(String string, byte[] byArray, String string2, byte[] byArray2) throws HttpMalformedHeaderException {
        this.setRequestHeader(string);
        this.setRequestBody(byArray);
        if (string2 != null && !string2.equals("")) {
            this.setResponseHeader(string2);
            this.setResponseBody(byArray2);
        }
    }

    public HttpRequestHeader getRequestHeader() {
        return this.mReqHeader;
    }

    public void setRequestHeader(HttpRequestHeader httpRequestHeader) {
        if (httpRequestHeader == null) {
            throw new IllegalArgumentException("The parameter reqHeader must not be null.");
        }
        this.mReqHeader = httpRequestHeader;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.mResHeader;
    }

    public void setResponseHeader(HttpResponseHeader httpResponseHeader) {
        if (httpResponseHeader == null) {
            throw new IllegalArgumentException("The parameter resHeader must not be null.");
        }
        this.mResHeader = httpResponseHeader;
    }

    public HttpRequestBody getRequestBody() {
        return this.mReqBody;
    }

    public void setRequestBody(HttpRequestBody httpRequestBody) {
        if (httpRequestBody == null) {
            throw new IllegalArgumentException("The parameter reqBody must not be null.");
        }
        this.mReqBody = httpRequestBody;
    }

    public HttpResponseBody getResponseBody() {
        return this.mResBody;
    }

    public void setResponseBody(HttpResponseBody httpResponseBody) {
        if (httpResponseBody == null) {
            throw new IllegalArgumentException("The parameter resBody must not be null.");
        }
        this.mResBody = httpResponseBody;
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
    }

    public void setRequestHeader(String string) throws HttpMalformedHeaderException {
        HttpRequestHeader httpRequestHeader = new HttpRequestHeader(string);
        this.setRequestHeader(httpRequestHeader);
    }

    public void setResponseHeader(String string) throws HttpMalformedHeaderException {
        HttpResponseHeader httpResponseHeader = new HttpResponseHeader(string);
        this.setResponseHeader(httpResponseHeader);
    }

    public void setRequestBody(String string) {
        this.getRequestBody().setCharset(this.getRequestHeader().getCharset());
        this.getRequestBody().setBody(string);
    }

    public void setRequestBody(byte[] byArray) {
        this.getRequestBody().setBody(byArray);
        this.getRequestBody().setCharset(this.getRequestHeader().getCharset());
    }

    public void setResponseBody(String string) {
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
        this.getResponseBody().setBody(string);
    }

    public void setResponseBody(byte[] byArray) {
        this.getResponseBody().setBody(byArray);
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpMessage)) {
            return false;
        }
        HttpMessage httpMessage = (HttpMessage)object;
        boolean bl = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(httpMessage.getRequestHeader().getMethod())) {
            return false;
        }
        URI uRI = this.getRequestHeader().getURI();
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        if (uRI == null) {
            return uRI2 == null;
        }
        if (uRI2 == null) {
            return false;
        }
        try {
            if (uRI.getHost() == null || uRI2.getHost() == null || !uRI.getHost().equalsIgnoreCase(uRI2.getHost())) {
                return false;
            }
            if (uRI.getPort() != uRI2.getPort()) {
                return false;
            }
            String string = uRI.getPathQuery();
            String string2 = uRI2.getPathQuery();
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null) {
                return string.equalsIgnoreCase(string2);
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
                return this.getRequestBody().equals(httpMessage.getRequestBody());
            }
            bl = true;
        }
        catch (URIException uRIException) {
            try {
                bl = this.getRequestHeader().getURI().toString().equalsIgnoreCase(httpMessage.getRequestHeader().getURI().toString());
            }
            catch (Exception exception) {
                log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getRequestHeader().getMethod().toLowerCase(Locale.ROOT).hashCode();
        URI uRI = this.getRequestHeader().getURI();
        if (uRI != null) {
            n = 31 * n + uRI.getPort();
            try {
                n = 31 * n + (uRI.getRawHost() == null ? 0 : uRI.getHost().toLowerCase(Locale.ROOT).hashCode());
            }
            catch (URIException uRIException) {
                log.error((Object)("Failed to obtain the host for hashCode calculation: " + uRI.toString()), (Throwable)uRIException);
            }
            n = 31 * n + (uRI.getRawPathQuery() == null ? 0 : uRI.getEscapedPathQuery().toLowerCase(Locale.ROOT).hashCode());
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            n = 31 * n + this.getRequestBody().hashCode();
        }
        return n;
    }

    public boolean equalType(HttpMessage httpMessage) {
        boolean bl = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(httpMessage.getRequestHeader().getMethod())) {
            return false;
        }
        URI uRI = this.getRequestHeader().getURI();
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        try {
            if (uRI.getHost() == null || uRI2.getHost() == null || !uRI.getHost().equalsIgnoreCase(uRI2.getHost())) {
                return false;
            }
            if (uRI.getPort() != uRI2.getPort()) {
                return false;
            }
            String string = uRI.getPath();
            String string2 = uRI2.getPath();
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null && !string.equalsIgnoreCase(string2)) {
                return false;
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (!this.queryEquals(httpMessage)) {
                return false;
            }
            bl = true;
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return bl;
    }

    private boolean queryEquals(HttpMessage httpMessage) {
        boolean bl = false;
        TreeSet<String> treeSet = null;
        TreeSet<String> treeSet2 = null;
        treeSet = this.getParamNameSet(HtmlParameter.Type.url);
        if (!((Object)treeSet).equals(treeSet2 = this.getParamNameSet(HtmlParameter.Type.url))) {
            return false;
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !((Object)(treeSet = this.getParamNameSet(HtmlParameter.Type.form))).equals(treeSet2 = this.getParamNameSet(HtmlParameter.Type.form))) {
            return false;
        }
        bl = true;
        return bl;
    }

    @Deprecated
    public TreeSet<String> getParamNameSet(HtmlParameter.Type type, String string) {
        return this.getParamNameSet(type);
    }

    public TreeSet<String> getParamNameSet(HtmlParameter.Type type) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Map<String, String> map = Model.getSingleton().getSession().getParams(this, type);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }

    private TreeSet<HtmlParameter> getParamsSet(HtmlParameter.Type type) {
        TreeSet<HtmlParameter> treeSet = new TreeSet<HtmlParameter>();
        Map<String, String> map = Model.getSingleton().getSession().getParams(this, type);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            treeSet.add(new HtmlParameter(type, entry.getKey(), entry.getValue()));
        }
        return treeSet;
    }

    public String[] getParamNames() {
        Vector<String> vector = new Vector<String>();
        TreeSet<String> treeSet = this.getParamNameSet(HtmlParameter.Type.url);
        for (String object2 : treeSet) {
            if (object2 == null) continue;
            vector.add(object2);
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            treeSet = this.getParamNameSet(HtmlParameter.Type.form);
            for (String string : treeSet) {
                if (string == null) continue;
                vector.add(string);
            }
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public TreeSet<HtmlParameter> getUrlParams() {
        return this.getParamsSet(HtmlParameter.Type.url);
    }

    public TreeSet<HtmlParameter> getFormParams() {
        String string = this.mReqHeader.getHeader("Content-Type");
        if (string == null || !StringUtils.startsWithIgnoreCase(string.trim(), "application/x-www-form-urlencoded")) {
            return new TreeSet<HtmlParameter>();
        }
        return this.getParamsSet(HtmlParameter.Type.form);
    }

    public void setCookieParamsAsString(String string) {
        this.getRequestHeader().setHeader("Cookie", string);
    }

    public String getCookieParamsAsString() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!this.getRequestHeader().isEmpty()) {
            this.addAll(linkedList, this.getRequestHeader().getHeaders("Cookie"));
        }
        if (!this.getResponseHeader().isEmpty()) {
            this.addAll(linkedList, this.getResponseHeader().getHeaders("Set-Cookie"));
            this.addAll(linkedList, this.getResponseHeader().getHeaders("Set-Cookie2"));
        }
        if (linkedList.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : linkedList) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void addAll(List<String> list, Vector<String> vector) {
        if (vector != null) {
            list.addAll(vector);
        }
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        TreeSet<HtmlParameter> treeSet = new TreeSet<HtmlParameter>();
        if (!this.getRequestHeader().isEmpty()) {
            treeSet.addAll(this.getRequestHeader().getCookieParams());
        }
        if (!this.getResponseHeader().isEmpty()) {
            treeSet.addAll(this.getResponseHeader().getCookieParams());
        }
        return treeSet;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public HttpMessage cloneAll() {
        HttpMessage httpMessage = this.cloneRequest();
        if (!this.getResponseHeader().isEmpty()) {
            try {
                httpMessage.getResponseHeader().setMessage(this.getResponseHeader().toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                // empty catch block
            }
            httpMessage.setResponseBody(this.getResponseBody().getBytes());
        }
        return httpMessage;
    }

    public HttpMessage cloneRequest() {
        HttpMessage httpMessage = new HttpMessage();
        if (!this.getRequestHeader().isEmpty()) {
            try {
                httpMessage.getRequestHeader().setMessage(this.getRequestHeader().toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                log.error((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
            }
            httpMessage.setRequestBody(this.getRequestBody().getBytes());
        }
        return httpMessage;
    }

    public int getTimeElapsedMillis() {
        return this.timeElapsed;
    }

    public void setTimeElapsedMillis(int n) {
        this.timeElapsed = n;
    }

    public long getTimeSentMillis() {
        return this.timeSent;
    }

    public void setTimeSentMillis(long l) {
        this.timeSent = l;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public void mutateHttpMethod(String string) {
        String string2 = this.getRequestHeader().toString();
        try {
            String string3;
            HttpRequestHeader httpRequestHeader = new HttpRequestHeader(string2);
            URI uRI = httpRequestHeader.getURI();
            String string4 = this.getRequestBody().toString();
            String string5 = httpRequestHeader.getMethod();
            if (string5.equalsIgnoreCase(string)) {
                return;
            }
            if (string5.equals("POST")) {
                if (string4 != null && string4.length() > 0) {
                    String[] stringArray;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (uRI.getQuery() != null) {
                        stringBuilder.append(uRI.getQuery());
                    }
                    for (String string6 : stringArray = string4.split("&")) {
                        String[] stringArray2;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('&');
                        }
                        if ((stringArray2 = string6.split("=")).length == 1) {
                            stringBuilder.append(stringArray2[0]);
                            continue;
                        }
                        stringBuilder.append(string6);
                    }
                    uRI.setQuery(stringBuilder.toString());
                }
                httpRequestHeader.setURI(uRI);
                string4 = "";
            } else if (string.equals("POST") && (string3 = uRI.getQuery()) != null) {
                String[] stringArray;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string7 : stringArray = string3.split("&")) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(string7);
                    String[] stringArray3 = string7.split("=");
                    if (stringArray3.length != 1) continue;
                    stringBuilder.append('=');
                }
                string4 = stringBuilder.toString();
                uRI.setQuery(null);
                httpRequestHeader.setURI(uRI);
            }
            httpRequestHeader.setMethod(string);
            this.getRequestHeader().setMessage(httpRequestHeader.toString());
            this.getRequestBody().setBody(string4);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.error((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
    }

    public void setFormParams(TreeSet<HtmlParameter> treeSet) {
        this.mReqBody.setFormParams(treeSet);
    }

    public void setGetParams(TreeSet<HtmlParameter> treeSet) {
        this.mReqHeader.setGetParams(treeSet);
    }

    public void setCookieParams(TreeSet<HtmlParameter> treeSet) {
        this.mReqHeader.setCookieParams(treeSet);
    }

    public boolean isWebSocketUpgrade() {
        if (!this.getResponseHeader().isEmpty()) {
            String string = this.getResponseHeader().getHeader("connection");
            String string2 = this.getResponseHeader().getHeader("upgrade");
            if (string != null && string.equalsIgnoreCase("upgrade") && string2 != null && string2.equalsIgnoreCase("websocket")) {
                return true;
            }
        }
        return false;
    }

    public void setCookies(List<HttpCookie> list) {
        this.mReqHeader.setCookies(list);
    }

    @Override
    public boolean isInScope() {
        return Model.getSingleton().getSession().isInScope(this.getRequestHeader().getURI().toString());
    }

    public boolean isEventStream() {
        boolean bl = false;
        if (!this.getResponseHeader().isEmpty()) {
            String string = this.getResponseHeader().getHeader("content-type");
            if (string != null && string.equals("text/event-stream")) {
                bl = true;
            }
        } else {
            String string = this.getRequestHeader().getHeader("Accept");
            if (string != null && string.equals("text/event-stream")) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isForceIntercept() {
        String string = this.getRequestHeader().getHeader("X-Security-Proxy");
        if (string != null) {
            for (String string2 : string.split(",")) {
                if (!"intercept".equalsIgnoreCase(string2.trim())) continue;
                return true;
            }
        }
        return this.forceIntercept;
    }

    public void setForceIntercept(boolean bl) {
        this.forceIntercept = bl;
    }

    public User getRequestingUser() {
        return this.requestUser;
    }

    public void setRequestingUser(User user) {
        this.requestUser = user;
    }

    public boolean isResponseFromTargetHost() {
        return this.responseFromTargetHost;
    }

    public void setResponseFromTargetHost(boolean bl) {
        this.responseFromTargetHost = bl;
    }
}

