/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.autoupdate.Downloader;

public class DownloadManager
extends Thread {
    private static final Logger logger = Logger.getLogger(DownloadManager.class);
    private List<Downloader> currentDownloads = new ArrayList<Downloader>();
    private List<Downloader> completedDownloads = new ArrayList<Downloader>();
    private boolean shutdown = false;
    private boolean cancelDownloads = false;
    private ConnectionParam connectionParam;

    public DownloadManager(ConnectionParam connectionParam) {
        super("ZAP-DownloadManager");
        this.connectionParam = connectionParam;
        this.setDaemon(true);
        Authenticator.setDefault(new ZapProxyAuthenticator());
    }

    public Downloader downloadFile(URL uRL, File file, long l, String string) {
        Proxy proxy;
        Object object;
        logger.debug((Object)("Download file " + uRL + " to " + file.getAbsolutePath()));
        if (this.connectionParam.isUseProxy(uRL.getHost())) {
            object = new InetSocketAddress(this.connectionParam.getProxyChainName(), this.connectionParam.getProxyChainPort());
            proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        object = new Downloader(uRL, proxy, file, l, string);
        ((Thread)object).start();
        this.currentDownloads.add((Downloader)object);
        return object;
    }

    @Override
    public void run() {
        while (this.getCurrentDownloadCount() > 0 || !this.shutdown) {
            ArrayList<Downloader> arrayList = new ArrayList<Downloader>();
            for (Downloader downloader : this.currentDownloads) {
                if (!downloader.isAlive()) {
                    if (downloader.getException() != null) {
                        logger.debug((Object)("Download failed " + downloader.getTargetFile().getAbsolutePath()));
                    } else if (downloader.isValidated()) {
                        logger.debug((Object)("Download finished " + downloader.getTargetFile().getAbsolutePath()));
                    } else {
                        logger.error((Object)("Validation failed " + downloader.getTargetFile().getAbsolutePath()));
                        downloader.cancelDownload();
                        if (View.isInitialised()) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("cfu.warn.badhash", downloader.getTargetFile().getName()));
                        }
                    }
                    arrayList.add(downloader);
                    continue;
                }
                if (this.cancelDownloads) {
                    logger.debug((Object)("Cancelling download " + downloader.getTargetFile().getAbsolutePath()));
                    downloader.cancelDownload();
                    continue;
                }
                logger.debug((Object)("Still downloading " + downloader.getTargetFile().getAbsolutePath() + " progress % " + downloader.getProgressPercent()));
            }
            for (Downloader downloader : arrayList) {
                this.completedDownloads.add(downloader);
                this.currentDownloads.remove(downloader);
            }
            try {
                if (this.getCurrentDownloadCount() > 0) {
                    DownloadManager.sleep(200L);
                    continue;
                }
                DownloadManager.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug((Object)"Shutdown");
    }

    public int getCurrentDownloadCount() {
        return this.currentDownloads.size();
    }

    public void shutdown(boolean bl) {
        this.shutdown = true;
        this.cancelDownloads = bl;
    }

    public int getProgressPercent(URL uRL) throws Exception {
        for (Downloader downloader : this.currentDownloads) {
            if (!downloader.getUrl().equals(uRL)) continue;
            if (downloader.getException() != null) {
                throw downloader.getException();
            }
            return downloader.getProgressPercent();
        }
        for (Downloader downloader : this.completedDownloads) {
            if (!downloader.getUrl().equals(uRL)) continue;
            if (downloader.getException() != null) {
                throw downloader.getException();
            }
            return 100;
        }
        return -1;
    }

    public List<Downloader> getProgress() {
        ArrayList<Downloader> arrayList = new ArrayList<Downloader>();
        for (Downloader downloader : this.currentDownloads) {
            arrayList.add(downloader);
        }
        for (Downloader downloader : this.completedDownloads) {
            arrayList.add(downloader);
        }
        return arrayList;
    }

    private final class ZapProxyAuthenticator
    extends Authenticator {
        private ZapProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                return null;
            }
            if (this.getRequestingURL() == null) {
                return null;
            }
            if (!DownloadManager.this.connectionParam.isUseProxy(this.getRequestingURL().getHost())) {
                return null;
            }
            if (DownloadManager.this.connectionParam.getProxyChainPort() != this.getRequestingPort()) {
                return null;
            }
            if (!DownloadManager.this.connectionParam.getProxyChainName().equals(this.getRequestingHost())) {
                return null;
            }
            return new PasswordAuthentication(DownloadManager.this.connectionParam.getProxyChainUserName(), DownloadManager.this.connectionParam.getProxyChainPassword().toCharArray());
        }
    }
}

