/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;

public class PopupMenuUnsetActiveSession
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionHttpSessions extension;

    public PopupMenuUnsetActiveSession() {
        super(Constant.messages.getString("httpsessions.popup.session.active.unset"));
        this.initialize();
    }

    public void setExtension(ExtensionHttpSessions extensionHttpSessions) {
        this.extension = extensionHttpSessions;
    }

    private void initialize() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpSessionsPanel httpSessionsPanel = PopupMenuUnsetActiveSession.this.extension.getHttpSessionsPanel();
                HttpSessionsSite httpSessionsSite = httpSessionsPanel.getCurrentHttpSessionSite();
                if (httpSessionsSite == null) {
                    return;
                }
                httpSessionsSite.unsetActiveSession();
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        HttpSession httpSession;
        if (component.getName() != null && component.getName().equals("httpsessions") && (httpSession = this.extension.getHttpSessionsPanel().getSelectedSession()) != null) {
            return httpSession.isActive();
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

