/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import freemind.common.XmlBindingTools;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import tests.freemind.FreeMindMainMock;

public class FreeMindProgressMonitor
extends JDialog {
    private static final String PROGRESS_MONITOR_WINDOW_CONFIGURATION_STORAGE = "progress_monitor_window_configuration_storage";
    private JLabel mLabel;
    private JProgressBar mProgressBar;
    private JButton mCancelButton;
    protected boolean mCanceled = false;

    public FreeMindProgressMonitor(String pTitle) {
        this.setTitle(this.getString(pTitle));
        this.mLabel = new JLabel("!");
        this.mProgressBar = new JProgressBar();
        this.mCancelButton = new JButton();
        Tools.setLabelAndMnemonic(this.mCancelButton, this.getString("cancel"));
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                FreeMindProgressMonitor.this.mCanceled = true;
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.mLabel, constraints);
        constraints.gridy = 1;
        this.add((Component)this.mProgressBar, constraints);
        constraints.gridy = 2;
        constraints.fill = 0;
        constraints.anchor = 13;
        this.add((Component)this.mCancelButton, constraints);
        this.pack();
        this.setSize(new Dimension(600, 200));
        String marshaled = Resources.getInstance().getProperty(PROGRESS_MONITOR_WINDOW_CONFIGURATION_STORAGE);
        if (marshaled != null) {
            XmlBindingTools.getInstance().decorateDialog(marshaled, this);
        }
    }

    protected String getString(String resource) {
        return Resources.getInstance().getResourceString(resource);
    }

    public boolean showProgress(int pCurrent, final int pMax, String pName, Object[] pParameters) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeMindProgressMonitor.this.mProgressBar.setMaximum(pMax);
            }
        });
        return this.showProgress(pCurrent, pName, pParameters);
    }

    public boolean showProgress(int pCurrent, String pName, Object[] pParameters) {
        final String format = Resources.getInstance().format(pName, pParameters);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeMindProgressMonitor.this.mLabel.setText(format);
            }
        });
        return this.setProgress(pCurrent);
    }

    public boolean setProgress(final int pCurrent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeMindProgressMonitor.this.mProgressBar.setValue(pCurrent);
            }
        });
        return this.mCanceled;
    }

    public void dismiss() {
        WindowConfigurationStorage storage = new WindowConfigurationStorage();
        String marshalled = XmlBindingTools.getInstance().storeDialogPositions(storage, this);
        Resources.getInstance().getProperties().setProperty(PROGRESS_MONITOR_WINDOW_CONFIGURATION_STORAGE, marshalled);
        this.setVisible(false);
    }

    public static void main(String[] args) throws InterruptedException {
        FreeMindMainMock mock = new FreeMindMainMock();
        Resources.createInstance(mock);
        FreeMindProgressMonitor progress = new FreeMindProgressMonitor("title");
        progress.setVisible(true);
        for (int i = 0; i < 10; ++i) {
            boolean canceled = progress.showProgress(i, 10, "inhalt {0}", new Object[]{i});
            if (canceled) {
                progress.dismiss();
                System.exit(1);
            }
            Thread.sleep(1000L);
        }
        progress.dismiss();
        System.exit(0);
    }
}

