/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.IOLayout;

@GeneratedBy(value=IOLayout.class)
public class IOLayoutImpl
extends BasicObjectLayoutImpl
implements IOLayout {
    public static final IOLayout INSTANCE = new IOLayoutImpl();
    protected static final Shape.Allocator I_O_ALLOCATOR = LAYOUT.createAllocator();
    protected static final Property I_BUFFER_PROPERTY = Property.create("@ibuffer", I_O_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final Property LINE_NO_PROPERTY = Property.create("@lineno", I_O_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property DESCRIPTOR_PROPERTY = Property.create("@descriptor", I_O_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property MODE_PROPERTY = Property.create("@mode", I_O_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected IOLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createIOShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new IOType(logicalClass, metaClass)).addProperty(I_BUFFER_PROPERTY).addProperty(LINE_NO_PROPERTY).addProperty(DESCRIPTOR_PROPERTY).addProperty(MODE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createIO(DynamicObjectFactory factory, DynamicObject iBuffer, int lineNo, int descriptor, int mode) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (IOLayoutImpl.createsIO(factory));
        assert (factory.getShape().hasProperty("@ibuffer"));
        assert (factory.getShape().hasProperty("@lineno"));
        assert (factory.getShape().hasProperty("@descriptor"));
        assert (factory.getShape().hasProperty("@mode"));
        assert (iBuffer != null);
        return factory.newInstance(iBuffer, lineNo, descriptor, mode);
    }

    private static boolean isIO(DynamicObject object) {
        return IOLayoutImpl.isIO(object.getShape().getObjectType());
    }

    private static boolean isIO(ObjectType objectType) {
        return objectType instanceof IOType;
    }

    private static boolean createsIO(DynamicObjectFactory factory) {
        return IOLayoutImpl.isIO(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getIBuffer(DynamicObject object) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@ibuffer"));
        return (DynamicObject)I_BUFFER_PROPERTY.get(object, IOLayoutImpl.isIO(object));
    }

    @Override
    public int getLineNo(DynamicObject object) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@lineno"));
        return (Integer)LINE_NO_PROPERTY.get(object, IOLayoutImpl.isIO(object));
    }

    @Override
    public void setLineNo(DynamicObject object, int value) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@lineno"));
        try {
            LINE_NO_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getDescriptor(DynamicObject object) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@descriptor"));
        return (Integer)DESCRIPTOR_PROPERTY.get(object, IOLayoutImpl.isIO(object));
    }

    @Override
    public void setDescriptor(DynamicObject object, int value) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@descriptor"));
        try {
            DESCRIPTOR_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getMode(DynamicObject object) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@mode"));
        return (Integer)MODE_PROPERTY.get(object, IOLayoutImpl.isIO(object));
    }

    @Override
    public void setMode(DynamicObject object, int value) {
        assert (IOLayoutImpl.isIO(object));
        assert (object.getShape().hasProperty("@mode"));
        try {
            MODE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class IOType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public IOType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public IOType setLogicalClass(DynamicObject logicalClass) {
            return new IOType(logicalClass, this.metaClass);
        }

        @Override
        public IOType setMetaClass(DynamicObject metaClass) {
            return new IOType(this.logicalClass, metaClass);
        }
    }
}

