/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.ssa;

import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.BitSet;
import java.util.List;

public class LiveVarAnalysis {
    private final MethodNode mth;
    private BitSet[] uses;
    private BitSet[] defs;
    private BitSet[] liveIn;
    private BitSet[] assignBlocks;

    public LiveVarAnalysis(MethodNode mth) {
        this.mth = mth;
    }

    public void runAnalysis() {
        int bbCount = this.mth.getBasicBlocks().size();
        int regsCount = this.mth.getRegsCount();
        this.uses = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        this.defs = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        this.assignBlocks = LiveVarAnalysis.initBitSetArray(regsCount, bbCount);
        this.fillBasicBlockInfo();
        this.processLiveInfo();
    }

    public BitSet getAssignBlocks(int regNum) {
        return this.assignBlocks[regNum];
    }

    public boolean isLive(int blockId, int regNum) {
        return this.liveIn[blockId].get(regNum);
    }

    private void fillBasicBlockInfo() {
        for (BlockNode block : this.mth.getBasicBlocks()) {
            int blockId = block.getId();
            BitSet gen = this.uses[blockId];
            BitSet kill = this.defs[blockId];
            for (InsnNode insn : block.getInstructions()) {
                for (InsnArg arg : insn.getArguments()) {
                    int regNum;
                    if (!arg.isRegister() || kill.get(regNum = ((RegisterArg)arg).getRegNum())) continue;
                    gen.set(regNum);
                }
                RegisterArg result = insn.getResult();
                if (result == null) continue;
                int regNum = result.getRegNum();
                kill.set(regNum);
                this.assignBlocks[regNum].set(blockId);
            }
        }
    }

    private void processLiveInfo() {
        boolean changed;
        int bbCount = this.mth.getBasicBlocks().size();
        int regsCount = this.mth.getRegsCount();
        BitSet[] liveIn = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        List<BlockNode> blocks = this.mth.getBasicBlocks();
        int blocksSize = blocks.size();
        int k = 0;
        do {
            changed = false;
            for (int i = 0; i < blocksSize; ++i) {
                BlockNode block = blocks.get(i);
                int blockId = block.getId();
                BitSet prevIn = liveIn[blockId];
                BitSet newIn = new BitSet(regsCount);
                List<BlockNode> successors = block.getSuccessors();
                int successorsSize = successors.size();
                for (int s = 0; s < successorsSize; ++s) {
                    newIn.or(liveIn[successors.get(s).getId()]);
                }
                newIn.andNot(this.defs[blockId]);
                newIn.or(this.uses[blockId]);
                if (prevIn.equals(newIn)) continue;
                changed = true;
                liveIn[blockId] = newIn;
            }
            if (k++ <= 1000) continue;
            throw new JadxRuntimeException("Live variable analysis reach iterations limit");
        } while (changed);
        this.liveIn = liveIn;
    }

    private static BitSet[] initBitSetArray(int length, int bitsCount) {
        BitSet[] array = new BitSet[length];
        for (int i = 0; i < length; ++i) {
            array[i] = new BitSet(bitsCount);
        }
        return array;
    }
}

